/*
 * Decompiled with CFR 0.152.
 */
package IM.util;

import java.util.Random;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Base64Coder {
    private static char[] map1 = new char[64];
    private static byte[] map2;

    static {
        int i = 0;
        int c = 65;
        while (c <= 90) {
            Base64Coder.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 97;
        while (c <= 122) {
            Base64Coder.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            Base64Coder.map1[i++] = c;
            c = (char)(c + 1);
        }
        Base64Coder.map1[i++] = 43;
        Base64Coder.map1[i++] = 47;
        map2 = new byte[128];
        i = 0;
        while (i < map2.length) {
            Base64Coder.map2[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 64) {
            Base64Coder.map2[Base64Coder.map1[i]] = (byte)i;
            ++i;
        }
    }

    public static String encode(String s) {
        return new String(Base64Coder.encode(s.getBytes()));
    }

    public static char[] encode(byte[] in) {
        return Base64Coder.encode(in, in.length);
    }

    public static char[] encode(byte[] in, int length) {
        int iLen = Math.min(in.length, length);
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < iLen) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iLen ? in[ip++] & 0xFF : 0;
            int i2 = ip < iLen ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static String decode(String s) {
        return new String(Base64Coder.decode(s.toCharArray()));
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] decode(char[] in) {
        iLen = in.length;
        if (iLen % 4 == 0) ** GOTO lbl5
        throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4..\n" + new String(in));
lbl-1000:
        // 1 sources

        {
            --iLen;
lbl5:
            // 2 sources

            ** while (iLen > 0 && in[iLen - 1] == '=')
        }
lbl6:
        // 1 sources

        oLen = iLen * 3 / 4;
        out = new byte[oLen];
        ip = 0;
        op = 0;
        while (ip < iLen) {
            i0 = in[ip++];
            i1 = in[ip++];
            i2 = ip < iLen ? in[ip++] : 65;
            v0 = i3 = ip < iLen ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            b0 = Base64Coder.map2[i0];
            b1 = Base64Coder.map2[i1];
            b2 = Base64Coder.map2[i2];
            b3 = Base64Coder.map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            o0 = b0 << 2 | b1 >>> 4;
            o1 = (b1 & 15) << 4 | b2 >>> 2;
            o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    private static void test1() {
        System.out.println("test1 started");
        char[] b = Base64Coder.encode("Hello\u4f60\u597d".getBytes());
        String s = new String(Base64Coder.decode(b));
        if (!s.equals("Hello\u4f60\u597d")) {
            System.out.println("Error 1");
        }
        String c1 = "QWxhZGRpbjpvcGVuIHNlc2FtZQ==";
        s = Base64Coder.decode("QWxhZGRpbjpvcGVuIHNlc2FtZQ==");
        if (!s.equals("Aladdin:open sesame")) {
            System.out.println("Error 2");
        }
        if (!(s = Base64Coder.encode(s)).equals("QWxhZGRpbjpvcGVuIHNlc2FtZQ==")) {
            System.out.println("Error 3");
        }
        System.out.println("test1 completed");
    }

    private static boolean compareByteArrays(byte[] a1, byte[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        int p = 0;
        while (p < a1.length) {
            if (a1[p] != a2[p]) {
                return false;
            }
            ++p;
        }
        return true;
    }

    private static void test2() throws Exception {
        System.out.println("test2 started");
        BASE64Encoder enc = new BASE64Encoder();
        BASE64Decoder dec = new BASE64Decoder();
        Random rnd = new Random(1401617298L);
        int i = 0;
        while (i < 10000) {
            int len = rnd.nextInt(55);
            byte[] b0 = new byte[len];
            rnd.nextBytes(b0);
            char[] e1 = Base64Coder.encode(b0);
            String es1 = new String(e1);
            String e2 = enc.encode(b0);
            if (!es1.equals(e2)) {
                System.out.println("Error\ne1=" + es1 + " len=" + es1.length() + "\ne2=" + e2 + " len=" + e2.length());
            }
            byte[] b1 = Base64Coder.decode(e1);
            byte[] b2 = dec.decodeBuffer(e2);
            if (!Base64Coder.compareByteArrays(b1, b0) || !Base64Coder.compareByteArrays(b2, b0)) {
                System.out.println("Decoded data not equal. len1=" + b1.length + " len2=" + b2.length);
            }
            ++i;
        }
        System.out.println("test2 completed");
    }

    public static void main(String[] args) throws Exception {
        System.out.println("TestBase64Coder started");
        Base64Coder.test1();
        Base64Coder.test2();
        System.out.println("TestBase64Coder completed");
    }
}

