/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.jmf;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import javax.imageio.ImageIO;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.Player;
import javax.media.control.FrameGrabbingControl;
import javax.media.format.VideoFormat;
import javax.media.protocol.DataSource;
import javax.media.util.BufferToImage;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import jmapps.util.JMFUtils;
import netscape.javascript.JSObject;
import wiseoa.jmf.TimeMark;
import wiseoa.jmf.Tools;

public class MainFrame
extends JApplet
implements ComponentListener {
    public int workid;
    public int userid;
    public static String randomPrefix = "";
    public String HomeURL = "";
    public JPanel jp_toolbar;
    public JButton jb_one;
    public JButton jb_auto;
    public JButton jb_autoNow;
    public JButton jb_stopAuto;
    public Component camera = null;
    public JLabel jl_tip;
    public int photoWidth = 0;
    public int photoHeight = 0;
    public double bl = 0.0;
    public Timer timer = new Timer();
    CountDown CD;
    Player player = null;
    int photoCount;
    String defaultTip = "";
    public volatile boolean autoSnagit = false;

    public void enableAutoSnagit(boolean e) {
        this.jb_one.setVisible(e);
        this.jb_auto.setVisible(e);
        this.jb_autoNow.setVisible(!e);
        this.jb_stopAuto.setVisible(!e);
        if (e) {
            this.jl_tip.setText(this.defaultTip);
        }
    }

    public void init() {
        this.HomeURL = this.getCodeBase().toString();
        if (this.HomeURL.substring(0, 4).equalsIgnoreCase("file")) {
            this.HomeURL = "http://zengjun3:9080/wiseoa/";
        }
        System.out.println(this.HomeURL);
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        SimpleDateFormat SDF = new SimpleDateFormat("HHmmss");
        randomPrefix = SDF.format(new Date());
        String s = this.getParameter("workid");
        if (s == null || s.equals("")) {
            s = "-9999";
        }
        this.workid = new Integer(s);
        s = this.getParameter("userid");
        if (s == null || s.equals("")) {
            s = "-9999";
        }
        this.userid = new Integer(s);
        s = this.getParameter("right");
        if (s == null || s.equals("")) {
            s = "false";
        }
        if (!s.equals("true")) {
            return;
        }
        this.photoCount = 0;
        Container cc = this.getContentPane();
        cc.setLayout(null);
        this.jp_toolbar = new JPanel();
        this.jp_toolbar.setLayout(new FlowLayout(1, 4, 0));
        this.jp_toolbar.setOpaque(true);
        this.jp_toolbar.setBackground(Color.white);
        cc.add(this.jp_toolbar);
        cc.setBackground(Color.white);
        this.jb_one = new JButton("\u62cd\u7167");
        this.jb_one.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.jp_toolbar.add(this.jb_one);
        this.jb_auto = new JButton("\u81ea\u52a8\u8fde\u62cd");
        this.jb_auto.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.jp_toolbar.add(this.jb_auto);
        this.jb_autoNow = new JButton("\u7acb\u5373\u62cd\u7167");
        this.jb_autoNow.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.jp_toolbar.add(this.jb_autoNow);
        this.jb_stopAuto = new JButton("\u53d6\u6d88");
        this.jb_stopAuto.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.jp_toolbar.add(this.jb_stopAuto);
        this.jl_tip = new JLabel();
        this.jl_tip.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.jl_tip.setOpaque(true);
        this.jl_tip.setBackground(Color.white);
        this.jl_tip.setHorizontalAlignment(0);
        cc.add(this.jl_tip);
        CaptureDeviceInfo di = null;
        String str1 = "vfw:Logitech USB Video Camera:0";
        String str2 = "vfw:Microsoft WDM Image Capture (Win32):0";
        di = CaptureDeviceManager.getDevice((String)str2);
        Format[] formats = di.getFormats();
        VideoFormat useingFormat = null;
        double maxRange = 0.0;
        int i = 0;
        while (i < formats.length) {
            if (formats[i] instanceof VideoFormat) {
                VideoFormat f = (VideoFormat)formats[i];
                Dimension d = f.getSize();
                if ((double)(d.width * d.height) > maxRange) {
                    useingFormat = f;
                    maxRange = d.width * d.height;
                    this.photoWidth = d.width;
                    this.photoHeight = d.height;
                }
            }
            ++i;
        }
        this.defaultTip = "\u7167\u7247\u5c3a\u5bf8\uff1a" + this.photoWidth + "\u00d7" + this.photoHeight + "(\u50cf\u7d20)";
        this.jl_tip.setText(this.defaultTip);
        this.bl = this.photoWidth / this.photoHeight;
        DataSource dataSource = JMFUtils.createCaptureDataSource(null, null, (String)str2, (Format)useingFormat);
        try {
            this.player = Manager.createRealizedPlayer((DataSource)dataSource);
            this.player.start();
            this.camera = this.player.getVisualComponent();
            if (this.camera != null) {
                this.camera.setLocation(30, 30);
                this.camera.setSize(300, 240);
                cc.add(this.camera);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.jb_one.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.snagit();
            }
        });
        this.jb_auto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.startAuto();
            }
        });
        this.jb_autoNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.stopAuto();
                MainFrame.this.snagit();
                MainFrame.this.startAuto();
            }
        });
        this.jb_stopAuto.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainFrame.this.stopAuto();
            }
        });
        this.componentResized(null);
        this.addComponentListener(this);
        this.enableAutoSnagit(true);
    }

    public void stopAuto() {
        this.autoSnagit = false;
        Tools.Delay(500);
    }

    public void startAuto() {
        this.autoSnagit = true;
        this.delaySnagit();
    }

    public void stop() {
        System.out.println("\u505c\u6b62\u6444\u50cf\u5934");
        try {
            this.player.stop();
            this.player.close();
        }
        catch (Exception e) {
            System.out.println("\u505c\u6b62\u6444\u50cf\u5934\u65f6\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    public void delaySnagit() {
        String s = this.jsrun("getDelaySecond");
        if (s == null) {
            s = "8";
        }
        int second = 5;
        try {
            second = Integer.valueOf(s);
        }
        catch (Exception e) {
            Tools.ShowInfo(this, "\u95f4\u9694\u65f6\u95f4\u4e0d\u6b63\u786e");
            return;
        }
        this.enableAutoSnagit(false);
        this.CD = new CountDown();
        this.CD.second = second;
        this.CD.start();
    }

    public void snagit() {
        TimeMark tm = new TimeMark();
        this.jb_autoNow.setEnabled(false);
        this.jb_one.setEnabled(false);
        ++this.photoCount;
        Buffer buf = null;
        BufferToImage btoi = null;
        Image img = null;
        FrameGrabbingControl fgc = (FrameGrabbingControl)this.player.getControl("javax.media.control.FrameGrabbingControl");
        buf = fgc.grabFrame();
        tm.stamp("grabFrame");
        btoi = new BufferToImage((VideoFormat)buf.getFormat());
        img = btoi.createImage(buf);
        BufferedImage bi = (BufferedImage)this.getContentPane().createImage(1280, 1024);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(img, null, null);
        tm.stamp("drawImage");
        this.jl_tip.setText("\u5df2\u62cd\u7167\uff0c\u6b63\u5728\u4fdd\u5b58...");
        Tools.Delay(100);
        try {
            try {
                byte[] bs = null;
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bo);
                ImageIO.write((RenderedImage)bi, "jpg", bos);
                bos.flush();
                bos.close();
                bs = bo.toByteArray();
                tm.stamp("get bytes");
                String name = this.getPhotoName(this.jsrun("getPhotoName"));
                System.out.println("\u4fdd\u5b58\u7167\u7247\uff1a" + name);
                RPCParameter p = new RPCParameter();
                p.put("workid", this.workid);
                p.put("userid", this.userid);
                p.put("filename", name);
                p.put("bytes", bs);
                p = RPC.Call(String.valueOf(this.HomeURL) + "servlet/wiseoa.flow.appletrpc.LoadFlowFormConfig", "saveCamera", p);
                tm.stamp("rpc save ");
                if (p.Success) {
                    final String data = p.get("data", "");
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MainFrame.this.jsrun("appendPhotoList", new Object[]{data});
                        }
                    });
                } else {
                    System.out.println(p.ErrorText);
                }
                this.jl_tip.setText(this.defaultTip);
                tm.stamp("all over");
            }
            catch (Exception ee) {
                this.jl_tip.setText(ee.getMessage());
                g2.dispose();
                this.jb_autoNow.setEnabled(true);
                this.jb_one.setEnabled(true);
            }
        }
        finally {
            g2.dispose();
            this.jb_autoNow.setEnabled(true);
            this.jb_one.setEnabled(true);
        }
    }

    public String getPhotoName(String name) {
        if (name == null) {
            name = "\u968f\u673a\u547d\u540d";
        }
        String t = "00" + this.photoCount;
        t = t.substring(t.length() - 3);
        if (name.equals("\u968f\u673a\u547d\u540d")) {
            return "\u7167\u7247" + randomPrefix + "-" + t + ".jpg";
        }
        return String.valueOf(name) + ".jpg";
    }

    public String jsrun(String func) {
        Object o = this.jsrun(func, new Object[0]);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Object jsrun(String func, Object[] p) {
        try {
            JSObject win = JSObject.getWindow((Applet)this);
            Object ret = win.call(func, p);
            return ret;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return e.getMessage();
        }
    }

    public static BufferedImage rotateImg(BufferedImage image, int degree, Color bgcolor) {
        int iw = image.getWidth();
        int ih = image.getHeight();
        int w = 0;
        int h = 0;
        int x = 0;
        int y = 0;
        if ((degree %= 360) < 0) {
            degree += 360;
        }
        double ang = (double)degree * 0.0174532925;
        if (degree == 180 || degree == 0 || degree == 360) {
            w = iw;
            h = ih;
        } else if (degree == 90 || degree == 270) {
            w = ih;
            h = iw;
        } else {
            int d = iw + ih;
            w = (int)((double)d * Math.abs(Math.cos(ang)));
            h = (int)((double)d * Math.abs(Math.sin(ang)));
        }
        x = w / 2 - iw / 2;
        y = h / 2 - ih / 2;
        BufferedImage rotatedImage = new BufferedImage(w, h, image.getType());
        Graphics gs = rotatedImage.getGraphics();
        gs.setColor(bgcolor);
        gs.fillRect(0, 0, w, h);
        AffineTransform at = new AffineTransform();
        at.rotate(ang, w / 2, h / 2);
        at.translate(x, y);
        AffineTransformOp op = new AffineTransformOp(at, 1);
        op.filter(image, rotatedImage);
        image = rotatedImage;
        gs.dispose();
        return image;
    }

    public static void main(String[] args) {
        MainFrame cf = new MainFrame();
        cf.init();
        cf.start();
        JFrame f = new JFrame();
        f.setBounds(0, 0, 800, 600);
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(cf);
        f.doLayout();
        f.setVisible(true);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        Rectangle rc = this.getContentPane().getBounds();
        this.jp_toolbar.setBounds(0, 0, rc.width, 24);
        this.jl_tip.setBounds(0, 24, rc.width, 20);
        this.jp_toolbar.doLayout();
        if (this.camera != null) {
            int top = this.jl_tip.getBounds().y + this.jl_tip.getBounds().height + 3;
            this.camera.setLocation(0, top);
            double w = rc.width;
            double h = (double)rc.width * 1.0 / (double)this.photoWidth * (double)this.photoHeight;
            int h1 = rc.height - top - 5;
            if (h > (double)h1) {
                h = h1;
                w = h / (double)this.photoHeight * (double)this.photoWidth;
            }
            this.camera.setSize((int)w, (int)h);
            this.camera.setLocation((rc.width - (int)w) / 2, top);
        }
    }

    public void componentShown(ComponentEvent e) {
        this.componentResized(e);
    }

    class CountDown
    extends Thread {
        int second = 0;

        CountDown() {
        }

        public void run() {
            while (true) {
                boolean n = false;
                int i = 0;
                while (i < this.second) {
                    int j = 0;
                    while (j < 10) {
                        if (!MainFrame.this.autoSnagit) {
                            MainFrame.this.enableAutoSnagit(true);
                            return;
                        }
                        try {
                            CountDown.sleep(100L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++j;
                    }
                    MainFrame.this.jl_tip.setText("\u7b49\u5f85" + (this.second - i) + "\u79d2\u540e\u81ea\u52a8\u62cd\u7167(\u70b9\u51fb\u7acb\u5373\u62cd\u7167\u53ef\u4ee5\u4e0d\u5fc5\u7b49\u5f85)");
                    ++i;
                }
                MainFrame.this.jl_tip.setText("\u6b63\u5728\u62cd\u7167...");
                MainFrame.this.snagit();
            }
        }
    }
}

