/*
 * Decompiled with CFR 0.152.
 */
package com.jeans.trayicon;

import com.jeans.trayicon.TrayIconButton;
import com.jeans.trayicon.TrayIconCallback;
import com.jeans.trayicon.TrayIconException;
import com.jeans.trayicon.TrayIconPopup;
import com.jeans.trayicon.TrayIconPopupSeparator;
import com.jeans.trayicon.TrayIconPopupSimpleItem;
import com.jeans.trayicon.WindowsTrayIcon;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;

public class TestTrayIcon
extends JFrame {
    private TrayIconButton icon;
    private Button exit_bt;
    private Button hide_bt;

    public TestTrayIcon() throws TrayIconException, InterruptedException {
        super("Test Icon");
        this.setBackground(SystemColor.control);
        WindowsTrayIcon.setWindowsMessageCallback(new WindowsMessageCallback());
        this.setLayout(new GridLayout(0, 1, 3, 3));
        this.setIconImage(TestTrayIcon.loadImage("Duke16.gif"));
        this.icon = new TrayIconButton("Duke", TestTrayIcon.loadImage("Duke16.gif"), 16, 16);
        this.add(this.icon);
        RestoreListener listener = new RestoreListener(false);
        this.icon.addActionListener(listener);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 0, 3, 3));
        this.exit_bt = new Button("Exit");
        panel.add(this.exit_bt);
        this.exit_bt.addActionListener(new ExitListener());
        this.hide_bt = new Button("Hide");
        panel.add(this.hide_bt);
        this.hide_bt.addActionListener(new HideListener());
        this.icon.setPopup(this.makePopup());
        this.add(panel);
        this.pack();
        this.validate();
        this.addWindowListener(new ExitWindowListener());
    }

    public TrayIconPopup makePopup() {
        TrayIconPopup popup = new TrayIconPopup();
        TrayIconPopupSimpleItem item = new TrayIconPopupSimpleItem("&S\ufffd\ufffd\u02be");
        item.setDefault(true);
        item.addActionListener(new RestoreListener(true));
        popup.addMenuItem(item);
        popup.addMenuItem(new TrayIconPopupSeparator());
        item = new TrayIconPopupSimpleItem("&X\ufffd\u02f3\ufffd");
        item.addActionListener(new ExitListener());
        popup.addMenuItem(item);
        return popup;
    }

    public static Image loadImage(String fileName) {
        return Toolkit.getDefaultToolkit().getImage("src/images" + File.separator + fileName);
    }

    public static void main(String[] args) {
        try {
            String appName = "TestTray";
            long result = WindowsTrayIcon.sendWindowsMessage(appName, 1234);
            if (result != -1L) {
                System.out.println("Already running other instance of " + appName + " (returns: " + result + ")");
                return;
            }
            WindowsTrayIcon.initTrayIcon(appName);
            TestTrayIcon test = new TestTrayIcon();
            TestTrayIcon.centerDialog(test);
            test.setVisible(true);
        }
        catch (TrayIconException e) {
            System.out.println("Error: " + e.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doExit() {
        System.out.println("Exit selected.");
        WindowsTrayIcon.cleanUp();
        System.exit(0);
    }

    public void doHide(boolean exitOnFail) {
        System.out.println("Hide selected.");
        boolean visible = true;
        if (this.icon.testVisible()) {
            visible = false;
        }
        this.setVisible(visible);
        if (visible) {
            System.out.println("Hide works only when there's an icon in the system tray.");
            if (exitOnFail) {
                this.doExit();
            }
        }
    }

    public static void centerDialog(Window frame) {
        Dimension dialogSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - dialogSize.width / 2, screenSize.height / 2 - dialogSize.height / 2);
    }

    private class ExitListener
    implements ActionListener {
        private ExitListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            TestTrayIcon.this.doExit();
        }
    }

    private class ExitWindowListener
    extends WindowAdapter {
        private ExitWindowListener() {
        }

        public void windowClosing(WindowEvent evt) {
            WindowsTrayIcon.cleanUp();
            System.exit(0);
        }
    }

    private class HideListener
    implements ActionListener {
        private HideListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            TestTrayIcon.this.doHide(false);
        }
    }

    private class RestoreListener
    implements ActionListener {
        protected boolean from_menu;

        public RestoreListener(boolean fromMenu) {
            this.from_menu = fromMenu;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.from_menu) {
                System.out.println("Restore selected..");
            } else {
                System.out.println("Tray icon button pressed..");
            }
            TestTrayIcon.this.setVisible(true);
            TestTrayIcon.this.requestFocus();
        }
    }

    private class WindowsMessageCallback
    implements TrayIconCallback {
        private WindowsMessageCallback() {
        }

        public int callback(int param) {
            System.out.println("Other instance started (parameter: " + param + ")");
            TestTrayIcon.this.setVisible(true);
            TestTrayIcon.this.requestFocus();
            return 4321;
        }
    }
}

