/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import jun.df.Areas;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.DrawTool;

public class HeadTool
extends DrawTool {
    int m_mousestate = 5;
    int m_col;
    int m_DownCol;
    Point m_LastDrawPos = new Point();
    Rectangle m_headrect = new Rectangle();

    public HeadTool() {
        super(2);
    }

    public void OnLButtonDown(DataView pView, MouseEvent e) {
        super.OnLButtonDown(pView, e);
        if (DrawTool.c_MouseDownObject != null && DrawTool.c_MouseDownObject.m_ObjectType == 4 && DrawTool.c_MouseDownObject.GetActAsButton()) {
            return;
        }
        Point point = e.getPoint();
        this.m_mousestate = 6;
        DataDoc pDoc = pView.GetDoc();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        Rectangle rectCenter = new Rectangle();
        Rectangle client = pView.getBounds();
        this.m_DownCol = this.m_col = pView.GetHeadRect(point, rect, client);
        this.m_LastDrawPos.x = rect.x;
        this.m_LastDrawPos.y = rect.y + rect.height;
        this.m_headrect = (Rectangle)rect.clone();
        rectLT.setBounds(rect.x, rect.y, delta.x, rect.height / 4);
        rectLB.setBounds(rect.x, rect.y + rect.height / 4, delta.x, rect.height * 3 / 4);
        rectRT.setBounds(rect.x + rect.width - delta.x, rect.y, delta.x, rect.height / 4);
        rectRB.setBounds(rect.x + rect.width - delta.x, rect.y + rect.height / 4, delta.x, rect.height * 3 / 4);
        rectCenter.setBounds(rect.x + delta.x, rect.y, rect.width - 2 * delta.x, rect.height);
        if (this.m_col > -1) {
            if (rectLT.contains(point)) {
                pView.setCursor(this.GetCursor("LT.gif", pView));
                this.m_mousestate = 0;
            }
            if (rectLB.contains(point)) {
                pView.setCursor(this.GetCursor("LB.gif", pView));
                this.m_mousestate = 1;
            }
            if (rectRT.contains(point)) {
                pView.setCursor(this.GetCursor("RT.gif", pView));
                this.m_mousestate = 2;
            }
            if (rectRB.contains(point)) {
                pView.setCursor(this.GetCursor("RB.gif", pView));
                this.m_mousestate = 3;
            }
            if (rectCenter.contains(point) && pView.GetDoc().m_ColumnMove) {
                pView.setCursor(this.GetCursor("MOVE.gif", pView));
                this.m_mousestate = 4;
                pView.DrawXorLine(this.m_LastDrawPos.x, this.m_LastDrawPos.y - 20, this.m_LastDrawPos.x, this.m_LastDrawPos.y);
            }
        }
        if (this.m_mousestate == 0 || this.m_mousestate == 1 || this.m_mousestate == 2 || this.m_mousestate == 3) {
            pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
        }
        if (this.m_mousestate == 6 || this.m_mousestate == 5) {
            DrawTool.c_drawShape = 0;
            DataView.selectTool.OnLButtonDown(pView, e);
        }
    }

    public void OnLButtonDblClk(DataView pView, MouseEvent e) {
        pView.ReleaseCapture();
        c_drawShape = 0;
    }

    public void OnLButtonUp(DataView pView, MouseEvent e) {
        Point point = e.getPoint();
        Rectangle rect = new Rectangle();
        DataDoc pDoc = pView.GetDoc();
        Areas pArea = pDoc.m_Areas;
        int areaCount = pArea.Count();
        Rectangle client = pView.getBounds();
        if (this.m_col > -1) {
            switch (this.m_mousestate) {
                case 0: 
                case 2: {
                    int col2;
                    int col1;
                    if (this.m_mousestate == 0) {
                        col1 = this.m_col - 1;
                        col2 = this.m_col;
                    } else {
                        col1 = this.m_col;
                        col2 = this.m_col;
                        while (++col2 < areaCount - 1 && pArea.AreaWidth(col2) <= 0) {
                        }
                    }
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    if (col2 >= areaCount) break;
                    int delta = Math.max(0, point.x - pArea.AreaLeft(pDoc.leftBlank, col1, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn));
                    int w1 = pArea.AreaWidth(col1);
                    int w2 = pArea.AreaWidth(col2);
                    int delta2 = delta - w1;
                    pArea.SetAreaWidth(col2, pArea.AreaWidth(col2) - delta2);
                    if (pArea.AreaWidth(col2) < 0) {
                        pArea.SetAreaWidth(col2, 0);
                        pArea.SetAreaWidth(col1, w1 + w2);
                    } else {
                        pArea.SetAreaWidth(col1, Math.max(0, delta));
                    }
                    pView.repaint();
                    break;
                }
                case 1: 
                case 3: {
                    int col1 = this.m_mousestate == 1 ? this.m_col - 1 : this.m_col;
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    int delta = Math.max(0, point.x - pArea.AreaLeft(pDoc.leftBlank, col1, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn));
                    pArea.SetAreaWidth(col1, delta);
                    pView.repaint();
                    break;
                }
                case 4: {
                    pView.setCursor(this.GetCursor("DEFAULT", pView));
                    this.m_col = pView.GetHeadRect(point, rect, client);
                    pView.DrawXorLine(this.m_LastDrawPos.x, this.m_LastDrawPos.y - 20, this.m_LastDrawPos.x, this.m_LastDrawPos.y);
                    pView.MoveArea(this.m_DownCol, this.m_col, this.m_DownCol > this.m_col ? -1 : 1);
                }
            }
        }
        pView.repaint();
        this.m_mousestate = 5;
        super.OnLButtonUp(pView, e);
    }

    public void OnMouseMove(DataView pView, MouseEvent e) {
        Point point = e.getPoint();
        DataDoc pDoc = pView.GetDoc();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        if (this.m_mousestate == 5 || this.m_mousestate == 6) {
            this.m_col = pView.GetHeadRect(point, rect, null);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_col > -1) {
            rectLT.setBounds(rect.x, rect.y, delta.x, rect.height / 2);
            rectRT.setBounds(rect.x + rect.width - delta.x, rect.y, delta.x, rect.height / 2);
            rectLB.setBounds(rect.x, rect.y + rect.height / 2, delta.x, rect.height * 1 / 2);
            rectRB.setBounds(rect.x + rect.width - delta.x, rect.y + rect.height / 2, delta.x, rect.height * 1 / 2);
            String hCur = "DEFAULT";
            if (rectLT.contains(point)) {
                hCur = "LT.gif";
            }
            if (rectRT.contains(point)) {
                hCur = "RT.gif";
            }
            if (rectLB.contains(point)) {
                hCur = "LB.gif";
            }
            if (rectRB.contains(point)) {
                hCur = "RB.gif";
            }
            pView.setCursor(this.GetCursor(hCur, pView));
        }
        super.OnMouseMove(pView, e);
        if (!pView.GetCapture() && !pView.IsOnHeader(point, null)) {
            pView.setCursor(this.GetCursor("DEFAULT", pView));
            DrawTool.c_drawShape = 0;
        }
    }

    public void OnMouseDrag(DataView pView, MouseEvent e) {
        Point point = e.getPoint();
        DataDoc pDoc = pView.GetDoc();
        Point delta = new Point(3, 0);
        Rectangle rect = new Rectangle();
        Rectangle rectLT = new Rectangle();
        Rectangle rectLB = new Rectangle();
        Rectangle rectRT = new Rectangle();
        Rectangle rectRB = new Rectangle();
        if (this.m_mousestate == 5 || this.m_mousestate == 6) {
            this.m_col = pView.GetHeadRect(point, rect, null);
            this.m_headrect = (Rectangle)rect.clone();
        } else {
            rect = (Rectangle)this.m_headrect.clone();
        }
        if (this.m_col > -1) {
            switch (this.m_mousestate) {
                case 0: 
                case 1: {
                    if (this.m_mousestate == 0) {
                        pView.setCursor(this.GetCursor("LT.gif", pView));
                    }
                    if (this.m_mousestate == 1) {
                        pView.setCursor(this.GetCursor("LB.gif", pView));
                    }
                    Rectangle client = pView.getBounds();
                    pView.DrawXorLine(HeadTool.c_last.x, client.y, HeadTool.c_last.x, client.y + client.height);
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.m_mousestate == 2) {
                        pView.setCursor(this.GetCursor("RT.gif", pView));
                    }
                    if (this.m_mousestate == 3) {
                        pView.setCursor(this.GetCursor("RB.gif", pView));
                    }
                    Rectangle client = pView.getBounds();
                    pView.DrawXorLine(HeadTool.c_last.x, client.y, HeadTool.c_last.x, client.y + client.height);
                    pView.DrawXorLine(point.x, client.y, point.x, client.y + client.height);
                    break;
                }
                case 4: {
                    pView.setCursor(this.GetCursor("MOVE.gif", pView));
                    Rectangle client = pView.getBounds();
                    this.m_col = pView.GetHeadRect(point, rect, client);
                    pView.DrawXorLine(this.m_LastDrawPos.x, this.m_LastDrawPos.y - 20, this.m_LastDrawPos.x, this.m_LastDrawPos.y);
                    this.m_LastDrawPos.x = rect.x;
                    this.m_LastDrawPos.y = rect.y + rect.height;
                    pView.DrawXorLine(this.m_LastDrawPos.x, this.m_LastDrawPos.y - 20, this.m_LastDrawPos.x, this.m_LastDrawPos.y);
                }
            }
        }
        super.OnMouseDrag(pView, e);
        if (!pView.GetCapture() && !pView.IsOnHeader(point, null)) {
            pView.setCursor(this.GetCursor("DEFAULT", pView));
            DrawTool.c_drawShape = 0;
        }
    }

    public void OnRButtonDown(DataView pView, MouseEvent e) {
        super.OnRButtonDown(pView, e);
    }
}

