/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import javax.swing.JTextField;
import jun.db.core.ObjectTool;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.DrawObject;
import jun.df.IEditNumeric;

public class EditNumeric
extends JTextField
implements FocusListener,
KeyListener {
    DataDoc m_pDoc;
    DataView m_pView;
    int m_Row;
    Rectangle m_Rect;
    DrawObject m_pObject;
    private double m_dblCurrentValue = 0.0;
    private boolean m_ShowComma = true;
    private int m_DecimalCount = 4;
    private char m_DecimalSeparator;
    private char m_GroupingSeparator;
    private boolean m_AutoSelect = true;

    public EditNumeric() {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        this.m_DecimalSeparator = dfs.getDecimalSeparator();
        this.m_GroupingSeparator = dfs.getGroupingSeparator();
        this.setHorizontalAlignment(4);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void BeginEdit(DataDoc pDoc, DataView pView, DrawObject obj, Rectangle rc, int row) {
        Double d;
        this.m_pDoc = pDoc;
        this.m_pView = pView;
        this.m_pObject = obj;
        this.m_Rect = (Rectangle)rc.clone();
        this.m_Row = row;
        Object v = this.m_pObject.GetValue(this.m_pDoc, this.m_Row);
        try {
            d = (Double)ObjectTool.ChangeType((Object)v, (String)"java.lang.Double");
        }
        catch (Exception e) {
            d = null;
        }
        this.m_Rect.x += 2;
        ++this.m_Rect.y;
        this.m_Rect.width -= 3;
        this.m_Rect.height -= 2;
        this.setBounds(this.m_Rect);
        this.setBorder(null);
        this.setFont(this.m_pObject.GetFont(this.m_pDoc, this.m_Row));
        this.m_pView.getParent().add((Component)this, 2);
        this.setFocusable(true);
        String esn = this.m_pObject.GetEditStyleName(row);
        int dc = 0;
        if (esn.length() == 0) {
            if (this.m_pObject.GetUniformDataType() == 1) {
                esn = "\u6574\u6570\u6570\u7f3a\u7701\u683c\u5f0f";
                dc = 0;
            } else {
                esn = "\u5c0f\u6570\u7f3a\u7701\u683c\u5f0f";
                dc = this.m_pObject.GetDecimalCount();
            }
        }
        IEditNumeric ien = (IEditNumeric)pDoc.GetEditStyle(esn);
        dc = ien.GetDecimalCount();
        this.SetShowComma(ien.GetShowComma());
        this.SetDecimalCount(dc);
        this.SetValue(d);
        this.m_AutoSelect = ien.GetAutoSelect();
        this.requestFocus();
    }

    public double GetValue() {
        String s = this.getText();
        DecimalFormat df = new DecimalFormat(this.GetPattern());
        df.setGroupingSize(3);
        try {
            return df.parse(s).doubleValue();
        }
        catch (ParseException e) {
            return 0.0;
        }
    }

    public void SetValue(double dblValue) {
        String t = this.toString(dblValue);
        this.setText(t);
    }

    public void SetValue(Double d) {
        if (d == null) {
            this.SetValue(0.0);
        } else {
            this.SetValue((double)d);
        }
    }

    public String GetPattern() {
        return EditNumeric.GetPattern(this.m_DecimalCount, this.m_DecimalSeparator, this.m_ShowComma, this.m_GroupingSeparator);
    }

    public static String GetPattern(int DecimalCount, char DecimalSeparator, boolean ShowComma, char GroupingSeparator) {
        String pattern;
        if (DecimalCount == 0) {
            pattern = "###,###,###,###,###,###,##0";
        } else {
            String t = "00000000000000000000";
            t = t.substring(0, DecimalCount);
            pattern = "###,###,###,###,###,###,##0." + t;
        }
        if (DecimalSeparator != '.') {
            pattern.replaceAll(".", String.valueOf(DecimalSeparator));
        }
        if (!ShowComma) {
            pattern.replaceAll(",", "");
        }
        if (ShowComma && GroupingSeparator != ',') {
            pattern.replaceAll(",", String.valueOf(GroupingSeparator));
        }
        return pattern;
    }

    static double Round(double num, int i) {
        return ObjectTool.Round((double)num, (int)i);
    }

    String toString(double dblValue) {
        String pattern = this.GetPattern();
        return EditNumeric.toString(dblValue, pattern, this.m_DecimalCount);
    }

    public static String toString(double dblValue, String pattern) {
        int n = pattern.length();
        int p = pattern.indexOf(".");
        if (p < 0) {
            p = n;
        }
        int DecimalCount = n - p;
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(EditNumeric.Round(dblValue, DecimalCount));
    }

    public static String toString(double dblValue, String pattern, int DecimalCount) {
        DecimalFormat df = new DecimalFormat(pattern);
        df.setGroupingSize(3);
        return df.format(EditNumeric.Round(dblValue, DecimalCount));
    }

    int CaretFarAwayDot() {
        int p = this.getCaretPosition();
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            return n - p;
        }
        return n - p - this.m_DecimalCount - 1;
    }

    int DotPos() {
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            return n;
        }
        return n - this.m_DecimalCount - 1;
    }

    public void SetShowComma(boolean b) {
        this.m_ShowComma = b;
    }

    public boolean GetShowComma() {
        return this.m_ShowComma;
    }

    public int GetDecimalCount() {
        return this.m_DecimalCount;
    }

    public void SetDecimalCount(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 20) {
            n = 20;
        }
        this.m_DecimalCount = n;
    }

    public void focusGained(FocusEvent e) {
        int n = this.getText().length();
        if (this.m_DecimalCount == 0) {
            this.setCaretPosition(n);
        } else {
            this.setCaretPosition(Math.max(n - this.m_DecimalCount - 1, 0));
        }
        if (this.m_AutoSelect) {
            this.setSelectionStart(0);
            this.setSelectionEnd(n);
        }
    }

    public void focusLost(FocusEvent e) {
        double d = this.GetValue();
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.m_pObject.SetValue(new Double(d), this.m_pDoc, this.m_Row);
        this.m_pView.repaint(this.m_Rect.x, this.m_Rect.y, this.m_Rect.width, this.m_Rect.height);
        this.m_pView.EndEdit(this.m_Row, this.m_pObject);
    }

    private void ProcessBackSpace() {
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        if (cp == 0) {
            return;
        }
        String t = this.getText();
        if (t.charAt(0) == '-' && cp == 1) {
            return;
        }
        int cfad = this.CaretFarAwayDot();
        char c = t.charAt(cp - 1);
        if (c == this.m_DecimalSeparator || c == this.m_GroupingSeparator) {
            this.setCaretPosition(cp - 1);
            return;
        }
        String s = String.valueOf(t.substring(0, cp - 1)) + t.substring(cp);
        s = s.replaceAll(String.valueOf(this.m_GroupingSeparator), "");
        double d = 0.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (Exception e) {
            d = 0.0;
        }
        this.SetValue(d);
        if (cfad >= 0) {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        } else {
            this.setCaretPosition(Math.max(this.DotPos() - cfad - 1, 0));
        }
    }

    private void ProcessDelete() {
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        String t = this.getText();
        if (cp == t.length()) {
            return;
        }
        char c = t.charAt(cp);
        if (c == this.m_GroupingSeparator || c == '-') {
            this.setCaretPosition(cp + 2);
        } else {
            this.setCaretPosition(cp + 1);
        }
        this.ProcessBackSpace();
    }

    private void ProcessNumber(char pch) {
        String s;
        this.ReplaceSel();
        int cp = this.getCaretPosition();
        String t = this.getText();
        int cfad = 0;
        if (cp == t.length()) {
            s = String.valueOf(t) + String.valueOf(pch);
        } else {
            cfad = this.CaretFarAwayDot();
            char c = t.charAt(cp);
            if (c == '-') {
                ++cp;
            }
            s = String.valueOf(t.substring(0, cp)) + String.valueOf(pch) + t.substring(cp);
        }
        s = s.replaceAll(String.valueOf(this.m_GroupingSeparator), "");
        double d = Double.parseDouble(s);
        this.SetValue(d);
        if (cfad >= 0) {
            this.setCaretPosition(Math.max(this.DotPos() - cfad, 0));
        } else {
            this.setCaretPosition(Math.max(this.DotPos() - cfad + 1, 0));
        }
        if (d == 0.0 && t.charAt(0) == '-') {
            cp = this.getCaretPosition();
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }
    }

    private void ReplaceSel() {
        this.replaceSelection("");
        if (this.getText().indexOf(46) < 0) {
            this.SetValue(this.GetValue());
            this.setCaretPosition(this.DotPos());
        }
    }

    private void ProcessDot() {
        this.ReplaceSel();
        if (this.m_DecimalCount == 0) {
            return;
        }
        this.setCaretPosition(this.DotPos() + 1);
    }

    private void ProcessMINUS() {
        this.ReplaceSel();
        double d = this.GetValue();
        int cp = this.getCaretPosition();
        String t = this.getText();
        int n = t.charAt(0) == '-' ? -1 : 1;
        this.SetValue(-d);
        this.setCaretPosition(cp += n);
        if (d == 0.0 && t.charAt(0) != '-') {
            this.setText("-" + this.getText());
            this.setCaretPosition(cp + 1);
        }
    }

    private void ProcessPLUS() {
        this.ReplaceSel();
        double d = this.GetValue();
        if (d >= 0.0) {
            return;
        }
        this.ProcessMINUS();
    }

    public void keyTyped(KeyEvent e) {
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        char c = e.getKeyChar();
        if (c >= '0' && c <= '9') {
            this.ProcessNumber(c);
            e.consume();
        }
        if (c == '.') {
            this.ProcessDot();
        }
        if (c == '-') {
            this.ProcessMINUS();
        }
        if (c == '+') {
            this.ProcessPLUS();
        }
        switch (e.getKeyCode()) {
            case 8: {
                this.ProcessBackSpace();
                e.consume();
                break;
            }
            case 127: {
                this.ProcessDelete();
                e.consume();
                break;
            }
            case 38: 
            case 40: {
                this.m_pView.requestFocus();
                break;
            }
            case 9: {
                this.m_pView.requestFocus();
                break;
            }
            case 10: {
                this.m_pView.requestFocus();
                break;
            }
            case 27: {
                break;
            }
        }
        this.m_pView.Simulate_keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
    }
}

