/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JTextField;
import jun.db.core.ObjectTool;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.DrawObject;
import jun.df.IEditDateTime;

public class EditDatetime
extends JTextField
implements FocusListener,
KeyListener {
    String m_strMask = "YYYY.MM.DD hh:mm:ss";
    String m_strMask2 = "yyyy.MM.dd HH:mm:ss";
    DataDoc m_pDoc;
    DataView m_pView;
    int m_Row;
    Rectangle m_Rect;
    DrawObject m_pObject;

    public void BeginEdit(DataDoc pDoc, DataView pView, DrawObject obj, Rectangle rc, int row) {
        this.m_pDoc = pDoc;
        this.m_pView = pView;
        this.m_pObject = obj;
        this.m_Rect = (Rectangle)rc.clone();
        this.m_Row = row;
        Object v = this.m_pObject.GetValue(this.m_pDoc, this.m_Row);
        this.m_Rect.x += 2;
        ++this.m_Rect.y;
        this.m_Rect.width -= 3;
        this.m_Rect.height -= 2;
        this.setBounds(this.m_Rect);
        this.setBorder(null);
        this.setFont(this.m_pObject.GetFont(this.m_pDoc, this.m_Row));
        this.m_pView.getParent().add((Component)this, 2);
        this.setFocusable(true);
        this.requestFocus();
        String esn = this.m_pObject.GetEditStyleName(row);
        if (esn.length() == 0) {
            esn = "\u65e5\u671f\u7f3a\u7701\u683c\u5f0f";
        }
        IEditDateTime ied = (IEditDateTime)pDoc.GetEditStyle(esn);
        this.SetFormat(ied.GetFormat());
        this.SetDateTime(v);
        if (ied.GetAutoSelect()) {
            this.setSelectionStart(0);
            this.setSelectionEnd(this.getText().length());
        }
    }

    public EditDatetime() {
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void SetFormat(String mask) {
        this.m_strMask = mask;
        this.m_strMask2 = EditDatetime.convertMask(mask);
    }

    public static String convertMask(String mask) {
        return mask.replaceAll("YYYY", "yyyy").replaceAll("YY", "yy").replaceAll("DD", "dd").replaceAll("hh", "HH");
    }

    public static String Date2String(Date d, String mask) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            dateFormat.applyPattern(mask);
            dateFormat.setLenient(false);
            return dateFormat.format(d);
        }
        catch (Exception e) {
            String s = mask;
            s = s.replaceAll("y", " ").replaceAll("m", " ").replaceAll("d", " ").replaceAll("h", " ").replaceAll("s", " ").replaceAll("Y", " ").replaceAll("M", " ").replaceAll("D", " ").replaceAll("H", " ").replaceAll("S", " ");
            return s;
        }
    }

    Date validateDate(String vDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        try {
            dateFormat.applyPattern(this.m_strMask2);
            dateFormat.setLenient(false);
            Date date = dateFormat.parse(vDate);
            return date;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void SetDateTime(Object v) {
        try {
            Date d = (Date)ObjectTool.ChangeType((Object)v, (String)"java.sql.Date");
            int p = this.getSelectionStart();
            this.setText(EditDatetime.Date2String(d, this.m_strMask2));
            this.setSelectionStart(p);
            this.setSelectionEnd(p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Date GetDateTime() {
        return this.validateDate(this.getText());
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        Date d = this.GetDateTime();
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
        this.m_pObject.SetValue(d, this.m_pDoc, this.m_Row);
        this.m_pView.repaint(this.m_Rect.x, this.m_Rect.y, this.m_Rect.width, this.m_Rect.height);
        this.m_pView.EndEdit(this.m_Row, this.m_pObject);
    }

    public void keyTyped(KeyEvent e) {
        e.consume();
        String old = this.getText();
        char nChar = e.getKeyChar();
        int pos = this.getSelectionStart();
        switch (e.getKeyCode()) {
            case 8: 
            case 38: {
                --pos;
                break;
            }
            case 9: {
                break;
            }
        }
        block4 : switch (nChar) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int maskLength;
                String str;
                Date d;
                if (pos >= this.m_strMask.length()) break;
                char c = this.m_strMask.charAt(pos);
                if (pos < old.length() && pos < this.m_strMask.length() && old.charAt(pos) != nChar && (c == 'D' || c == 'M' || c == 'Y' || c == 'h' || c == 'm' || c == 's') && (d = this.validateDate(str = String.valueOf(old.substring(0, pos)) + nChar + old.substring(pos + 1))) != null) {
                    this.SetDateTime(d);
                }
                if (++pos >= (maskLength = this.m_strMask.length())) break;
                while (pos < maskLength) {
                    c = this.m_strMask.charAt(pos);
                    if (c == 'D' || c == 'M' || c == 'Y' || c == 'h' || c == 'm' || c == 's') break block4;
                    ++pos;
                }
                break;
            }
        }
        this.setSelectionStart(pos);
        this.setSelectionEnd(pos);
    }

    public void keyPressed(KeyEvent e) {
        String old = this.getText();
        if (this.validateDate(old) == null && e.getKeyCode() != 10) {
            this.SetDateTime(new Date());
        }
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                e.consume();
                if (this.getSelectionStart() != 0 || this.getSelectionEnd() != this.getText().length()) break;
                this.SetDateTime(null);
                break;
            }
            case 155: {
                e.consume();
                break;
            }
            case 38: 
            case 40: {
                e.consume();
                int pos = this.getSelectionStart();
                Date d = this.validateDate(old);
                if (d == null) {
                    return;
                }
                if (pos < this.m_strMask.length()) {
                    char c = this.m_strMask.charAt(pos);
                    if (c != 'D' && c != 'M' && c != 'Y' && c != 'h' && c != 'm' && c != 's' && --pos >= 0) {
                        c = this.m_strMask.charAt(pos);
                    }
                    GregorianCalendar cd = new GregorianCalendar();
                    cd.setTime(d);
                    int nChar = e.getKeyCode();
                    switch (c) {
                        case 'D': {
                            ((Calendar)cd).add(5, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'M': {
                            ((Calendar)cd).add(2, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'Y': {
                            ((Calendar)cd).add(1, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'h': {
                            ((Calendar)cd).add(10, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 'm': {
                            ((Calendar)cd).add(12, nChar != 38 ? -1 : 1);
                            break;
                        }
                        case 's': {
                            ((Calendar)cd).add(13, nChar != 38 ? -1 : 1);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.SetDateTime(cd.getTime());
                }
                return;
            }
            case 9: 
            case 10: {
                e.consume();
                this.m_pView.requestFocus();
            }
        }
        this.m_pView.Simulate_keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
    }
}

