/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.text.Position;
import jun.df.ConfigEditComboBox;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.DrawObject;
import jun.df.MyEdit;
import jun.df.MyList;

public class DropDownListBox
extends JComponent
implements MouseListener {
    DataDoc m_pDoc;
    DataView m_pView;
    int m_Row;
    Rectangle m_Rect;
    DrawObject m_pObject;
    ConfigEditComboBox m_CBO;
    public Color parentBkColor = new Color(255, 255, 255);
    public Color bkColor = new Color(242, 241, 238);
    public Color BorderColor = new Color(0, 102, 153);
    public boolean isDown = false;
    public boolean isMouseEnter = false;
    int x;
    int bw;
    int width;
    int height;
    MyEdit m_Edit;
    MyList dataList;
    JScrollPane scrollPane;
    public Color HighLight = Color.WHITE;
    public Color LowerLight = new Color(197, 193, 177);

    public DropDownListBox() {
        this.addMouseListener(this);
        this.m_Edit = new MyEdit(this);
    }

    public void BeginEdit(DataDoc pDoc, DataView pView, DrawObject obj, Rectangle rc, int row) {
        this.m_pDoc = pDoc;
        this.m_pView = pView;
        this.m_pObject = obj;
        this.m_Rect = (Rectangle)rc.clone();
        this.m_Row = row;
        String s = this.m_pObject.GetShowText(this.m_pDoc, this.m_Row);
        ++this.m_Rect.x;
        ++this.m_Rect.y;
        --this.m_Rect.width;
        --this.m_Rect.height;
        this.setBounds(this.m_Rect);
        this.setBorder(null);
        this.m_pView.getParent().add((Component)this, 2);
        this.Init(this.m_pView.getParent());
        this.setFocusable(true);
        this.setBackground(this.m_pObject.GetBackColor(this.m_pDoc, this.m_Row));
        String esn = this.m_pObject.GetEditStyleName(row);
        this.m_CBO = (ConfigEditComboBox)pDoc.GetEditStyle(esn);
        if (this.m_CBO != null && this.m_CBO.m_esc.m_Data2Show != null) {
            Object[] value = this.m_CBO.m_esc.m_Data2Show.values().toArray();
            this.dataList.setListData(value);
        }
        s = this.m_pObject.GetShowText(this.m_pDoc, this.m_Row);
        this.m_Edit.setText(s);
        this.m_Edit.requestFocus();
    }

    public void SetEditFocus() {
        this.dataList.setVisible(false);
        this.scrollPane.setVisible(false);
        this.m_Edit.requestFocus();
    }

    public void SetListFocus() {
        int index = this.dataList.getNextMatch(this.m_Edit.getText(), 0, Position.Bias.Forward);
        if (index < 0) {
            index = 0;
        }
        try {
            this.dataList.setVisible(true);
            this.m_Edit.listGainFocus = true;
            this.dataList.setSelectedIndex(index);
            this.dataList.setSelectedValue(this.dataList.getSelectedValue(), true);
            this.dataList.requestFocus();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void Init(Container ct) {
        int yy;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.x = this.width - 15;
        if (this.x < 0) {
            this.x = 0;
        }
        int bw = Math.min(15, this.width);
        this.add(this.m_Edit);
        this.m_Edit.setBounds(0, 0, this.width - bw, this.height + 1);
        Font fnt = this.m_pObject.GetFont(this.m_pDoc, this.m_Row);
        this.m_Edit.setFont(fnt);
        this.dataList = new MyList();
        this.dataList.Init(this);
        this.dataList.setFont(fnt);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().setView(this.dataList);
        int xx = this.getX();
        if (xx + this.width + 1 > ct.getWidth()) {
            xx = ct.getWidth() - this.width - 1;
        }
        if ((yy = this.getY() + this.height) + 100 > ct.getHeight()) {
            yy = this.getY() - 100;
        }
        this.scrollPane.setBounds(xx, yy, this.width + 1, 100);
        this.scrollPane.setVisible(false);
        ct.add((Component)this.scrollPane, 2);
    }

    public void paint(Graphics arg0) {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.x = this.width - 15;
        if (this.x < 0) {
            this.x = 0;
        }
        int bw = Math.min(15, this.width);
        Graphics2D g2 = (Graphics2D)arg0;
        g2.setColor(Color.GREEN);
        g2.fillRect(0, 0, this.width, this.height);
        g2.setColor(this.parentBkColor);
        g2.fillRect(this.x, 0, bw, this.height);
        g2.setColor(this.bkColor);
        g2.fillRoundRect(this.x, 0, bw - 1, this.height - 1, 2, 2);
        g2.setColor(this.isMouseEnter ? (this.isDown ? this.LowerLight : this.HighLight) : this.bkColor);
        g2.drawLine(this.x + 1, this.height - 2, this.x + 1, 1);
        g2.drawLine(this.x + 1, 1, this.x + 13, 1);
        g2.setColor(this.isMouseEnter ? (this.isDown ? this.HighLight : this.LowerLight) : this.bkColor);
        g2.drawLine(this.width - 2, 1, this.width - 2, this.height - 2);
        g2.drawLine(this.width - 2, this.height - 2, this.x + 1, this.height - 2);
        g2.setColor(this.BorderColor);
        g2.drawRoundRect(this.x, 0, 14, this.height - 1, 2, 2);
        int h = (this.height - 8) / 2;
        int w = this.x + 1 + (bw - 5) / 2 + (this.isDown ? 1 : 0);
        g2.drawLine(w, h, w, h);
        g2.drawLine(w + 2, h, w + 2, h);
        g2.drawLine(w, h + 2, w, h + 2);
        g2.drawLine(w + 2, h + 2, w + 2, h + 2);
        g2.drawLine(w -= 2, h += 4, w + 6, h);
        g2.drawLine(w + 1, h + 1, w + 5, h + 1);
        g2.drawLine(w + 2, h + 2, w + 4, h + 2);
        g2.drawLine(w + 3, h + 3, w + 3, h + 3);
        super.paint(arg0);
    }

    public static void main(String[] args) {
        JFrame j = new JFrame();
        Container ct = j.getContentPane();
        ct.setLayout(null);
        DropDownListBox dab = new DropDownListBox();
        dab.setBounds(10, 10, 105, 20);
        ct.add(dab);
        dab.Init(ct);
        j.setBounds(100, 100, 300, 300);
        ct.setBackground(Color.WHITE);
        j.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getX() > this.x) {
            boolean v = this.scrollPane.isVisible();
            this.scrollPane.setVisible(!v);
            if (this.scrollPane.isVisible()) {
                this.SetListFocus();
            } else {
                this.dataList.EditGainFocus = true;
                this.SetEditFocus();
            }
        } else {
            this.dataList.EditGainFocus = true;
            this.SetEditFocus();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.isMouseEnter = e.getX() > this.x;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.isMouseEnter = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        this.isDown = e.getX() > this.x;
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.isDown = false;
        this.repaint();
    }
}

