/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import jun.df.CurrentPoint;
import jun.df.DRAWSHAPE;
import jun.df.DataView;
import jun.df.DrawObject;
import jun.df.MOUSESTATE;

public class DrawTool
implements MOUSESTATE,
DRAWSHAPE {
    static ArrayList c_tools = new ArrayList();
    static Point c_down = null;
    static int c_nDownFlags = 0;
    static Point c_last = null;
    static int c_drawShape = 0;
    static boolean c_IsDragSelection = true;
    static DrawObject c_LastDrawObject = null;
    static int c_LastRow = -1;
    static DrawObject c_MouseDownObject = null;
    static int c_MouseDownRow = -1;
    static DrawObject c_MouseUpObject = null;
    static int c_MouseUpRow = -1;
    static final String IDC_LT = "LT.gif";
    static final String IDC_LB = "LB.gif";
    static final String IDC_RT = "RT.gif";
    static final String IDC_RB = "RB.gif";
    static final String IDC_MOVE = "MOVE.gif";
    static final String IDC_ARROW = "DEFAULT";
    static final String IDC_HAND = "hand.gif";
    int m_drawShape;

    public Applet ContainedByApplet(Component op) {
        Component ct = op;
        while (ct != null) {
            if (ct instanceof Applet) {
                return (Applet)ct;
            }
            ct = ct.getParent();
        }
        return null;
    }

    public Cursor GetCursor(String curName, Component who) {
        if (curName == IDC_ARROW) {
            return new Cursor(0);
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Applet ContainedByApplet = this.ContainedByApplet(who);
        Cursor cur = null;
        Image img = null;
        URL url = this.getClass().getClassLoader().getResource("jun/df/res/" + curName);
        if (ContainedByApplet != null) {
            img = ContainedByApplet.getImage(url);
            if (img == null) {
                return new Cursor(0);
            }
            cur = tk.createCustomCursor(img, new Point(10, 10), curName);
        } else {
            img = tk.getImage("jun/df/res/" + curName);
            cur = tk.createCustomCursor(img, new Point(10, 10), curName);
        }
        return cur;
    }

    public DrawTool(int drawShape) {
        this.Init(drawShape);
    }

    protected void Init(int drawShape) {
        this.m_drawShape = drawShape;
        c_tools.add(this);
    }

    static DrawTool FindTool(int drawShape) {
        int i = 0;
        while (i < c_tools.size()) {
            DrawTool tool = (DrawTool)c_tools.get(i);
            if (tool.m_drawShape == drawShape) {
                return tool;
            }
            ++i;
        }
        return null;
    }

    void DrawObjectWithEffect(DataView pView, int row, DrawObject obj, int offset) {
        if (obj == null) {
            return;
        }
        if (obj.m_ObjectType != 4) {
            return;
        }
        if (!obj.m_ActAsButton) {
            return;
        }
        Rectangle rc = pView.getBounds();
        Rectangle objRc = obj.GetBounds(pView, row);
        String s = obj.mf_Visible;
        boolean v = obj.m_Visible;
        obj.mf_Visible = "";
        obj.m_Visible = false;
        Graphics2D g = (Graphics2D)pView.getGraphics();
        g.setClip(objRc);
        pView.OnDraw(g);
        obj.mf_Visible = s;
        obj.m_Visible = v;
        obj.Draw(pView.GetDoc(), pView, objRc, rc, (Graphics2D)pView.getGraphics(), row, obj.m_pBand.GetName() == 3, offset);
    }

    public void OnLButtonDown(DataView pView, MouseEvent e) {
        pView.requestFocus();
        pView.SetCapture();
        c_down = e.getPoint();
        c_last = e.getPoint();
        CurrentPoint cp = new CurrentPoint(e.getX(), e.getY(), pView);
        int row = cp.Row;
        if (pView.GetFormStyle() == 1) {
            row = pView.GetCurrentBindRow();
        }
        c_MouseDownObject = cp.pObject;
        c_MouseDownRow = row;
        this.DrawObjectWithEffect(pView, row, c_MouseDownObject, 1);
    }

    public void OnLButtonDblClk(DataView pView, MouseEvent e) {
    }

    public void OnLButtonUp(DataView pView, MouseEvent e) {
        pView.ReleaseCapture();
        c_IsDragSelection = false;
        CurrentPoint cp = new CurrentPoint(e.getX(), e.getY(), pView);
        c_MouseUpObject = cp.pObject;
        int row = cp.Row;
        if (pView.GetFormStyle() == 1) {
            row = pView.GetCurrentBindRow();
        }
        c_MouseUpRow = row;
        System.out.println(row);
        this.DrawObjectWithEffect(pView, c_MouseDownRow, c_MouseDownObject, 0);
        if (cp.pObject != null && row >= 0) {
            cp.pObject.BeginEdit(pView, cp.Rect, row);
        }
        if (c_MouseDownObject != null && c_MouseUpObject != null && c_MouseDownObject.equals(c_MouseUpObject) && c_MouseDownRow == c_MouseUpRow) {
            pView.EventManager().FireObjectMouseClicked(c_MouseUpRow, cp.pObject);
        }
    }

    public void OnMouseMove(DataView pView, MouseEvent e) {
        c_last = e.getPoint();
        CurrentPoint cp = new CurrentPoint(e.getX(), e.getY(), pView);
        int row = cp.Row;
        if (cp.pObject != null && cp.pObject.m_ObjectType == 4 && cp.pObject.m_ActAsButton) {
            pView.setCursor(this.GetCursor(IDC_HAND, pView));
        }
        if (c_LastDrawObject != null || cp.pObject == null) {
            // empty if block
        }
        if (c_LastDrawObject == null && cp.pObject != null) {
            pView.EventManager().FireObjectMouseEnter(row, cp.pObject);
        }
        if (c_LastDrawObject != null && cp.pObject == null) {
            pView.EventManager().FireObjectMouseOut(c_LastRow, c_LastDrawObject);
        }
        if (c_LastDrawObject != null && cp.pObject != null && !c_LastDrawObject.equals(cp.pObject)) {
            pView.EventManager().FireObjectMouseOut(c_LastRow, c_LastDrawObject);
            pView.EventManager().FireObjectMouseEnter(row, cp.pObject);
        }
        c_LastDrawObject = cp.pObject;
        c_LastRow = row;
    }

    public void OnMouseDrag(DataView pView, MouseEvent e) {
        c_last = e.getPoint();
    }

    public void OnRButtonDown(DataView pView, MouseEvent e) {
    }
}

