/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.applet.Applet;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import jun.db.core.DataStore;
import jun.db.core.ObjectTool;
import jun.df.Band;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.EditDatetime;
import jun.df.EditNumeric;
import jun.df.IEditComboBox;
import jun.df.IEditDateTime;
import jun.df.IEditNumeric;
import jun.df.IEdition;

public class DrawObject
implements IEdition,
Serializable {
    String m_Name = "";
    Object m_Value = null;
    Object m_Tag = null;
    Object m_MapedData = null;
    Band m_pBand = null;
    String m_Bind;
    int m_BindNo;
    int m_ObjectType = 0;
    int m_Alpha = 100;
    int m_EditType = 0;
    String m_EditStyleName = "";
    int hAlign = 999;
    int vAlign = 2;
    boolean isMultiLine = false;
    static Hashtable m_FontMap = new Hashtable();
    boolean m_Antialias = false;
    int m_BackMode = 0;
    Color m_BackColor = new Color(255, 255, 255);
    Color textColor = new Color(0, 0, 0);
    boolean m_Editable1 = true;
    boolean m_Editable2 = true;
    String m_ImageURL = "";
    String m_FontName = "\u5b8b\u4f53";
    public int m_FontSize = 12;
    boolean m_FontBold = false;
    boolean m_FontItalic = false;
    boolean m_FontUnderline = false;
    boolean m_Visible = true;
    boolean m_ActAsButton = true;
    boolean m_ViewAsPassword = false;
    int m_Border = 4;
    int m_StartBand = 0;
    int m_EndBand = 0;
    int m_X = 0;
    int m_Width = 0;
    int m_Y = 0;
    int m_Height = 0;
    String m_Forma = null;
    String mf_BackMode = "";
    String mf_BackColor = "";
    String mf_TextColor = "";
    String mf_BmpFile = "";
    String mf_BmpMaskColor = "";
    String mf_FontName = "";
    String mf_FontSize = "";
    String mf_FontBold = "";
    String mf_FontItalic = "";
    String mf_FontUnderline = "";
    String mf_Visible = "";
    String mf_Border = "";
    String mf_X = "";
    String mf_Width = "";
    String mf_Y = "";
    String mf_Height = "";
    String mf_ImageURL = "";
    String mf_Editable1 = "";
    String mf_Editable2 = "";
    String mf_EditStyleName = "";
    String mf_ViewAsPassword = "";
    private String m_DateFormat = "yyyy.MM.dd HH:mm:ss";
    private SimpleDateFormat m_SDF = new SimpleDateFormat(this.m_DateFormat);
    private boolean m_ShowComma = true;
    private int m_DecimalCount = 8;
    private String m_NumericFormat = "###,###,###,###,##0.0000";
    private DecimalFormat m_DF = new DecimalFormat(this.m_NumericFormat);
    private Image m_Image = null;

    public String GetEdition() {
        return "1.0";
    }

    public String Name() {
        return this.m_Name;
    }

    public Object GetValue() {
        return this.m_Value;
    }

    public Object GetTag() {
        return this.m_Tag;
    }

    public void SetTag(Object obj) {
        this.m_Tag = obj;
    }

    public DrawObject(Band pb) {
        this.m_pBand = pb;
    }

    public Object GetValue(int row) {
        return this.GetValue(this.m_pBand.m_pDoc, row);
    }

    Object GetValue(DataDoc pDoc, int row) {
        this.RecalculateValue(pDoc, row);
        return this.m_Value;
    }

    public String GetShowText(int row) {
        return this.GetShowText(this.m_pBand.m_pDoc, row);
    }

    public String GetShowText(DataDoc pDoc, int row) {
        if (this.GetViewAsPassword(row)) {
            return "***";
        }
        String ret = "";
        if (!this.GetVisible(pDoc, row)) {
            return ret;
        }
        this.RecalculateValue(pDoc, row);
        if (this.m_Value == null) {
            return "";
        }
        Object v = this.m_Value;
        String es = "";
        switch (this.m_EditType) {
            case 0: 
            case 1: {
                if (v instanceof BigDecimal) {
                    return this.m_DF.format(((Number)v).doubleValue());
                }
                if (v instanceof Double) {
                    return this.m_DF.format(((Number)v).doubleValue());
                }
                if (v instanceof Float) {
                    return this.m_DF.format(((Number)v).doubleValue());
                }
                if (v instanceof Date) {
                    return this.m_SDF.format(v);
                }
                return v.toString();
            }
            case 2: {
                es = this.GetEditStyleName(row);
                IEditNumeric en = (IEditNumeric)pDoc.GetEditStyle(es);
                Double dv = null;
                try {
                    dv = (Double)ObjectTool.ChangeType((Object)v, (String)"java.lang.Double");
                }
                catch (Exception e) {
                    return v.toString();
                }
                if (en == null) {
                    return this.m_DF.format(dv);
                }
                return EditNumeric.toString(dv, EditNumeric.GetPattern(en.GetDecimalCount(), '.', en.GetShowComma(), ','));
            }
            case 3: {
                es = this.GetEditStyleName(row);
                IEditDateTime edt = (IEditDateTime)pDoc.GetEditStyle(es);
                Date dtv = null;
                try {
                    dtv = (Date)ObjectTool.ChangeType((Object)v, (String)"java.util.Date");
                }
                catch (Exception e) {
                    return v.toString();
                }
                if (edt == null) {
                    return this.m_SDF.format(dtv);
                }
                return EditDatetime.Date2String(dtv, EditDatetime.convertMask(edt.GetFormat()));
            }
            case 4: {
                es = this.GetEditStyleName(row);
                IEditComboBox ecb = (IEditComboBox)pDoc.GetEditStyle(es);
                if (ecb != null) {
                    return ecb.GetShowString(this.m_Value);
                }
                return v.toString();
            }
            case 5: {
                System.out.println("unsupport  CheckBox");
            }
        }
        return v.toString();
    }

    void repaint(DataDoc pDoc, int row) {
        int i = 0;
        while (i < pDoc.m_ViewList.size()) {
            DataView pView = (DataView)pDoc.m_ViewList.get(i);
            Rectangle rc = this.GetBounds(pView, row);
            if (rc != null) {
                pView.repaint(rc.x - 1, rc.y - 1, rc.width + 2, rc.height + 2);
            }
            ++i;
        }
    }

    Rectangle GetImageBounds(DataView pView, int row) {
        Rectangle rc = this.GetBounds(pView, row);
        Image img = this.GetImage(row);
        if (this.m_ObjectType != 4 || img == null) {
            return rc;
        }
        int w = rc.width;
        int h = rc.height;
        if (this.m_Width == 0) {
            w = img.getWidth(pView);
        }
        if (this.m_Height == 0) {
            h = img.getHeight(pView);
        }
        rc.width = w;
        rc.height = h;
        return rc;
    }

    Rectangle GetBounds(DataView pView, int row) {
        switch (this.m_pBand.GetName()) {
            case 1: {
                return this.GetBoundsInHeader(pView);
            }
            case 2: {
                return this.GetBoundsInFooter(pView);
            }
            case 3: {
                return this.GetBoundsInDetail(pView, row);
            }
            case 4: {
                return this.GetBoundsInTrailer(pView, row);
            }
        }
        return null;
    }

    Rectangle GetBoundsInHeader(DataView pView) {
        Rectangle client = pView.getBounds();
        DataDoc pDoc = pView.GetDoc();
        int EndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            EndBand = pDoc.m_Areas.Count() - 1;
        }
        int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, EndBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int top = 0;
        int bottom = pDoc.m_pHeader.Height(pDoc);
        return this.CombineRect(null, pDoc, pView, left, top, right, bottom, client, 0);
    }

    Rectangle GetBoundsInFooter(DataView pView) {
        Rectangle client = pView.getBounds();
        DataDoc pDoc = pView.GetDoc();
        int EndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            EndBand = pDoc.m_Areas.Count() - 1;
        }
        int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, EndBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int bottom = client.y + client.height;
        int top = Math.max(0, bottom - pDoc.m_pFooter.Height(pDoc));
        return this.CombineRect(null, pDoc, pView, left, top, right, bottom, client, 0);
    }

    Rectangle GetBoundsInDetail(DataView pView, int drow) {
        int bottom;
        Rectangle client = pView.getBounds();
        DataDoc pDoc = pView.GetDoc();
        int EndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            EndBand = pDoc.m_Areas.Count() - 1;
        }
        int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, EndBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int top = Math.min(pDoc.m_pHeader.Height(pDoc), client.y + client.height);
        int maxBottom = bottom = Math.max(top, client.y + client.height - pDoc.m_pFooter.Height(pDoc));
        Rectangle rc = this.CombineRect(null, pDoc, pView, left, top, right, bottom, client, 0, true);
        if (pView.GetFormStyle() == 1) {
            return rc;
        }
        int startRow = pView.m_FirstViewRow;
        int row = 0;
        row = startRow;
        while (row <= drow) {
            int h = pDoc.m_pDetail.Height(pDoc, row);
            bottom = Math.min(top + h, maxBottom);
            rc = this.CombineRect(null, pDoc, pView, left, top, right, bottom, client, row, true);
            if (row == drow) break;
            top += h;
            Integer key = new Integer(row);
            Hashtable MapGroups = (Hashtable)pDoc.m_pDs.getFriendlyProperty("m_MapGroups");
            if (MapGroups.containsKey(key)) {
                ArrayList pVec = (ArrayList)MapGroups.get(key);
                int ti = pVec.size() - 1;
                while (ti >= 0) {
                    int k = (Integer)pVec.get(ti);
                    Band pTrailer = pDoc.m_pTrailers.Item(k);
                    if (pTrailer != null) {
                        top += pTrailer.Height(pDoc);
                    }
                    --ti;
                }
            }
            ++row;
        }
        return rc;
    }

    Rectangle GetBoundsInTrailer(DataView pView, int drow) {
        int bottom;
        Rectangle client = pView.getBounds();
        DataDoc pDoc = pView.GetDoc();
        int EndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            EndBand = pDoc.m_Areas.Count() - 1;
        }
        int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, EndBand, pDoc.m_FixedColumnCount, pView.m_FirstViewColumn);
        int top = Math.min(pDoc.m_pHeader.Height(pDoc), client.y + client.height);
        int maxBottom = bottom = Math.max(top, client.y + client.height - pDoc.m_pFooter.Height(pDoc));
        Rectangle rc = this.CombineRect(null, pDoc, pView, left, top, right, bottom, client, 0);
        if (pView.GetFormStyle() == 1) {
            return rc;
        }
        int startRow = pView.m_FirstViewRow;
        int row = 0;
        row = startRow;
        while (row <= drow) {
            int h = pDoc.m_pDetail.Height(pDoc, row);
            top = bottom = top + h;
            Integer key = new Integer(row);
            Hashtable MapGroups = (Hashtable)pDoc.m_pDs.getFriendlyProperty("m_MapGroups");
            if (MapGroups.containsKey(key)) {
                ArrayList pVec = (ArrayList)MapGroups.get(key);
                int ti = pVec.size() - 1;
                while (ti >= 0) {
                    int k = (Integer)pVec.get(ti);
                    Band pTrailer = pDoc.m_pTrailers.Item(k);
                    if (pTrailer != null) {
                        int GroupIndex = this.m_pBand.GetTrailerNo();
                        if (GroupIndex < 0) {
                            return null;
                        }
                        if (row == drow && k == GroupIndex && top < maxBottom) {
                            bottom = top + pDoc.m_pTrailers.Item(GroupIndex).Height(pDoc);
                            bottom = Math.min(bottom, maxBottom);
                            rc = this.CombineRect(null, pDoc, pView, left, top, right, bottom, client, row);
                            return rc;
                        }
                        top += pTrailer.Height(pDoc);
                    }
                    --ti;
                }
            }
            ++row;
        }
        return null;
    }

    public void SetEditable(boolean v) {
        if (this.m_pBand.m_pDoc.GetDrawObjectEditableScheme() == 1) {
            this.m_Editable1 = v;
            this.mf_Editable1 = "";
        } else {
            this.m_Editable2 = v;
            this.mf_Editable2 = "";
        }
    }

    public void SetEditableFormula(String v) {
        if (v == null) {
            return;
        }
        if (this.m_pBand.m_pDoc.GetDrawObjectEditableScheme() == 1) {
            this.mf_Editable1 = v;
        } else {
            this.mf_Editable2 = v;
        }
    }

    public String GetEditableFormula() {
        if (this.m_pBand.m_pDoc.GetDrawObjectEditableScheme() == 1) {
            return this.mf_Editable1;
        }
        return this.mf_Editable2;
    }

    public boolean GetEditable(int row) {
        return this.GetEditable(this.m_pBand.m_pDoc, row);
    }

    boolean GetEditable(DataDoc pDoc, int row) {
        String mf_Editable;
        boolean m_Editable;
        if (this.m_pBand.m_pDoc.GetDrawObjectEditableScheme() == 1) {
            m_Editable = this.m_Editable1;
            mf_Editable = this.mf_Editable1;
        } else {
            m_Editable = this.m_Editable2;
            mf_Editable = this.mf_Editable2;
        }
        if (this.m_ObjectType != 1) {
            return false;
        }
        if (this.m_pBand.GetName() != 3) {
            return false;
        }
        if (mf_Editable.equals("") || pDoc.m_pDs == null) {
            return m_Editable;
        }
        Object v = DrawObject.GetValue(pDoc, row, mf_Editable);
        try {
            return (Boolean)v;
        }
        catch (Exception e) {
            return m_Editable;
        }
    }

    public void BeginEdit(int row) {
        this.BeginEdit((DataView)this.m_pBand.m_pDoc.m_ViewList.get(0), null, row);
    }

    void BeginEdit(DataView pView, Rectangle rect, int row) {
        if (!this.GetEditable(pView.GetDoc(), row)) {
            return;
        }
        if (rect == null) {
            rect = this.GetBounds(pView, row);
        }
        if (rect == null) {
            return;
        }
        if (rect.width * rect.height == 0) {
            return;
        }
        pView.BeginEdit(rect, this, row);
    }

    void Draw(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC, int row) {
        this.Draw(pDoc, pView, rect, client, pDC, row, false, 0);
    }

    void Draw(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC, int row, boolean inDetail) {
        this.Draw(pDoc, pView, rect, client, pDC, row, inDetail, 0);
    }

    void Draw(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC, int row, boolean inDetail, int offset) {
        if (this.m_Antialias) {
            pDC.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Rectangle rc = (Rectangle)rect.clone();
        int bkMode = this.GetBackMode(pDoc, row);
        Color bkColor = bkMode == 0 ? pDoc.m_PaperColor : this.GetBackColor(pDoc, row);
        boolean rowIsSelected = false;
        if (pDoc.m_pDs != null && row >= 0 && row < pDoc.m_pDs.getRowCount()) {
            rowIsSelected = pView.m_SelectedRows.containsKey(new Integer(row));
        }
        if (inDetail && rowIsSelected) {
            bkColor = pDoc.m_BKColorOfSelectedRow;
        }
        if (inDetail && rowIsSelected || this.GetBackMode(pDoc, row) == 1) {
            if (this.m_Alpha < 0 || this.m_Alpha > 100) {
                this.m_Alpha = 100;
            }
            if (this.m_Alpha == 100) {
                pDC.setColor(bkColor);
                pDC.fillRect(rc.x, rc.y, rc.width, rc.height);
            } else {
                AlphaComposite ac = AlphaComposite.getInstance(3, (float)this.m_Alpha / 100.0f);
                BufferedImage buff_img = new BufferedImage(rc.width, rc.height, 7);
                Graphics2D gs = buff_img.createGraphics();
                gs.setTransform(new AffineTransform());
                gs.setComposite(ac);
                gs.setColor(bkColor);
                gs.fillRect(0, 0, rc.width, rc.height);
                pDC.drawImage(buff_img, rc.x, rc.y, rc.width, rc.height, pView);
            }
        }
        switch (this.m_ObjectType) {
            case 0: 
            case 1: 
            case 2: {
                this.DrawBorder(pDoc, rc, pView, pDC, row);
                rc.grow(-pView.LW() * 2, -pView.LW());
                String showText = this.GetShowText(pDoc, row);
                this.DrawString(pDC, rc, showText, bkMode, bkColor, this.GetTextColor(pDoc, row), this.GetFontName(pDoc, row), this.GetFontSize(pDoc, row), this.GetFontBold(pDoc, row), this.GetFontItalic(pDoc, row), this.GetFontUnderline(pDoc, row), this.GetHAlign(), this.GetVAlign(), this.isMultiLine);
                break;
            }
            case 3: {
                if (!this.GetVisible(pDoc, row)) {
                    return;
                }
                pDC.setColor(this.GetTextColor(pDoc, row));
                pDC.drawLine(rc.x, rc.y, rc.x + rc.width, rc.y + rc.height);
                break;
            }
            case 4: {
                if (!this.GetVisible(pDoc, row)) {
                    return;
                }
                Image img = this.GetImage(row);
                int w = rc.width;
                int h = rc.height;
                if (this.m_Width == 0) {
                    w = img.getWidth(pView);
                }
                if (this.m_Height == 0) {
                    h = img.getHeight(pView);
                }
                pDC.drawImage(img, rc.x + offset, rc.y + offset, w, h, pView);
            }
        }
        if (this.m_Antialias) {
            pDC.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    public Applet ContainedByApplet(Component op) {
        Component ct = op;
        while (ct != null) {
            if (ct instanceof Applet) {
                return (Applet)ct;
            }
            ct = ct.getParent();
        }
        return null;
    }

    private Image GetImage(int row) {
        if (this.m_ObjectType != 4) {
            return null;
        }
        if (this.m_Image == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Applet ContainedByApplet = this.ContainedByApplet((DataView)this.m_pBand.m_pDoc.m_ViewList.get(0));
            String imgURL = this.GetImageURL(row);
            URL url = this.getClass().getClassLoader().getResource(imgURL);
            this.m_Image = ContainedByApplet != null ? ContainedByApplet.getImage(url) : tk.getImage(this.GetImageURL(row));
        }
        return this.m_Image;
    }

    void DrawInHeader(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC) {
        Rectangle rc = new Rectangle();
        Rectangle rc2 = new Rectangle();
        int BackupEndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            this.m_EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            this.m_EndBand = pDoc.m_Areas.Count() - 1;
        }
        boolean isPrint = pDC.getDeviceConfiguration().getDevice().getType() == 1;
        try {
            try {
                int row;
                if (isPrint) {
                    if (this.m_StartBand > pView.m_LastPrintColumn) {
                        throw new Exception("do nothing");
                    }
                    this.m_EndBand = Math.min(this.m_EndBand, pView.m_LastPrintColumn);
                }
                int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, this.m_EndBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int top = 0;
                int bottom = pDoc.m_pHeader.Height(pDoc);
                rc = this.CombineRect(pDC, pDoc, pView, left, top, right, bottom, client, 0);
                if (rc.width == 0) {
                    throw new Exception("do nothing");
                }
                if (rc.height == 0) {
                    throw new Exception("do nothing");
                }
                if (!rc.intersects(rect)) {
                    throw new Exception("do nothing");
                }
                int n = row = isPrint ? pView.m_FirstPrintRow : pView.m_FirstViewRow;
                if (pView.GetFormStyle() == 1) {
                    row = pView.GetCurrentBindRow();
                }
                this.Draw(pDoc, pView, rc, client, pDC, row);
            }
            catch (Exception e) {
                this.m_EndBand = BackupEndBand;
            }
        }
        finally {
            this.m_EndBand = BackupEndBand;
        }
    }

    void DrawInDetail(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC) {
        ArrayList pVec = new ArrayList();
        Rectangle rc = new Rectangle();
        Rectangle rc2 = (Rectangle)client.clone();
        int BackupEndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            this.m_EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            this.m_EndBand = pDoc.m_Areas.Count() - 1;
        }
        boolean isPrint = pDC.getDeviceConfiguration().getDevice().getType() == 1;
        try {
            try {
                int startRow;
                int bottom;
                if (isPrint) {
                    if (this.m_StartBand > pView.m_LastPrintColumn) {
                        throw new Exception("do nothing");
                    }
                    this.m_EndBand = Math.min(this.m_EndBand, pView.m_LastPrintColumn);
                }
                int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, this.m_EndBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int top = Math.min(pDoc.m_pHeader.Height(pDoc), rc2.y + rc2.height);
                int maxBottom = bottom = Math.max(top, rc2.y + rc2.height - pDoc.m_pFooter.Height(pDoc));
                rc = this.CombineRect(pDC, pDoc, pView, left, top, right, bottom, client, 0, true);
                if (rc.width == 0) {
                    throw new Exception("do nothing");
                }
                if (pDoc.m_pDs == null) {
                    throw new Exception("do nothing");
                }
                if (pView.GetFormStyle() == 1) {
                    this.Draw(pDoc, pView, rc, client, pDC, pView.GetCurrentBindRow(), true);
                    throw new Exception("return");
                }
                int rowcount = pDoc.m_pDs.getRowCount();
                if (isPrint) {
                    rowcount = pView.m_LastPrintRow + 1;
                }
                int row = startRow = isPrint ? pView.m_FirstPrintRow : pView.m_FirstViewRow;
                while (row < rowcount) {
                    if (top > rect.y + rect.height) {
                        break;
                    }
                    int h = pDoc.m_pDetail.Height(pDoc, row);
                    bottom = Math.min(top + h, maxBottom);
                    rc = this.CombineRect(pDC, pDoc, pView, left, top, right, bottom, client, row, true);
                    if (rc.intersects(rect) && top < maxBottom) {
                        this.Draw(pDoc, pView, rc, client, pDC, row, true);
                    }
                    top += h;
                    Integer key = new Integer(row);
                    Hashtable MapGroups = (Hashtable)pDoc.m_pDs.getFriendlyProperty("m_MapGroups");
                    if (MapGroups.containsKey(key)) {
                        pVec = (ArrayList)MapGroups.get(key);
                        int ti = pVec.size() - 1;
                        while (ti >= 0) {
                            int k = (Integer)pVec.get(ti);
                            Band pTrailer = pDoc.m_pTrailers.Item(k);
                            if (pTrailer != null) {
                                top += pTrailer.Height(pDoc);
                            }
                            --ti;
                        }
                    }
                    ++row;
                }
            }
            catch (Exception exception) {}
        }
        finally {
            this.m_EndBand = BackupEndBand;
        }
    }

    void DrawInTrailer(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC, int GroupIndex) {
        Rectangle rc2 = (Rectangle)client.clone();
        int BackupEndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            this.m_EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            this.m_EndBand = pDoc.m_Areas.Count() - 1;
        }
        boolean isPrint = pDC.getDeviceConfiguration().getDevice().getType() == 1;
        try {
            try {
                int startRow;
                int bottom;
                if (isPrint) {
                    if (this.m_StartBand > pView.m_LastPrintColumn) {
                        throw new Exception("do nothing");
                    }
                    this.m_EndBand = Math.min(this.m_EndBand, pView.m_LastPrintColumn);
                }
                int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, this.m_EndBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int top = Math.min(pDoc.m_pHeader.Height(pDoc), rc2.y + rc2.height);
                int maxBottom = bottom = Math.max(top, rc2.y + rc2.height - pDoc.m_pFooter.Height(pDoc));
                Rectangle rc = this.CombineRect(pDC, pDoc, pView, left, top, right, bottom, client, 0);
                if (rc.width == 0) {
                    throw new Exception("do nothing");
                }
                int rowcount = pDoc.m_pDs.getRowCount();
                if (isPrint) {
                    rowcount = pView.m_LastPrintRow + 1;
                }
                int row = startRow = isPrint ? pView.m_FirstPrintRow : pView.m_FirstViewRow;
                while (row < rowcount) {
                    if (top > rect.y + rect.height) {
                        break;
                    }
                    int h = pDoc.m_pDetail.Height(pDoc, row);
                    top = bottom = top + h;
                    Integer key = new Integer(row);
                    Hashtable MapGroups = (Hashtable)pDoc.m_pDs.getFriendlyProperty("m_MapGroups");
                    if (MapGroups.containsKey(key)) {
                        ArrayList pVec = (ArrayList)MapGroups.get(key);
                        int ti = pVec.size() - 1;
                        while (ti >= 0) {
                            int k = (Integer)pVec.get(ti);
                            Band pTrailer = pDoc.m_pTrailers.Item(k);
                            if (pTrailer != null) {
                                if (k == GroupIndex && top < maxBottom) {
                                    bottom = top + pDoc.m_pTrailers.Item(GroupIndex).Height(pDoc);
                                    rc = this.CombineRect(pDC, pDoc, pView, left, top, right, bottom = Math.min(bottom, maxBottom), client, row);
                                    if (rc.intersects(rect)) {
                                        this.Draw(pDoc, pView, rc, client, pDC, row);
                                    }
                                }
                                top += pTrailer.Height(pDoc);
                            }
                            --ti;
                        }
                    }
                    ++row;
                }
            }
            catch (Exception e) {
                this.m_EndBand = BackupEndBand;
            }
        }
        finally {
            this.m_EndBand = BackupEndBand;
        }
    }

    void DrawInFooter(DataDoc pDoc, DataView pView, Rectangle rect, Rectangle client, Graphics2D pDC) {
        Rectangle rc2 = (Rectangle)client.clone();
        int BackupEndBand = this.m_EndBand;
        if (this.m_EndBand == 0) {
            this.m_EndBand = this.m_StartBand;
        }
        if (this.m_EndBand == -1) {
            this.m_EndBand = pDoc.m_Areas.Count() - 1;
        }
        boolean isPrint = pDC.getDeviceConfiguration().getDevice().getType() == 1;
        try {
            try {
                int row;
                if (isPrint) {
                    if (this.m_StartBand > pView.m_LastPrintColumn) {
                        throw new Exception("do nothing");
                    }
                    this.m_EndBand = Math.min(this.m_EndBand, pView.m_LastPrintColumn);
                }
                int left = pDoc.m_Areas.AreaLeft(pDoc.leftBlank, this.m_StartBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int right = pDoc.m_Areas.AreaRight(pDoc.leftBlank, this.m_EndBand, pDoc.m_FixedColumnCount, isPrint ? pView.m_FirstPrintColumn : pView.m_FirstViewColumn);
                int bottom = rc2.y + rc2.height;
                int top = Math.max(0, bottom - pDoc.m_pFooter.Height(pDoc));
                Rectangle rc = this.CombineRect(pDC, pDoc, pView, left, top, right, bottom, client, 0);
                if (rc.width == 0) {
                    throw new Exception("do nothing");
                }
                if (rc.height == 0) {
                    throw new Exception("do nothing");
                }
                if (!rc.intersects(rect)) {
                    throw new Exception("do nothing");
                }
                int n = row = isPrint ? pView.m_FirstPrintRow : pView.m_FirstViewRow;
                if (pView.GetFormStyle() == 1) {
                    row = pView.GetCurrentBindRow();
                }
                this.Draw(pDoc, pView, rc, client, pDC, row);
            }
            catch (Exception e) {
                this.m_EndBand = BackupEndBand;
            }
        }
        finally {
            this.m_EndBand = BackupEndBand;
        }
    }

    public void SetDateFormat(String f) {
        this.m_DateFormat = f;
        this.m_SDF = new SimpleDateFormat(f);
    }

    public int GetObjectType() {
        return this.m_ObjectType;
    }

    public int GetBindNo() {
        return this.m_BindNo;
    }

    public String GetBind() {
        return this.m_Bind;
    }

    public void SetBind(String colName) {
        this.m_Bind = colName;
        DataStore ds = this.m_pBand.m_pDoc.m_pDs;
        if (ds != null) {
            int ot;
            int col;
            this.m_BindNo = col = ds.col2Index(this.m_Bind);
            if (col >= 0 && ((ot = ds.getPrimaryBuffer().getColumnProperty(col).getObjType()) == 8 || ot == 2)) {
                this.SetEditable(false);
            }
        }
    }

    public void SetValue(Object v) {
        this.m_Value = v;
        this.repaint(this.m_pBand.m_pDoc, 0);
    }

    void SetValue(Object v, DataDoc pDoc, int row) {
        if (this.m_ObjectType == 1 && pDoc.m_pDs != null) {
            pDoc.m_pDs.setValue(row, this.m_Bind, v);
        }
    }

    void DrawBorder(DataDoc pDoc, Rectangle rc, DataView pView, Graphics2D pDC, int row) {
        switch (this.GetBorder(pDoc, row)) {
            case 0: {
                break;
            }
            case 1: {
                pDC.setColor(pDoc.m_GridLineColor);
                pDC.drawLine(rc.x, rc.y + rc.height, rc.x + rc.width, rc.y + rc.height);
                break;
            }
            case 4: {
                pDC.setColor(pDoc.m_GridLineColor);
                pDC.drawRect(rc.x, rc.y, rc.width, rc.height);
                break;
            }
            case 5: {
                pDC.setColor(pDoc.m_GridLineColor);
                pDC.draw3DRect(rc.x, rc.y, rc.width, rc.height, true);
                break;
            }
            case 6: {
                pDC.setColor(pDoc.m_GridLineColor);
                pDC.draw3DRect(rc.x, rc.y, rc.width, rc.height, false);
            }
        }
    }

    Rectangle CombineRect(Graphics2D pDC, DataDoc pDoc, DataView pView, int left, int top, int right, int bottom, Rectangle ValidRect, int row) {
        return this.CombineRect(pDC, pDoc, pView, left, top, right, bottom, ValidRect, row, false);
    }

    Rectangle CombineRect(Graphics2D pDC, DataDoc pDoc, DataView pView, int left, int top, int right, int bottom, Rectangle ValidRect, int row, boolean inDetail) {
        int t = 0;
        Rectangle tc = new Rectangle();
        boolean isPrint = pDC == null ? false : pDC.getDeviceConfiguration().getDevice().getType() == 1;
        switch (pView.GetFormStyle()) {
            case 2: {
                t = this.GetX(pDoc, row);
                tc.x = t >= 0 ? Math.min(left + t, right) : Math.max(left, Math.max(right + t, 0));
                t = this.GetY(pDoc, row);
                tc.y = t >= 0 ? Math.min(top + t, bottom) : Math.max(top, Math.max(bottom + t, 0));
                t = this.GetWidth(pDoc, row);
                if (t == 0) {
                    tc.width = right - tc.x;
                }
                if (t > 0) {
                    tc.width = Math.min(tc.x + t, right) - tc.x;
                }
                if (t < 0) {
                    tc.width = Math.max(tc.x, Math.max(right + t, 0)) - tc.x;
                }
                if ((t = this.GetHeight(pDoc, row)) == 0) {
                    tc.height = bottom - tc.y;
                }
                if (t > 0) {
                    tc.height = Math.min(tc.y + t, bottom) - tc.y;
                }
                if (t < 0) {
                    tc.height = Math.max(tc.y, Math.max(bottom + t, 0)) - tc.y;
                }
                tc.x = Math.max(tc.x, ValidRect.x);
                tc.y = Math.max(tc.y, ValidRect.y);
                if (tc.x + tc.width > ValidRect.x + ValidRect.width) {
                    tc.width = ValidRect.x + ValidRect.width - tc.x;
                }
                if (tc.y + tc.height <= ValidRect.y + ValidRect.height) break;
                tc.height = ValidRect.y + ValidRect.height - tc.y;
                break;
            }
            case 1: {
                int limitTop = top;
                top -= inDetail ? (isPrint ? pView.m_FirstPrintRow : pView.m_FirstViewRow) : 0;
                if (left == 0) {
                    boolean bl = true;
                }
                tc.x = (t = this.GetX(pDoc, row)) >= 0 ? Math.min(left + t, right) : Math.max(left, Math.max(right + t, 0));
                t = this.GetY(pDoc, row);
                tc.y = t >= 0 ? Math.min(top + t, bottom) : Math.max(top, Math.max(bottom + t, 0));
                t = this.GetWidth(pDoc, row);
                if (t == 0) {
                    tc.width = right - tc.x;
                }
                if (t > 0) {
                    tc.width = Math.min(tc.x + t, right) - tc.x;
                }
                if (t < 0) {
                    tc.width = Math.max(tc.x, Math.max(right + t, 0)) - tc.x;
                }
                if ((t = this.GetHeight(pDoc, row)) == 0) {
                    tc.height = bottom - tc.y;
                }
                if (t > 0) {
                    tc.height = Math.min(tc.y + t, bottom) - tc.y;
                }
                if (t < 0) {
                    tc.height = Math.max(tc.y, Math.max(bottom + t, 0)) - tc.y;
                }
                if (tc.x + tc.width > ValidRect.x + ValidRect.width) {
                    tc.width = ValidRect.x + ValidRect.width - tc.x;
                }
                if (tc.y + tc.height > ValidRect.y + ValidRect.height) {
                    tc.height = ValidRect.y + ValidRect.height - tc.y;
                }
                if (tc.x < pDoc.leftBlank) {
                    tc.width -= pDoc.leftBlank - tc.x;
                    tc.x = pDoc.leftBlank;
                }
                if (tc.y < limitTop) {
                    tc.height -= limitTop - tc.y;
                    tc.y = limitTop;
                }
                if (tc.height < 0) {
                    tc.height = 0;
                }
                if (tc.width >= 0) break;
                tc.width = 0;
            }
        }
        return tc;
    }

    void RecalculateValue(DataDoc pDoc, int row) {
        switch (this.m_ObjectType) {
            case 0: 
            case 3: 
            case 4: {
                break;
            }
            case 1: {
                if (pDoc.m_pDs == null) break;
                int col = pDoc.m_pDs.col2Index(this.m_Bind);
                if (col >= 0 && row >= 0 && row < pDoc.m_pDs.getRowCount()) {
                    this.m_Value = pDoc.m_pDs.getValue(row, col);
                    break;
                }
                this.m_Value = null;
                break;
            }
            case 2: {
                this.m_Value = row >= 0 && row < pDoc.m_pDs.getRowCount() ? pDoc.m_pDs.evaluate(this.m_Bind, row) : null;
            }
        }
    }

    public Color GetTextColor(int row) {
        return this.GetTextColor(this.m_pBand.m_pDoc, row);
    }

    public void SetTextColor(Color v) {
        if (v == null) {
            return;
        }
        this.textColor = v;
        this.mf_TextColor = "";
    }

    public void SetTextColorFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_TextColor = v;
    }

    public String GetTextColorFormula() {
        return this.mf_TextColor;
    }

    Color GetTextColor(DataDoc pDoc, int row) {
        if (this.mf_TextColor.equals("") || pDoc.m_pDs == null) {
            return this.textColor;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_TextColor);
        try {
            return (Color)v;
        }
        catch (Exception e) {
            return this.textColor;
        }
    }

    public void SetBackColor(Color v) {
        if (v == null) {
            return;
        }
        this.m_BackColor = v;
        this.mf_BackColor = "";
        this.m_BackMode = 1;
    }

    public void SetImageURL(String url) {
        if (url == null) {
            return;
        }
        this.m_ImageURL = url;
        this.mf_ImageURL = "";
    }

    public void SetImageURLFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_ImageURL = v;
    }

    public String GetImageURLFormula() {
        return this.mf_ImageURL;
    }

    public String GetImageURL(int row) {
        return this.GetImageURL(this.m_pBand.m_pDoc, row);
    }

    String GetImageURL(DataDoc pDoc, int row) {
        if (this.mf_ImageURL.equals("") || pDoc.m_pDs == null) {
            return this.m_ImageURL;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_ImageURL);
        try {
            return (String)v;
        }
        catch (Exception e) {
            return this.m_ImageURL;
        }
    }

    public void SetBackColorFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_BackColor = "";
        this.mf_BackColor.concat(v);
    }

    public String GetBackColorFormula() {
        return this.mf_BackColor;
    }

    public Color GetBackColor(int row) {
        return this.GetBackColor(this.m_pBand.m_pDoc, row);
    }

    Color GetBackColor(DataDoc pDoc, int row) {
        if (this.mf_BackColor.equals("") || pDoc.m_pDs == null) {
            return this.m_BackColor;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_BackColor);
        try {
            return (Color)v;
        }
        catch (Exception e) {
            return this.m_BackColor;
        }
    }

    public void SetVisible(boolean v) {
        this.m_Visible = v;
        this.mf_Visible = "";
    }

    public void SetVisibleFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_Visible = v;
    }

    public String GetVisibleFormula() {
        return this.mf_Visible;
    }

    public boolean GetVisible(int row) {
        return this.GetVisible(this.m_pBand.m_pDoc, row);
    }

    boolean GetVisible(DataDoc pDoc, int row) {
        if (this.mf_Visible.equals("") || pDoc.m_pDs == null) {
            return this.m_Visible;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_Visible);
        return Boolean.valueOf(v.toString());
    }

    public String GetViewAsPasswordFormula() {
        return this.mf_ViewAsPassword;
    }

    public boolean GetViewAsPassword(int row) {
        return this.GetViewAsPassword(this.m_pBand.m_pDoc, row);
    }

    boolean GetViewAsPassword(DataDoc pDoc, int row) {
        if (this.mf_ViewAsPassword.equals("") || pDoc.m_pDs == null) {
            return this.m_ViewAsPassword;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_ViewAsPassword);
        return Boolean.valueOf(v.toString());
    }

    public void SetViewAsPassword(boolean v) {
        this.m_ViewAsPassword = v;
        this.mf_ViewAsPassword = "";
    }

    public void SetViewAsPasswordFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_ViewAsPassword = v;
    }

    boolean GetFontUnderline(DataDoc pDoc, int row) {
        if (this.mf_FontUnderline.equals("") || pDoc.m_pDs == null) {
            return this.m_FontUnderline;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_FontUnderline);
        return Boolean.valueOf(v.toString());
    }

    public void SetFontItalic(boolean v) {
        this.m_FontItalic = v;
        this.mf_FontItalic = "";
    }

    public void SetFontItalicFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_FontItalic = v;
    }

    public String GetFontItalicFormula() {
        return this.mf_FontItalic;
    }

    public boolean GetFontItalic(int row) {
        return this.GetFontItalic(this.m_pBand.m_pDoc, row);
    }

    public void SetFontUnderline(boolean v) {
        this.m_FontUnderline = v;
        this.mf_FontUnderline = "";
    }

    public void SetFontUnderlineFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_FontUnderline = v;
    }

    public boolean GetFontUnderline(int row) {
        return this.GetFontUnderline(this.m_pBand.m_pDoc, row);
    }

    public String GetFontUnderlineFormula() {
        return this.mf_FontUnderline;
    }

    boolean GetFontItalic(DataDoc pDoc, int row) {
        if (this.mf_FontItalic.equals("") || pDoc.m_pDs == null) {
            return this.m_FontItalic;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_FontItalic);
        return Boolean.valueOf(v.toString());
    }

    public void SetFontBold(boolean v) {
        this.m_FontBold = v;
        this.mf_FontBold = "";
    }

    public void SetFontBoldFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_FontBold = v;
    }

    public String GetFontBoldFormula() {
        return this.mf_FontBold;
    }

    public boolean GetFontBold(int row) {
        return this.GetFontBold(this.m_pBand.m_pDoc, row);
    }

    boolean GetFontBold(DataDoc pDoc, int row) {
        if (this.mf_FontBold.equals("") || pDoc.m_pDs == null) {
            return this.m_FontBold;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_FontBold);
        return Boolean.valueOf(v.toString());
    }

    public void SetHeight(int v) {
        this.m_Height = v;
        this.mf_Height = "";
    }

    public void SetHeightFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_Height = v;
    }

    public String GetHeightFormula() {
        return this.mf_Height;
    }

    public int GetHeight(int row) {
        return this.GetHeight(this.m_pBand.m_pDoc, row);
    }

    int GetHeight(DataDoc pDoc, int row) {
        if (this.mf_Height.equals("") || pDoc.m_pDs == null) {
            return this.m_Height;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_Height);
        return Integer.parseInt(v.toString());
    }

    public void SetWidth(int v) {
        this.m_Width = v;
        this.mf_Width = "";
    }

    public void SetWidthFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_Width = v;
    }

    public String GetWidthFormula() {
        return this.mf_Width;
    }

    public int GetWidth(int row) {
        return this.GetWidth(this.m_pBand.m_pDoc, row);
    }

    int GetWidth(DataDoc pDoc, int row) {
        if (this.mf_Width.equals("") || pDoc.m_pDs == null) {
            return this.m_Width;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_Width);
        return Integer.parseInt(v.toString());
    }

    public void SetY(int v) {
        this.m_Y = v;
        this.mf_Y = "";
    }

    public void SetYFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_Y = v;
    }

    public String GetYFormula() {
        return this.mf_Y;
    }

    public int GetY(int row) {
        return this.GetY(this.m_pBand.m_pDoc, row);
    }

    int GetY(DataDoc pDoc, int row) {
        if (this.mf_Y.equals("") || pDoc.m_pDs == null) {
            return this.m_Y;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_Y);
        return Integer.parseInt(v.toString());
    }

    public void SetX(int v) {
        this.m_X = v;
        this.mf_X = "";
    }

    public void SetXFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_X = v;
    }

    public String GetXFormula() {
        return this.mf_X;
    }

    public int GetX(int row) {
        return this.GetX(this.m_pBand.m_pDoc, row);
    }

    int GetX(DataDoc pDoc, int row) {
        if (this.mf_X.equals("") || pDoc.m_pDs == null) {
            return this.m_X;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_X);
        return Integer.parseInt(v.toString());
    }

    public boolean GetShowComma() {
        return this.m_ShowComma;
    }

    public void SetShowComma(boolean b) {
        this.m_ShowComma = b;
        this.RebuildNumericFormat();
    }

    public int GetDecimalCount() {
        return this.m_DecimalCount;
    }

    public void SetDecimalCount(int n) {
        this.m_DecimalCount = Math.min(20, Math.max(n, 0));
        this.RebuildNumericFormat();
    }

    private void RebuildNumericFormat() {
        if (this.m_DecimalCount == 0) {
            this.m_NumericFormat = "###,###,###,###,###,###,##0";
        } else {
            String t = "00000000000000000000";
            t = t.substring(0, this.m_DecimalCount);
            this.m_NumericFormat = "###,###,###,###,###,###,##0." + t;
        }
        if (!this.m_ShowComma) {
            this.m_NumericFormat.replaceAll(",", "");
        }
        this.m_DF = new DecimalFormat(this.m_NumericFormat);
    }

    int GetHAlign() {
        if (this.hAlign != 999) {
            return this.hAlign;
        }
        if (this.m_MapedData == null) {
            if (this.m_Value == null) {
                return this.hAlign;
            }
            if (this.m_Value instanceof Number) {
                return 1;
            }
            if (this.m_Value instanceof Date) {
                return 2;
            }
            return 0;
        }
        if (this.m_MapedData instanceof Number) {
            return 1;
        }
        if (this.m_MapedData instanceof Date) {
            return 2;
        }
        return 0;
    }

    int GetVAlign() {
        return this.vAlign;
    }

    public void SetBorder(int v) {
        this.m_Border = v;
        this.mf_Border = "";
    }

    public void SetBorderFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_Border = v;
    }

    public String GetBorderFormula() {
        return this.mf_Border;
    }

    public int GetBorder(int row) {
        return this.GetBorder(this.m_pBand.m_pDoc, row);
    }

    int GetBorder(DataDoc pDoc, int row) {
        if (this.mf_Border.equals("") || pDoc.m_pDs == null) {
            return this.m_Border;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_Border);
        return Integer.parseInt(v.toString());
    }

    public void SetFontSize(int v) {
        this.m_FontSize = v;
        this.mf_FontSize = "";
    }

    public void SetFontSizeFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_FontSize = v;
    }

    public String GetFontSizeFormula() {
        return this.mf_FontSize;
    }

    public int GetFontSize(int row) {
        return this.GetFontSize(this.m_pBand.m_pDoc, row);
    }

    int GetFontSize(DataDoc pDoc, int row) {
        if (this.mf_FontSize.equals("") || pDoc.m_pDs == null) {
            return this.m_FontSize;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_FontSize);
        return Integer.parseInt(v.toString());
    }

    public void SetFontName(String v) {
        if (v == null) {
            return;
        }
        this.m_FontName = v;
        this.mf_FontName = "";
    }

    public void SetFontNameFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_FontName = v;
    }

    public String GetFontNameFormula() {
        return this.mf_FontName;
    }

    public String GetFontName(int row) {
        return this.GetFontName(this.m_pBand.m_pDoc, row);
    }

    String GetFontName(DataDoc pDoc, int row) {
        if (this.mf_FontName.equals("") || pDoc.m_pDs == null) {
            return this.m_FontName;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_FontName);
        return v.toString();
    }

    public int GetBackMode(int row) {
        return this.GetBackMode(this.m_pBand.m_pDoc, row);
    }

    int GetBackMode(DataDoc pDoc, int row) {
        if (this.mf_BackMode.equals("") || pDoc.m_pDs == null) {
            return this.m_BackMode;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_BackMode);
        return Integer.parseInt(v.toString());
    }

    public void SetBackMode(int v) {
        this.m_BackMode = v;
        this.mf_BackMode = "";
    }

    public void SetBackModeFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_BackMode = "";
        this.mf_BackMode.concat(v);
    }

    public String GetBackModeFormula() {
        return this.mf_BackMode;
    }

    static Object GetValue(DataDoc pDoc, int row, String expression) {
        if (row < 0) {
            return null;
        }
        Object v = null;
        int colIndex = pDoc.m_pDs.col2Index(expression);
        v = colIndex >= 0 ? pDoc.m_pDs.getValue(row, colIndex) : pDoc.m_pDs.evaluate(expression, row);
        return v;
    }

    Font GetFont(DataDoc pDoc, int row) {
        return DrawObject.GetFont(this.GetFontName(pDoc, row), this.GetFontSize(pDoc, row), this.GetFontBold(pDoc, row), this.GetFontItalic(pDoc, row), this.GetFontUnderline(pDoc, row));
    }

    static Font GetFont(String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline) {
        String key = String.valueOf(FontName) + String.valueOf(FontSize) + String.valueOf(FontBold) + String.valueOf(FontItalic) + String.valueOf(FontUnderline);
        if (m_FontMap.containsKey(key)) {
            return (Font)m_FontMap.get(key);
        }
        Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        Font font = new Font(map);
        m_FontMap.put(key, font);
        return font;
    }

    void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign) {
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.x, rc.y, rc.width, rc.height);
        Font font = DrawObject.GetFont(FontName, FontSize, FontBold, FontItalic, FontUnderline);
        FontRenderContext frc = g.getFontRenderContext();
        TextLayout layout = new TextLayout(s, font, frc);
        float drawPosY = rc.y;
        switch (vAlign) {
            case 1: {
                drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                break;
            }
            case 2: {
                drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                break;
            }
            default: {
                drawPosY += layout.getAscent();
            }
        }
        float drawPosX = rc.x;
        switch (hAlign) {
            case 1: {
                drawPosX = (float)(rc.x + rc.width) - layout.getAdvance();
                break;
            }
            case 2: {
                drawPosX = (float)rc.x + ((float)rc.width - layout.getAdvance()) / 2.0f;
                break;
            }
            default: {
                drawPosX = rc.x;
            }
        }
        layout.draw(g, drawPosX, drawPosY);
        g.setClip(oc.x, oc.y, oc.width, oc.height);
    }

    void DrawString(Graphics2D g, Rectangle rc, String s, int bkMode, Color bkcolor, Color textcolor, String FontName, int FontSize, boolean FontBold, boolean FontItalic, boolean FontUnderline, int hAlign, int vAlign, boolean MultiLine) {
        if (s.trim().equals("")) {
            return;
        }
        if (rc.width <= 0 || rc.height <= 0) {
            return;
        }
        if (!MultiLine) {
            this.DrawString(g, rc, s, bkMode, bkcolor, textcolor, FontName, FontSize, FontBold, FontItalic, FontUnderline, hAlign, vAlign);
            return;
        }
        g.setColor(bkcolor);
        if (bkMode != 0) {
            g.fillRect(rc.x, rc.y, rc.width, rc.height);
        }
        g.setColor(textcolor);
        Dimension size = rc.getSize();
        Rectangle oc = g.getClipBounds();
        g.setClip(rc.x, rc.y, rc.width, rc.height);
        Hashtable<TextAttribute, Object> map = new Hashtable<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, FontName);
        map.put(TextAttribute.SIZE, new Float(FontSize));
        if (FontUnderline) {
            map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (FontBold) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (FontItalic) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        AttributedString ss = new AttributedString(s, map);
        AttributedCharacterIterator text = ss.getIterator();
        FontRenderContext frc = g.getFontRenderContext();
        int paragraphStart = text.getBeginIndex();
        int paragraphEnd = text.getEndIndex();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(text, frc);
        float formatWidth = size.width;
        float drawPosY = rc.y;
        if (MultiLine && vAlign != 0) {
            double gg = 0.0;
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                gg += (double)(layout.getDescent() + layout.getLeading() + layout.getAscent());
            }
            if (gg < (double)rc.height) {
                if (vAlign == 2) {
                    drawPosY = (float)((double)drawPosY + ((double)rc.height - gg) / 2.0);
                }
                if (vAlign == 1) {
                    drawPosY = (float)((double)drawPosY + ((double)rc.height - gg));
                }
            }
        }
        lineMeasurer.setPosition(paragraphStart);
        while (lineMeasurer.getPosition() < paragraphEnd) {
            TextLayout layout = lineMeasurer.nextLayout(formatWidth);
            switch (vAlign) {
                case 1: {
                    if (!MultiLine) {
                        drawPosY += (float)rc.height - layout.getDescent() - layout.getLeading();
                        break;
                    }
                }
                case 2: {
                    if (!MultiLine) {
                        drawPosY += layout.getAscent() + ((float)rc.height - layout.getAscent() - layout.getDescent() - layout.getLeading()) / 2.0f;
                        break;
                    }
                }
                default: {
                    drawPosY += layout.getAscent();
                }
            }
            float drawPosX = rc.x;
            switch (hAlign) {
                case 1: {
                    drawPosX = (float)rc.x + formatWidth - layout.getAdvance();
                    break;
                }
                case 2: {
                    drawPosX = (float)rc.x + (formatWidth - layout.getAdvance()) / 2.0f;
                    break;
                }
                default: {
                    drawPosX = rc.x;
                }
            }
            layout.draw(g, drawPosX, drawPosY);
            if ((drawPosY += layout.getDescent() + layout.getLeading()) >= (float)(rc.y + rc.height) || !MultiLine) break;
        }
        g.setClip(oc.x, oc.y, oc.width, oc.height);
    }

    public void SetEditStyleName(String v) {
        if (v == null) {
            return;
        }
        this.m_EditStyleName = v;
        this.mf_EditStyleName = "";
    }

    public boolean SetEditStyle(int et, String name) {
        name = name.trim().toLowerCase();
        this.m_EditType = et;
        this.m_EditStyleName = name;
        return true;
    }

    public int GetUniformDataType() {
        if (this.m_ObjectType != 1) {
            return 6;
        }
        if (this.m_BindNo < 0) {
            return 6;
        }
        if (this.m_pBand.m_pDoc.m_pDs == null) {
            return 6;
        }
        return this.m_pBand.m_pDoc.m_pDs.getColumnProperty(this.m_BindNo).getUniformDataType();
    }

    public int GetEditType() {
        if (this.m_EditType != 0) {
            return this.m_EditType;
        }
        if (this.m_ObjectType != 1) {
            return 1;
        }
        if (this.m_BindNo < 0) {
            return 1;
        }
        switch (this.m_pBand.m_pDoc.m_pDs.getColumnProperty(this.m_BindNo).getUniformDataType()) {
            case 4: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 1;
    }

    public void SetEditStyleNameFormula(String v) {
        if (v == null) {
            return;
        }
        this.mf_EditStyleName = v;
    }

    public String GetEditStyleNameFormula() {
        return this.mf_EditStyleName;
    }

    public String GetEditStyleName(int row) {
        return this.GetEditStyleName(this.m_pBand.m_pDoc, row);
    }

    String GetEditStyleName(DataDoc pDoc, int row) {
        if (this.mf_EditStyleName.equals("") || pDoc.m_pDs == null) {
            return this.m_EditStyleName;
        }
        Object v = DrawObject.GetValue(pDoc, row, this.mf_EditStyleName);
        return v.toString();
    }

    public int GetHAlignment() {
        return this.hAlign;
    }

    public void SetHAlignment(int align) {
        this.hAlign = align;
    }

    public int GetVAlignment() {
        return this.vAlign;
    }

    public void SetVAlignment(int align) {
        this.vAlign = align;
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    public void setMultiLine(boolean isMultiLine) {
        this.isMultiLine = isMultiLine;
    }

    public int GetStartBand() {
        return this.m_StartBand;
    }

    public void SetStartBand(int startBand) {
        this.m_StartBand = startBand;
    }

    public int GetEndBand() {
        return this.m_EndBand;
    }

    public void SetEndBand(int endBand) {
        this.m_EndBand = endBand;
    }

    public boolean GetActAsButton() {
        return this.m_ActAsButton;
    }

    public void SetActAsButton(boolean actAsButton) {
        this.m_ActAsButton = actAsButton;
    }

    public boolean GetAntialias() {
        return this.m_Antialias;
    }

    public void SetAntialias(boolean antialias) {
        this.m_Antialias = antialias;
    }
}

