/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JScrollBar;
import jun.df.Band;
import jun.df.CurrentBindRow;
import jun.df.DataDoc;
import jun.df.DataForm;
import jun.df.DataFormEventManager;
import jun.df.DataStoreAction;
import jun.df.DataViewKeyListener;
import jun.df.DataViewMouseAdapter;
import jun.df.DataViewMouseMotionAdapter;
import jun.df.DataViewMouseWheelAdapter;
import jun.df.DrawObject;
import jun.df.DropDownListBox;
import jun.df.EditDatetime;
import jun.df.EditNormal;
import jun.df.EditNumeric;
import jun.df.HScrollBarListener;
import jun.df.HeadTool;
import jun.df.IAreasListener;
import jun.df.IEdition;
import jun.df.SelectTool;
import jun.df.VScrollBarListener;

public class DataView
extends Component
implements IEdition,
IAreasListener {
    private DataFormEventManager m_EventManager = new DataFormEventManager();
    private CurrentBindRow m_CurrentBindRow = new CurrentBindRow(this);
    JScrollBar m_hScrollBar = null;
    JScrollBar m_vScrollBar = null;
    boolean m_WheelV = true;
    private int m_FormStyle = 2;
    boolean m_Redraw = true;
    static SelectTool selectTool = new SelectTool();
    static HeadTool headTool = new HeadTool();
    private int m_CurrentRow = -1;
    int m_CurrentArea = -1;
    DrawObject m_CurrentObject = null;
    int m_FirstViewRow = 0;
    int m_FirstViewColumn = 0;
    ArrayList m_PageRange;
    int m_FirstPrintColumn;
    int m_FirstPrintRow;
    int m_LastPrintColumn;
    int m_LastPrintRow;
    int m_CurrentPrintingPage;
    int m_PageWidth;
    int m_PageHeight;
    private int LineWidth = 1;
    DataStoreAction m_DSA = null;
    private boolean m_MouseCapture = false;
    HashMap m_SelectedRows = new HashMap();
    private DataDoc m_Doc = null;

    public String GetEdition() {
        return "1.0";
    }

    public DataView(DataDoc doc, JScrollBar hSB, JScrollBar vSB) {
        this.m_Doc = doc;
        this.m_DSA = new DataStoreAction(this);
        this.m_Doc.AddView(this);
        this.m_Doc.m_Areas.AddListener(this);
        this.m_hScrollBar = hSB;
        this.m_vScrollBar = vSB;
        this.m_hScrollBar.addAdjustmentListener(new HScrollBarListener(this));
        this.m_vScrollBar.addAdjustmentListener(new VScrollBarListener(this));
        this.addMouseListener(new DataViewMouseAdapter(this));
        this.addMouseMotionListener(new DataViewMouseMotionAdapter(this));
        this.addMouseWheelListener(new DataViewMouseWheelAdapter(this));
        this.addKeyListener(new DataViewKeyListener(this));
    }

    int LW() {
        return this.LineWidth;
    }

    public DataDoc GetDoc() {
        return this.m_Doc;
    }

    void SetFormStyle(int fs) {
        if (this.m_FormStyle == fs) {
            return;
        }
        this.m_FormStyle = fs;
        this.m_Doc.m_Areas.AddListener(this);
        this.ResetHScrollBarScrollRange();
        this.ResetVScrollBarScrollRange();
    }

    int GetFormStyle() {
        return this.m_FormStyle;
    }

    void SetCapture() {
        this.m_MouseCapture = true;
    }

    void ReleaseCapture() {
        this.m_MouseCapture = false;
    }

    boolean GetCapture() {
        return this.m_MouseCapture;
    }

    boolean IsOnHeader(Point point, Rectangle pClientRect) {
        Rectangle client = pClientRect != null ? (Rectangle)pClientRect.clone() : this.getBounds();
        client.height = this.m_Doc.m_pHeader.Height(this.m_Doc);
        return client.contains(point);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.m_Redraw) {
            this.OnDraw(g2);
        }
    }

    void OnDraw(Graphics2D g) {
        Rectangle rc = g.getClipBounds();
        Rectangle client = this.getBounds();
        AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
        g.setComposite(ac);
        g.setColor(this.m_Doc.m_PaperColor);
        g.fill(client);
        ac = AlphaComposite.getInstance(3, 1.0f);
        g.setComposite(ac);
        g.fill(client);
        g.setColor(this.m_Doc.m_PaperColor);
        g.fillRect(rc.x, rc.y, rc.width, rc.height);
        this.DrawObjectInRect(rc, client, g);
    }

    void DrawObjectInRect(Rectangle rect, Rectangle client, Graphics2D g) {
        this.DrawHeader(rect, client, g);
        this.DrawDetail(rect, client, g);
        this.DrawTrailer(rect, client, g);
        this.DrawFooter(rect, client, g);
    }

    void DrawHeader(Rectangle rect, Rectangle client, Graphics2D g) {
        Band pBand = this.m_Doc.m_pHeader;
        Iterator vi = pBand.m_ObjectVector.iterator();
        while (vi.hasNext()) {
            DrawObject pObj = pBand.Item((String)vi.next());
            pObj.DrawInHeader(this.m_Doc, this, rect, client, g);
        }
    }

    void DrawDetail(Rectangle rect, Rectangle client, Graphics2D g) {
        Band pBand = this.m_Doc.m_pDetail;
        Iterator vi = pBand.m_ObjectVector.iterator();
        while (vi.hasNext()) {
            DrawObject pObj = pBand.Item((String)vi.next());
            pObj.DrawInDetail(this.m_Doc, this, rect, client, g);
        }
    }

    void DrawFooter(Rectangle rect, Rectangle client, Graphics2D g) {
        Band pBand = this.m_Doc.m_pFooter;
        Iterator vi = pBand.m_ObjectVector.iterator();
        while (vi.hasNext()) {
            DrawObject pObj = pBand.Item((String)vi.next());
            pObj.DrawInFooter(this.m_Doc, this, rect, client, g);
        }
    }

    void DrawTrailer(Rectangle rect, Rectangle client, Graphics2D g) {
        int i = 0;
        while (i < this.m_Doc.m_pTrailers.Count()) {
            Band pBand = this.m_Doc.m_pTrailers.Item(i);
            Iterator vi = pBand.m_ObjectVector.iterator();
            while (vi.hasNext()) {
                DrawObject pObj = pBand.Item((String)vi.next());
                pObj.DrawInTrailer(this.m_Doc, this, rect, client, g, i);
            }
            ++i;
        }
    }

    public void AreasCountChanged(int count) {
        this.ResetHScrollBarScrollRange();
    }

    public void AreaWidthChanged(int areaWidth) {
        this.ResetHScrollBarScrollRange();
    }

    int FreeStyleMaxRight(Band pBand, int row) {
        int ret = 0;
        int i = 0;
        while (i < pBand.Count()) {
            int w;
            DrawObject obj = pBand.Item(i);
            int x = obj.GetX(row);
            if (ret < x + (w = obj.GetWidth(row))) {
                ret = x + w;
            }
            ++i;
        }
        return ret;
    }

    int FreeStyleMaxRight() {
        int ret = 0;
        int row = this.GetCurrentBindRow();
        if (row < 0) {
            return this.m_Doc.m_Areas.AllAreaWidth() + this.m_Doc.leftBlank;
        }
        if (this.m_Doc.m_Areas.Count() > 1) {
            return this.m_Doc.m_Areas.AllAreaWidth() + this.m_Doc.leftBlank;
        }
        ret = Math.max(ret, this.FreeStyleMaxRight(this.m_Doc.m_pHeader, row));
        ret = Math.max(ret, this.FreeStyleMaxRight(this.m_Doc.m_pDetail, row));
        ret = Math.max(ret, this.FreeStyleMaxRight(this.m_Doc.m_pFooter, row));
        int i = 0;
        while (i < this.m_Doc.m_pTrailers.Count()) {
            ret = Math.max(ret, this.FreeStyleMaxRight(this.m_Doc.m_pTrailers.Item(i), row));
            ++i;
        }
        return ret;
    }

    int FreeStyleMaxBottom(Band pBand, int row) {
        int ret = 0;
        int i = 0;
        while (i < pBand.Count()) {
            int h;
            DrawObject obj = pBand.Item(i);
            int y = obj.GetY(row);
            if (ret < y + (h = obj.GetHeight(row))) {
                ret = y + h;
            }
            ++i;
        }
        return ret;
    }

    int FreeStyleMaxBottom() {
        int ret = 0;
        int row = this.GetCurrentBindRow();
        if (row < 0) {
            return this.m_Doc.m_pDetail.Height(this.m_Doc);
        }
        ret = Math.max(ret, this.FreeStyleMaxBottom(this.m_Doc.m_pDetail, row));
        ret = Math.max(ret, this.FreeStyleMaxBottom(this.m_Doc.m_pFooter, row));
        int i = 0;
        while (i < this.m_Doc.m_pTrailers.Count()) {
            ret = Math.max(ret, this.FreeStyleMaxBottom(this.m_Doc.m_pTrailers.Item(i), row));
            ++i;
        }
        return ret;
    }

    void ResetHScrollBarScrollRange() {
        int count = this.m_Doc.m_Areas.Count();
        Rectangle rc = this.getBounds();
        if (this.m_FormStyle == 2) {
            boolean oldV = this.m_hScrollBar.isVisible();
            boolean newV = true;
            int aw = this.m_Doc.m_Areas.AllAreaWidth() + this.m_Doc.leftBlank;
            if (aw <= rc.width) {
                newV = false;
            }
            if (newV != oldV) {
                this.m_hScrollBar.setVisible(newV);
                ((DataForm)this.getParent()).componentResized(null);
            } else {
                this.m_hScrollBar.setMinimum(0);
                this.m_hScrollBar.setMaximum(count - 1);
                if (this.m_FirstViewColumn >= count) {
                    this.m_FirstViewColumn = count - 1;
                }
            }
        }
        if (this.m_FormStyle == 1) {
            this.m_hScrollBar.setMinimum(0);
            int aw = this.FreeStyleMaxRight();
            boolean oldV = this.m_hScrollBar.isVisible();
            boolean newV = true;
            if (aw <= rc.width) {
                newV = false;
            }
            if (newV != oldV) {
                this.m_hScrollBar.setVisible(newV);
                ((DataForm)this.getParent()).componentResized(null);
            } else if (this.m_Doc.m_Areas.Count() <= 1) {
                this.m_hScrollBar.setMaximum(Math.max(0, aw - rc.width));
                this.m_hScrollBar.setUnitIncrement(20);
                this.m_hScrollBar.setBlockIncrement(rc.width);
            } else {
                this.m_hScrollBar.setMinimum(0);
                this.m_hScrollBar.setMaximum(count - 1);
                if (this.m_FirstViewColumn >= count) {
                    this.m_FirstViewColumn = count - 1;
                }
            }
        }
        this.repaint();
    }

    void ResetVScrollBarScrollRange() {
        try {
            int rowCount = this.m_Doc.m_pDs.getRowCount();
            if (this.m_FormStyle == 2) {
                boolean oldV = this.m_vScrollBar.isVisible();
                boolean newV = true;
                if (this.m_FirstViewRow == 0 && this.GetFirstRowOnNextPage() >= rowCount) {
                    newV = false;
                }
                if (newV != oldV) {
                    this.m_vScrollBar.setVisible(newV);
                    ((DataForm)this.getParent()).componentResized(null);
                } else {
                    this.m_vScrollBar.setMinimum(0);
                    this.m_vScrollBar.setMaximum(Math.max(0, rowCount - 1));
                }
            }
            if (this.m_FormStyle == 1) {
                Rectangle rc = this.getBounds();
                int h = this.m_Doc.m_pHeader.Height(this.m_Doc) + this.m_Doc.m_pFooter.Height(this.m_Doc);
                this.m_vScrollBar.setMinimum(0);
                int vh = rc.height - h;
                int dh = this.FreeStyleMaxBottom();
                boolean oldV = this.m_vScrollBar.isVisible();
                boolean newV = true;
                if (dh < vh) {
                    newV = false;
                }
                System.out.println("vh=" + String.valueOf(vh) + "    dh=" + String.valueOf(dh));
                if (newV != oldV) {
                    this.m_vScrollBar.setVisible(newV);
                    ((DataForm)this.getParent()).componentResized(null);
                } else {
                    int vmax = Math.max(0, dh - vh - this.m_hScrollBar.getHeight());
                    this.m_vScrollBar.setMaximum(vmax);
                    this.m_vScrollBar.setUnitIncrement(20);
                    this.m_vScrollBar.setBlockIncrement(vh);
                }
            }
        }
        catch (Exception e) {
            System.out.println("ResetVScrollBarScrollRange\u53d1\u751f\u9519\u8bef" + e.getMessage());
        }
        this.repaint();
    }

    int GetHeadRect(Point point, Rectangle rect, Rectangle pClientRect) {
        Rectangle client = pClientRect != null ? (Rectangle)pClientRect.clone() : this.getBounds();
        client.height = this.m_Doc.m_pHeader.Height(this.m_Doc);
        boolean left = false;
        Rectangle rc = new Rectangle();
        rc.y = client.y;
        rc.height = client.height;
        rc.x = this.m_Doc.leftBlank;
        int i = 0;
        while (i < this.m_Doc.m_FixedColumnCount) {
            rc.width = this.m_Doc.m_Areas.AreaWidth(i);
            if (rc.contains(point)) {
                rect.setBounds(rc);
                return i;
            }
            rc.x += rc.width;
            ++i;
        }
        int n = this.m_Doc.m_Areas.Count();
        i = this.m_FirstViewColumn;
        while (i < n) {
            rc.width = this.m_Doc.m_Areas.AreaWidth(i);
            if (rc.contains(point)) {
                rect.setBounds(rc);
                return i;
            }
            rc.x += rc.width;
            ++i;
        }
        return -1;
    }

    void DrawXorLine(int x1, int y1, int x2, int y2) {
        Graphics2D dc = (Graphics2D)this.getGraphics();
        dc.setColor(new Color(36, 121, 162));
        dc.setXORMode(new Color(255, 255, 255));
        dc.drawLine(x1, y1, x2, y2);
        dc.setPaintMode();
    }

    void MoveArea(int a1, int a2, int dir) {
        if (dir == -1 && a1 + 1 == a2) {
            return;
        }
        if (dir == 1 && a2 + 1 == a1) {
            return;
        }
        if (dir == 1) {
            ++a2;
        }
        int w = this.m_Doc.m_Areas.AreaWidth(a1);
        this.m_Doc.m_Areas.InsertArea(a2);
        this.m_Doc.m_Areas.SetAreaWidth(a2, w);
        if (a1 > a2) {
            ++a1;
        }
        Band pBand = this.m_Doc.m_pHeader;
        Iterator<Object> vi = pBand.m_ObjectVector.iterator();
        while (vi.hasNext()) {
            DrawObject pObj = pBand.Item((String)vi.next());
            if (pObj.m_StartBand != a1 || pObj.m_EndBand != a1 && pObj.m_EndBand != 0) continue;
            pObj.m_StartBand = a2;
        }
        pBand = this.m_Doc.m_pDetail;
        for (DrawObject pObj : pBand.m_ObjectMap.values()) {
            if (pObj.m_StartBand != a1 || pObj.m_EndBand != a1 && pObj.m_EndBand != 0) continue;
            pObj.m_StartBand = a2;
        }
        pBand = this.m_Doc.m_pFooter;
        for (DrawObject pObj : pBand.m_ObjectMap.values()) {
            if (pObj.m_StartBand != a1 || pObj.m_EndBand != a1 && pObj.m_EndBand != 0) continue;
            pObj.m_StartBand = a2;
        }
        int j = 0;
        while (j < this.m_Doc.m_pTrailers.Count()) {
            pBand = this.m_Doc.m_pTrailers.Item(j);
            for (DrawObject pObj : pBand.m_ObjectMap.values()) {
                if (pObj.m_StartBand != a1 || pObj.m_EndBand != a1 && pObj.m_EndBand != 0) continue;
                pObj.m_StartBand = a2;
            }
            ++j;
        }
        this.m_Doc.m_Areas.DeleteArea(a1);
    }

    void BeginEdit(Rectangle rect, DrawObject pObj, int row) {
        if (!pObj.GetEditable(this.m_Doc, row)) {
            return;
        }
        this.m_CurrentArea = pObj.m_StartBand;
        this.m_CurrentObject = pObj;
        this.SetCurrentRowAndFireRowFocusChanged(row);
        switch (pObj.GetEditType()) {
            case 1: {
                EditNormal m_NormalEdit = new EditNormal();
                m_NormalEdit.BeginEdit(this.m_Doc, this, pObj, rect, row);
                break;
            }
            case 3: {
                EditDatetime dateEdit = new EditDatetime();
                dateEdit.BeginEdit(this.m_Doc, this, pObj, rect, row);
                break;
            }
            case 2: {
                EditNumeric nEdit = new EditNumeric();
                nEdit.BeginEdit(this.m_Doc, this, pObj, rect, row);
                break;
            }
            case 4: {
                DropDownListBox ddlb = new DropDownListBox();
                ddlb.BeginEdit(this.m_Doc, this, pObj, rect, row);
            }
        }
        this.EventManager().FireBeginEdit(row, this.m_CurrentObject);
    }

    void EndEdit(int row, DrawObject obj) {
        this.EventManager().FireEndEdit(row, obj);
    }

    int GetFirstRowOnNextPage() {
        if (this.m_Doc.m_pDs == null) {
            return this.m_FirstViewRow;
        }
        int row = this.m_FirstViewRow;
        int h = 0;
        int RowCount = this.m_Doc.m_pDs.getRowCount();
        int ScreenHeight = this.getHeight();
        ScreenHeight = ScreenHeight - this.m_Doc.m_pFooter.Height(this.m_Doc) - this.m_Doc.m_pHeader.Height(this.m_Doc);
        row = this.m_FirstViewRow;
        while (row < RowCount) {
            if ((h = h + this.m_Doc.m_pDetail.Height(this.m_Doc, row) + this.m_Doc.DetailRowTrailerHeight(row)) > ScreenHeight) break;
            ++row;
        }
        return row;
    }

    int GetFirstRowOnPriorPage() {
        if (this.m_Doc.m_pDs == null) {
            return this.m_FirstViewRow;
        }
        int row = this.m_FirstViewRow;
        int h = 0;
        int RowCount = this.m_Doc.m_pDs.getRowCount();
        int ScreenHeight = this.getHeight() - this.m_Doc.m_pFooter.Height(this.m_Doc) - this.m_Doc.m_pHeader.Height(this.m_Doc);
        row = this.m_FirstViewRow - 1;
        while (row >= 0) {
            if ((h = h + this.m_Doc.m_pDetail.Height(this.m_Doc, row) + this.m_Doc.DetailRowTrailerHeight(row)) > ScreenHeight) {
                ++row;
                break;
            }
            --row;
        }
        if (row < 0) {
            return 0;
        }
        return row;
    }

    int GetFirstColumnOnNextPage() {
        int col = this.m_FirstViewColumn;
        int h = 0;
        int ColumnCount = this.m_Doc.m_Areas.Count();
        int ScreenWidth = this.getWidth() - this.m_Doc.m_Areas.FixedAreaWidth(this.m_Doc.m_FixedColumnCount);
        col = this.m_FirstViewColumn;
        while (col < ColumnCount) {
            if ((h += this.m_Doc.m_Areas.AreaWidth(col)) > ScreenWidth) break;
            ++col;
        }
        return col;
    }

    int GetFirstColumnOnPriorPage() {
        int col = this.m_FirstViewColumn;
        int h = 0;
        int ColumnCount = this.m_Doc.m_Areas.Count();
        int ScreenWidth = this.getWidth() - this.m_Doc.m_Areas.FixedAreaWidth(this.m_Doc.m_FixedColumnCount);
        col = this.m_FirstViewColumn - 1;
        while (col >= this.m_Doc.m_FixedColumnCount) {
            if ((h += this.m_Doc.m_Areas.AreaWidth(col)) > ScreenWidth) {
                ++col;
                break;
            }
            --col;
        }
        if (col < this.m_Doc.m_FixedColumnCount) {
            col = this.m_Doc.m_FixedColumnCount;
        }
        return col;
    }

    DrawObject ScrollToObject(int row, int col) {
        return this.ScrollToObject(null, row, col);
    }

    public DrawObject ScrollToObject(DrawObject pObject, int row, int col) {
        if (this.GetFormStyle() == 2) {
            return this.ScrollToObject_GridStyle(pObject, row, col);
        }
        if (this.GetFormStyle() == 1) {
            return this.ScrollToObject_FreeStyle(pObject);
        }
        return null;
    }

    DrawObject ScrollToObject_FreeStyle(DrawObject pObject) {
        int backupFirstRow = this.m_FirstViewRow;
        int backupFirstCol = this.m_FirstViewColumn;
        Rectangle client = this.getBounds();
        Rectangle rc2 = (Rectangle)client.clone();
        boolean left = false;
        int row = this.GetCurrentBindRow();
        int toIndex = 0;
        if (pObject.m_EndBand == 0) {
            toIndex = pObject.m_StartBand;
        }
        if (pObject.m_EndBand == -1) {
            toIndex = this.m_Doc.m_Areas.Count() - 1;
        }
        int maxHeight = this.m_Doc.m_pDetail.Height(this.m_Doc, row);
        int maxWidth = this.m_Doc.m_Areas.SomeAreaWidth(toIndex);
        int leftWidth = this.m_Doc.m_Areas.SomeAreaWidth(toIndex - 1);
        boolean top = false;
        Rectangle tc = new Rectangle();
        int t = pObject.GetX(this.m_Doc, row);
        tc.x = t >= 0 ? Math.min(leftWidth + t, maxWidth) : Math.max(leftWidth, Math.max(maxWidth + t, 0));
        t = pObject.GetY(this.m_Doc, row);
        tc.y = t >= 0 ? t : Math.max(maxHeight + t, 0);
        t = pObject.GetWidth(this.m_Doc, row);
        if (t == 0) {
            tc.width = Math.max(maxWidth - tc.x, 0);
        }
        if (t > 0) {
            tc.width = Math.min(tc.x + t, maxWidth) - tc.x;
        }
        if (t < 0) {
            tc.width = Math.max(tc.x, Math.max(maxWidth + t, 0)) - tc.x;
        }
        if ((t = pObject.GetHeight(this.m_Doc, row)) == 0) {
            tc.height = Math.max(maxHeight - tc.y, 0);
        }
        if (t > 0) {
            tc.height = Math.min(tc.y + t, maxHeight) - tc.y;
        }
        if (t < 0) {
            tc.height = Math.max(tc.y, Math.max(maxHeight + t, 0)) - tc.y;
        }
        Rectangle detailRc = (Rectangle)client.clone();
        detailRc.height = detailRc.height - this.m_Doc.m_pHeader.Height(this.m_Doc) - this.m_Doc.m_pFooter.Height(this.m_Doc);
        detailRc.width -= this.m_Doc.leftBlank;
        detailRc.x += this.m_FirstViewColumn;
        detailRc.y += this.m_FirstViewRow;
        if (detailRc.contains(tc)) {
            return pObject;
        }
        if (tc.x < detailRc.x || tc.x + tc.width > detailRc.x + detailRc.width) {
            this.m_FirstViewColumn = tc.width >= detailRc.width ? tc.x + 5 : tc.x + tc.width - detailRc.width + 5;
        }
        if (tc.y < detailRc.y || tc.y + tc.height > detailRc.y + detailRc.height) {
            this.m_FirstViewRow = tc.height > detailRc.height ? tc.y + 5 : tc.y + tc.height - detailRc.height + 5;
        }
        this.UpdateScrollBar();
        if (this.m_FirstViewColumn != backupFirstCol || this.m_FirstViewRow != backupFirstRow) {
            this.repaint();
        }
        return pObject;
    }

    DrawObject ScrollToObject_GridStyle(DrawObject pObject, int row, int col) {
        int backupFirstRow = this.m_FirstViewRow;
        int backupFirstCol = this.m_FirstViewColumn;
        DrawObject pObj = pObject;
        if (pObj == null) {
            pObj = this.m_Doc.FindFirstObject(this.m_Doc.m_pDetail, col);
        }
        if (pObj == null) {
            return null;
        }
        if (this.m_Doc.m_pDs == null) {
            return null;
        }
        if (pObj == null) {
            return null;
        }
        if (row < 0) {
            return null;
        }
        Rectangle rc = null;
        if (row < this.m_FirstViewRow) {
            this.m_FirstViewRow = row;
        } else {
            int lr = this.GetFirstRowOnNextPage() - 1;
            if (row >= lr) {
                this.m_FirstViewRow += row - lr;
                int maxBottom = this.getY() + this.getHeight() - this.m_Doc.m_pFooter.Height(this.m_Doc);
                int rowHeight = this.m_Doc.m_pDetail.Height(this.m_Doc, row);
                while (this.m_FirstViewRow < row) {
                    rc = pObj.GetBounds(this, row);
                    int h = rc.y + rowHeight;
                    if (h <= maxBottom) break;
                    ++this.m_FirstViewRow;
                }
            }
        }
        if (col < this.m_FirstViewColumn) {
            this.m_FirstViewColumn = col;
        } else {
            int lc = this.GetFirstColumnOnNextPage() - 1;
            if (col >= lc) {
                this.m_FirstViewColumn += col - lc;
                int colWidth = this.m_Doc.m_Areas.AreaWidth(col);
                int maxRight = this.getX() + this.getWidth();
                while (this.m_FirstViewColumn < col) {
                    rc = pObj.GetBounds(this, row);
                    int w = rc.x + colWidth;
                    if (w <= maxRight) break;
                    ++this.m_FirstViewColumn;
                }
            }
        }
        this.UpdateScrollBar();
        if (this.m_FirstViewColumn != backupFirstCol || this.m_FirstViewRow != backupFirstRow) {
            this.repaint();
        }
        return pObj;
    }

    void UpdateScrollBar() {
        if (this.m_hScrollBar.getValue() != this.m_FirstViewColumn) {
            this.m_hScrollBar.setValue(this.m_FirstViewColumn);
            this.m_hScrollBar.repaint();
        }
        if (this.m_vScrollBar.getValue() != this.m_FirstViewRow) {
            this.m_vScrollBar.setValue(this.m_FirstViewRow);
            this.m_vScrollBar.repaint();
        }
    }

    void OnKeyDownVK_UP_FreeForm(KeyEvent e) {
    }

    void OnKeyDownVK_UP_GridForm(KeyEvent e) {
        if (this.m_CurrentObject == null) {
            return;
        }
        switch (this.m_CurrentObject.m_pBand.GetName()) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                int row;
                int lastRow = row = this.m_CurrentRow;
                while (row > 0) {
                    if (this.m_CurrentObject.GetEditable(this.m_Doc, --row)) break;
                }
                this.ScrollToObject(this.m_CurrentObject, row, this.m_CurrentObject.m_StartBand);
                this.m_CurrentObject.BeginEdit(this, null, row);
            }
        }
    }

    void OnKeyDownVK_DOWN_FreeForm(KeyEvent e) {
        if (this.m_CurrentObject != null) {
            this.m_CurrentObject.BeginEdit(this, null, this.GetCurrentBindRow());
        }
    }

    void OnKeyDownVK_DOWN_GridForm(KeyEvent e) {
        if (this.m_CurrentObject == null) {
            return;
        }
        switch (this.m_CurrentObject.m_pBand.GetName()) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                int row;
                if (this.m_Doc.m_pDs == null) {
                    return;
                }
                int rc = this.m_Doc.m_pDs.getRowCount();
                int lastRow = row = this.m_CurrentRow;
                while (row < rc - 1) {
                    if (this.m_CurrentObject.GetEditable(this.m_Doc, ++row)) break;
                }
                this.ScrollToObject(this.m_CurrentObject, row, this.m_CurrentObject.m_StartBand);
                this.m_CurrentObject.BeginEdit(this, null, row);
            }
        }
    }

    void OnKeyDownVK_PageUp(KeyEvent e) {
        if (this.GetFormStyle() == 2) {
            this.OnKeyDownVK_PageUp_GridForm(e);
        }
        if (this.GetFormStyle() == 1) {
            this.OnKeyDownVK_PageUp_FreeForm(e);
        }
    }

    void OnKeyDownVK_PageDown(KeyEvent e) {
        if (this.GetFormStyle() == 2) {
            this.OnKeyDownVK_PageDown_GridForm(e);
        }
        if (this.GetFormStyle() == 1) {
            this.OnKeyDownVK_PageDown_FreeForm(e);
        }
    }

    void OnKeyDownVK_UP(KeyEvent e) {
        if (this.GetFormStyle() == 2) {
            this.OnKeyDownVK_UP_GridForm(e);
        }
        if (this.GetFormStyle() == 1) {
            this.OnKeyDownVK_UP_FreeForm(e);
        }
    }

    void OnKeyDownVK_DOWN(KeyEvent e) {
        if (this.GetFormStyle() == 2) {
            this.OnKeyDownVK_DOWN_GridForm(e);
        }
        if (this.GetFormStyle() == 1) {
            this.OnKeyDownVK_DOWN_FreeForm(e);
        }
    }

    void SetCurrentBindRow(int bindRow) {
        this.m_CurrentBindRow.SetCurrentBindRow(bindRow);
    }

    public void SetCurrentRowAndFireRowFocusChanged(int row) {
        this.EventManager().FireRowFocusChanged(this.m_CurrentRow, row);
        this.m_CurrentRow = row;
    }

    int GetCurrentBindRow() {
        return this.m_CurrentBindRow.GetCurrentBindRow();
    }

    void OnKeyDownVK_PageDown_FreeForm(KeyEvent e) {
        int row = this.GetCurrentBindRow();
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        if (row + 1 == this.m_Doc.m_pDs.getRowCount()) {
            return;
        }
        this.SetCurrentBindRow(row + 1);
        this.repaint();
        if (this.m_CurrentObject != null) {
            this.m_CurrentObject.BeginEdit(this, null, this.GetCurrentBindRow());
        }
    }

    void OnKeyDownVK_PageDown_GridForm(KeyEvent e) {
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        int row = this.GetFirstRowOnNextPage();
        if (row == this.m_Doc.m_pDs.getRowCount() - 1) {
            return;
        }
        this.m_FirstViewRow = row;
        this.UpdateScrollBar();
    }

    void OnKeyDownVK_PageUp_GridForm(KeyEvent e) {
        int row;
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        this.m_FirstViewRow = row = this.GetFirstRowOnPriorPage();
        this.UpdateScrollBar();
    }

    void OnKeyDownVK_PageUp_FreeForm(KeyEvent e) {
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        int row = this.GetCurrentBindRow();
        if (row == 0) {
            return;
        }
        this.SetCurrentBindRow(row - 1);
        this.repaint();
        if (this.m_CurrentObject != null) {
            this.m_CurrentObject.BeginEdit(this, null, this.GetCurrentBindRow());
        }
    }

    public void OnKeyDownVK_TAB(KeyEvent e) {
        if (this.GetFormStyle() == 2) {
            this.OnKeyDownVK_TAB_GridForm(e);
        }
        if (this.GetFormStyle() == 1) {
            this.OnKeyDownVK_TAB_FreeForm(e);
        }
    }

    void OnKeyDownVK_TAB_FreeForm(KeyEvent e) {
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        int AreaCount = this.m_Doc.m_Areas.Count();
        int RowCount = this.m_Doc.m_pDs.getRowCount();
        DrawObject oldFocusObject = this.m_CurrentObject;
        Band pBand = this.m_Doc.m_pDetail;
        if (this.m_CurrentObject != null) {
            pBand = this.m_CurrentObject.m_pBand;
        }
        this.m_CurrentObject = !e.isShiftDown() ? pBand.NextFocusReceiver(this, this.m_CurrentObject) : pBand.PriorFocusReceiver(this, this.m_CurrentObject);
        if (this.m_CurrentObject != null) {
            this.m_CurrentObject = this.ScrollToObject(this.m_CurrentObject, 0, 0);
            this.m_CurrentObject.BeginEdit(this, null, this.GetCurrentBindRow());
        } else {
            this.EventManager().FireNowhereToJump();
        }
    }

    void OnKeyDownVK_TAB_GridForm(KeyEvent e) {
        int row;
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        int AreaCount = this.m_Doc.m_Areas.Count();
        int RowCount = this.m_Doc.m_pDs.getRowCount();
        int col = this.m_CurrentArea;
        int lastRow = row = this.m_CurrentRow;
        int lastCol = col;
        try {
            if (!e.isShiftDown()) {
                do {
                    if (col != AreaCount - 1) continue;
                    if (row + 1 == RowCount) {
                        throw new Exception("goto label_edit");
                    }
                    ++row;
                    col = -1;
                } while (!this.m_Doc.FindFirstObject(this.m_Doc.m_pDetail, ++col).GetEditable(this.m_Doc, row));
            } else {
                do {
                    if (col != 0) continue;
                    if (row == 0) {
                        throw new Exception("goto label_edit");
                    }
                    --row;
                    col = AreaCount;
                } while (!this.m_Doc.FindFirstObject(this.m_Doc.m_pDetail, --col).GetEditable(this.m_Doc, row));
            }
            this.m_CurrentArea = col;
            this.m_CurrentObject = this.ScrollToObject(null, row, col);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_CurrentObject != null) {
            this.m_CurrentObject.BeginEdit(this, null, row);
        }
        if (lastRow == row && lastCol == col) {
            this.EventManager().FireNowhereToJump();
        }
    }

    public DataFormEventManager EventManager() {
        return this.m_EventManager;
    }

    void SelectRow(int row, boolean selectIt) {
        if (this.m_Doc.m_pDs == null) {
            return;
        }
        int rc = this.m_Doc.m_pDs.getRowCount();
        if (row >= rc) {
            return;
        }
        if (row == -1) {
            this.m_SelectedRows.clear();
            if (selectIt) {
                int i = 0;
                while (i < rc) {
                    this.m_SelectedRows.put(new Integer(i), null);
                    ++i;
                }
            }
        } else if (selectIt) {
            this.m_SelectedRows.put(new Integer(row), null);
        } else if (this.m_SelectedRows.containsKey(new Integer(row))) {
            this.m_SelectedRows.remove(new Integer(row));
        }
        this.repaint();
    }

    public DrawObject GetCurrentObject() {
        return this.m_CurrentObject;
    }

    boolean isSelected(int row) {
        return this.m_SelectedRows.containsKey(new Integer(row));
    }

    void Simulate_keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                this.OnKeyDownVK_UP(e);
                break;
            }
            case 40: {
                this.OnKeyDownVK_DOWN(e);
                break;
            }
            case 10: {
                if (e.isControlDown()) {
                    this.OnKeyDownVK_DOWN(e);
                    break;
                }
                this.OnKeyDownVK_TAB(e);
                break;
            }
            case 9: {
                this.OnKeyDownVK_TAB(e);
                break;
            }
            case 33: {
                this.OnKeyDownVK_PageUp(e);
                break;
            }
            case 34: {
                this.OnKeyDownVK_PageDown(e);
                break;
            }
        }
        this.EventManager().FireKeyPressed(e);
    }
}

