/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.util.HashMap;
import jun.db.core.DataStoreActionAdapter;
import jun.df.Band;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.DrawObject;

class DataStoreAction
extends DataStoreActionAdapter {
    private DataView pView;

    public DataStoreAction(DataView v) {
        this.pView = v;
    }

    public void retrieveEnd(int rowCount) {
        this.pView.m_SelectedRows.clear();
        this.pView.ResetVScrollBarScrollRange();
        this.pView.ResetHScrollBarScrollRange();
        if (this.pView.GetFormStyle() == 1) {
            this.pView.SetCurrentBindRow(-1);
            if (rowCount > 0) {
                this.pView.SetCurrentBindRow(0);
            }
        } else {
            this.pView.SetCurrentRowAndFireRowFocusChanged(-1);
            if (rowCount > 0) {
                this.pView.SetCurrentRowAndFireRowFocusChanged(0);
            }
        }
        this.pView.m_CurrentArea = 0;
        this.pView.m_CurrentObject = null;
        this.pView.repaint();
    }

    private void Repaint(Band pBand, DataDoc pDoc, int row, String col, int rowcount) {
        for (DrawObject pObj : pBand.m_ObjectMap.values()) {
            if (pObj.m_ObjectType != 1 || !pObj.m_Bind.equals(col)) continue;
            if (row >= 0) {
                pObj.repaint(pDoc, row);
                continue;
            }
            int i = 0;
            while (i < rowcount) {
                pObj.repaint(pDoc, i);
                ++i;
            }
        }
    }

    public void itemChanged(int row, String col, Object oldValue, Object newValue) {
        DataDoc pDoc = this.pView.GetDoc();
        int rc = pDoc.m_pDs.getRowCount();
        this.Repaint(pDoc.m_pHeader, pDoc, row, col, rc);
        this.Repaint(pDoc.m_pFooter, pDoc, row, col, rc);
        this.Repaint(pDoc.m_pDetail, pDoc, row, col, rc);
        int i = 0;
        while (i < pDoc.m_pTrailers.Count()) {
            this.Repaint(pDoc.m_pTrailers.Item(i), pDoc, row, col, rc);
            ++i;
        }
    }

    public void computerChanged(int row, String computer) {
        this.itemChanged(row, computer, null, null);
    }

    public void afterDeleteRow(int row) {
        super.afterDeleteRow(row);
        if (this.pView.GetFormStyle() == 1) {
            int oldBindRow = this.pView.GetCurrentBindRow();
            if (row == oldBindRow) {
                if (oldBindRow == this.pView.GetDoc().m_pDs.getRowCount()) {
                    --oldBindRow;
                }
                this.pView.SetCurrentBindRow(oldBindRow);
            }
        } else {
            HashMap map = this.pView.m_SelectedRows;
            HashMap<Integer, Object> newMap = new HashMap<Integer, Object>();
            for (Integer k : map.keySet()) {
                int kr = k;
                if (kr == row) continue;
                if (kr < row) {
                    newMap.put(k, null);
                }
                if (kr <= row) continue;
                newMap.put(new Integer(kr - 1), null);
            }
            this.pView.m_SelectedRows = newMap;
        }
        this.pView.ResetVScrollBarScrollRange();
        this.pView.repaint();
    }

    public void afterFilter(int primaryBufferRowCount, int filterBufferRowCount) {
        this.retrieveEnd(primaryBufferRowCount);
    }

    public void afterInsertRow(int row) {
        super.afterInsertRow(row);
        if (this.pView.GetFormStyle() == 2) {
            HashMap map = this.pView.m_SelectedRows;
            HashMap<Integer, Object> newMap = new HashMap<Integer, Object>();
            for (Integer k : map.keySet()) {
                int kr = k;
                if (kr < row) {
                    newMap.put(k, null);
                }
                if (kr < row) continue;
                newMap.put(new Integer(kr + 1), null);
            }
            this.pView.m_SelectedRows = newMap;
        }
        this.pView.ResetVScrollBarScrollRange();
        this.pView.repaint();
    }

    public void afterSort() {
        super.afterSort();
        this.retrieveEnd(this.pView.GetDoc().m_pDs.getRowCount());
    }

    public void sqlPreview(String sql) {
        super.sqlPreview(sql);
    }

    public boolean validate(int row) {
        return super.validate(row);
    }
}

