/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import jun.db.core.DataStore;
import jun.db.core.DataStoreListener;
import jun.db.core.ErrorInfo;
import jun.db.impl.DataStoreFactory;
import jun.df.Areas;
import jun.df.Band;
import jun.df.ConfigEditComboBox;
import jun.df.ConfigEditDateTime;
import jun.df.ConfigEditNormal;
import jun.df.ConfigEditNumeric;
import jun.df.DataView;
import jun.df.DrawObject;
import jun.df.EditStyleConfig;
import jun.df.IEdit;
import jun.df.IEdition;
import jun.df.Trailers;

public class DataDoc
implements IEdition {
    boolean m_ColumnMove = true;
    ArrayList m_ViewList = new ArrayList();
    DataStore m_pDs = null;
    Areas m_Areas = new Areas(this);
    Band m_pHeader = new Band(1, this);
    Band m_pDetail = new Band(3, this);
    Band m_pFooter = new Band(2, this);
    Trailers m_pTrailers = new Trailers(this);
    private ErrorInfo m_Error = null;
    Hashtable m_EditStyleConfig = new Hashtable();
    public boolean m_InPreview = false;
    int m_PrintScale = 100;
    int m_ViewScale = 100;
    Color m_GridLineColor = new Color(212, 208, 202);
    Color m_PaperColor = new Color(255, 255, 255);
    int m_FixedColumnCount = 0;
    String m_PrintDeviceName;
    short m_Orientation = 1;
    int m_PaperSize;
    int m_PaperWidth;
    int m_PaperHeight;
    int m_FromPage;
    int m_ToPage;
    boolean m_DirectPrint = true;
    int m_LeftMargin = 20;
    int m_TopMargin = 20;
    int m_RightMargin = 20;
    int m_BottomMargin = 20;
    boolean m_NewPageOnGroupBreak = false;
    String m_PageHeaderInfo = "";
    String m_BackgroundBmp = "";
    boolean m_ZeroVisible = true;
    int DrawObjectEditableScheme = 1;
    int leftBlank;
    Color m_BKColorOfSelectedRow = new Color(224, 228, 239);

    public DataDoc() {
        this.CreateEditStyle(1, "\u666e\u901a\u7f3a\u7701\u683c\u5f0f");
        this.CreateEditStyle(3, "\u65e5\u671f\u7f3a\u7701\u683c\u5f0f");
        this.CreateEditStyle(2, "\u5c0f\u6570\u7f3a\u7701\u683c\u5f0f");
        this.CreateEditStyle(2, "\u6574\u6570\u6570\u7f3a\u7701\u683c\u5f0f");
        ConfigEditNumeric cen = (ConfigEditNumeric)this.GetEditStyle("\u6574\u6570\u6570\u7f3a\u7701\u683c\u5f0f");
        cen.SetShowComma(false);
        cen.SetDecimalCount(0);
    }

    int GetBottomMargin() {
        return this.m_BottomMargin * 100 / this.m_PrintScale;
    }

    int GetTopMargin() {
        return this.m_TopMargin * 100 / this.m_PrintScale;
    }

    int GetRightMargin() {
        return this.m_RightMargin * 100 / this.m_PrintScale;
    }

    int GetLeftMargin() {
        return this.m_LeftMargin * 100 / this.m_PrintScale;
    }

    int DetailRowTrailerHeight(int row) {
        int ret = 0;
        if (this.m_pDs == null) {
            return 0;
        }
        Integer key = new Integer(row);
        Hashtable MapGroups = (Hashtable)this.m_pDs.getFriendlyProperty("m_MapGroups");
        if (MapGroups.containsKey(key)) {
            ArrayList pVec = (ArrayList)MapGroups.get(key);
            int ti = pVec.size() - 1;
            while (ti >= 0) {
                int k = (Integer)pVec.get(ti);
                Band pTrailer = this.m_pTrailers.Item(k);
                if (pTrailer != null) {
                    ret += pTrailer.Height(this);
                }
                --ti;
            }
        }
        return ret;
    }

    DrawObject FindFirstObject(Band pBand, int col) {
        if (col < 0) {
            return null;
        }
        if (col > this.m_Areas.Count() - 1) {
            return null;
        }
        for (DrawObject pObj : pBand.m_ObjectMap.values()) {
            if (pObj.m_StartBand != col) continue;
            return pObj;
        }
        return null;
    }

    public String GetEdition() {
        return "1.0";
    }

    void AddView(DataView view) {
        if (view == null) {
            return;
        }
        int i = 0;
        while (i < this.m_ViewList.size()) {
            if (view.equals((DataView)this.m_ViewList.get(i))) {
                return;
            }
            ++i;
        }
        this.m_ViewList.add(view);
        if (this.m_pDs != null) {
            this.m_pDs.getEvent().addDataStoreEventListener((DataStoreListener)view.m_DSA, -100, "");
            this.m_pDs.getEvent().fireRetrieveEnd(this.m_pDs.getRowCount());
        }
    }

    void SetDataStore(DataStore ds) {
        this.m_pDs = ds;
        if (ds == null) {
            return;
        }
        int i = 0;
        while (i < this.m_ViewList.size()) {
            DataView pView = (DataView)this.m_ViewList.get(i);
            this.m_pDs.getEvent().addDataStoreEventListener((DataStoreListener)pView.m_DSA, -100, "");
            ++i;
        }
        int rc = this.m_pDs.getRowCount();
        int i2 = 0;
        while (i2 < this.m_ViewList.size()) {
            DataView view = (DataView)this.m_ViewList.get(i2);
            view.m_DSA.retrieveEnd(rc);
            ++i2;
        }
    }

    ErrorInfo Error() {
        if (this.m_pDs != null) {
            return this.m_pDs.getError();
        }
        if (this.m_Error == null) {
            this.m_Error = DataStoreFactory.newErrorInfo();
        }
        return this.m_Error;
    }

    boolean IsValidEditType(int et) {
        if (et < 0 || et > 5) {
            this.Error().parseError("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
            return false;
        }
        return true;
    }

    boolean IsValidEditStyle(String name) {
        if (this.m_EditStyleConfig.containsKey(name = name.trim().toLowerCase())) {
            return true;
        }
        this.Error().parseError(String.valueOf(name) + "\u4e0d\u5b58\u5728");
        return false;
    }

    boolean CreateEditStyle(int et, String name) {
        this.Error().clear();
        if (!this.IsValidEditType(et)) {
            return false;
        }
        if (this.IsValidEditStyle(name = name.trim().toLowerCase())) {
            return false;
        }
        EditStyleConfig esc = new EditStyleConfig(et);
        esc.m_Name = name;
        this.m_EditStyleConfig.put(name, esc);
        return true;
    }

    IEdit GetEditStyle(String name) {
        this.Error().clear();
        name = name.trim().toLowerCase();
        if (!this.m_EditStyleConfig.containsKey(name)) {
            this.Error().parseError(String.valueOf(name) + "\u4e0d\u5b58\u5728");
            return null;
        }
        EditStyleConfig esc = (EditStyleConfig)this.m_EditStyleConfig.get(name);
        switch (esc.m_Type) {
            case 1: {
                ConfigEditNormal en = new ConfigEditNormal();
                en.m_esc = esc;
                return en;
            }
            case 3: {
                ConfigEditDateTime ed = new ConfigEditDateTime();
                ed.m_esc = esc;
                return ed;
            }
            case 2: {
                ConfigEditNumeric enu = new ConfigEditNumeric();
                enu.m_esc = esc;
                return enu;
            }
            case 4: {
                ConfigEditComboBox ecb = new ConfigEditComboBox();
                ecb.m_esc = esc;
                return ecb;
            }
        }
        return null;
    }

    public int GetDrawObjectEditableScheme() {
        return this.DrawObjectEditableScheme;
    }

    public void SetDrawObjectEditableScheme(int drawObjectEditableScheme) {
        this.DrawObjectEditableScheme = drawObjectEditableScheme;
    }
}

