/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import jun.df.EditStyleConfig;
import jun.df.IEditComboBox;

public class ConfigEditComboBox
implements IEditComboBox {
    EditStyleConfig m_esc = null;
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    static final String SET_NULL = "";

    public int GetType() {
        return this.m_esc.m_Type;
    }

    public String GetName() {
        return this.m_esc.m_Name;
    }

    public boolean GetAutoSelect() {
        return this.m_esc.m_AutoSelect;
    }

    public void SetAutoSelect(boolean b) {
        this.m_esc.m_AutoSelect = b;
    }

    private void EnsumeMapValid() {
        if (this.m_esc.m_Data2Show == null) {
            this.m_esc.m_Data2Show = new Hashtable();
        }
        if (this.m_esc.m_Show2Data == null) {
            this.m_esc.m_Show2Data = new Hashtable();
        }
        this.m_esc.m_Data2Show.put(SET_NULL, SET_NULL);
        this.m_esc.m_Show2Data.put(SET_NULL, SET_NULL);
    }

    public boolean GetEditAble() {
        return this.m_esc.m_Editable;
    }

    public void SetEditAble(boolean editable) {
        this.m_esc.m_Editable = editable;
    }

    public int GetListHeight() {
        return this.m_esc.m_ListHeight;
    }

    public void SetListHight(int h) {
        this.m_esc.m_ListHeight = h;
    }

    public int Size() {
        this.EnsumeMapValid();
        return this.m_esc.m_Data2Show.size();
    }

    public boolean Add(String data, String show) {
        if (show == null) {
            return false;
        }
        if (show.equals(SET_NULL)) {
            return false;
        }
        this.EnsumeMapValid();
        this.m_esc.m_Data2Show.put(data, show);
        this.m_esc.m_Show2Data.put(show, data);
        return true;
    }

    public boolean Add(long data, String show) {
        return this.Add(String.valueOf(data), show);
    }

    public boolean Add(double data, String show) {
        return this.Add(String.valueOf(data), show);
    }

    public boolean Add(Date data, String show) {
        return this.Add(sdf.format(data), show);
    }

    public boolean Add(Timestamp data, String show) {
        return this.Add(sdf.format(data), show);
    }

    public boolean Add(Time data, String show) {
        return this.Add(sdf.format(data), show);
    }

    public boolean Add(Object data, String show) {
        if (data == null) {
            return this.Add(SET_NULL, show);
        }
        return this.Add(data.toString(), show);
    }

    public boolean Remove(String data) {
        this.EnsumeMapValid();
        String key = data.toString();
        if (!this.m_esc.m_Data2Show.containsKey(key)) {
            return false;
        }
        String show = (String)this.m_esc.m_Data2Show.get(key);
        this.m_esc.m_Data2Show.remove(key);
        this.m_esc.m_Show2Data.remove(show);
        return true;
    }

    public boolean Remove(long data) {
        return this.Remove(String.valueOf(data));
    }

    public boolean Remove(double data) {
        return this.Remove(String.valueOf(data));
    }

    public boolean Remove(Date data) {
        return this.Remove(sdf.format(data));
    }

    public boolean Remove(Timestamp data) {
        return this.Remove(sdf.format(data));
    }

    public boolean Remove(Time data) {
        return this.Remove(sdf.format(data));
    }

    public void Clear() {
        this.EnsumeMapValid();
        this.m_esc.m_Data2Show.clear();
        this.m_esc.m_Show2Data.clear();
        this.m_esc.m_Data2Show.put(null, SET_NULL);
        this.m_esc.m_Show2Data.put(SET_NULL, null);
    }

    private String GetShowString_(Object data) {
        this.EnsumeMapValid();
        if (this.m_esc.m_Data2Show.containsKey(data)) {
            return (String)this.m_esc.m_Data2Show.get(data);
        }
        if (data == null) {
            return SET_NULL;
        }
        return data.toString();
    }

    public String GetShowString(String data) {
        return this.GetShowString_(data);
    }

    public String GetShowString(long data) {
        return this.GetShowString_(new Long(data));
    }

    public String GetShowString(double data) {
        return this.GetShowString_(new Double(data));
    }

    public String GetShowString(Date data) {
        return this.GetShowString_(sdf.format(data));
    }

    public String GetShowString(Timestamp data) {
        return this.GetShowString_(sdf.format(data));
    }

    public String GetShowString(Time data) {
        return this.GetShowString_(sdf.format(data));
    }

    public String GetShowString(Object data) {
        return this.GetShowString_(data.toString());
    }

    public Object Show2Data(String show) {
        return this.Show2Data(show, false);
    }

    public Object Show2Data(String show, boolean acceptAnyValue) {
        if (show.equals(SET_NULL)) {
            return null;
        }
        if (!this.m_esc.m_Show2Data.containsKey(show)) {
            return acceptAnyValue ? show : null;
        }
        return this.m_esc.m_Show2Data.get(show);
    }
}

