/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import jun.df.DataDoc;
import jun.df.DataView;
import jun.df.DrawObject;
import jun.df.IEdition;

public class Band
implements IEdition {
    public static final int _Header_ = 1;
    public static final int _Footer_ = 2;
    public static final int _Detail_ = 3;
    public static final int _Trailer_ = 4;
    DataDoc m_pDoc = null;
    private int m_Height = 20;
    String mf_Height = "";
    Hashtable m_ObjectMap = new Hashtable();
    ArrayList m_ObjectVector = new ArrayList();
    private int m_Name;
    private int m_TrailerNo;

    public Band(int name, DataDoc doc) {
        this.m_Name = name;
        this.m_TrailerNo = -1;
        this.m_pDoc = doc;
    }

    public Band(int name, int tn, DataDoc doc) {
        this.m_Name = name;
        this.m_TrailerNo = tn;
        this.m_pDoc = doc;
    }

    public int GetName() {
        return this.m_Name;
    }

    public int GetTrailerNo() {
        return this.m_TrailerNo;
    }

    public String GetEdition() {
        return "1.0";
    }

    public int Height(DataDoc pDoc, int row) {
        if (pDoc.m_pDs == null) {
            return this.m_Height;
        }
        if (row >= 0 && pDoc.m_pDs.getRowCount() > 0 && !this.mf_Height.trim().equals("")) {
            Object v = DrawObject.GetValue(pDoc, row, this.mf_Height);
            this.m_Height = Integer.parseInt(v.toString());
            return this.m_Height;
        }
        return this.m_Height;
    }

    public int Height() {
        return this.Height(this.m_pDoc, -1);
    }

    public int Height(DataDoc pDoc) {
        return this.Height(pDoc, -1);
    }

    public int Count() {
        return this.m_ObjectMap.size();
    }

    public DrawObject Item(String name) {
        if (!this.m_ObjectMap.containsKey(name = name.trim().toLowerCase())) {
            return null;
        }
        return (DrawObject)this.m_ObjectMap.get(name);
    }

    public DrawObject Item(int index) {
        if (index < 0 || index > this.Count() - 1) {
            return null;
        }
        Object v = null;
        Iterator ki = this.m_ObjectMap.keySet().iterator();
        v = ki.next();
        int i = 0;
        while (i < index) {
            v = ki.next();
            ++i;
        }
        return (DrawObject)this.m_ObjectMap.get(v);
    }

    private DrawObject AddObject(String name, int startBand, int endBand, int x, int y, int width, int height) {
        if (this.m_ObjectMap.containsKey(name = name.trim().toLowerCase())) {
            System.out.println("\u8be5\u540d\u79f0\u7684\u5bf9\u8c61\u5df2\u7ecf\u5b58\u5728");
            return null;
        }
        DrawObject pObject = new DrawObject(this);
        pObject.m_Name = name;
        pObject.m_StartBand = startBand;
        pObject.m_EndBand = endBand;
        pObject.m_X = x;
        pObject.m_Y = y;
        pObject.m_Width = width;
        pObject.m_Height = height;
        this.m_ObjectMap.put(name, pObject);
        this.m_ObjectVector.add(name);
        return pObject;
    }

    public DrawObject AddValue(String name, int startBand, int endBand, Object value, int x, int y, int width, int height) {
        DrawObject pObj = this.AddObject(name, startBand, endBand, x, y, width, height);
        if (pObj != null) {
            pObj.m_ObjectType = 0;
            pObj.SetValue(value);
        }
        return pObj;
    }

    public DrawObject AddBind(String name, int startBand, int endBand, String bind, int x, int y, int width, int height) {
        DrawObject pObj = this.AddObject(name, startBand, endBand, x, y, width, height);
        if (pObj != null) {
            pObj.m_ObjectType = 1;
            pObj.SetBind(bind);
        }
        return pObj;
    }

    public DrawObject AddLine(String name, int startBand, int endBand, int x, int y, int width, int height) {
        DrawObject pObj = this.AddObject(name, startBand, endBand, x, y, width, height);
        if (pObj != null) {
            pObj.m_ObjectType = 3;
        }
        return pObj;
    }

    public DrawObject AddImage(String name, int startBand, int endBand, String bmpFile, int x, int y, int width, int height) {
        DrawObject pObj = this.AddObject(name, startBand, endBand, x, y, width, height);
        if (pObj != null) {
            pObj.m_ObjectType = 4;
            pObj.SetImageURL(bmpFile);
        }
        return pObj;
    }

    public void SetHeight(int h) {
        this.m_Height = h;
    }

    public boolean DeleteObject(String name) {
        if (!this.m_ObjectMap.containsKey(name = name.trim().toLowerCase())) {
            return false;
        }
        this.m_ObjectMap.remove(name);
        this.m_ObjectVector.remove(name);
        return true;
    }

    public void PushLeft(int n) {
        for (Object key : this.m_ObjectMap.keySet()) {
            DrawObject pObj = (DrawObject)this.m_ObjectMap.get(key);
            if (pObj.m_StartBand >= n) {
                --pObj.m_StartBand;
            }
            if (pObj.m_EndBand < n || pObj.m_EndBand == 0) continue;
            --pObj.m_EndBand;
        }
    }

    public void PushRight(int n) {
        for (Object key : this.m_ObjectMap.keySet()) {
            DrawObject pObj = (DrawObject)this.m_ObjectMap.get(key);
            if (pObj.m_StartBand >= n) {
                ++pObj.m_StartBand;
            }
            if (pObj.m_EndBand < n || pObj.m_EndBand == 0) continue;
            ++pObj.m_EndBand;
        }
    }

    public void DeleteObjectInArea(int n) {
        ArrayList DelVector = new ArrayList();
        for (Object key : this.m_ObjectMap.keySet()) {
            DrawObject pObj = (DrawObject)this.m_ObjectMap.get(key);
            if (pObj.m_StartBand != n || pObj.m_EndBand != n && pObj.m_EndBand != 0) continue;
            DelVector.add(key);
        }
        int i = 0;
        while (i < DelVector.size()) {
            Object obj = DelVector.get(i);
            this.m_ObjectMap.remove(obj);
            this.m_ObjectVector.remove(obj);
            ++i;
        }
    }

    public void Clear() {
        this.m_ObjectMap.clear();
        this.m_ObjectVector.clear();
    }

    public void BringToTop(String name) {
        if (!this.m_ObjectMap.containsKey(name = name.trim().toLowerCase())) {
            System.out.println("\u8be5\u540d\u79f0\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728");
            return;
        }
        this.m_ObjectVector.remove(name);
        this.m_ObjectVector.add(name);
    }

    public void SendToBottom(String name) {
        if (!this.m_ObjectMap.containsKey(name = name.trim().toLowerCase())) {
            System.out.println("\u8be5\u540d\u79f0\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728");
            return;
        }
        this.m_ObjectVector.remove(name);
        this.m_ObjectVector.add(0, name);
    }

    public DrawObject PriorFocusReceiver(DataView pView, DrawObject relativeObj) {
        Rectangle rc = null;
        if (relativeObj == null) {
            return null;
        }
        if (relativeObj != null) {
            rc = relativeObj.GetBounds(pView, pView.GetCurrentBindRow());
        }
        DrawObject retObj = null;
        Rectangle rc0 = new Rectangle(0, 0, 0, 0);
        int k = 1000000;
        Iterator vi = this.m_ObjectVector.iterator();
        while (vi.hasNext()) {
            DrawObject pObj = this.Item((String)vi.next());
            if (!pObj.GetEditable(pView.GetDoc(), pView.GetCurrentBindRow())) continue;
            Rectangle rc2 = pObj.GetBounds(pView, pView.GetCurrentBindRow());
            if (rc2.x + rc2.y * k >= rc.x + rc.y * k || rc2.x + rc2.y * k <= rc0.x + rc0.y * k) continue;
            rc0 = (Rectangle)rc2.clone();
            retObj = pObj;
        }
        return retObj;
    }

    public DrawObject NextFocusReceiver(DataView pView, DrawObject relativeObj) {
        Rectangle rc = null;
        if (relativeObj == null) {
            return null;
        }
        if (relativeObj != null) {
            rc = relativeObj.GetBounds(pView, pView.GetCurrentBindRow());
        }
        DrawObject retObj = null;
        Rectangle rc0 = new Rectangle(99999, 99999, 0, 0);
        int k = 1000000;
        Iterator vi = this.m_ObjectVector.iterator();
        while (vi.hasNext()) {
            DrawObject pObj = this.Item((String)vi.next());
            if (!pObj.GetEditable(pView.GetDoc(), pView.GetCurrentBindRow())) continue;
            Rectangle rc2 = pObj.GetBounds(pView, pView.GetCurrentBindRow());
            if (rc2.x + rc2.y * k <= rc.x + rc.y * k || rc2.x + rc2.y * k >= rc0.x + rc0.y * k) continue;
            rc0 = (Rectangle)rc2.clone();
            retObj = pObj;
        }
        return retObj;
    }
}

