/*
 * Decompiled with CFR 0.152.
 */
package jun.df;

import java.util.ArrayList;
import jun.df.DataDoc;
import jun.df.IAreasListener;
import jun.df.IEdition;

public class Areas
implements IEdition {
    private ArrayList m_Listener = new ArrayList();
    private ArrayList m_AreaWidth = new ArrayList();
    private DataDoc m_pDoc = null;

    public String GetEdition() {
        return "1.0";
    }

    public Areas(DataDoc doc) {
        this.m_pDoc = doc;
    }

    public Areas(DataDoc doc, int n) {
        this.m_pDoc = doc;
        int i = 0;
        while (i < n) {
            this.m_AreaWidth.add(new Integer(800));
            ++i;
        }
    }

    public void AddArea(int w) {
        this.m_AreaWidth.add(new Integer(w));
        this.FireAreasCountChanged();
    }

    public void InsertArea(int before) {
        if (before < 0) {
            before = 0;
        }
        if (before >= this.Count()) {
            this.AddArea(80);
        } else {
            this.m_AreaWidth.add(before, new Integer(80));
            this.m_pDoc.m_pHeader.PushRight(before);
            this.m_pDoc.m_pDetail.PushRight(before);
            this.m_pDoc.m_pFooter.PushRight(before);
            int i = 0;
            while (i < this.m_pDoc.m_pTrailers.Count()) {
                this.m_pDoc.m_pTrailers.Item(i).PushRight(before);
                ++i;
            }
            this.FireAreasCountChanged();
        }
    }

    public void DeleteArea(int index) {
        if (index < 0) {
            return;
        }
        if (index >= this.Count()) {
            return;
        }
        this.m_AreaWidth.remove(index);
        this.m_pDoc.m_pHeader.DeleteObjectInArea(index);
        this.m_pDoc.m_pDetail.DeleteObjectInArea(index);
        this.m_pDoc.m_pFooter.DeleteObjectInArea(index);
        int i = 0;
        while (i < this.m_pDoc.m_pTrailers.Count()) {
            this.m_pDoc.m_pTrailers.Item(i).DeleteObjectInArea(index);
            ++i;
        }
        this.m_pDoc.m_pHeader.PushLeft(index + 1);
        this.m_pDoc.m_pDetail.PushLeft(index + 1);
        this.m_pDoc.m_pFooter.PushLeft(index + 1);
        i = 0;
        while (i < this.m_pDoc.m_pTrailers.Count()) {
            this.m_pDoc.m_pTrailers.Item(i).PushLeft(index + 1);
            ++i;
        }
        this.FireAreasCountChanged();
    }

    public void SetAreaWidth(int index, int w) {
        if (index < 0 || index > this.Count() - 1) {
            return;
        }
        this.m_AreaWidth.set(index, new Integer(w));
        this.FireAreaWidthChanged(index);
    }

    public int FixedAreaWidth(int fixedCount) {
        int ret = 0;
        int i = 0;
        while (i < Math.min(fixedCount, this.Count())) {
            ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
            ++i;
        }
        return ret;
    }

    public int AreaLeft(int leftMargin, int index, int fixedCount, int firstViewIndex) {
        int ret = Math.max(leftMargin, 0);
        if (index < 0 || index > this.Count() - 1) {
            return 0;
        }
        if (index < fixedCount) {
            int i = 0;
            while (i < index) {
                ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
                ++i;
            }
        } else {
            int i = 0;
            while (i < fixedCount) {
                ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
                ++i;
            }
            i = Math.max(firstViewIndex, 0);
            while (i < index) {
                ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
                ++i;
            }
        }
        return ret;
    }

    public int AreaRight(int leftMargin, int index, int fixedCount, int firstViewIndex) {
        if (index < 0 || index > this.Count() - 1) {
            return 0;
        }
        int ret = Math.max(leftMargin, 0);
        if (index < fixedCount) {
            int i = 0;
            while (i <= index) {
                ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
                ++i;
            }
        } else {
            int i = 0;
            while (i < fixedCount) {
                ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
                ++i;
            }
            i = Math.max(firstViewIndex, 0);
            while (i <= index) {
                ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
                ++i;
            }
        }
        return ret;
    }

    public int AreaWidth(int index) {
        if (index < 0 || index > this.Count() - 1) {
            return 0;
        }
        return (Integer)this.m_AreaWidth.get(index);
    }

    public int Count() {
        return this.m_AreaWidth.size();
    }

    public void AddListener(IAreasListener listener) {
        int c = this.Count();
        int i = 0;
        while (i < this.m_Listener.size()) {
            IAreasListener al = (IAreasListener)this.m_Listener.get(i);
            if (listener == al) {
                return;
            }
            ++i;
        }
        this.m_Listener.add(listener);
    }

    private void FireAreasCountChanged() {
        int c = this.Count();
        int i = 0;
        while (i < this.m_Listener.size()) {
            IAreasListener listener = (IAreasListener)this.m_Listener.get(i);
            listener.AreasCountChanged(c);
            ++i;
        }
    }

    private void FireAreaWidthChanged(int areaNo) {
        int c = this.Count();
        int i = 0;
        while (i < this.m_Listener.size()) {
            IAreasListener listener = (IAreasListener)this.m_Listener.get(i);
            listener.AreaWidthChanged(areaNo);
            ++i;
        }
    }

    public int AllAreaWidth() {
        return this.SomeAreaWidth(this.Count() - 1);
    }

    public int SomeAreaWidth(int toIndex) {
        int ret = 0;
        int i = 0;
        while (i < Math.min(this.Count(), toIndex + 1)) {
            ret += ((Integer)this.m_AreaWidth.get(i)).intValue();
            ++i;
        }
        return ret;
    }
}

