/*
 * Decompiled with CFR 0.152.
 */
package wiseoa.appletupload;

import appletrpc.RPC;
import appletrpc.RPCParameter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JOptionPane;
import wiseoa.appletupload.FastUpload;

public class FastUploadThread
extends Thread {
    String fileName;
    boolean OnInternat;
    FastUpload applet;
    String ToPath;
    String Tip;
    String reName;
    int UserID;
    int subjectID;
    int needCheckType;
    int needCheckSize;

    public FastUploadThread(FastUpload ca, String f, String topath, boolean isOnInternat, String rename, int subjectID_, int needCheckType_, int needCheckSize_, int userid) {
        this.fileName = f;
        this.OnInternat = isOnInternat;
        this.applet = ca;
        this.ToPath = topath;
        this.reName = rename;
        this.subjectID = subjectID_;
        this.needCheckType = needCheckType_;
        this.needCheckSize = needCheckSize_;
        this.UserID = userid;
    }

    public void run() {
        File theFile = new File(this.fileName);
        RPCParameter rp = new RPCParameter();
        rp.put("filename", this.reName);
        rp.put("topath", this.ToPath);
        rp.put("filesize", theFile.length());
        rp.put("subjectid", this.subjectID);
        rp.put("needchecktype", this.needCheckType);
        rp.put("needchecksize", this.needCheckSize);
        rp.put("userid", this.UserID);
        String newFileName = this.reName;
        long IgnoreSize = 0L;
        rp = RPC.Call(String.valueOf(this.applet.HomeURL) + "servlet/IM.server.FileConfirm", "FileQuery", rp);
        if (!rp.Success) {
            String info = rp.ErrorText;
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this.applet), info, "\u63d0\u793a", 2);
            return;
        }
        if (rp.get("exist", true)) {
            int result = JOptionPane.showConfirmDialog(JOptionPane.getFrameForComponent(this.applet), "\u5728\u8be5\u76ee\u5f55\u4e2d\u5df2\u7ecf\u5b58\u5728\u540d\u79f0\u4e3a[" + this.reName + "]\u7684\u6587\u4ef6" + "\n\u63a5\u7740\u7eed\u4f20\u8bf7\u70b9\u51fb[\u662f] \uff0c\n\u8986\u76d6\u6587\u4ef6\u8bf7\u70b9\u51fb[\u5426]\uff0c\n\u7ed3\u675f\u64cd\u4f5c\u8bf7\u70b9\u51fb[\u64a4\u6d88]", "\u63d0\u793a", 1);
            if (result == 2) {
                return;
            }
            if (result == 1) {
                this.Tip = "\u4e0a\u4f20\u6587\u4ef6";
            }
            if (result == 0) {
                this.Tip = "\u7eed\u4f20\u6587\u4ef6";
                IgnoreSize = rp.get("filesize", 0);
            }
        } else {
            this.Tip = "\u4e0a\u4f20\u6587\u4ef6";
            IgnoreSize = 0L;
        }
        long fileSize = theFile.length();
        this.applet.UploadStart();
        try {
            try {
                FastUploadThread.sleep(1000L);
                FileInputStream fis = new FileInputStream(theFile);
                boolean readOver = false;
                long hadRead = 0L;
                Date startTime = new Date();
                long timeCost = 0L;
                fis.skip(IgnoreSize);
                while (!readOver) {
                    String servletURL = String.valueOf(this.applet.HomeURL) + "servlet/wiseoa.UploadToMyFolder?topath=" + URLEncoder.encode(this.ToPath, "UTF-8") + "&name=" + URLEncoder.encode(newFileName, "UTF-8");
                    URL url = new URL(servletURL);
                    System.out.println(this.ToPath);
                    System.out.println(servletURL);
                    System.out.println(newFileName);
                    URLConnection urlcon = url.openConnection();
                    urlcon.setRequestProperty("Content-Type", "application/octet-stream");
                    urlcon.setDoOutput(true);
                    urlcon.setUseCaches(false);
                    GZIPOutputStream gos = new GZIPOutputStream(urlcon.getOutputStream());
                    BufferedOutputStream bos = new BufferedOutputStream(gos);
                    int once = this.applet.FileBlockSize;
                    byte[] buffer = new byte[once];
                    int actually = 0;
                    int readTimes = 0;
                    timeCost = (new Date().getTime() - startTime.getTime()) / 1000L;
                    if (timeCost <= 0L) {
                        timeCost = 1L;
                    }
                    String speed = String.valueOf(FastUploadThread.FileSize(hadRead / timeCost)) + "/s";
                    actually = fis.read(buffer);
                    if (actually <= 0) {
                        readOver = true;
                        break;
                    }
                    ++readTimes;
                    int percent = (int)(((hadRead += (long)actually) + IgnoreSize) * 100L / fileSize);
                    this.applet.SetTipInfo("\u5b8c\u6210\u4e86" + String.valueOf(percent) + "%\uff0c\u901f\u5ea6\u662f" + speed);
                    FastUploadThread.sleep(1L);
                    bos.write(buffer, 0, actually);
                    bos.flush();
                    bos.close();
                    gos.close();
                    GZIPInputStream gs = new GZIPInputStream(urlcon.getInputStream());
                    ObjectInputStream p = new ObjectInputStream(new BufferedInputStream(gs));
                    RPCParameter ret = (RPCParameter)p.readObject();
                    p.close();
                }
                fis.close();
                this.applet.SetTipInfo("\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6210");
                FastUploadThread.sleep(1000L);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                this.applet.UploadEnd();
            }
        }
        finally {
            this.applet.UploadEnd();
        }
    }

    public static String FileSize(double fl) {
        DecimalFormat df = new DecimalFormat("###,###,###.0");
        String size = fl < 1024.0 ? "1KB" : (fl < 1048576.0 ? String.valueOf(df.format(fl / 1024.0)) + "KB" : String.valueOf(df.format(fl / 1048576.0)) + "MB");
        return size;
    }
}

