/*
 * Decompiled with CFR 0.152.
 */
package jun.control.grid;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class Grid
extends JPanel
implements ComponentListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
AdjustmentListener {
    private Dimension dMinimum;
    private Font fFont;
    private FontMetrics fMetrics;
    private Graphics gImage;
    private Image iImage;
    private int iWidth;
    private int iHeight;
    private int iRowHeight;
    private int iFirstRow;
    private int iGridWidth;
    private int iGridHeight;
    private int iX;
    private int iY;
    private boolean autoColumnWidth = false;
    private String[] sColHead;
    private Vector vData;
    private Vector vState;
    private int[] iColWidth;
    private int iColCount;
    private int iRowCount;
    private HashMap colMap = new HashMap();
    private Color LineColor = new Color(213, 204, 176);
    private Color TitleBkColor = new Color(235, 234, 219);
    private Scrollbar sbHoriz;
    private Scrollbar sbVert;
    private int iSbWidth;
    private int iSbHeight;
    private boolean bDrag;
    private int iXDrag;
    private int iColDrag;
    private Method f_BeginEdit = null;

    public Grid() {
        this.fFont = new Font("Dialog", 0, 12);
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.sbHoriz.addAdjustmentListener(this);
        this.sbVert.addAdjustmentListener(this);
        this.setBorder(BorderFactory.createLoweredBevelBorder());
    }

    String[] getHead() {
        return this.sColHead;
    }

    Vector getData() {
        return this.vData;
    }

    @Override
    public void setMinimumSize(Dimension d) {
        this.dMinimum = d;
    }

    public void Reset() {
        this.vData = new Vector();
        this.vState = new Vector();
        this.iRowCount = 0;
        this.adjustScroll();
        this.repaint();
    }

    public void setHead(String[] head) {
        this.vData = new Vector();
        this.vState = new Vector();
        this.iColCount = head.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        int i = 0;
        while (i < this.iColCount) {
            this.sColHead[i] = head[i];
            this.iColWidth[i] = 100;
            ++i;
        }
        this.iRowCount = 0;
        this.iRowHeight = 19;
        this.adjustScroll();
        this.repaint();
    }

    public void addRow(String p1) {
        this.addRow(p1, null, null, null, null, null, null, null, null, null);
    }

    public void addRow(String p1, String p2) {
        this.addRow(p1, p2, null, null, null, null, null, null, null, null);
    }

    public void addRow(String p1, String p2, String p3) {
        this.addRow(p1, p2, p3, null, null, null, null, null, null, null);
    }

    public void addRow(String p1, String p2, String p3, String p4) {
        this.addRow(p1, p2, p3, p4, null, null, null, null, null, null);
    }

    public void addRow(String p1, String p2, String p3, String p4, String p5) {
        this.addRow(p1, p2, p3, p4, p5, null, null, null, null, null);
    }

    public void addRow(String p1, String p2, String p3, String p4, String p5, String p6) {
        this.addRow(p1, p2, p3, p4, p5, p6, null, null, null, null);
    }

    public void addRow(String p1, String p2, String p3, String p4, String p5, String p6, String p7) {
        this.addRow(p1, p2, p3, p4, p5, p6, p7, null, null, null);
    }

    public void addRow(String p1, String p2, String p3, String p4, String p5, String p6, String p7, String p8) {
        this.addRow(p1, p2, p3, p4, p5, p6, p7, p8, null, null);
    }

    public void addRow(String p1, String p2, String p3, String p4, String p5, String p6, String p7, String p8, String p9) {
        this.addRow(p1, p2, p3, p4, p5, p6, p7, p8, p9, null);
    }

    public void addRow(String p1, String p2, String p3, String p4, String p5, String p6, String p7, String p8, String p9, String p10) {
        this.addRowData(new String[]{p1, p2, p3, p4, p5, p6, p7, p8, p9, p10});
    }

    public void addRowData(String[] parms) {
        String[] data = new String[parms.length];
        int i = 0;
        int k = 0;
        while (i < parms.length) {
            String s = parms[k];
            if (s != null) {
                data[i] = s;
                ++i;
            }
            ++k;
        }
        String[] row = new String[Math.max(data.length, this.iColCount)];
        i = 0;
        while (i < data.length) {
            row[i] = data[i];
            ++i;
        }
        i = data.length;
        while (i < row.length) {
            row[i] = "";
            ++i;
        }
        this.vData.addElement(row);
        this.vState.add(new Boolean(false));
        ++this.iRowCount;
        this.adjustScroll();
        this.repaint();
    }

    public int insertRow(int beforeRow) {
        int ret;
        String[] s = new String[this.iColCount];
        int i = 0;
        while (i < this.iColCount) {
            s[i] = "";
            ++i;
        }
        if (beforeRow < 0) {
            beforeRow = 0;
        }
        if (beforeRow >= this.iRowCount) {
            this.addRowData(s);
            ret = this.iRowCount - 1;
        } else {
            this.vData.add(beforeRow, s);
            this.vState.add(beforeRow, new Boolean(false));
            ret = beforeRow;
            ++this.iRowCount;
            this.adjustScroll();
        }
        this.repaint();
        return ret;
    }

    public void deleteRow(int row) {
        if (row < 0) {
            return;
        }
        if (row >= this.iRowCount) {
            return;
        }
        this.vData.remove(row);
        this.vState.remove(row);
        --this.iRowCount;
        this.adjustScroll();
        this.repaint();
    }

    public void SelectRow(int row, boolean b) {
        if (row >= this.iRowCount) {
            return;
        }
        if (row < 0) {
            int i = 0;
            while (i < this.iRowCount) {
                this.vState.set(i, new Boolean(b));
                ++i;
            }
        } else {
            this.vState.set(row, new Boolean(b));
        }
        this.repaint();
    }

    public int getSelectedRow(int afterRow) {
        int i = Math.max(afterRow + 1, 0);
        while (i < this.iRowCount) {
            Boolean b = (Boolean)this.vState.get(i);
            if (b.booleanValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isRowSelected(int row) {
        if (row < 0 || row >= this.iRowCount) {
            return false;
        }
        return (Boolean)this.vState.get(row);
    }

    public String getDisplayText(int row, int col) {
        return this.getDisplay(col, row);
    }

    public String getText(int row, int col) {
        if (row < 0) {
            return "";
        }
        if (col < 0) {
            return "";
        }
        if (row >= this.iRowCount) {
            return "";
        }
        String[] s = (String[])this.vData.get(row);
        if (col >= s.length) {
            return "";
        }
        return s[col];
    }

    public void setText(int row, int col, String str) {
        if (row < 0) {
            return;
        }
        if (col < 0) {
            return;
        }
        if (row >= this.iRowCount) {
            return;
        }
        if (col >= this.iColCount) {
            return;
        }
        String[] s = (String[])this.vData.get(row);
        s[col] = str;
        this.vData.set(row, s);
        this.repaint();
    }

    public void update() {
        this.adjustScroll();
        this.repaint();
    }

    void adjustScroll() {
        Rectangle rc = this.getBounds();
        if (rc.width * rc.height == 0) {
            return;
        }
        int w = 0;
        int i = 0;
        while (i < this.iColCount) {
            w += this.iColWidth[i];
            ++i;
        }
        this.iGridWidth = w;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        int x = rc.x;
        int y = rc.y;
        w = rc.width;
        int h = rc.height;
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        if (this.iGridWidth <= rc.width) {
            this.iSbHeight = 0;
        }
        if (this.iGridHeight <= rc.height) {
            this.iSbWidth = 0;
        }
        this.iHeight = h - this.iSbHeight;
        this.iWidth = w - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        if (this.iGridWidth <= rc.width) {
            this.sbHoriz.setVisible(false);
            this.iX = 0;
        } else {
            this.sbHoriz.setVisible(true);
            this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth);
            this.iX = this.sbHoriz.getValue();
        }
        if (this.iGridHeight <= rc.height) {
            this.sbVert.setVisible(false);
            this.iY = 0;
        } else {
            this.sbVert.setVisible(true);
            int v = this.iY / this.iRowHeight;
            h = this.iHeight / this.iRowHeight;
            this.sbVert.setValues(v, h, 0, this.iRowCount + 1);
            this.iY = this.iRowHeight * this.sbVert.getValue();
        }
        this.iImage = null;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (g == null) {
            return;
        }
        g.setFont(this.fFont);
        this.fMetrics = g.getFontMetrics();
        if (this.autoColumnWidth) {
            int i = 0;
            while (i < this.iColCount) {
                this.calcAutoWidth(i);
                ++i;
            }
            this.adjustScroll();
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.iWidth, this.iHeight);
        g.setColor(this.TitleBkColor);
        g.fillRect(0, 0, this.iWidth, this.iRowHeight);
        int x = -this.iX;
        int i = 0;
        while (i < this.iColCount) {
            int w = this.iColWidth[i];
            int sl = this.fMetrics.stringWidth(this.sColHead[i]);
            g.setColor(new Color(245, 245, 240));
            g.drawString(this.sColHead[i], Math.max(x + 2, x + 2 + (w - sl) / 2), this.iRowHeight - 5 + 1);
            g.setColor(Color.BLACK);
            g.drawString(this.sColHead[i], Math.max(x + 2, x + 2 + (w - sl) / 2), this.iRowHeight - 5);
            g.setColor(new Color(172, 168, 153));
            g.drawLine(x + w - 1, 4, x + w - 1, this.iRowHeight - 4);
            g.setColor(Color.WHITE);
            g.drawLine(x + w, 5, x + w, this.iRowHeight - 4);
            x += w;
            ++i;
        }
        g.setColor(this.TitleBkColor);
        g.fillRect(0, 0, 1, this.iRowHeight);
        g.fillRect(x + 1, 0, this.iWidth - x, this.iRowHeight);
        g.drawLine(0, 0, 0, this.iRowHeight - 1);
        int y = this.iRowHeight + 1 - this.iY;
        int j = 0;
        while (y < this.iRowHeight + 1) {
            ++j;
            y += this.iRowHeight;
        }
        this.iFirstRow = j;
        y = this.iRowHeight + 1;
        while (y < this.iHeight && j < this.iRowCount) {
            boolean isSelected = (Boolean)this.vState.get(j);
            Color b = Color.white;
            if (isSelected) {
                b = new Color(8032156);
            }
            g.setColor(b);
            g.fillRect(0, y, this.getWidth(), this.iRowHeight - 1);
            x = -this.iX;
            int i2 = 0;
            while (i2 < this.iColCount) {
                int w = this.iColWidth[i2];
                Color t = Color.black;
                if (isSelected) {
                    t = Color.WHITE;
                }
                g.setColor(t);
                Rectangle oldClip = g.getClipBounds();
                g.setClip(x, y, w, this.iRowHeight);
                g.drawString(this.getDisplay(i2, j), x + 2, y + this.iRowHeight - 6);
                g.setClip(oldClip);
                g.setColor(this.LineColor);
                g.drawLine(x + w - 1, y, x + w - 1, y + this.iRowHeight - 1);
                g.drawLine(x, y + this.iRowHeight - 1, x + w - 1, y + this.iRowHeight - 1);
                x += w;
                ++i2;
            }
            g.setColor(Color.WHITE);
            g.fillRect(x, y, this.iWidth - x, this.iRowHeight - 1);
            ++j;
            y += this.iRowHeight;
        }
        g.setColor(new Color(226, 222, 205));
        g.drawLine(0, this.iRowHeight - 2, this.iWidth, this.iRowHeight - 2);
        g.setColor(new Color(214, 210, 194));
        g.drawLine(0, this.iRowHeight - 1, this.iWidth, this.iRowHeight - 1);
        g.setColor(new Color(203, 199, 184));
        g.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        g.setColor(SystemColor.control);
        g.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        Rectangle rc = this.getBounds();
        g.setColor(this.LineColor);
        g.drawRect(0, 0, rc.width - 1, rc.height - 1);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public Dimension preferredSize() {
        return this.minimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.minimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    @Override
    public Dimension minimumSize() {
        return this.dMinimum;
    }

    private void calcAutoWidth(int i) {
        int w = 10;
        w = Math.max(w, this.fMetrics.stringWidth(this.sColHead[i]));
        int j = 0;
        while (j < this.iRowCount) {
            String[] s = (String[])this.vData.elementAt(j);
            w = Math.max(w, this.fMetrics.stringWidth(s[i]));
            ++j;
        }
        this.iColWidth[i] = w + 6;
    }

    private String getDisplay(int x, int y) {
        String ret = ((String[])this.vData.elementAt(y))[x];
        if (ret == null) {
            return "";
        }
        Integer key = new Integer(x);
        if (this.colMap.containsKey(key)) {
            try {
                Map map = (Map)this.colMap.get(key);
                if (map.containsKey(ret)) {
                    return map.get(ret).toString();
                }
            }
            catch (Exception e) {
                return ret;
            }
        }
        return ret;
    }

    private static int getMaxHeight(FontMetrics f) {
        return f.getHeight() + 4;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.adjustScroll();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.getRowAtPoint(e.getX(), e.getY());
        int col = this.getColumnAtPoint(e.getX(), e.getY());
        Rectangle rc = this.getEditRectangle(e.getX(), e.getY());
        if (row >= 0 && col >= 0) {
            this.OnBeginEdit(row, col, rc);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private int getRowAtPoint(int x, int y) {
        if (this.iRowHeight == 0) {
            return -1;
        }
        if (y < this.iRowHeight) {
            return -1;
        }
        int row = this.iFirstRow + (y - this.iRowHeight) / this.iRowHeight;
        if (row >= this.iRowCount) {
            return -1;
        }
        return row;
    }

    private int getColumnAtPoint(int x, int y) {
        x += this.iX;
        int w = 0;
        int i = 0;
        while (i < this.iColCount) {
            if (x < (w += this.iColWidth[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Rectangle getEditRectangle(int x, int y) {
        Rectangle rc = null;
        int row = this.getRowAtPoint(x, y);
        if (row < 0) {
            return null;
        }
        int col = this.getColumnAtPoint(x, y);
        if (col < 0) {
            return null;
        }
        rc = new Rectangle();
        rc.y = this.iRowHeight + (row - this.iFirstRow) * this.iRowHeight;
        rc.height = this.iRowHeight;
        int w = 0;
        int i = 0;
        while (i < col) {
            w += this.iColWidth[i];
            ++i;
        }
        rc.x = w - this.iX - 1;
        rc.width = this.iColWidth[col];
        return rc;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int row = this.getRowAtPoint(e.getX(), e.getY());
        if (row >= 0 && row < this.iRowCount) {
            if (!e.isControlDown() && !e.isShiftDown()) {
                this.SelectRow(-1, false);
                this.SelectRow(row, true);
            }
            if (e.isControlDown()) {
                this.SelectRow(row, !this.isRowSelected(row));
            }
            if (e.isShiftDown()) {
                int firstrow;
                int i = firstrow = this.getSelectedRow(-1);
                while (i <= row) {
                    this.SelectRow(i, true);
                    ++i;
                }
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.bDrag && x < this.iWidth) {
            int w = x - this.iXDrag;
            if (w < 0) {
                w = 0;
            }
            this.iColWidth[this.iColDrag] = w;
            this.adjustScroll();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (y <= this.iRowHeight) {
            int xb = x;
            x += this.iX - this.iGridWidth;
            int i = this.iColCount - 1;
            while (i >= 0) {
                if (x > -2 && x < 2) break;
                x += this.iColWidth[i];
                --i;
            }
            if (i >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = xb - this.iColWidth[i];
                    this.iColDrag = i;
                }
                return;
            }
        }
        this.mouseExited(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.sbVert.isVisible()) {
            return;
        }
        int n = this.sbVert.getValue();
        int wr = e.getWheelRotation();
        int d = e.getScrollAmount() * wr;
        if ((n += d) < 0) {
            n = 0;
        }
        if (n >= this.sbVert.getMinimum() && n < this.sbVert.getMaximum()) {
            this.sbVert.setValue(n);
            this.iY = this.iRowHeight * this.sbVert.getValue();
            this.repaint();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
        this.repaint();
    }

    public void setColumnDataMap(int colIndex, Map map) {
        if (colIndex < 0 || colIndex >= this.iColCount) {
            return;
        }
        this.colMap.put(new Integer(colIndex), map);
    }

    public void setColumnWidth(int colIndex, int width) {
        if (colIndex < 0 || colIndex >= this.iColCount) {
            return;
        }
        this.iColWidth[colIndex] = width;
        this.adjustScroll();
        this.repaint();
    }

    public void OnBeginEdit(int row, int col, Rectangle bound) {
    }

    public boolean isAutoColumnWidth() {
        return this.autoColumnWidth;
    }

    public void setAutoColumnWidth(boolean autoColumnWidth) {
        this.autoColumnWidth = autoColumnWidth;
    }

    public int RowCount() {
        return this.iRowCount;
    }

    public int ColumnCount() {
        return this.iColCount;
    }
}

