/*
 * Decompiled with CFR 0.152.
 */
package jun.control.colorpick;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jun.control.colorpick.CanvasB;
import jun.control.colorpick.CanvasHS;

public class colorpicker
extends Applet
implements MouseListener,
MouseMotionListener,
AdjustmentListener {
    protected static final int reginfo = 0;
    CanvasHS chs = new CanvasHS();
    CanvasB cb = new CanvasB();
    TextField tf_hc = new TextField(6);
    Scrollbar sb_r = new Scrollbar(0, 0, 20, 0, 275);
    Scrollbar sb_g = new Scrollbar(0, 0, 20, 0, 275);
    Scrollbar sb_b = new Scrollbar(0, 0, 20, 0, 275);
    Label l_r = new Label();
    Label l_g = null;
    Label l_b = null;
    Canvas cc = null;
    String StrJSvar = null;
    Color initValue = null;

    private void processEvent(MouseEvent mouseevent) {
        if (mouseevent.getComponent() instanceof CanvasHS) {
            this.cb.refresh(this.chs.getColorAt(mouseevent.getX(), mouseevent.getY()));
            this.cb.repaint();
            Color color = this.cb.getColor();
            this.updateDisplay(color);
        }
        if (mouseevent.getComponent() instanceof CanvasB) {
            Color color1 = this.cb.getColorAt(mouseevent.getX(), mouseevent.getY());
            this.sb_r.setValue(color1.getRed());
            this.sb_g.setValue(color1.getGreen());
            this.sb_b.setValue(color1.getBlue());
            this.updateDisplay(color1);
            this.cb.setCursor(mouseevent.getY());
            this.cb.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseevent) {
        this.processEvent(mouseevent);
    }

    @Override
    public void mousePressed(MouseEvent mouseevent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseevent) {
        this.processEvent(mouseevent);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentevent) {
        Color color = new Color(this.sb_r.getValue(), this.sb_g.getValue(), this.sb_b.getValue());
        this.updateDisplay(color);
        this.cb.setCursor(this.cb.size().height / 2);
        this.cb.refresh(color);
        this.cc.setBackground(color);
    }

    @Override
    public void paint(Graphics g) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseevent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseevent) {
    }

    public colorpicker() {
        this.l_r.setAlignment(2);
        this.l_g = new Label();
        this.l_g.setAlignment(2);
        this.l_b = new Label();
        this.l_b.setAlignment(2);
        this.cc = new Canvas();
    }

    public void setColor(String s) {
        try {
            Color color = new Color(Integer.parseInt(s, 16));
            this.updateDisplay(color);
        }
        catch (NumberFormatException numberformatexception) {
            System.out.println("Invalid color");
        }
    }

    public final void updateDisplay(Color color) {
        String s = Integer.toHexString(color.getRGB() & 0xFFFFFF).toUpperCase();
        s = "000000" + s;
        s = s.substring(s.length() - 6);
        s = "#" + s;
        this.tf_hc.setText(s);
        this.l_r.setText(Integer.toString(color.getRed()));
        this.l_g.setText(Integer.toString(color.getGreen()));
        this.l_b.setText(Integer.toString(color.getBlue()));
        this.sb_r.setValue(color.getRed());
        this.sb_g.setValue(color.getGreen());
        this.sb_b.setValue(color.getBlue());
        this.cc.setBackground(color);
    }

    @Override
    public void mouseEntered(MouseEvent mouseevent) {
        this.showStatus("ColorPicker for non-commercial use only. Copyright 2001, 2002 by NavSurf.com, http://navsurf.com");
    }

    @Override
    public void mouseExited(MouseEvent mouseevent) {
    }

    private void retrieveParameters() {
        if (this.getParameter("js_variable") != null) {
            this.StrJSvar = this.getParameter("js_variable");
        }
        if (this.getParameter("start_value") != null) {
            try {
                this.initValue = new Color(Integer.parseInt(this.getParameter("start_value"), 16));
            }
            catch (NumberFormatException numberformatexception) {
                System.out.println("Invalid start_value");
                this.initValue = Color.gray;
            }
        } else {
            this.initValue = Color.gray;
        }
    }

    @Override
    public void init() {
        this.retrieveParameters();
        this.setLayout(new BorderLayout());
        this.setFont(new Font("Arial", 1, 12));
        this.setBackground(Color.white);
        GridBagLayout gridbaglayout = new GridBagLayout();
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        GridBagConstraints gridbagconstraints1 = new GridBagConstraints();
        Panel panel = new Panel(gridbaglayout);
        Panel panel1 = new Panel(new FlowLayout(1, 10, 0));
        Panel panel2 = new Panel(gridbaglayout);
        Canvas canvas = new Canvas();
        Canvas canvas1 = new Canvas();
        Canvas canvas2 = new Canvas();
        canvas.resize(20, 20);
        canvas.setBackground(Color.red);
        canvas1.resize(20, 20);
        canvas1.setBackground(Color.green);
        canvas2.resize(20, 20);
        canvas2.setBackground(Color.blue);
        this.chs.addMouseMotionListener(this);
        this.chs.addMouseListener(this);
        this.cb.addMouseMotionListener(this);
        this.cb.addMouseListener(this);
        gridbagconstraints1.insets = new Insets(5, 5, 5, 5);
        gridbagconstraints1.gridwidth = 0;
        panel.add((Component)new Label("ColorPicker\u00a9 NavSurf.com @ http://navsurf.com"), gridbagconstraints1);
        gridbagconstraints1.fill = 0;
        gridbagconstraints1.gridwidth = -1;
        panel.add((Component)this.chs, gridbagconstraints1);
        gridbagconstraints1.gridwidth = 0;
        panel.add((Component)this.cb, gridbagconstraints1);
        this.cc.resize(50, 50);
        this.cc.setBackground(Color.gray);
        this.sb_r.addAdjustmentListener(this);
        this.sb_g.addAdjustmentListener(this);
        this.sb_b.addAdjustmentListener(this);
        this.cb.refresh(this.initValue);
        this.updateDisplay(this.initValue);
        gridbagconstraints.anchor = 10;
        gridbagconstraints.insets = new Insets(5, 5, 5, 5);
        gridbagconstraints.ipadx = 0;
        gridbagconstraints.weightx = 0.0;
        gridbagconstraints.fill = 1;
        panel2.add((Component)this.l_r, gridbagconstraints);
        panel2.add((Component)canvas, gridbagconstraints);
        gridbagconstraints.ipadx = 250;
        gridbagconstraints.gridwidth = 0;
        panel2.add((Component)this.sb_r, gridbagconstraints);
        gridbagconstraints.ipadx = 0;
        gridbagconstraints.gridwidth = 1;
        panel2.add((Component)this.l_g, gridbagconstraints);
        panel2.add((Component)canvas1, gridbagconstraints);
        gridbagconstraints.ipadx = 250;
        gridbagconstraints.gridwidth = 0;
        panel2.add((Component)this.sb_g, gridbagconstraints);
        gridbagconstraints.ipadx = 0;
        gridbagconstraints.gridwidth = 1;
        panel2.add((Component)this.l_b, gridbagconstraints);
        panel2.add((Component)canvas2, gridbagconstraints);
        gridbagconstraints.ipadx = 250;
        gridbagconstraints.gridwidth = 0;
        panel2.add((Component)this.sb_b, gridbagconstraints);
        panel1.add(new Label("Hex Code"));
        panel1.add(this.tf_hc);
        panel1.add(this.cc);
        this.add((Component)panel, "North");
        this.add((Component)panel2, "Center");
        this.add((Component)panel1, "South");
    }
}

