/*
 * Decompiled with CFR 0.152.
 */
package jun.control.colorpick;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.MemoryImageSource;

public class CanvasB
extends Canvas {
    static final int HEIGHT = 256;
    static final int WIDTH = 30;
    private int[] colormap = new int[7680];
    private Image col_img = null;
    private Point cur_point = new Point();
    int mouseY = 0;
    int prevY = 0;

    CanvasB() {
        super.setBackground(Color.white);
        super.resize(40, 256);
        int i = 0;
        do {
            int j = 1;
            do {
                this.colormap[i + (256 - j) * 30] = Color.HSBtoRGB(0.0f, 0.0f, (float)j / 256.0f);
            } while (++j <= 256);
        } while (++i < 30);
        this.col_img = this.createImage(new MemoryImageSource(30, 256, this.colormap, 0, 30));
        this.mouseY = 128;
    }

    public Color getColorAt(int i, int j) {
        Color color = new Color(this.colormap[i + j * 30]);
        return color;
    }

    public Color getColor() {
        Color color = new Color(this.colormap[this.mouseY * 30]);
        return color;
    }

    @Override
    public void paint(Graphics g) {
        int[] nArray = new int[3];
        nArray[1] = 5;
        int[] ai = nArray;
        int[] ai1 = new int[]{this.mouseY - 5, this.mouseY, this.mouseY + 5};
        g.setColor(Color.black);
        g.fillPolygon(ai, ai1, 3);
        ai[0] = this.size().width - ai[0];
        ai[1] = this.size().width - ai[1];
        ai[2] = this.size().width - ai[2];
        g.fillPolygon(ai, ai1, 3);
        g.drawImage(this.col_img, 5, 0, this);
    }

    @Override
    public void update(Graphics g) {
        g.clearRect(0, 0, 5, this.size().height);
        g.clearRect(this.size().width - 5, 0, this.size().width, this.size().height);
        this.paint(g);
    }

    public void refresh(Color color) {
        int i = 0;
        do {
            int j = 1;
            do {
                this.colormap[i + j * 30] = 0xFF000000 | j * 2 * (color.getRed() - 255) / 256 + 255 << 16 | j * 2 * (color.getGreen() - 255) / 256 + 255 << 8 | j * 2 * (color.getBlue() - 255) / 256 + 255;
            } while (++j <= 128);
        } while (++i < 30);
        i = 0;
        do {
            int k = 128;
            do {
                this.colormap[i + k * 30] = 0xFF000000 | color.getRed() * 2 * (256 - k) / 256 << 16 | color.getGreen() * 2 * (256 - k) / 256 << 8 | color.getBlue() * 2 * (256 - k) / 256;
            } while (++k < 256);
        } while (++i < 30);
        this.col_img = this.createImage(new MemoryImageSource(30, 256, this.colormap, 0, 30));
        this.repaint();
    }

    @Override
    public boolean mouseDrag(Event event, int i, int j) {
        return true;
    }

    public void setCursor(int i) {
        this.prevY = this.mouseY;
        this.mouseY = i;
    }
}

