/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.gui;

import EDU.auburn.VGJ.graph.Edge;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.gui.GraphCanvasActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;

public class GraphCanvasEventManager {
    private ArrayList m_ListenerList = new ArrayList();
    private HashMap orderMap = new HashMap();
    private HashMap nameMap = new HashMap();

    public void AddGraphCanvasActionListener(GraphCanvasActionListener listener) {
        this.AddGraphCanvasActionListener(listener, 1);
    }

    public void AddGraphCanvasActionListener(GraphCanvasActionListener listener, int order) {
        this.AddGraphCanvasActionListener(listener, order, null);
    }

    public void AddGraphCanvasActionListener(GraphCanvasActionListener listener, int order, String name) {
        this.orderMap.put(listener, new Integer(order));
        if (name != null && !name.trim().equals("")) {
            this.nameMap.put(name, listener);
        }
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            int ar = (Integer)this.orderMap.get(al);
            if (order < ar) {
                this.m_ListenerList.add(i, listener);
                return;
            }
            ++i;
        }
        this.m_ListenerList.add(listener);
    }

    public boolean RemoveGraphCanvasActionListener(String name) {
        if (!this.nameMap.containsKey(name)) {
            return false;
        }
        return this.RemoveGraphCanvasActionListener((GraphCanvasActionListener)this.nameMap.get(name));
    }

    public boolean RemoveGraphCanvasActionListener(GraphCanvasActionListener listener) {
        if (listener == null) {
            return false;
        }
        int n = this.m_ListenerList.size();
        int rc = 0;
        int i = n - 1;
        while (i >= 0) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            if (al.equals(listener)) {
                this.m_ListenerList.remove(i);
                ++rc;
            }
            --i;
        }
        if (this.orderMap.containsKey(listener)) {
            this.orderMap.remove(listener);
        }
        return rc > 0;
    }

    public boolean FireDeleteNodePermit(Node node) {
        int n = this.m_ListenerList.size();
        boolean permit = true;
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            permit = al.DeleteNodePermit(node);
            if (!permit) {
                return false;
            }
            ++i;
        }
        return permit;
    }

    public void FireAfterDeleteNode(Node node) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.AfterDeleteNode(node);
            ++i;
        }
    }

    public void FireAfterAddNode(Node node) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.AfterAddNode(node);
            ++i;
        }
    }

    public void FireNodeClicked(Node node, int quadrant, int clickCount) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.NodeClicked(node, quadrant, clickCount);
            ++i;
        }
    }

    public boolean FireDeleteEdgePermit(Edge edge) {
        int n = this.m_ListenerList.size();
        boolean permit = true;
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            permit = al.DeleteEdgePermit(edge);
            if (!permit) {
                return false;
            }
            ++i;
        }
        return permit;
    }

    public void FireAfterAddEdge(Edge edge) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.AfterAddEdge(edge);
            ++i;
        }
    }

    public void FireAfterDeleteEdge(Edge edge) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.AfterDeleteEdge(edge);
            ++i;
        }
    }

    public void FireEdgeClicked(Edge edge, int quadrant, int clickCount) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.EdgeClicked(edge, quadrant, clickCount);
            ++i;
        }
    }

    public void FireBlankClicked(int quadrant) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.BlankClicked(quadrant);
            ++i;
        }
    }

    public void FirekeyPressed(KeyEvent e) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.GraphKeyPressed(e);
            ++i;
        }
    }

    public void FireEventMousePressed(MouseEvent e) {
        int n = this.m_ListenerList.size();
        int i = 0;
        while (i < n) {
            GraphCanvasActionListener al = (GraphCanvasActionListener)this.m_ListenerList.get(i);
            al.eventMousePressed(e);
            ++i;
        }
    }
}

