/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.gui;

import EDU.auburn.VGJ.graph.Edge;
import EDU.auburn.VGJ.graph.Graph;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.gui.GraphCanvasActionListener;
import EDU.auburn.VGJ.gui.GraphCanvasEventManager;
import EDU.auburn.VGJ.util.DDimension;
import EDU.auburn.VGJ.util.DDimension3;
import EDU.auburn.VGJ.util.DPoint;
import EDU.auburn.VGJ.util.DPoint3;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class GraphCanvas
extends JComponent
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    public static final int CREATE_NODES = 0;
    public static final int CREATE_EDGES = 1;
    public static final int SELECT_NODES = 2;
    public static final int SELECT_EDGES = 3;
    public static final int SELECT_BOTH = 4;
    private static final int aaDivs_ = 4;
    private static Color[] aaShades_ = new Color[32];
    private JComponent frame_;
    private Graph graph_;
    private DPoint offset_ = new DPoint(0.0, 0.0);
    private Node newEdgeNode_;
    private Node movingNode_;
    private Node selectedNode_;
    private double movingZ_;
    private double movingX_;
    private double movingY_;
    private double selectedRatio_;
    private Point selectedEdge_;
    private static final int NONE_ = 0;
    private static final int CENTER_ = 1;
    private static final int CORNER_ = 2;
    private static final int BOTTOM_ = 3;
    private static final int LEFT_ = 4;
    private int selected_ = 0;
    private int mouseMode_ = 0;
    private boolean scaleBounds_ = true;
    private boolean xyPlane_ = true;
    private boolean _3d_ = false;
    private Image backImage_ = null;
    private Font font_;
    private int currentMouseAction_ = 0;
    private DPoint3 lastEdgePoint_ = null;
    private int pathLength_;
    private int pathArraySize_;
    private DPoint3[] pathArray_;
    private int multiSelectX_;
    private int multiSelectY_;
    private int multiSelectX2_;
    private int multiSelectY2_;
    private Rectangle selectionRect = null;
    private double moveX_;
    private double moveY_;
    public double hSpacing = 30.0;
    public double vSpacing = 40.0;
    private int qualityCB_ = 1;
    private int quality_ = 1;
    public boolean drawNodeNo = false;
    private GraphCanvasEventManager EM = new GraphCanvasEventManager();

    static {
        int i = 0;
        while (i < 32) {
            int shade = 255 - i * 512 / 16;
            if (shade < 0) {
                shade = 0;
            }
            GraphCanvas.aaShades_[i] = new Color(shade, shade, shade);
            ++i;
        }
    }

    public GraphCanvas(Graph graph_in, JComponent frame_in) {
        this.graph_ = graph_in;
        this.frame_ = frame_in;
        this.setBackground(Color.white);
        this.font_ = new Font("\u5b8b\u4f53", 0, 12);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
    }

    public void keyPressed(KeyEvent e) {
        System.out.println("key down");
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        System.out.println(key);
        if (key == 127) {
            this.deleteSelected(true);
        } else if (key == 103 || key == 117 || key == 100 || key == 99) {
            this.groupControl(key);
        }
        if (key == 65 && e.isControlDown()) {
            this.selectAll();
        }
        this.EM.FirekeyPressed(e);
    }

    public int getQuadrant(Point p) {
        Rectangle rc = this.getBounds();
        Rectangle rc1 = new Rectangle(rc.width / 2, 0, rc.width / 2, rc.height / 2);
        Rectangle rc2 = new Rectangle(0, 0, rc.width / 2, rc.height / 2);
        Rectangle rc3 = new Rectangle(0, rc.height / 2, rc.width / 2, rc.height / 2);
        Rectangle rc4 = new Rectangle(rc.width / 2, rc.height / 2, rc.width / 2, rc.height / 2);
        int quadrant = 0;
        if (rc1.contains(p)) {
            quadrant = 1;
        }
        if (rc2.contains(p)) {
            quadrant = 2;
        }
        if (rc3.contains(p)) {
            quadrant = 3;
        }
        if (rc4.contains(p)) {
            quadrant = 4;
        }
        return quadrant;
    }

    public void mouseClicked(MouseEvent e) {
        int x_in = e.getX();
        int y_in = e.getY();
        int quadrant = this.getQuadrant(e.getPoint());
        Node node = this.findNearestNode_(x_in, y_in, false);
        if (node != null) {
            this.EM.FireNodeClicked(node, quadrant, e.getClickCount());
            return;
        }
        Edge edge = this.findNearestEdge_(x_in, y_in);
        if (edge != null) {
            this.EM.FireEdgeClicked(edge, quadrant, e.getClickCount());
            return;
        }
        this.EM.FireBlankClicked(quadrant);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void ShowMenu(Point p) {
        JPopupMenu ret = new JPopupMenu("popup");
        Border border = BorderFactory.createLineBorder(new Color(88, 88, 103));
        ret.setBorder(border);
        JMenuItem m_export = new JMenuItem("\u5bfc\u51fa");
        ret.add(m_export);
        m_export.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        JMenuItem m_import = new JMenuItem("\u5bfc\u5165");
        ret.add(m_import);
        m_import.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        ret.show(this, p.x, p.y);
    }

    public void mousePressed(MouseEvent e) {
        int x_in = e.getX();
        int y_in = e.getY();
        int quadrant = this.getQuadrant(e.getPoint());
        if (this.currentMouseAction_ == 2 && this.newEdgeNode_ != null) {
            if (!e.isShiftDown()) {
                Node tmpnode = this.findNearestNode_(x_in, y_in, false);
                if (tmpnode == null) {
                    this.newEdgeNode_ = null;
                    this.currentMouseAction_ = 3;
                    this.unselectItems();
                    this.repaint();
                } else {
                    if (this.pathLength_ == 0 && this.newEdgeNode_ != tmpnode) {
                        this.unselectItems();
                        Edge edge = this.graph_.insertEdge(this.graph_.getIndexFromNode(this.newEdgeNode_), this.graph_.getIndexFromNode(tmpnode));
                        if (edge != null) {
                            this.selectedEdge_ = new Point(0, 0);
                            this.EM.FireAfterAddEdge(edge);
                            this.EM.FireEdgeClicked(edge, quadrant, 1);
                        }
                    } else {
                        DPoint3[] tmp_array;
                        if (this.pathLength_ == 0) {
                            tmp_array = new DPoint3[2];
                            DPoint3 pos = tmpnode.getPosition3();
                            DPoint3 pos2 = new DPoint3(pos);
                            DDimension3 size = tmpnode.getBoundingBox3();
                            double w = size.width / 2.0;
                            if (w < 10.0) {
                                w = 10.0;
                            }
                            double h = size.height / 2.0 + w * 1.5;
                            pos.translate(-w, -h, 0.0);
                            pos2.translate(w, -h, 0.0);
                            tmp_array[0] = pos;
                            tmp_array[1] = pos2;
                        } else {
                            tmp_array = new DPoint3[this.pathLength_];
                            System.arraycopy(this.pathArray_, 0, tmp_array, 0, this.pathLength_);
                        }
                        this.unselectItems();
                        Edge edge = this.graph_.insertEdge(this.graph_.getIndexFromNode(this.newEdgeNode_), this.graph_.getIndexFromNode(tmpnode), tmp_array);
                        if (edge != null) {
                            this.selectedEdge_ = new Point(0, 0);
                            this.EM.FireAfterAddEdge(edge);
                            this.EM.FireEdgeClicked(edge, quadrant, 1);
                        }
                    }
                    this.currentMouseAction_ = 0;
                    this.repaint();
                }
            } else {
                DPoint3 pos = new DPoint3(x_in, y_in, 0.0);
                DPoint3 p2 = this.lastEdgePoint_ != null ? new DPoint3(this.lastEdgePoint_) : this.newEdgeNode_.intersectWithLineTo(pos, this.xyPlane_, this.quality_);
                Graphics g = this.getGraphics();
                g.setColor(Color.black);
                g.drawLine(x_in, y_in, (int)p2.x, (int)p2.y);
                g.dispose();
                this.lastEdgePoint_ = pos;
                if (this.pathLength_ >= this.pathArraySize_) {
                    this.pathArraySize_ = this.pathLength_ * 2;
                    DPoint3[] new_array = new DPoint3[this.pathArraySize_];
                    System.arraycopy(this.pathArray_, 0, new_array, 0, this.pathLength_);
                    this.pathArray_ = new_array;
                }
                this.pathArray_[this.pathLength_] = this.lastEdgePoint_;
                ++this.pathLength_;
                return;
            }
            return;
        }
        if (this.currentMouseAction_ != 0) {
            return;
        }
        DPoint3 pos = new DPoint3(x_in, y_in, 0.0);
        this.movingZ_ = 0.0;
        if ((e.getModifiers() & 0xE) == 0) {
            this.currentMouseAction_ = 1;
            if (this.mouseMode_ == 1) {
                this.currentMouseAction_ = 2;
            }
            if (this.mouseMode_ == 2 || this.mouseMode_ == 3 || this.mouseMode_ == 4) {
                this.currentMouseAction_ = 3;
            }
        } else {
            this.currentMouseAction_ = (e.getModifiers() & 8) != 0 ? 1 : ((e.getModifiers() & 0xA) != 0 ? 2 : 3);
        }
        try {
            if (this.currentMouseAction_ == 1) {
                if (this.findNearestNode_(x_in, y_in, false) != null) {
                    this.currentMouseAction_ = 3;
                    throw new Exception("");
                }
                if (this.findNearestEdge_(x_in, y_in) != null) {
                    this.currentMouseAction_ = 3;
                    throw new Exception("");
                }
                if (this.selectedNode_ != null || this.selectedEdge_ != null) {
                    this.unselectItems();
                    this.repaint();
                }
                int index = this.graph_.insertNode();
                this.movingNode_ = this.graph_.getNodeFromIndex(index);
                this.EM.FireAfterAddNode(this.movingNode_);
                this.unselectItems();
                this.movingNode_.setSelected(true);
                this.selectedNode_ = this.movingNode_;
                this.movingNode_.setPosition(pos);
                if (this.graph_.getNodesCount() == 1) {
                    this.movingNode_.setShape(2);
                    this.movingNode_.setLabel("\u5f00\u59cb");
                    this.movingNode_.setRoot(true);
                    this.movingNode_.setBackgroundColor(new Color(255, 230, 180));
                }
                DDimension bbox = this.movingNode_.getBoundingBox();
                this.movingNode_.setBoundingBox(bbox.width, bbox.height);
                Graphics graphics = this.getGraphics();
                graphics.setColor(Color.black);
                this.movingNode_.draw(this, graphics, this.quality_, this.drawNodeNo);
                graphics.dispose();
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        try {
            if (this.currentMouseAction_ == 2) {
                if (this.findNearestEdge_(x_in, y_in) != null) {
                    this.currentMouseAction_ = 3;
                    throw new Exception("");
                }
                this.newEdgeNode_ = null;
                this.lastEdgePoint_ = null;
                if (this.selectedNode_ != null || this.selectedEdge_ != null) {
                    this.unselectItems();
                    this.repaint();
                }
                if ((this.newEdgeNode_ = this.findNearestNode_(x_in, y_in, false)) != null) {
                    this.pathLength_ = 0;
                    this.pathArraySize_ = 10;
                    this.pathArray_ = new DPoint3[this.pathArraySize_];
                }
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        if (this.currentMouseAction_ == 3) {
            this.selected_ = 0;
            if (this.selectedNode_ != null) {
                Node tmpnode = this.graph_.firstNode();
                while (tmpnode != null && this.selected_ == 0) {
                    if (tmpnode.getSelected() && tmpnode.isVisible()) {
                        this.selectedNode_ = tmpnode;
                        DPoint3 posc = tmpnode.getPosition3();
                        DDimension bbox = tmpnode.getBoundingBox();
                        DPoint tr = new DPoint(posc.x + bbox.width / 2.0 + 1.0, posc.y - bbox.height / 2.0 - 1.0);
                        DPoint bl = new DPoint(posc.x - bbox.width / 2.0 - 1.0, posc.y + bbox.height / 2.0 + 1.0);
                        double newdist = (posc.x - (double)x_in) * (posc.x - (double)x_in) + (posc.y - (double)y_in) * (posc.y - (double)y_in);
                        double dist = 16.0;
                        if (newdist < dist) {
                            this.selected_ = 1;
                            dist = newdist;
                        }
                        if ((newdist = (tr.x - (double)x_in) * (tr.x - (double)x_in) + (tr.y - (double)y_in) * (tr.y - (double)y_in)) < dist) {
                            this.selected_ = 2;
                            this.selectedRatio_ = bbox.height == 0.0 && bbox.width == 0.0 ? 1.0 : bbox.height / bbox.width;
                            dist = newdist;
                        }
                        if ((newdist = (posc.x - (double)x_in) * (posc.x - (double)x_in) + (bl.y - (double)y_in) * (bl.y - (double)y_in)) < dist) {
                            this.selected_ = 3;
                            dist = newdist;
                        }
                        if ((newdist = (bl.x - (double)x_in) * (bl.x - (double)x_in) + (posc.y - (double)y_in) * (posc.y - (double)y_in)) < dist) {
                            this.selected_ = 4;
                        }
                    }
                    tmpnode = this.graph_.nextNode(tmpnode);
                }
                if (this.selected_ != 0) {
                    DPoint3 tmppos = this.selectedNode_.getPosition3();
                    this.movingZ_ = tmppos.z;
                    this.movingX_ = tmppos.x;
                    this.movingY_ = tmppos.y;
                    Node tmpnode2 = this.graph_.firstNode();
                    while (tmpnode2 != null) {
                        tmpnode2.saveState();
                        tmpnode2 = this.graph_.nextNode(tmpnode2);
                    }
                    Enumeration edges = this.graph_.getEdges();
                    while (edges.hasMoreElements()) {
                        ((Edge)edges.nextElement()).saveState();
                    }
                    this.moveX_ = x_in;
                    this.moveY_ = y_in;
                }
            }
            if (this.selected_ == 0) {
                Point tmpedge;
                if ((e.getModifiers() & 1) == 0) {
                    this.unselectItems();
                }
                Node tmpnode = this.findNearestNode_(x_in, y_in, true);
                if (this.mouseMode_ != 3 && tmpnode != null) {
                    this.selectedNode_ = tmpnode;
                    this.selectedNode_.setSelected(true);
                    this.selected_ = 0;
                } else if (this.mouseMode_ != 2 && (tmpedge = this.findNearestEdgePoint_(x_in, y_in)) != null) {
                    this.selectedEdge_ = tmpedge;
                    this.setEdgeSelected_(this.selectedEdge_.x, this.selectedEdge_.y, true);
                } else {
                    this.currentMouseAction_ = 4;
                    this.multiSelectX_ = x_in;
                    this.multiSelectY_ = y_in;
                    this.multiSelectX2_ = -1;
                }
            }
        }
        this.EM.FireEventMousePressed(e);
    }

    public void mouseReleased(MouseEvent e) {
        int x_in = e.getX();
        int y_in = e.getY();
        this.selectionRect = null;
        DPoint3 pos = new DPoint3(x_in, y_in, this.movingZ_);
        switch (this.currentMouseAction_) {
            case 1: {
                this.computeBounds();
                this.repaint();
                break;
            }
            case 2: {
                if (this.newEdgeNode_ == null) break;
                return;
            }
            case 3: {
                this.computeBounds();
                this.repaint();
                break;
            }
            case 4: {
                this.multiSelect_();
            }
        }
        this.currentMouseAction_ = 0;
        String string = this.getLabel_(pos.x, pos.y, pos.z, true);
        this.mouseClicked(e);
    }

    public void mouseDragged(MouseEvent e) {
        int x_in = e.getX();
        int y_in = e.getY();
        DPoint3 pos = new DPoint3(x_in, y_in, this.movingZ_);
        DPoint3 vpos = new DPoint3(pos);
        System.out.println(this.currentMouseAction_);
        if (this.currentMouseAction_ == 1) {
            this.movingNode_.setPosition(pos);
            this.repaint();
        } else if (this.currentMouseAction_ == 2 && this.newEdgeNode_ != null) {
            DPoint3 p2 = this.lastEdgePoint_ != null ? new DPoint3(this.lastEdgePoint_) : this.newEdgeNode_.intersectWithLineTo(pos, this.xyPlane_, this.quality_);
            this.repaint();
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.drawLine(x_in, y_in, (int)p2.x, (int)p2.y);
            graphics.dispose();
        } else if (this.currentMouseAction_ == 3 && this.selectedNode_ != null) {
            if (this.selected_ == 0) {
                DPoint3 tmppos = this.selectedNode_.getPosition3();
                this.moveX_ = tmppos.x;
                this.moveY_ = tmppos.y;
                int xoffs = x_in - (int)this.moveX_;
                int yoffs = y_in - (int)this.moveY_;
                if (xoffs * xoffs + yoffs * yoffs > 9) {
                    this.selected_ = 1;
                    this.movingZ_ = tmppos.z;
                    this.movingX_ = tmppos.x;
                    this.movingY_ = tmppos.y;
                    Node tmpnode = this.graph_.firstNode();
                    while (tmpnode != null) {
                        tmpnode.saveState();
                        tmpnode = this.graph_.nextNode(tmpnode);
                    }
                    Enumeration edges = this.graph_.getEdges();
                    while (edges.hasMoreElements()) {
                        ((Edge)edges.nextElement()).saveState();
                    }
                    this.repaint();
                }
            }
            if (this.selected_ == 1) {
                int xoffs = x_in - (int)this.moveX_;
                int yoffs = y_in - (int)this.moveY_;
                Node tmpnode = this.graph_.firstNode();
                while (tmpnode != null) {
                    if (tmpnode.getSelected()) {
                        tmpnode.slide(xoffs, yoffs);
                    }
                    tmpnode = this.graph_.nextNode(tmpnode);
                }
                Enumeration edges = this.graph_.getEdges();
                while (edges.hasMoreElements()) {
                    Edge edge = (Edge)edges.nextElement();
                    if (!edge.tail().getSelected() || !edge.head().getSelected()) continue;
                    edge.slide(xoffs, yoffs);
                }
                this.repaint();
            } else if (this.selected_ != 0) {
                double ratiox = 1.0;
                double ratioy = 1.0;
                double ratioz = 1.0;
                if (this.selected_ == 2) {
                    ratioy = ratioz = Math.max(Math.abs((double)x_in - this.movingX_) / Math.abs(this.moveX_ - this.movingX_), Math.abs((double)y_in - this.movingY_) / Math.abs(this.moveY_ - this.movingY_));
                    ratiox = ratioz;
                } else if (this.selected_ == 3) {
                    ratioy = Math.abs((double)y_in - this.movingY_) / Math.abs(this.moveY_ - this.movingY_);
                } else if (this.selected_ == 4) {
                    ratiox = Math.abs((double)x_in - this.movingX_) / Math.abs(this.moveX_ - this.movingX_);
                }
                Node tmpnode = this.graph_.firstNode();
                while (tmpnode != null) {
                    if (tmpnode.getSelected()) {
                        tmpnode.scale(ratiox, ratioy, ratioz);
                    }
                    tmpnode = this.graph_.nextNode(tmpnode);
                }
            }
        } else if (this.currentMouseAction_ == 4) {
            this.multiSelectX2_ = x_in;
            this.multiSelectY2_ = y_in;
            this.drawSelectRect();
        }
        String string = this.getLabel_(pos.x, pos.y, pos.z, true);
    }

    public void mouseMoved(MouseEvent e) {
        int x_in = e.getX();
        int y_in = e.getY();
        this.ChangeCursor(e, x_in, y_in);
        DPoint3 pos = new DPoint3(x_in, y_in, 0.0);
        if (this.currentMouseAction_ == 2 && this.newEdgeNode_ != null) {
            DPoint3 p2 = this.lastEdgePoint_ != null ? new DPoint3(this.lastEdgePoint_) : this.newEdgeNode_.intersectWithLineTo(pos, this.xyPlane_, this.quality_);
            this.repaint();
            Graphics graphics = this.getGraphics();
            graphics.setColor(Color.black);
            graphics.drawLine(x_in, y_in, (int)p2.x, (int)p2.y);
            graphics.dispose();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        int wr = e.getWheelRotation();
        int n = e.getScrollAmount() * wr * 10;
        JScrollPane sp = (JScrollPane)this.getParent().getParent();
        JScrollBar sb = sp.getVerticalScrollBar();
        int v = sb.getValue();
        if ((v += n) < sb.getMaximum() && v > 0) {
            sb.setValue(v);
        }
        if (v < 0) {
            sb.setValue(0);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(2000, 2000);
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Rectangle rc = g.getClipBounds();
        g.setColor(Color.white);
        g.fill(rc);
        this.drawObjects_(graphics);
    }

    public byte[] ExportToImage() {
        byte[] ret = null;
        this.unselectItems();
        Rectangle rc = this.computeBounds();
        int w = rc.width + 40;
        int h = rc.height + 40;
        BufferedImage img = new BufferedImage(w, h, 1);
        Graphics graphics = img.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, w, h);
        graphics.translate(-Math.max(0, rc.x - 20), -Math.max(0, rc.y - 20));
        this.drawObjects_(graphics);
        try {
            try {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                BufferedOutputStream bos = new BufferedOutputStream(bo);
                ImageIO.write((RenderedImage)img, "png", bos);
                bos.flush();
                bos.close();
                ret = bo.toByteArray();
            }
            catch (Exception e) {
                ret = null;
                graphics.dispose();
            }
        }
        finally {
            graphics.dispose();
        }
        return ret;
    }

    public void drawObjects_(Graphics graphics) {
        graphics.setFont(this.font_);
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.draw(this, graphics, this.quality_, this.drawNodeNo);
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        Enumeration edges = this.graph_.getEdges();
        boolean directed = this.graph_.isDirected();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            Node head = edge.head();
            Node tail = edge.tail();
            if (head.getVisibleGroupRoot() == tail.getVisibleGroupRoot() && head != tail || head == tail && !head.isVisible()) continue;
            boolean arrow_only = false;
            if (directed) {
                arrow_only = this.drawBackEdge_(tail.getIndex(), head.getIndex());
            }
            if (!directed && tail.getIndex() > head.getIndex()) continue;
            edge.draw(graphics, this.xyPlane_, directed, arrow_only, this.quality_, this);
        }
    }

    public void ChangeCursor(MouseEvent event, int x_in, int y_in) {
        Node tmpnode;
        int cursorPos = 0;
        int labelPosition = 0;
        Cursor cur = new Cursor(0);
        if (this.findNearestEdgePoint_(x_in, y_in) != null) {
            cur = new Cursor(12);
        }
        if ((tmpnode = this.findNearestNode_(x_in, y_in, false)) != null) {
            cur = new Cursor(12);
            if (tmpnode.getSelected() && tmpnode.isVisible()) {
                labelPosition = tmpnode.getLabelPosition();
                DPoint3 posc = tmpnode.getPosition3();
                DDimension bbox = tmpnode.getBoundingBox();
                DPoint tr = new DPoint(posc.x + bbox.width / 2.0 + 1.0, posc.y - bbox.height / 2.0 - 1.0);
                DPoint bl = new DPoint(posc.x - bbox.width / 2.0 - 1.0, posc.y + bbox.height / 2.0 + 1.0);
                double newdist = (posc.x - (double)x_in) * (posc.x - (double)x_in) + (posc.y - (double)y_in) * (posc.y - (double)y_in);
                double dist = 16.0;
                if (newdist < dist) {
                    cursorPos = 1;
                    dist = newdist;
                }
                if ((newdist = (tr.x - (double)x_in) * (tr.x - (double)x_in) + (tr.y - (double)y_in) * (tr.y - (double)y_in)) < dist) {
                    cursorPos = 2;
                    this.selectedRatio_ = bbox.height == 0.0 && bbox.width == 0.0 ? 1.0 : bbox.height / bbox.width;
                    dist = newdist;
                }
                if ((newdist = (posc.x - (double)x_in) * (posc.x - (double)x_in) + (bl.y - (double)y_in) * (bl.y - (double)y_in)) < dist) {
                    cursorPos = 3;
                    dist = newdist;
                }
                if ((newdist = (bl.x - (double)x_in) * (bl.x - (double)x_in) + (posc.y - (double)y_in) * (posc.y - (double)y_in)) < dist) {
                    cursorPos = 4;
                }
                switch (cursorPos) {
                    case 1: {
                        cur = new Cursor(13);
                        break;
                    }
                    case 2: {
                        if (labelPosition == 1) break;
                        cur = new Cursor(7);
                        break;
                    }
                    case 3: {
                        if (labelPosition == 1) break;
                        cur = new Cursor(9);
                        break;
                    }
                    case 4: {
                        if (labelPosition == 1) break;
                        cur = new Cursor(10);
                        break;
                    }
                    default: {
                        cur = new Cursor(12);
                    }
                }
            }
        }
        this.setCursor(cur);
    }

    public Rectangle computeBounds() {
        double minX = 0.0;
        double minY = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        Node tmpnode = this.graph_.firstNode();
        if (tmpnode != null) {
            DPoint tmppoint = tmpnode.getPosition();
            DDimension tmpdim = tmpnode.getBoundingBox();
            minX = tmppoint.x - tmpdim.width / 2.0;
            maxX = tmppoint.x + tmpdim.width / 2.0;
            minY = tmppoint.y - tmpdim.height / 2.0;
            maxY = tmppoint.y + tmpdim.height / 2.0;
            tmpnode = this.graph_.nextNode(tmpnode);
            while (tmpnode != null) {
                tmppoint = tmpnode.getPosition();
                tmpdim = tmpnode.getBoundingBox();
                double w = tmpdim.width / 2.0;
                double h = tmpdim.height / 2.0;
                if (tmppoint.x - w < minX) {
                    minX = tmppoint.x - w;
                }
                if (tmppoint.x + w > maxX) {
                    maxX = tmppoint.x + w;
                }
                if (tmppoint.y - h < minY) {
                    minY = tmppoint.y - h;
                }
                if (tmppoint.y + h > maxY) {
                    maxY = tmppoint.y + h;
                }
                tmpnode = this.graph_.nextNode(tmpnode);
            }
        }
        return new Rectangle((int)minX, (int)minY, (int)(maxX - minX), (int)(maxY - minY));
    }

    private Node findNearestNode_(double x, double y, boolean group_nodes) {
        Node node = null;
        double closest = 4000.0;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (tmpnode.isVisible() && (group_nodes || !tmpnode.isGroup())) {
                DPoint3 pos = tmpnode.getPosition3();
                DDimension bbox = tmpnode.getBoundingBox();
                pos.x = Math.abs(pos.x - x);
                pos.y = Math.abs(pos.y - y);
                if (pos.x < bbox.width / 2.0 + 1.0 && pos.y < bbox.height / 2.0 + 1.0 && pos.x + pos.y < closest) {
                    closest = pos.x + pos.y;
                    node = tmpnode;
                }
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        return node;
    }

    private Point findNearestEdgePoint_(double x, double y) {
        Point edge = null;
        DPoint3 pos = new DPoint3();
        DPoint3 pos2 = new DPoint3();
        double closest = 4000.0;
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (!tmpnode.isGroup()) {
                int child = tmpnode.firstChild();
                while (child != -1) {
                    Node childnode = this.graph_.getNodeFromIndex(child);
                    if (!childnode.isGroup()) {
                        int npoints = 0;
                        DPoint3[] path = this.graph_.getEdgePathPoints(tmpnode.getIndex(), child);
                        if (path != null) {
                            npoints = path.length;
                        }
                        int pointindex = 0;
                        while (pointindex <= npoints) {
                            if (pointindex == 0) {
                                pos = tmpnode.getPosition3();
                            } else {
                                pos.move(path[pointindex - 1]);
                            }
                            if (pointindex == npoints) {
                                pos2 = childnode.getPosition3();
                            } else {
                                pos2.move(path[pointindex]);
                            }
                            if ((x >= pos.x - 1.0 && x <= pos2.x + 1.0 || x >= pos2.x - 1.0 && x <= pos.x + 1.0) && (y >= pos.y - 1.0 && y <= pos2.y + 1.0 || y >= pos2.y - 1.0 && y <= pos.y + 1.0)) {
                                double dist;
                                double dx = pos2.x - pos.x;
                                double dy = pos2.y - pos.y;
                                double l1 = 0.0;
                                double l2 = 0.0;
                                if (dx == 0.0 || dy == 0.0) {
                                    dist = 0.0;
                                    double dist2 = 0.0;
                                } else {
                                    double xd = Math.abs(dx / dy * (y - pos.y) + pos.x - x);
                                    double yd = Math.abs(dy / dx * (x - pos.x) + pos.y - y);
                                    dist = Math.min(xd, yd);
                                    l1 = (y - pos.y) * (y - pos.y) + (x - pos.x) * (x - pos.x);
                                    l2 = (y - pos2.y) * (y - pos2.y) + (x - pos2.x) * (x - pos2.x);
                                }
                                if (dist < 3.0 && dist < closest) {
                                    closest = dist;
                                    edge = l1 < l2 && this.graph_.getEdge(child, tmpnode.getIndex()) != null ? new Point(child, tmpnode.getIndex()) : new Point(tmpnode.getIndex(), child);
                                }
                            }
                            ++pointindex;
                        }
                    }
                    child = tmpnode.nextChild();
                }
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        return edge;
    }

    private String getLabel_(double x, double y, double z, boolean mousein) {
        String string = new String();
        if (mousein) {
            string = string.concat("x: " + x + "  y: " + y + "  z: " + z);
        }
        if (this.selectedNode_ != null) {
            DPoint3 pos = this.selectedNode_.getPosition3();
            DDimension3 bbox = this.selectedNode_.getBoundingBox3();
            string = string.concat("   Node " + this.selectedNode_.getIndex() + "   x: " + pos.x + "  y: " + pos.y + "  z: " + pos.z + "   w: " + bbox.width + "  h: " + bbox.height + "  d: " + bbox.depth);
        }
        if (this.selectedEdge_ != null) {
            string = string.concat("   Edge (" + this.selectedEdge_.x + "," + this.selectedEdge_.y + ")");
        }
        return string;
    }

    public void update(boolean adjust_bounds) {
        this.unselectItems();
        this.currentMouseAction_ = 0;
        if (adjust_bounds) {
            this.computeBounds();
        }
        this.repaint();
    }

    public JComponent getFrame() {
        return this.frame_;
    }

    public Graph getGraph() {
        return this.graph_;
    }

    public void deleteSelected(boolean group_warning) {
        if (group_warning) {
            boolean group = false;
            Node tmpnode = this.graph_.firstNode();
            while (tmpnode != null) {
                if (tmpnode.getSelected() && tmpnode.isGroup()) {
                    group = true;
                    break;
                }
                tmpnode = this.graph_.nextNode(tmpnode);
            }
            if (group) {
                return;
            }
        }
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            if (tmpnode.getSelected() && this.EM.FireDeleteNodePermit(tmpnode)) {
                this.graph_.removeNode(tmpnode);
                this.EM.FireAfterDeleteNode(tmpnode);
            }
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        this.selectedNode_ = null;
        this.computeBounds();
        Enumeration edges = this.graph_.getEdges();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            if (!edge.selected || !this.EM.FireDeleteEdgePermit(edge)) continue;
            this.graph_.removeEdge(edge);
            this.EM.FireAfterDeleteEdge(edge);
        }
        this.repaint();
        if (this.currentMouseAction_ == 2) {
            this.currentMouseAction_ = 0;
            this.repaint();
        }
    }

    public Node getSelectedNode() {
        return this.selectedNode_;
    }

    public void unselectItems() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.setSelected(false);
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        this.selectedNode_ = null;
        Enumeration edges = this.graph_.getEdges();
        while (edges.hasMoreElements()) {
            ((Edge)edges.nextElement()).selected = false;
        }
        this.selectedEdge_ = null;
        this.repaint();
    }

    public void scaleBounds(boolean sb) {
        this.scaleBounds_ = sb;
    }

    public void setMouseMode(int mode) {
        this.mouseMode_ = mode;
    }

    public void setDirected(boolean directed) {
        this.graph_.setDirected(directed);
        this.repaint();
    }

    private boolean drawBackEdge_(int n1, int n2) {
        DPoint3[] path2;
        if (n1 <= n2 || this.graph_.getEdge(n2, n1) == null) {
            return false;
        }
        DPoint3[] path1 = this.graph_.getEdgePathPoints(n1, n2);
        if (path1.length != (path2 = this.graph_.getEdgePathPoints(n2, n1)).length) {
            return false;
        }
        int pt = 0;
        while (pt < path1.length) {
            if (!path1[pt].equals(path2[path1.length - 1 - pt])) {
                return false;
            }
            ++pt;
        }
        return true;
    }

    private void drawSelectRect() {
        this.setCursor(new Cursor(1));
        Graphics graphics = this.getGraphics();
        graphics.setColor(new Color(255, 153, 153));
        graphics.setXORMode(new Color(255, 255, 255));
        int sx = Math.min(this.multiSelectX_, this.multiSelectX2_);
        int sy = Math.min(this.multiSelectY_, this.multiSelectY2_);
        int sw = Math.abs(this.multiSelectX_ - this.multiSelectX2_);
        int sh = Math.abs(this.multiSelectY_ - this.multiSelectY2_);
        if (this.selectionRect != null) {
            graphics.drawRect(this.selectionRect.x, this.selectionRect.y, this.selectionRect.width, this.selectionRect.height);
        }
        if (this.multiSelectX2_ != -1) {
            graphics.drawRect(sx, sy, sw, sh);
            this.selectionRect = new Rectangle(sx, sy, sw, sh);
        } else {
            this.selectionRect = null;
        }
        graphics.setPaintMode();
        graphics.dispose();
    }

    private void multiSelect_() {
        if (this.multiSelectX2_ == -1) {
            return;
        }
        double x1 = Math.min(this.multiSelectX_, this.multiSelectX2_);
        double y1 = Math.min(this.multiSelectY_, this.multiSelectY2_);
        double x2 = Math.max(this.multiSelectX_, this.multiSelectX2_);
        double y2 = Math.max(this.multiSelectY_, this.multiSelectY2_);
        if (this.mouseMode_ != 3) {
            Node tmpnode = this.graph_.firstNode();
            while (tmpnode != null) {
                DPoint3 pos = tmpnode.getPosition3();
                if (pos.x >= x1 && pos.x <= x2 && pos.y >= y1 && pos.y <= y2) {
                    tmpnode.setSelected(true);
                    this.selectedNode_ = tmpnode;
                }
                tmpnode = this.graph_.nextNode(tmpnode);
            }
        }
        if (this.mouseMode_ == 3) {
            Enumeration edges = this.graph_.getEdges();
            boolean directed = this.graph_.isDirected();
            while (edges.hasMoreElements()) {
                Edge edge = (Edge)edges.nextElement();
                if (!directed && edge.tail().getIndex() > edge.head().getIndex()) continue;
                DPoint3 p1 = edge.tail().getPosition3();
                DPoint3 p2 = edge.head().getPosition3();
                if (!(p1.x >= x1) || !(p1.x <= x2) || !(p1.y >= y1) || !(p1.y <= y2) || !(p2.x >= x1) || !(p2.x <= x2) || !(p2.y >= y1) || !(p2.y <= y2)) continue;
                edge.selected = true;
                this.selectedEdge_ = new Point(edge.tail().getIndex(), edge.head().getIndex());
            }
        }
        this.repaint();
    }

    public Edge findNearestEdge_(double x, double y) {
        Point tmpedge = this.findNearestEdgePoint_(x, y);
        if (tmpedge == null) {
            return null;
        }
        int ix = tmpedge.x;
        int iy = tmpedge.y;
        if (!this.graph_.isDirected()) {
            Edge edge = this.graph_.getEdge(Math.min(ix, iy), Math.max(ix, iy));
            return edge;
        }
        Edge edge = this.graph_.getEdge(ix, iy);
        return edge;
    }

    private void setEdgeSelected_(int n1, int n2, boolean state) {
        if (!this.graph_.isDirected()) {
            Edge edge = this.graph_.getEdge(Math.min(n1, n2), Math.max(n1, n2));
            edge.selected = state;
        } else {
            Edge edge = this.graph_.getEdge(n1, n2);
            edge.selected = state;
        }
    }

    public void selectAll() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.setSelected(true);
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        this.selectedNode_ = this.graph_.firstNode();
        this.repaint();
    }

    public double getHSpacing() {
        return this.hSpacing;
    }

    public double getVSpacing() {
        return this.vSpacing;
    }

    public Font getFont() {
        return this.font_;
    }

    public void setFont(Font font) {
        this.font_ = font;
        this.repaint();
    }

    public void setWireframe(boolean wireframe) {
        this.quality_ = wireframe ? 0 : this.qualityCB_;
    }

    public void setQuality(int quality) {
        if (this.qualityCB_ == this.quality_) {
            this.quality_ = quality;
        }
        this.qualityCB_ = quality;
    }

    public void removeEdgeBends() {
        this.graph_.removeEdgePaths();
        this.repaint();
    }

    public void removeGroups() {
        this.graph_.removeGroups();
        this.repaint();
    }

    public void groupControl(int key) {
        if (key == 103 || key == 117 || key == 100) {
            Node tmpnode = this.graph_.firstNode();
            while (tmpnode != null) {
                if (tmpnode.getSelected() && tmpnode.isVisible()) {
                    if (key == 103 || key == 117) {
                        this.graph_.group(tmpnode, key == 103);
                    } else if (key == 100) {
                        this.graph_.killGroup(tmpnode);
                    }
                }
                tmpnode = this.graph_.nextNode(tmpnode);
            }
        } else if (key == 99) {
            int groupnode_id = this.graph_.insertNode();
            Node groupnode = this.graph_.nodeFromIndex(groupnode_id);
            groupnode.setGroup();
            Node one_member = null;
            Node tmpnode = this.graph_.firstNode();
            while (tmpnode != null) {
                if (tmpnode.getSelected() && tmpnode.isVisible()) {
                    this.graph_.setNodeGroup(tmpnode, groupnode);
                    one_member = tmpnode;
                }
                tmpnode = this.graph_.nextNode(tmpnode);
            }
            if (one_member != null) {
                this.graph_.group(one_member, true);
            }
        }
        this.unselectItems();
        this.repaint();
    }

    public void drawRotatedText(String string, double theta, int cx, int cy, Graphics graphics_in) {
        FontMetrics fm = graphics_in.getFontMetrics();
        int label_w = Math.max(1, fm.stringWidth(string));
        int label_h = Math.max(1, fm.getHeight());
        double cos_theta = Math.cos(theta);
        if (cos_theta < 0.0) {
            theta += Math.PI;
            cos_theta = -cos_theta;
        }
        double sin_theta = Math.sin(theta);
        cx = (int)((double)cx + -sin_theta * (double)label_h / 2.0);
        cy = (int)((double)cy + -cos_theta * (double)label_h / 2.0);
        BufferedImage tmp_image = new BufferedImage(label_w, label_h, 4);
        Graphics graphics = ((Image)tmp_image).getGraphics();
        graphics.setFont(this.font_);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, label_w, label_h);
        graphics.setColor(new Color(0));
        graphics.drawString(string, 0, fm.getAscent());
        graphics.dispose();
        int[] pixels = Node.getImagePixels(tmp_image, label_w, label_h);
        if (pixels == null) {
            return;
        }
        int image_size = (int)Math.ceil(Math.sqrt((double)(label_w * label_w) + (double)(label_h * label_h))) + 2;
        int[] result = new int[image_size * image_size];
        this.rotImage_(theta, pixels, label_w, label_h, result, image_size);
        cx -= image_size / 2;
        cy -= image_size / 2;
        int y = 0;
        while (y < image_size) {
            int x = 0;
            while (x < image_size) {
                if (result[y * image_size + x] > 0) {
                    graphics_in.setColor(aaShades_[result[y * image_size + x] / 2]);
                    graphics_in.drawLine(cx + x, cy + y, cx + x, cy + y);
                }
                ++x;
            }
            ++y;
        }
    }

    private void rotImage_(double theta, int[] pixels, int w, int h, int[] result, int image_size) {
        double dxX = Math.cos(theta);
        double dyX = -Math.sin(theta);
        double dxY = -dyX;
        double dyY = dxX;
        double dxIx = dxX / 4.0;
        double dyIx = dyX / 4.0;
        double dxIy = dxY / 4.0;
        double dyIy = dyY / 4.0;
        double hdxIx = dxIx / 2.0;
        double hdyIx = dyIx / 2.0;
        double hdxIy = dxIy / 2.0;
        double hdyIy = dyIy / 2.0;
        double xX = (double)image_size / 2.0 - dxX * (double)w / 2.0 - dxY * (double)h / 2.0;
        double yX = (double)image_size / 2.0 - dyX * (double)w / 2.0 - dyY * (double)h / 2.0;
        int x = 0;
        while (x < w) {
            double xY = xX;
            double yY = yX;
            int y = 0;
            while (y < h) {
                double xIx = xY + hdxIx;
                double yIx = yY + hdyIx;
                if ((pixels[y * w + x] & 0xFFFFFF) == 0) {
                    double Ix = 0.0;
                    while (Ix < 4.0) {
                        double xIy = xIx + hdxIy;
                        double yIy = yIx + hdyIy;
                        double Iy = 0.0;
                        while (Iy < 4.0) {
                            if ((int)yIy * image_size + (int)xIy > 0 && (int)yIy * image_size + (int)xIy < image_size * image_size) {
                                int n = (int)yIy * image_size + (int)xIy;
                                result[n] = result[n] + 1;
                            }
                            xIy += dxIy;
                            yIy += dyIy;
                            Iy += 1.0;
                        }
                        xIx += dxIx;
                        yIx += dyIx;
                        Ix += 1.0;
                    }
                }
                xY += dxY;
                yY += dyY;
                ++y;
            }
            xX += dxX;
            yX += dyX;
            ++x;
        }
    }

    public void selectNode(int node_index) {
        Node node;
        this.selectedNode_ = node = this.graph_.getNodeFromId(node_index);
        node.setSelected(true);
        this.repaint();
    }

    public void AddGraphCanvasActionListener(GraphCanvasActionListener listener) {
        this.EM.AddGraphCanvasActionListener(listener);
    }

    public void AddGraphCanvasActionListener(GraphCanvasActionListener listener, int order) {
        this.EM.AddGraphCanvasActionListener(listener, order);
    }

    public void AddGraphCanvasActionListener(GraphCanvasActionListener listener, int order, String name) {
        this.EM.AddGraphCanvasActionListener(listener, order, name);
    }

    public void overturn() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.overturn();
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        Enumeration edges = this.graph_.getEdges();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            edge.overturn();
        }
        this.repaint();
    }

    public void moveToCenter() {
        Node tmpnode = this.graph_.firstNode();
        while (tmpnode != null) {
            tmpnode.saveState();
            tmpnode = this.graph_.nextNode(tmpnode);
        }
        Enumeration edges = this.graph_.getEdges();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            edge.saveState();
        }
        Rectangle rc = this.computeBounds();
        int x = (2000 - rc.width) / 2 - rc.x;
        int y = (2000 - rc.height) / 2 - rc.y;
        Node tmpnode2 = this.graph_.firstNode();
        while (tmpnode2 != null) {
            tmpnode2.slide(x, y);
            tmpnode2 = this.graph_.nextNode(tmpnode2);
        }
        edges = this.graph_.getEdges();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            edge.slide(x, y);
        }
        this.repaint();
    }
}

