/*
 * Decompiled with CFR 0.152.
 */
package EDU.auburn.VGJ.graph;

import EDU.auburn.VGJ.graph.GMLlexer;
import EDU.auburn.VGJ.graph.GMLobject;
import EDU.auburn.VGJ.graph.Node;
import EDU.auburn.VGJ.graph.Tool;
import EDU.auburn.VGJ.gui.GraphCanvas;
import EDU.auburn.VGJ.util.DPoint;
import EDU.auburn.VGJ.util.DPoint3;
import flow.Escape;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jun.db.impl.DataStoreFactory;

public class Edge {
    protected Node head_;
    protected Node tail_;
    protected DPoint3[] points_;
    private DPoint3[] oldpoints_ = null;
    private boolean dummy_ = false;
    public boolean selected = true;
    private String label_;
    private String script_ = "";
    private String script2_ = "";
    private String scriptAfterSubmit = "";
    private String comment_ = "";
    private int scriptRunOnServer_ = 0;
    private String reason1_ = "";
    private String reason2_ = "";
    private int ver = 2;
    private static Color DefaultLineColor = new Color(30, 93, 0);
    private Color LineColor = DefaultLineColor;
    private String guid = "";
    private String thirdConfig = "";
    private int groupno = 0;
    private int checkedDefault = 0;
    private static Image sign_scriptAfterSubmit = null;
    public Object data;

    public Edge(Node tail, Node head, DPoint3[] points, boolean dummy) {
        this.head_ = head;
        this.tail_ = tail;
        this.points_ = points;
        if (points == null) {
            points = new DPoint3[]{};
        }
        this.dummy_ = dummy;
        this.label_ = new String("");
        this.comment_ = "";
        this.guid = DataStoreFactory.newGUID();
    }

    public Edge(Node tail, Node head, Edge from) {
        this.head_ = head;
        this.tail_ = tail;
        this.dummy_ = from.dummy_;
        this.label_ = from.label_;
        this.comment_ = from.comment_;
        this.script_ = from.script_;
        this.script_ = from.script2_;
        this.scriptAfterSubmit = from.scriptAfterSubmit;
        this.scriptRunOnServer_ = from.scriptRunOnServer_;
        this.LineColor = from.LineColor;
        DPoint3[] frompoints = from.points();
        this.points_ = new DPoint3[frompoints.length];
        System.arraycopy(frompoints, 0, this.points_, 0, frompoints.length);
        this.guid = from.guid;
    }

    public static Image getSignImage_scriptAfterSubmit() {
        if (sign_scriptAfterSubmit != null) {
            return sign_scriptAfterSubmit;
        }
        sign_scriptAfterSubmit = Tool.GetImageFromURL("Edu/auburn/VGJ/graph/tag_red.png");
        return sign_scriptAfterSubmit;
    }

    public Edge(Node tail, Node head, GMLobject gml) {
        this.head_ = head;
        this.tail_ = tail;
        Integer tmpint = null;
        GMLobject edgegraphics = gml.getGMLSubObject("graphics", 3, false);
        if (edgegraphics != null) {
            tmpint = (Integer)gml.getValue("ver", 0);
            int v = tmpint != null ? tmpint : 0;
            int points_size = 10;
            DPoint3[] points = new DPoint3[points_size];
            int pointnum = 0;
            GMLobject point = edgegraphics.getGMLSubObject("Point", 3, false);
            while (point != null) {
                Double x = (Double)point.getValue("x", 1);
                Double y = (Double)point.getValue("y", 1);
                Double z = (Double)point.getValue("z", 1);
                if (v == 0) {
                    x = new Double(1000.0 + x);
                    y = new Double(1000.0 - y);
                }
                if (x != null && y != null) {
                    if (pointnum >= points_size) {
                        points_size = pointnum * 2;
                        DPoint3[] tmppoints = new DPoint3[points_size];
                        System.arraycopy(points, 0, tmppoints, 0, pointnum);
                        points = tmppoints;
                    }
                    points[pointnum] = new DPoint3(x, y, 0.0);
                    points[pointnum].z = z != null ? z : 0.0;
                    ++pointnum;
                }
                point = edgegraphics.getNextGMLSubObject();
            }
            this.points_ = new DPoint3[pointnum];
            System.arraycopy(points, 0, this.points_, 0, pointnum);
        } else {
            this.points_ = new DPoint3[0];
        }
        String label = (String)gml.getValue("label", 2);
        this.label_ = label != null ? label : new String();
        String comment = (String)gml.getValue("comment", 2);
        this.comment_ = comment != null ? comment : "";
        String script = (String)gml.getValue("script", 2);
        this.script_ = script != null ? script : new String();
        String script2 = (String)gml.getValue("script2", 2);
        this.script2_ = script2 != null ? script2 : new String();
        String t = (String)gml.getValue("scriptAfterSubmit", 2);
        this.scriptAfterSubmit = t != null ? t : new String();
        Integer ti = null;
        ti = (Integer)gml.getValue("scriptrunonserver", 0);
        this.scriptRunOnServer_ = ti != null ? ti : 0;
        String reason1 = (String)gml.getValue("reason1", 2);
        this.reason1_ = reason1 != null ? reason1 : new String();
        String reason2 = (String)gml.getValue("reason2", 2);
        this.reason2_ = reason2 != null ? reason2 : new String();
        try {
            this.LineColor = Color.decode(gml.getValue("linecolor", 2).toString());
        }
        catch (Exception e) {
            this.LineColor = DefaultLineColor;
        }
        this.guid = (String)gml.getValue("guid", 2);
        if (this.guid == null) {
            this.guid = DataStoreFactory.newGUID();
        }
        if ((this.thirdConfig = (String)gml.getValue("thirdconfig", 2)) == null) {
            this.thirdConfig = "";
        }
        try {
            this.groupno = new Integer(gml.getValue("groupno", 0).toString());
        }
        catch (Exception e) {
            this.groupno = 0;
        }
        try {
            this.checkedDefault = new Integer(gml.getValue("checkedDefault", 0).toString());
        }
        catch (Exception e) {
            this.checkedDefault = 0;
        }
    }

    public void setGMLvalues(GMLobject gml) {
        gml.setValue("ver", 0, new Integer(this.ver));
        gml.setValue("target", 0, new Integer(this.head_.getIdObject()));
        gml.setValue("source", 0, new Integer(this.tail_.getIdObject()));
        gml.setValue("data", 3, null);
        if (this.points_.length > 0) {
            GMLobject edgegraphics = new GMLobject("graphics", 3);
            gml.addObjectToEnd(edgegraphics);
            int length = this.points_.length;
            int pt = 0;
            while (pt < length) {
                GMLobject point = new GMLobject("Point", 3);
                edgegraphics.addObjectToEnd(point);
                point.setValue("z", 1, new Double(this.points_[pt].z));
                point.setValue("y", 1, new Double(this.points_[pt].y));
                point.setValue("x", 1, new Double(this.points_[pt].x));
                ++pt;
            }
        }
        gml.setValue("label", 2, this.label_);
        gml.setValue("comment", 2, this.comment_);
        gml.setValue("script", 2, this.script_);
        gml.setValue("script2", 2, this.script2_);
        gml.setValue("scriptAfterSubmit", 2, this.scriptAfterSubmit);
        gml.setValue("thirdconfig", 2, this.thirdConfig);
        gml.setValue("reason1", 2, this.reason1_);
        gml.setValue("reason2", 2, this.reason2_);
        gml.setValue("scriptrunonserver", 0, new Integer(this.scriptRunOnServer_));
        gml.setValue("guid", 2, this.guid);
        gml.setValue("groupno", 0, new Integer(this.groupno));
        gml.setValue("checkedDefault", 0, new Integer(this.checkedDefault));
        gml.setValue("linecolor", 2, GMLlexer.Color2Hex(this.LineColor));
    }

    public void draw(Graphics graphics, boolean inplane, boolean directed, boolean arrow_only, int quality, GraphCanvas canvas) {
        double theta;
        String label;
        DPoint3 p2to;
        DPoint3 p1to;
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.LineColor = this.getScript().trim().length() > 0 ? Color.red : DefaultLineColor;
        int npoints = this.points_.length;
        graphics.setColor(this.LineColor);
        if (npoints == 0) {
            p1to = this.head_.getPosition3();
            p2to = this.tail_.getPosition3();
        } else {
            p1to = this.points_[0];
            p2to = this.points_[npoints - 1];
        }
        DPoint3 p1 = this.tail_.intersectWithLineTo(p1to, inplane, quality);
        DPoint3 p2 = this.head_.intersectWithLineTo(p2to, inplane, quality);
        if (this.head_ == this.tail_ && npoints == 0) {
            p2.x = p1.x + 1.0;
            p2.y = p1.y;
        }
        if (!arrow_only) {
            if (npoints == 0) {
                graphics.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
            } else {
                DPoint3 point = new DPoint3(this.points_[0]);
                graphics.drawLine((int)p1.x, (int)p1.y, (int)point.x, (int)point.y);
                DPoint3 oldpoint = new DPoint3();
                int i = 1;
                while (i < npoints) {
                    oldpoint.move(point);
                    point.move(this.points_[i]);
                    graphics.drawLine((int)oldpoint.x, (int)oldpoint.y, (int)point.x, (int)point.y);
                    ++i;
                }
                graphics.drawLine((int)point.x, (int)point.y, (int)p2.x, (int)p2.y);
            }
        }
        if (this.scriptAfterSubmit != null && this.scriptAfterSubmit.length() > 0) {
            graphics.drawImage(Edge.getSignImage_scriptAfterSubmit(), (int)(p1.x + p2.x) / 2, (int)(p1.y + p2.y) / 2, null);
        }
        if (directed) {
            DPoint3 from = new DPoint3(p2to);
            if ((int)from.x == (int)p2.x && (int)from.y == (int)p2.y) {
                from.x -= 10.0;
            }
            this.drawArrow_(graphics, from, p2);
        }
        if (this.selected) {
            graphics.setColor(Color.red);
            graphics.drawRect((int)p1.x - 2, (int)p1.y - 2, 4, 4);
            if (this.head_ != this.tail_) {
                graphics.drawRect((int)p2.x - 2, (int)p2.y - 2, 4, 4);
            }
            int pointindex = 0;
            while (pointindex < npoints) {
                p2.move(this.points_[pointindex]);
                graphics.drawRect((int)p2.x - 2, (int)p2.y - 2, 4, 4);
                ++pointindex;
            }
            graphics.setColor(Color.white);
            graphics.drawRect((int)p1.x - 1, (int)p1.y - 1, 2, 2);
            if (this.head_ != this.tail_) {
                graphics.drawRect((int)p2.x - 1, (int)p2.y - 1, 2, 2);
            }
            pointindex = 0;
            while (pointindex < npoints) {
                p2.move(this.points_[pointindex]);
                graphics.drawRect((int)p2.x - 1, (int)p2.y - 1, 2, 2);
                ++pointindex;
            }
            graphics.setColor(Color.black);
        }
        if ((label = this.label_).equals("")) {
            label = Escape.unescape(this.script_);
        }
        StringTokenizer stk = new StringTokenizer(label, "\\n");
        ArrayList<String> labList = new ArrayList<String>();
        while (stk.hasMoreElements()) {
            String t = stk.nextToken();
            labList.add(t);
        }
        int ln = labList.size();
        DPoint3 to = npoints == 0 ? new DPoint3(p2) : new DPoint3(p1to);
        if (p1.x == to.x && p1.y == to.y) {
            to.x += 1.0;
        }
        int dir = Math.cos(-(theta = Math.atan2(-(to.y - p1.y), to.x - p1.x))) > 0.0 ? 1 : -1;
        int ti = 0;
        while (ti < labList.size()) {
            String t = (String)labList.get(ti);
            if (dir == -1) {
                t = (String)labList.get(labList.size() - 1 - ti);
            }
            if (quality > 0 && t != null && t.length() > 0) {
                double center_x = (p1.x + to.x) / 2.0;
                double center_y = (p1.y + to.y) / 2.0;
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                canvas.drawRotatedText(t, theta, (int)(center_x += (double)((ln - ti - 1) * 13) * Math.sin(-theta)), (int)(center_y -= (double)((ln - ti - 1) * 13) * Math.cos(-theta)), graphics);
            }
            ++ti;
        }
    }

    private void drawArrow_(Graphics graphics, DPoint3 p1, DPoint3 p2) {
        double dx = p1.x - p2.x;
        double dy = p1.y - p2.y;
        double length = Math.sqrt(dx * dx + dy * dy);
        DPoint p3 = new DPoint(p2.x, p2.y);
        double arrow_size = 8.0;
        p3.x += arrow_size / length * dx;
        p3.y += arrow_size / length * dy;
        DPoint p4 = new DPoint(p3.x, p3.y);
        p4.x = p4.x + arrow_size * (this.selected ? 0.9 : 0.4) / length * dy;
        p4.y = p4.y - arrow_size * (this.selected ? 0.9 : 0.4) / length * dx;
        p3.x = p3.x - arrow_size * (this.selected ? 0.9 : 0.4) / length * dy;
        p3.y = p3.y + arrow_size * (this.selected ? 0.9 : 0.4) / length * dx;
        graphics.setColor(this.LineColor);
        graphics.drawLine((int)p2.x, (int)p2.y, (int)p4.x, (int)p4.y);
        graphics.drawLine((int)p2.x, (int)p2.y, (int)p3.x, (int)p3.y);
    }

    public DPoint3[] points() {
        return this.points_;
    }

    public Node head() {
        return this.head_;
    }

    public Node tail() {
        return this.tail_;
    }

    public boolean isDummy() {
        return this.dummy_;
    }

    public void saveState() {
        this.oldpoints_ = new DPoint3[this.points_.length];
        int i = 0;
        while (i < this.points_.length) {
            this.oldpoints_[i] = new DPoint3(this.points_[i]);
            ++i;
        }
    }

    public void slide(int xoffs, int yoffs) {
        if (this.oldpoints_ == null) {
            return;
        }
        int i = 0;
        while (i < this.points_.length) {
            this.points_[i].move(this.oldpoints_[i]);
            this.points_[i].x += (double)xoffs;
            this.points_[i].y += (double)yoffs;
            ++i;
        }
    }

    public void overturn() {
        this.saveState();
        int i = 0;
        while (i < this.points_.length) {
            this.points_[i].move(this.oldpoints_[i]);
            this.points_[i].x = 2000.0 - this.points_[i].x;
            this.points_[i].y = 2000.0 - this.points_[i].y;
            ++i;
        }
    }

    public String getLabel() {
        return this.label_;
    }

    public void setLabel(String label) {
        if (label == null) {
            label = "";
        }
        this.label_ = label;
    }

    public String getScript() {
        return this.script_;
    }

    public void setScript(String label) {
        if (label == null) {
            label = "";
        }
        this.script_ = label;
    }

    public String getScript2() {
        return this.script2_;
    }

    public void setScript2(String label) {
        if (label == null) {
            label = "";
        }
        this.script2_ = label;
    }

    public String getScriptAfterSubmit() {
        return this.scriptAfterSubmit;
    }

    public void setScriptAfterSubmit(String label) {
        if (label == null) {
            label = "";
        }
        this.scriptAfterSubmit = label;
    }

    public Color getLineColor() {
        return this.LineColor;
    }

    public void setLineColor(Color lineColor) {
        this.LineColor = lineColor;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String s) {
        this.guid = s;
    }

    public int getGroupNo() {
        return this.groupno;
    }

    public void setGroupNo(int goupno) {
        this.groupno = goupno;
    }

    public String getReason1() {
        return Escape.unescape(this.reason1_);
    }

    public void setReason1(String reason1_) {
        if (reason1_ == null) {
            reason1_ = "";
        }
        if (reason1_.equals("")) {
            reason1_ = " ";
        }
        this.reason1_ = Escape.escape(reason1_);
    }

    public String getReason2() {
        return Escape.unescape(this.reason2_);
    }

    public void setReason2(String reason2_) {
        if (reason2_ == null) {
            reason2_ = "";
        }
        if (reason2_.equals("")) {
            reason2_ = " ";
        }
        this.reason2_ = Escape.escape(reason2_);
    }

    public String getThirdConfig() {
        return this.thirdConfig;
    }

    public void setThirdConfig(String thirdConfig) {
        if (thirdConfig == null) {
            thirdConfig = "";
        }
        this.thirdConfig = thirdConfig;
    }

    public int getScriptRunOnServer() {
        return this.scriptRunOnServer_;
    }

    public void setScriptRunOnServer(int scriptRunOnServer) {
        this.scriptRunOnServer_ = scriptRunOnServer;
    }

    public boolean isCheckedDefault() {
        return this.checkedDefault == 1;
    }

    public void setCheckedDefault(boolean checkedDefault_) {
        this.checkedDefault = checkedDefault_ ? 1 : 0;
    }

    public String getComment() {
        return Escape.unescape(this.comment_);
    }

    public void setComment(String comment) {
        if (comment == null) {
            comment = "";
        }
        this.comment_ = Escape.escape(comment);
    }
}

