/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.GenericReadHandler;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.SimpleObjectFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class RootXmlReadHandler
extends FrontendDefaultHandler {
    private Stack currentHandlers;
    private Stack outerScopes;
    private XmlReadHandler rootHandler;
    private HashMap objectRegistry = new HashMap();
    private SimpleObjectFactory classToHandlerMapping = new SimpleObjectFactory();
    private boolean rootHandlerInitialized;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;

    protected void addDefaultMappings() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        Class<?> clazz12;
        Class<?> clazz13;
        Class<?> clazz14;
        Class<?> clazz15;
        MultiplexMappingEntry[] paintEntries = new MultiplexMappingEntry[2];
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        paintEntries[0] = new MultiplexMappingEntry("color", clazz16.getName());
        Class<?> clazz17 = class$1;
        if (clazz17 == null) {
            try {
                clazz17 = class$1 = Class.forName("java.awt.GradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        paintEntries[1] = new MultiplexMappingEntry("gradientPaint", clazz17.getName());
        Class<?> clazz18 = class$2;
        if (clazz18 == null) {
            try {
                clazz18 = class$2 = Class.forName("java.awt.Paint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addMultiplexMapping(clazz18, "type", paintEntries);
        Class<?> clazz19 = class$0;
        if (clazz19 == null) {
            try {
                clazz19 = class$0 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz15 = class$3) == null) {
            try {
                clazz15 = class$3 = Class.forName("org.jfree.xml.parser.coretypes.ColorReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz19, clazz15);
        Class<?> clazz20 = class$1;
        if (clazz20 == null) {
            try {
                clazz20 = class$1 = Class.forName("java.awt.GradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz14 = class$4) == null) {
            try {
                clazz14 = class$4 = Class.forName("org.jfree.xml.parser.coretypes.GradientPaintReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz20, clazz14);
        MultiplexMappingEntry[] point2DEntries = new MultiplexMappingEntry[2];
        Class<?> clazz21 = class$5;
        if (clazz21 == null) {
            try {
                clazz21 = class$5 = Class.forName("java.awt.geom.Point2D$Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        point2DEntries[0] = new MultiplexMappingEntry("float", clazz21.getName());
        Class<?> clazz22 = class$6;
        if (clazz22 == null) {
            try {
                clazz22 = class$6 = Class.forName("java.awt.geom.Point2D$Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        point2DEntries[1] = new MultiplexMappingEntry("double", clazz22.getName());
        Class<?> clazz23 = class$7;
        if (clazz23 == null) {
            try {
                clazz23 = class$7 = Class.forName("java.awt.geom.Point2D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addMultiplexMapping(clazz23, "type", point2DEntries);
        Class<?> clazz24 = class$5;
        if (clazz24 == null) {
            try {
                clazz24 = class$5 = Class.forName("java.awt.geom.Point2D$Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz13 = class$8) == null) {
            try {
                clazz13 = class$8 = Class.forName("org.jfree.xml.parser.coretypes.Point2DReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz24, clazz13);
        Class<?> clazz25 = class$6;
        if (clazz25 == null) {
            try {
                clazz25 = class$6 = Class.forName("java.awt.geom.Point2D$Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz12 = class$8) == null) {
            try {
                clazz12 = class$8 = Class.forName("org.jfree.xml.parser.coretypes.Point2DReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz25, clazz12);
        MultiplexMappingEntry[] rectangle2DEntries = new MultiplexMappingEntry[2];
        Class<?> clazz26 = class$9;
        if (clazz26 == null) {
            try {
                clazz26 = class$9 = Class.forName("java.awt.geom.Rectangle2D$Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rectangle2DEntries[0] = new MultiplexMappingEntry("float", clazz26.getName());
        Class<?> clazz27 = class$10;
        if (clazz27 == null) {
            try {
                clazz27 = class$10 = Class.forName("java.awt.geom.Rectangle2D$Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        rectangle2DEntries[1] = new MultiplexMappingEntry("double", clazz27.getName());
        Class<?> clazz28 = class$11;
        if (clazz28 == null) {
            try {
                clazz28 = class$11 = Class.forName("java.awt.geom.Rectangle2D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addMultiplexMapping(clazz28, "type", rectangle2DEntries);
        Class<?> clazz29 = class$9;
        if (clazz29 == null) {
            try {
                clazz29 = class$9 = Class.forName("java.awt.geom.Rectangle2D$Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz11 = class$12) == null) {
            try {
                clazz11 = class$12 = Class.forName("org.jfree.xml.parser.coretypes.Rectangle2DReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz29, clazz11);
        Class<?> clazz30 = class$10;
        if (clazz30 == null) {
            try {
                clazz30 = class$10 = Class.forName("java.awt.geom.Rectangle2D$Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz10 = class$12) == null) {
            try {
                clazz10 = class$12 = Class.forName("org.jfree.xml.parser.coretypes.Rectangle2DReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz30, clazz10);
        MultiplexMappingEntry[] listEntries = new MultiplexMappingEntry[4];
        Class<?> clazz31 = class$13;
        if (clazz31 == null) {
            try {
                clazz31 = class$13 = Class.forName("java.util.ArrayList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listEntries[0] = new MultiplexMappingEntry("array-list", clazz31.getName());
        Class<?> clazz32 = class$14;
        if (clazz32 == null) {
            try {
                clazz32 = class$14 = Class.forName("java.util.LinkedList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listEntries[1] = new MultiplexMappingEntry("linked-list", clazz32.getName());
        Class<?> clazz33 = class$15;
        if (clazz33 == null) {
            try {
                clazz33 = class$15 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listEntries[2] = new MultiplexMappingEntry("vector", clazz33.getName());
        Class<?> clazz34 = class$16;
        if (clazz34 == null) {
            try {
                clazz34 = class$16 = Class.forName("java.util.Stack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        listEntries[3] = new MultiplexMappingEntry("stack", clazz34.getName());
        Class<?> clazz35 = class$17;
        if (clazz35 == null) {
            try {
                clazz35 = class$17 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addMultiplexMapping(clazz35, "type", listEntries);
        Class<?> clazz36 = class$14;
        if (clazz36 == null) {
            try {
                clazz36 = class$14 = Class.forName("java.util.LinkedList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz9 = class$18) == null) {
            try {
                clazz9 = class$18 = Class.forName("org.jfree.xml.parser.coretypes.ListReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz36, clazz9);
        Class<?> clazz37 = class$15;
        if (clazz37 == null) {
            try {
                clazz37 = class$15 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz8 = class$18) == null) {
            try {
                clazz8 = class$18 = Class.forName("org.jfree.xml.parser.coretypes.ListReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz37, clazz8);
        Class<?> clazz38 = class$13;
        if (clazz38 == null) {
            try {
                clazz38 = class$13 = Class.forName("java.util.ArrayList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz7 = class$18) == null) {
            try {
                clazz7 = class$18 = Class.forName("org.jfree.xml.parser.coretypes.ListReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz38, clazz7);
        Class<?> clazz39 = class$16;
        if (clazz39 == null) {
            try {
                clazz39 = class$16 = Class.forName("java.util.Stack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz6 = class$18) == null) {
            try {
                clazz6 = class$18 = Class.forName("org.jfree.xml.parser.coretypes.ListReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz39, clazz6);
        MultiplexMappingEntry[] strokeEntries = new MultiplexMappingEntry[1];
        Class<?> clazz40 = class$19;
        if (clazz40 == null) {
            try {
                clazz40 = class$19 = Class.forName("java.awt.BasicStroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        strokeEntries[0] = new MultiplexMappingEntry("basic", clazz40.getName());
        Class<?> clazz41 = class$20;
        if (clazz41 == null) {
            try {
                clazz41 = class$20 = Class.forName("java.awt.Stroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addMultiplexMapping(clazz41, "type", strokeEntries);
        Class<?> clazz42 = class$19;
        if (clazz42 == null) {
            try {
                clazz42 = class$19 = Class.forName("java.awt.BasicStroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz5 = class$21) == null) {
            try {
                clazz5 = class$21 = Class.forName("org.jfree.xml.parser.coretypes.BasicStrokeReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz42, clazz5);
        Class<?> clazz43 = class$22;
        if (clazz43 == null) {
            try {
                clazz43 = class$22 = Class.forName("java.awt.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz4 = class$23) == null) {
            try {
                clazz4 = class$23 = Class.forName("org.jfree.xml.parser.coretypes.FontReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz43, clazz4);
        Class<?> clazz44 = class$24;
        if (clazz44 == null) {
            try {
                clazz44 = class$24 = Class.forName("java.awt.Insets");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz3 = class$25) == null) {
            try {
                clazz3 = class$25 = Class.forName("org.jfree.xml.parser.coretypes.InsetsReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz44, clazz3);
        Class<?> clazz45 = class$26;
        if (clazz45 == null) {
            try {
                clazz45 = class$26 = Class.forName("java.awt.RenderingHints");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz2 = class$27) == null) {
            try {
                clazz2 = class$27 = Class.forName("org.jfree.xml.parser.coretypes.RenderingHintsReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz45, clazz2);
        Class<?> clazz46 = class$28;
        if (clazz46 == null) {
            try {
                clazz46 = class$28 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((clazz = class$29) == null) {
            try {
                clazz = class$29 = Class.forName("org.jfree.xml.parser.coretypes.StringReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addManualMapping(clazz46, clazz);
    }

    public abstract ObjectFactory getFactoryLoader();

    protected void addManualMapping(Class classToRead, Class handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (classToRead == null) {
            throw new NullPointerException("classToRead must not be null.");
        }
        Class<?> clazz = class$30;
        if (clazz == null) {
            try {
                clazz = class$30 = Class.forName("org.jfree.xml.parser.XmlReadHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(handler)) {
            throw new IllegalArgumentException("The given handler is no XmlReadHandler.");
        }
        this.classToHandlerMapping.addManualMapping(new ManualMappingDefinition(classToRead, handler.getName(), null));
    }

    protected void addMultiplexMapping(Class baseClass, String typeAttr, MultiplexMappingEntry[] mdef) {
        this.classToHandlerMapping.addMultiplexMapping(new MultiplexMappingDefinition(baseClass, typeAttr, mdef));
    }

    public void setHelperObject(String key, Object value) {
        if (value == null) {
            this.objectRegistry.remove(key);
        } else {
            this.objectRegistry.put(key, value);
        }
    }

    public Object getHelperObject(String key) {
        return this.objectRegistry.get(key);
    }

    public XmlReadHandler createHandler(Class classToRead, String tagName, Attributes atts) throws XmlReaderException {
        XmlReadHandler retval = this.findHandlerForClass(classToRead, atts, new ArrayList());
        if (retval == null) {
            throw new NullPointerException("Unable to find handler for class: " + classToRead);
        }
        retval.init(this, tagName);
        return retval;
    }

    private XmlReadHandler findHandlerForClass(Class classToRead, Attributes atts, ArrayList history) throws XmlReaderException {
        ObjectFactory genericFactory = this.getFactoryLoader();
        if (history.contains(classToRead)) {
            throw new IllegalStateException("Circular reference detected: " + history);
        }
        history.add(classToRead);
        ManualMappingDefinition manualDefinition = this.classToHandlerMapping.getManualMappingDefinition(classToRead);
        if (manualDefinition == null) {
            manualDefinition = genericFactory.getManualMappingDefinition(classToRead);
        }
        if (manualDefinition != null) {
            return this.loadHandlerClass(manualDefinition.getReadHandler());
        }
        MultiplexMappingDefinition mplex = this.getFactoryLoader().getMultiplexDefinition(classToRead);
        if (mplex == null) {
            mplex = this.classToHandlerMapping.getMultiplexDefinition(classToRead);
        }
        if (mplex != null) {
            String attributeValue = atts.getValue(mplex.getAttributeName());
            if (attributeValue == null) {
                throw new XmlReaderException("Multiplexer type attribute is not defined: " + mplex.getAttributeName() + " for " + classToRead);
            }
            MultiplexMappingEntry entry = mplex.getEntryForType(attributeValue);
            if (entry == null) {
                throw new XmlReaderException("Invalid type attribute value: " + mplex.getAttributeName() + " = " + attributeValue);
            }
            Class c = this.loadClass(entry.getTargetClass());
            if (!c.equals(mplex.getBaseClass())) {
                return this.findHandlerForClass(c, atts, history);
            }
        }
        if (this.classToHandlerMapping.isGenericHandler(classToRead)) {
            return new GenericReadHandler(this.classToHandlerMapping.getFactoryForClass(classToRead));
        }
        if (this.getFactoryLoader().isGenericHandler(classToRead)) {
            return new GenericReadHandler(this.getFactoryLoader().getFactoryForClass(classToRead));
        }
        return null;
    }

    protected void setRootHandler(XmlReadHandler handler) {
        this.rootHandler = handler;
        this.rootHandlerInitialized = false;
    }

    protected XmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public void recurse(XmlReadHandler handler, String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        this.outerScopes.push(this.currentHandlers);
        this.currentHandlers = new Stack();
        this.currentHandlers.push(handler);
        handler.startElement(tagName, attrs);
    }

    public void delegate(XmlReadHandler handler, String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        this.currentHandlers.push(handler);
        handler.init(this, tagName);
        handler.startElement(tagName, attrs);
    }

    public void unwind(String tagName) throws SAXException, XmlReaderException {
        this.currentHandlers.pop();
        if (this.currentHandlers.isEmpty() && !this.outerScopes.isEmpty()) {
            this.currentHandlers = (Stack)this.outerScopes.pop();
        } else if (!this.currentHandlers.isEmpty()) {
            this.getCurrentHandler().endElement(tagName);
        }
    }

    protected XmlReadHandler getCurrentHandler() {
        return (XmlReadHandler)this.currentHandlers.peek();
    }

    public void startDocument() throws SAXException {
        this.outerScopes = new Stack();
        this.currentHandlers = new Stack();
        this.currentHandlers.push(this.rootHandler);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.rootHandlerInitialized) {
            this.rootHandler.init(this, qName);
            this.rootHandlerInitialized = true;
        }
        try {
            this.getCurrentHandler().startElement(qName, attributes);
        }
        catch (XmlReaderException xre) {
            throw new ParseException(xre, this.getLocator());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getCurrentHandler().characters(ch, start, length);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ParseException(e, this.getLocator());
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.getCurrentHandler().endElement(qName);
        }
        catch (XmlReaderException xre) {
            throw new ParseException(xre, this.getLocator());
        }
    }

    protected XmlReadHandler loadHandlerClass(String className) throws XmlReaderException {
        try {
            Class c = this.loadClass(className);
            return (XmlReadHandler)c.newInstance();
        }
        catch (Exception e) {
            throw new XmlReaderException("LoadHanderClass: Unable to instantiate " + className, e);
        }
    }

    protected Class loadClass(String className) throws XmlReaderException {
        if (className == null) {
            throw new XmlReaderException("LoadHanderClass: Class name not defined");
        }
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            return c;
        }
        catch (Exception e) {
            throw new XmlReaderException("LoadHanderClass: Unable to load " + className, e);
        }
    }

    public Object getResult() throws SAXException {
        if (this.rootHandler != null) {
            try {
                return this.rootHandler.getObject();
            }
            catch (XmlReaderException e) {
                throw new ElementDefinitionException(e);
            }
        }
        return null;
    }
}

