/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import jun.db.util.Base64Coder;
import netscape.javascript.JSObject;
import org.json.JSONArray;
import org.json.JSONObject;

public class AppletMenu
extends JApplet {
    public Color menuItemBackgroundColor = new Color(0xFFFFFF);

    public void addMenu(Object m, JSONArray items, boolean isMainLevel) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length()) {
            JMenuItem mi;
            JSONObject item = items.getJSONObject(i);
            String type = item.getString("type", "leaf");
            String name = item.getString("name", "");
            String url = item.getString("url", "");
            String img = item.getString("img", "");
            System.out.println(String.valueOf(name) + " url:" + url);
            String target = item.getString("target", "");
            if (type.equals("leaf")) {
                mi = new JMenuItem(name);
                mi.addActionListener(new MenuOnClick(img, name, url, target, this));
                if (m instanceof JMenuBar) {
                    ((JMenuBar)m).add(mi);
                }
                if (m instanceof JMenu) {
                    ((JMenu)m).add(mi);
                }
            } else {
                mi = new JMenu(name);
                if (m instanceof JMenuBar) {
                    ((JMenuBar)m).add((JMenu)mi);
                }
                if (m instanceof JMenu) {
                    ((JMenu)m).add(mi);
                }
                this.addMenu(mi, item.getJSONArray("submenu", null), false);
                if (isMainLevel) {
                    mi.setOpaque(true);
                    mi.setBackground(this.menuItemBackgroundColor);
                }
            }
            ++i;
        }
    }

    public JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        String s = this.getParameter("menu");
        s = Base64Coder.decode((String)s);
        JSONArray config = new JSONArray(s);
        String t = this.getParameter("height");
        int height = Integer.valueOf(t);
        menuBar.setOpaque(true);
        menuBar.setBackground(this.menuItemBackgroundColor);
        menuBar.setBorder(null);
        this.addMenu(menuBar, config, true);
        JPanel menuBar1 = new JPanel();
        menuBar1.setBorder(null);
        menuBar1.setBackground(this.menuItemBackgroundColor);
        menuBar1.setOpaque(true);
        menuBar1.setPreferredSize(new Dimension(2000, height));
        JMenuBar menuBar2 = new JMenuBar();
        menuBar2.setLayout(new BorderLayout());
        menuBar2.add((Component)menuBar1, "Center");
        menuBar1.add(menuBar);
        return menuBar2;
    }

    public void init() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            AppletMenu.initAllFontSon9();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AppletMenu.this.initMenu();
            }
        });
    }

    public void initMenu() {
        String s = this.getParameter("backgroundcolor");
        this.menuItemBackgroundColor = AppletMenu.Hex2Color(s);
        this.setJMenuBar(this.createMenuBar());
        Container cc = this.getContentPane();
        cc.setBackground(this.menuItemBackgroundColor);
        this.repaint();
    }

    public static Color Hex2Color(String c) {
        try {
            Color color = Color.decode(c);
            return color;
        }
        catch (Exception e) {
            return Color.BLACK;
        }
    }

    public static void initAllFontSon9() {
        try {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            Font f1 = new Font("SimSun", 0, 12);
            Font f2 = new Font("SimSun", 1, 12);
            AppletMenu.initFontDefaults(table, f1, f2, f1, f1, f1, f1, f1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initFontDefaults(UIDefaults table, Object controlFont, Object controlBoldFont, Object fixedControlFont, Object menuFont, Object messageFont, Object toolTipFont, Object windowFont) {
        Object[] defaults = new Object[]{"Button.font", controlFont, "CheckBox.font", controlFont, "ColorChooser.font", controlFont, "ComboBox.font", controlFont, "EditorPane.font", controlFont, "FormattedTextField.font", controlFont, "Label.font", controlFont, "List.font", controlFont, "Panel.font", controlFont, "PasswordField.font", controlFont, "ProgressBar.font", controlFont, "RadioButton.font", controlFont, "ScrollPane.font", controlFont, "Spinner.font", controlFont, "TabbedPane.font", controlFont, "Table.font", controlFont, "TableHeader.font", controlFont, "TextField.font", controlFont, "TextPane.font", controlFont, "ToolBar.font", controlFont, "ToggleButton.font", controlFont, "Tree.font", controlFont, "Viewport.font", controlFont, "InternalFrame.titleFont", windowFont, "OptionPane.font", messageFont, "OptionPane.messageFont", messageFont, "OptionPane.buttonFont", messageFont, "Spinner.font", fixedControlFont, "TextArea.font", fixedControlFont, "TitledBorder.font", controlBoldFont, "ToolTip.font", toolTipFont};
        table.putDefaults(defaults);
        if (menuFont != null) {
            Object[] menuDefaults = new Object[]{"CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "MenuBar.font", menuFont, "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "PopupMenu.font", menuFont, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont};
            table.putDefaults(menuDefaults);
        }
    }

    public static void main(String[] args) {
        AppletMenu demo = new AppletMenu();
        demo.setSize(450, 260);
        demo.setVisible(true);
    }

    class MenuOnClick
    implements ActionListener {
        String img;
        String name;
        String target;
        String url;
        JApplet applet;

        public MenuOnClick(String img_, String name_, String url_, String target_, JApplet applet_) {
            this.img = img_;
            this.name = name_;
            this.url = url_;
            this.target = target_;
            this.applet = applet_;
        }

        public void actionPerformed(ActionEvent e) {
            JSObject win = JSObject.getWindow((Applet)this.applet);
            Object ret = win.call("openURL", this.img, this.name, this.url, this.target);
        }
    }
}

