/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.DateCell;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.format.CellFormat;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.SheetImpl;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.DataValidation;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadDateFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(WritableSheetImpl.class);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean chartOnly;
    private DataValidation dataValidation;
    private ArrayList rowBreaks;
    private ArrayList drawings;
    private ArrayList images;
    private boolean drawingsModified;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final int maxSheetNameLength = 31;
    private static final char[] illegalSheetNameCharacters = new char[]{'*', ':', '?', '\\'};
    private static final String[] imageTypes = new String[]{"png"};
    static /* synthetic */ Class class$0;

    public WritableSheetImpl(String n, File of, FormattingRecords fr, SharedStrings ss, WorkbookSettings ws, WritableWorkbookImpl ww) {
        this.name = this.validateName(n);
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = ww;
        this.formatRecords = fr;
        this.sharedStrings = ss;
        this.workbookSettings = ws;
        this.drawingsModified = false;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.images = new ArrayList();
        this.settings = new SheetSettings();
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    public WritableCell getWritableCell(int column, int row) {
        WritableCell c = null;
        if (row < this.rows.length && this.rows[row] != null) {
            c = this.rows[row].getCell(column);
        }
        if (c == null) {
            c = new EmptyCell(column, row);
        }
        return c;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if (row[j].getContents().equals(contents)) {
                    cell = row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.getRows() && !found) {
            Cell[] row = this.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if ((row[j].getType() == CellType.LABEL || row[j].getType() == CellType.STRING_FORMULA) && row[j].getContents().equals(contents)) {
                    cell = (LabelCell)row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.numColumns - 1;
        while (col >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        int i = 0;
        while (i <= col) {
            cells[i] = this.getCell(i, row);
            ++i;
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        int i = 0;
        while (i <= row) {
            cells[i] = this.getCell(col, i);
            ++i;
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    public void insertRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.numRows - row);
        int i = row + 1;
        while (i <= this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].incrementRow();
            }
            ++i;
        }
        HyperlinkRecord hr2 = null;
        for (HyperlinkRecord hr2 : this.hyperlinks) {
            hr2.insertRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertRow(row);
        }
        this.mergedCells.insertRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= row) {
                ++val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, row);
        }
        ++this.numRows;
    }

    public void insertColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        int i = 0;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].insertColumn(col);
            }
            ++i;
        }
        HyperlinkRecord hr2 = null;
        for (HyperlinkRecord hr2 : this.hyperlinks) {
            hr2.insertColumn(col);
        }
        for (ColumnInfoRecord cir : this.columnFormats) {
            if (cir.getColumn() < col) continue;
            cir.incrementColumn();
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertColumn(col);
        }
        this.mergedCells.insertColumn(col);
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, col);
        }
        ++this.numColumns;
    }

    public void removeColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        int i = 0;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].removeColumn(col);
            }
            ++i;
        }
        HyperlinkRecord hr2 = null;
        for (HyperlinkRecord hr2 : this.hyperlinks) {
            if (hr2.getColumn() == col && hr2.getLastColumn() == col) {
                this.hyperlinks.remove(this.hyperlinks.indexOf(hr2));
                continue;
            }
            hr2.removeColumn(col);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeColumn(col);
        }
        this.mergedCells.removeColumn(col);
        Iterator i2 = this.columnFormats.iterator();
        ColumnInfoRecord removeColumn = null;
        while (i2.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i2.next();
            if (cir.getColumn() == col) {
                removeColumn = cir;
                continue;
            }
            if (cir.getColumn() <= col) continue;
            cir.decrementColumn();
        }
        if (removeColumn != null) {
            this.columnFormats.remove(removeColumn);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, col);
        }
        --this.numColumns;
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.numRows - (row + 1));
        int i = row;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].decrementRow();
            }
            ++i;
        }
        HyperlinkRecord hr = null;
        Iterator i2 = this.hyperlinks.iterator();
        while (i2.hasNext()) {
            hr = (HyperlinkRecord)i2.next();
            if (hr.getRow() == row && hr.getLastRow() == row) {
                i2.remove();
                continue;
            }
            hr.removeRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeRow(row);
        }
        this.mergedCells.removeRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == row) continue;
            if (val > row) {
                --val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, row);
        }
        --this.numRows;
    }

    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        CellValue cv = (CellValue)cell;
        if (cv.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.addCell(cv);
        this.numRows = Math.max(row + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowrec.getMaxColumn());
        cv.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    private RowRecord getRowRecord(int row) throws RowsExceededException {
        RowRecord rowrec;
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row);
        }
        return rowrec;
    }

    RowRecord getRowInfo(int r) {
        if (r < 0 || r > this.rows.length) {
            return null;
        }
        return this.rows[r];
    }

    ColumnInfoRecord getColumnInfo(int c) {
        Iterator i = this.columnFormats.iterator();
        ColumnInfoRecord cir = null;
        boolean stop = false;
        while (i.hasNext() && !stop) {
            cir = (ColumnInfoRecord)i.next();
            if (cir.getColumn() < c) continue;
            stop = true;
        }
        if (!stop) {
            return null;
        }
        return cir.getColumn() == c ? cir : null;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setHidden(boolean h) {
        this.settings.setHidden(h);
    }

    public void setProtected(boolean prot) {
        this.settings.setProtected(prot);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    public boolean isHidden() {
        return this.settings.isHidden();
    }

    public void setColumnView(int col, int width) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, int width, CellFormat format) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        cv.setFormat(format);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, CellView view) {
        block7: {
            XFRecord xfr = (XFRecord)view.getFormat();
            if (xfr == null) {
                xfr = WritableWorkbookImpl.NORMAL_STYLE;
            }
            try {
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                int width = view.depUsed() ? view.getDimension() * 256 : view.getSize();
                ColumnInfoRecord cir = new ColumnInfoRecord(col, width, xfr);
                if (view.isHidden()) {
                    cir.setHidden(true);
                }
                if (!this.columnFormats.contains(cir)) {
                    this.columnFormats.add(cir);
                } else {
                    boolean removed = this.columnFormats.remove(cir);
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException e) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord cir = new ColumnInfoRecord(col, view.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block7;
                this.columnFormats.add(cir);
            }
        }
    }

    public void setRowView(int row, int height) throws RowsExceededException {
        this.setRowView(row, height, false);
    }

    public void setRowView(int row, boolean collapsed) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.setCollapsed(collapsed);
    }

    public void setRowView(int row, int height, boolean collapsed) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.setRowHeight(height);
        rowrec.setCollapsed(collapsed);
    }

    public void write() throws IOException {
        boolean dmod = this.drawingsModified;
        if (this.workbook.getDrawingGroup() != null) {
            dmod |= this.workbook.getDrawingGroup().hasDrawingsOmitted();
        }
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings, dmod);
        this.sheetWriter.setButtonPropertySet(this.buttonPropertySet);
        this.sheetWriter.setDataValidation(this.dataValidation);
        this.sheetWriter.write();
    }

    private void copyCells(Sheet s) {
        int cells = s.getRows();
        Cell[] row = null;
        Cell cell = null;
        int i = 0;
        while (i < cells) {
            row = s.getRow(i);
            int j = 0;
            while (j < row.length) {
                cell = row[j];
                CellType ct = cell.getType();
                try {
                    ReadFormulaRecord fr;
                    CellValue b;
                    if (ct == CellType.LABEL) {
                        Label l = new Label((LabelCell)cell);
                        this.addCell(l);
                    } else if (ct == CellType.NUMBER) {
                        Number n = new Number((NumberCell)cell);
                        this.addCell(n);
                    } else if (ct == CellType.DATE) {
                        DateTime dt = new DateTime((DateCell)cell);
                        this.addCell(dt);
                    } else if (ct == CellType.BOOLEAN) {
                        b = new Boolean((BooleanCell)cell);
                        this.addCell(b);
                    } else if (ct == CellType.NUMBER_FORMULA) {
                        fr = new ReadNumberFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                    } else if (ct == CellType.STRING_FORMULA) {
                        fr = new ReadStringFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                    } else if (ct == CellType.BOOLEAN_FORMULA) {
                        fr = new ReadBooleanFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                    } else if (ct == CellType.DATE_FORMULA) {
                        fr = new ReadDateFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                    } else if (ct == CellType.FORMULA_ERROR) {
                        fr = new ReadErrorFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                    } else if (ct == CellType.EMPTY && cell.getCellFormat() != null) {
                        b = new Blank(cell);
                        this.addCell(b);
                    }
                }
                catch (WriteException e) {
                    Assert.verify(false);
                }
                ++j;
            }
            ++i;
        }
    }

    void copy(Sheet s) {
        jxl.read.biff.DataValidation rdv;
        this.settings = new SheetSettings(s.getSettings());
        this.copyCells(s);
        SheetImpl si = (SheetImpl)s;
        jxl.read.biff.ColumnInfoRecord[] readCirs = si.getColumnInfos();
        int i = 0;
        while (i < readCirs.length) {
            jxl.read.biff.ColumnInfoRecord rcir = readCirs[i];
            int j = rcir.getStartColumn();
            while (j <= rcir.getEndColumn()) {
                ColumnInfoRecord cir = new ColumnInfoRecord(rcir, j, this.formatRecords);
                cir.setHidden(rcir.getHidden());
                this.columnFormats.add(cir);
                ++j;
            }
            ++i;
        }
        Hyperlink[] hls = s.getHyperlinks();
        int i2 = 0;
        while (i2 < hls.length) {
            WritableHyperlink hr = new WritableHyperlink(hls[i2], this);
            this.hyperlinks.add(hr);
            ++i2;
        }
        Range[] merged = s.getMergedCells();
        int i3 = 0;
        while (i3 < merged.length) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i3], this));
            ++i3;
        }
        try {
            jxl.read.biff.RowRecord[] rowprops = si.getRowProperties();
            int i4 = 0;
            while (i4 < rowprops.length) {
                RowRecord rr = this.getRowRecord(rowprops[i4].getRowNumber());
                XFRecord format = rowprops[i4].hasDefaultFormat() ? this.formatRecords.getXFRecord(rowprops[i4].getXFIndex()) : null;
                rr.setRowDetails(rowprops[i4].getRowHeight(), rowprops[i4].matchesDefaultFontHeight(), rowprops[i4].isCollapsed(), format);
                ++i4;
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        int[] rowbreaks = si.getRowPageBreaks();
        if (rowbreaks != null) {
            int i5 = 0;
            while (i5 < rowbreaks.length) {
                this.rowBreaks.add(new Integer(rowbreaks[i5]));
                ++i5;
            }
        }
        if ((rdv = si.getDataValidation()) != null) {
            this.dataValidation = new DataValidation(rdv, this.workbook, this.workbookSettings);
        }
        this.sheetWriter.setCharts(si.getCharts());
        DrawingGroupObject[] dr = si.getDrawings();
        int i6 = 0;
        while (i6 < dr.length) {
            if (dr[i6] instanceof Drawing) {
                WritableImage wi = new WritableImage(dr[i6], this.workbook.getDrawingGroup());
                this.drawings.add(wi);
                this.images.add(wi);
            } else if (dr[i6] instanceof Comment) {
                Comment c = new Comment(dr[i6], this.workbook.getDrawingGroup(), this.workbookSettings);
                this.drawings.add(c);
                CellValue cv = (CellValue)this.getWritableCell(c.getColumn(), c.getRow());
                Assert.verify(cv.getCellFeatures() != null);
                cv.getWritableCellFeatures().setCommentDrawing(c);
            }
            ++i6;
        }
        this.sheetWriter.setWorkspaceOptions(si.getWorkspaceOptions());
        if (si.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (si.getPLS() != null) {
            this.plsRecord = new PLSRecord(si.getPLS());
        }
        if (si.getButtonPropertySet() != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(si.getButtonPropertySet());
        }
    }

    void copy(WritableSheet s) {
        this.settings = new SheetSettings(s.getSettings());
        this.copyCells(s);
        this.columnFormats = ((WritableSheetImpl)s).columnFormats;
        Range[] merged = s.getMergedCells();
        int i = 0;
        while (i < merged.length) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i], this));
            ++i;
        }
        try {
            RowRecord[] copyRows = ((WritableSheetImpl)s).rows;
            RowRecord row = null;
            int i2 = 0;
            while (i2 < copyRows.length) {
                row = copyRows[i2];
                if (row != null && (!row.isDefaultHeight() || row.isCollapsed())) {
                    RowRecord rr = this.getRowRecord(i2);
                    rr.setRowDetails(row.getRowHeight(), row.matchesDefaultFontHeight(), row.isCollapsed(), row.getStyle());
                }
                ++i2;
            }
        }
        catch (RowsExceededException e) {
            Assert.verify(false);
        }
        WritableSheetImpl si = (WritableSheetImpl)s;
        this.rowBreaks = new ArrayList(si.rowBreaks);
        DataValidation rdv = si.dataValidation;
        if (rdv != null) {
            this.dataValidation = new DataValidation(rdv, this.workbook, this.workbookSettings);
        }
        this.sheetWriter.setCharts(si.getCharts());
        DrawingGroupObject[] dr = si.getDrawings();
        int i3 = 0;
        while (i3 < dr.length) {
            if (dr[i3] instanceof Drawing) {
                WritableImage wi = new WritableImage(dr[i3], this.workbook.getDrawingGroup());
                this.drawings.add(wi);
                this.images.add(wi);
            } else if (dr[i3] instanceof Comment) {
                Comment c = new Comment(dr[i3], this.workbook.getDrawingGroup(), this.workbookSettings);
                this.drawings.add(c);
            }
            ++i3;
        }
        this.sheetWriter.setWorkspaceOptions(si.getWorkspaceOptions());
        if (si.plsRecord != null) {
            this.plsRecord = new PLSRecord(si.plsRecord);
        }
        if (si.buttonPropertySet != null) {
            this.buttonPropertySet = new ButtonPropertySetRecord(si.buttonPropertySet);
        }
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        int i = 0;
        while (i < this.hyperlinks.size()) {
            hl[i] = (Hyperlink)this.hyperlinks.get(i);
            ++i;
        }
        return hl;
    }

    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] hl = new WritableHyperlink[this.hyperlinks.size()];
        int i = 0;
        while (i < this.hyperlinks.size()) {
            hl[i] = (WritableHyperlink)this.hyperlinks.get(i);
            ++i;
        }
        return hl;
    }

    public void removeHyperlink(WritableHyperlink h) {
        this.removeHyperlink(h, false);
    }

    public void removeHyperlink(WritableHyperlink h, boolean preserveLabel) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(h));
        if (!preserveLabel) {
            Assert.verify(this.rows.length > h.getRow() && this.rows[h.getRow()] != null);
            this.rows[h.getRow()].removeCell(h.getColumn());
        }
    }

    public void addHyperlink(WritableHyperlink h) throws WriteException, RowsExceededException {
        Label l;
        String cnts;
        Cell c = this.getCell(h.getColumn(), h.getRow());
        String contents = null;
        if (h.isFile() || h.isUNC()) {
            cnts = h.getContents();
            contents = cnts == null ? h.getFile().getPath() : cnts;
        } else if (h.isURL()) {
            cnts = h.getContents();
            contents = cnts == null ? h.getURL().toString() : cnts;
        } else if (h.isLocation()) {
            contents = h.getContents();
        }
        if (c.getType() == CellType.LABEL) {
            l = (Label)c;
            l.setString(contents);
            l.setCellFormat(WritableWorkbook.HYPERLINK_STYLE);
        } else {
            l = new Label(h.getColumn(), h.getRow(), contents, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell(l);
        }
        int i = h.getRow();
        while (i <= h.getLastRow()) {
            int j = h.getColumn();
            while (j <= h.getLastColumn()) {
                if (i != h.getRow() && j != h.getColumn() && this.rows[i] != null) {
                    this.rows[i].removeCell(j);
                }
                ++j;
            }
            ++i;
        }
        h.initialize(this);
        this.hyperlinks.add(h);
    }

    public Range mergeCells(int col1, int row1, int col2, int row2) throws WriteException, RowsExceededException {
        if (col2 < col1 || row2 < row1) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (col2 >= this.numColumns || row2 >= this.numRows) {
            this.addCell(new Blank(col2, row2));
        }
        SheetRangeImpl range = new SheetRangeImpl(this, col1, row1, col2, row2);
        this.mergedCells.add(range);
        return range;
    }

    public void unmergeCells(Range r) {
        this.mergedCells.unmergeCells(r);
    }

    public void setHeader(String l, String c, String r) {
        HeaderFooter header = new HeaderFooter();
        header.getLeft().append(l);
        header.getCentre().append(c);
        header.getRight().append(r);
        this.settings.setHeader(header);
    }

    public void setFooter(String l, String c, String r) {
        HeaderFooter footer = new HeaderFooter();
        footer.getLeft().append(l);
        footer.getCentre().append(c);
        footer.getRight().append(r);
        this.settings.setFooter(footer);
    }

    public void setPageSetup(PageOrientation p) {
        this.settings.setOrientation(p);
    }

    public void setPageSetup(PageOrientation p, double hm, double fm) {
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public void setPageSetup(PageOrientation p, PaperSize ps, double hm, double fm) {
        this.settings.setPaperSize(ps);
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public void addRowPageBreak(int row) {
        Iterator i = this.rowBreaks.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            if ((Integer)i.next() != row) continue;
            found = true;
        }
        if (!found) {
            this.rowBreaks.add(new Integer(row));
        }
    }

    private Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    private DrawingGroupObject[] getDrawings() {
        DrawingGroupObject[] dr = new DrawingGroupObject[this.drawings.size()];
        System.arraycopy(this.drawings.toArray(), 0, dr, 0, dr.length);
        return dr;
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        for (ColumnInfoRecord cir : this.columnFormats) {
            cir.rationalize(xfMapping);
        }
        int i = 0;
        while (i < this.rows.length) {
            if (this.rows[i] != null) {
                this.rows[i].rationalize(xfMapping);
            }
            ++i;
        }
        Chart[] charts = this.getCharts();
        int c = 0;
        while (c < charts.length) {
            charts[c].rationalize(xfMapping, fontMapping, formatMapping);
            ++c;
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int col) {
        return this.getColumnView(col).getFormat();
    }

    public int getColumnWidth(int col) {
        return this.getColumnView(col).getDimension();
    }

    public int getRowHeight(int row) {
        return this.getRowView(row).getDimension();
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    public CellView getRowView(int row) {
        CellView cv = new CellView();
        try {
            RowRecord rr = this.getRowRecord(row);
            if (rr == null || rr.isDefaultHeight()) {
                cv.setDimension(this.settings.getDefaultRowHeight());
                cv.setSize(this.settings.getDefaultRowHeight());
            } else if (rr.isCollapsed()) {
                cv.setHidden(true);
            } else {
                cv.setDimension(rr.getRowHeight());
                cv.setSize(rr.getRowHeight());
            }
            return cv;
        }
        catch (RowsExceededException e) {
            cv.setDimension(this.settings.getDefaultRowHeight());
            cv.setSize(this.settings.getDefaultRowHeight());
            return cv;
        }
    }

    public CellView getColumnView(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        CellView cv = new CellView();
        if (cir != null) {
            cv.setDimension(cir.getWidth() / 256);
            cv.setSize(cir.getWidth());
            cv.setHidden(cir.getHidden());
            cv.setFormat(cir.getCellFormat());
        } else {
            cv.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cv.setSize(this.settings.getDefaultColumnWidth());
        }
        return cv;
    }

    public void addImage(WritableImage image) {
        boolean supported = false;
        java.io.File imageFile = image.getImageFile();
        String fileType = "?";
        if (imageFile != null) {
            String fileName = imageFile.getName();
            int fileTypeIndex = fileName.lastIndexOf(46);
            fileType = fileTypeIndex != -1 ? fileName.substring(fileTypeIndex + 1) : "";
            int i = 0;
            while (i < imageTypes.length && !supported) {
                if (fileType.equalsIgnoreCase(imageTypes[i])) {
                    supported = true;
                }
                ++i;
            }
        } else {
            supported = true;
        }
        if (supported) {
            this.workbook.addDrawing(image);
            this.drawings.add(image);
            this.images.add(image);
        } else {
            StringBuffer message = new StringBuffer("Image type ");
            message.append(fileType);
            message.append(" not supported.  Supported types are ");
            message.append(imageTypes[0]);
            int i = 1;
            while (i < imageTypes.length) {
                message.append(", ");
                message.append(imageTypes[i]);
                ++i;
            }
            logger.warn(message.toString());
        }
    }

    public int getNumberOfImages() {
        return this.images.size();
    }

    public WritableImage getImage(int i) {
        return (WritableImage)this.images.get(i);
    }

    public Image getDrawing(int i) {
        return (Image)this.images.get(i);
    }

    public void removeImage(WritableImage wi) {
        boolean removed = this.drawings.remove(wi);
        this.images.remove(wi);
        this.drawingsModified = true;
        this.workbook.removeDrawing(wi);
    }

    private String validateName(String n) {
        if (n.length() > 31) {
            logger.warn("Sheet name " + n + " too long - truncating");
            n = n.substring(0, 31);
        }
        if (n.charAt(0) == '\'') {
            logger.warn("Sheet naming cannot start with ' - removing");
            n = n.substring(1);
        }
        int i = 0;
        while (i < illegalSheetNameCharacters.length) {
            String newname = n.replace(illegalSheetNameCharacters[i], '@');
            if (n != newname) {
                logger.warn(String.valueOf(illegalSheetNameCharacters[i]) + " is not a valid character within a sheet name - replacing");
            }
            n = newname;
            ++i;
        }
        return n;
    }

    void addDrawing(DrawingGroupObject o) {
        this.drawings.add(o);
        Assert.verify(!(o instanceof Drawing));
    }

    private static class ColumnInfoComparator
    implements Comparator {
        ColumnInfoComparator() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }
    }
}

