/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;

public final class CompoundFile
extends BaseCompoundFile {
    private static Logger logger = Logger.getLogger(CompoundFile.class);
    private byte[] data;
    private int numBigBlockDepotBlocks;
    private int sbdStartBlock;
    private int rootStartBlock;
    private int extensionBlock;
    private int numExtensionBlocks;
    private byte[] rootEntry;
    private int[] bigBlockChain;
    private int[] smallBlockChain;
    private int[] bigBlockDepotBlocks;
    private ArrayList propertySets;
    private WorkbookSettings settings;
    static /* synthetic */ Class class$0;

    public CompoundFile(byte[] d, WorkbookSettings ws) throws BiffException {
        this.data = d;
        this.settings = ws;
        int i = 0;
        while (i < BaseCompoundFile.IDENTIFIER.length) {
            if (this.data[i] != BaseCompoundFile.IDENTIFIER[i]) {
                throw new BiffException(BiffException.unrecognizedOLEFile);
            }
            ++i;
        }
        this.propertySets = new ArrayList();
        this.numBigBlockDepotBlocks = IntegerHelper.getInt(this.data[44], this.data[45], this.data[46], this.data[47]);
        this.sbdStartBlock = IntegerHelper.getInt(this.data[60], this.data[61], this.data[62], this.data[63]);
        this.rootStartBlock = IntegerHelper.getInt(this.data[48], this.data[49], this.data[50], this.data[51]);
        this.extensionBlock = IntegerHelper.getInt(this.data[68], this.data[69], this.data[70], this.data[71]);
        this.numExtensionBlocks = IntegerHelper.getInt(this.data[72], this.data[73], this.data[74], this.data[75]);
        this.bigBlockDepotBlocks = new int[this.numBigBlockDepotBlocks];
        int pos = 76;
        int bbdBlocks = this.numBigBlockDepotBlocks;
        if (this.numExtensionBlocks != 0) {
            bbdBlocks = 109;
        }
        int i2 = 0;
        while (i2 < bbdBlocks) {
            this.bigBlockDepotBlocks[i2] = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
            pos += 4;
            ++i2;
        }
        int j = 0;
        while (j < this.numExtensionBlocks) {
            pos = (this.extensionBlock + 1) * 512;
            int blocksToRead = Math.min(this.numBigBlockDepotBlocks - bbdBlocks, 127);
            int i3 = bbdBlocks;
            while (i3 < bbdBlocks + blocksToRead) {
                this.bigBlockDepotBlocks[i3] = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
                pos += 4;
                ++i3;
            }
            if ((bbdBlocks += blocksToRead) < this.numBigBlockDepotBlocks) {
                this.extensionBlock = IntegerHelper.getInt(d[pos], d[pos + 1], d[pos + 2], d[pos + 3]);
            }
            ++j;
        }
        this.readBigBlockDepot();
        this.readSmallBlockDepot();
        this.rootEntry = this.readData(this.rootStartBlock);
        this.readPropertySets();
    }

    private void readBigBlockDepot() {
        int pos = 0;
        int index = 0;
        this.bigBlockChain = new int[this.numBigBlockDepotBlocks * 512 / 4];
        int i = 0;
        while (i < this.numBigBlockDepotBlocks) {
            pos = (this.bigBlockDepotBlocks[i] + 1) * 512;
            int j = 0;
            while (j < 128) {
                this.bigBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
                ++j;
            }
            ++i;
        }
    }

    private void readSmallBlockDepot() {
        int pos = 0;
        int index = 0;
        int sbdBlock = this.sbdStartBlock;
        this.smallBlockChain = new int[0];
        while (sbdBlock != -2) {
            int[] oldChain = this.smallBlockChain;
            this.smallBlockChain = new int[this.smallBlockChain.length + 128];
            System.arraycopy(oldChain, 0, this.smallBlockChain, 0, oldChain.length);
            pos = (sbdBlock + 1) * 512;
            int j = 0;
            while (j < 128) {
                this.smallBlockChain[index] = IntegerHelper.getInt(this.data[pos], this.data[pos + 1], this.data[pos + 2], this.data[pos + 3]);
                pos += 4;
                ++index;
                ++j;
            }
            sbdBlock = this.bigBlockChain[sbdBlock];
        }
    }

    private void readPropertySets() {
        int offset = 0;
        byte[] d = null;
        while (offset < this.rootEntry.length) {
            d = new byte[128];
            System.arraycopy(this.rootEntry, offset, d, 0, d.length);
            BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile)this.new BaseCompoundFile.PropertyStorage(d);
            this.propertySets.add(ps);
            offset += 128;
        }
    }

    public byte[] getStream(String streamName) throws BiffException {
        BaseCompoundFile.PropertyStorage ps = this.getPropertyStorage(streamName);
        if (ps.size >= 4096 || streamName.equalsIgnoreCase("Root Entry")) {
            return this.getBigBlockStream(ps);
        }
        return this.getSmallBlockStream(ps);
    }

    private BaseCompoundFile.PropertyStorage getPropertyStorage(String name) throws BiffException {
        Iterator i = this.propertySets.iterator();
        boolean found = false;
        BaseCompoundFile.PropertyStorage ps = null;
        while (!found && i.hasNext()) {
            ps = (BaseCompoundFile.PropertyStorage)i.next();
            if (!ps.name.equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (!found) {
            throw new BiffException(BiffException.streamNotFound);
        }
        return ps;
    }

    private byte[] getBigBlockStream(BaseCompoundFile.PropertyStorage ps) {
        int numBlocks = ps.size / 512;
        if (ps.size % 512 != 0) {
            ++numBlocks;
        }
        byte[] streamData = new byte[numBlocks * 512];
        int block = ps.startBlock;
        int count = 0;
        int pos = 0;
        while (block != -2 && count < numBlocks) {
            pos = (block + 1) * 512;
            System.arraycopy(this.data, pos, streamData, count * 512, 512);
            ++count;
            block = this.bigBlockChain[block];
        }
        if (block != -2 && count == numBlocks) {
            logger.warn("Property storage size inconsistent with block chain.");
        }
        return streamData;
    }

    private byte[] getSmallBlockStream(BaseCompoundFile.PropertyStorage ps) throws BiffException {
        BaseCompoundFile.PropertyStorage rootps = null;
        try {
            rootps = this.getPropertyStorage("Root Entry");
        }
        catch (BiffException e) {
            rootps = (BaseCompoundFile.PropertyStorage)this.propertySets.get(0);
        }
        byte[] rootdata = this.readData(rootps.startBlock);
        byte[] sbdata = new byte[]{};
        int block = ps.startBlock;
        boolean count = false;
        int pos = 0;
        while (block != -2) {
            byte[] olddata = sbdata;
            sbdata = new byte[olddata.length + 64];
            System.arraycopy(olddata, 0, sbdata, 0, olddata.length);
            pos = block * 64;
            System.arraycopy(rootdata, pos, sbdata, olddata.length, 64);
            block = this.smallBlockChain[block];
        }
        return sbdata;
    }

    private byte[] readData(int bl) {
        int block = bl;
        int pos = 0;
        byte[] entry = new byte[]{};
        while (block != -2) {
            byte[] oldEntry = entry;
            entry = new byte[oldEntry.length + 512];
            System.arraycopy(oldEntry, 0, entry, 0, oldEntry.length);
            pos = (block + 1) * 512;
            System.arraycopy(this.data, pos, entry, oldEntry.length, 512);
            block = this.bigBlockChain[block];
        }
        return entry;
    }

    public String[] getPropertySetNames() {
        String[] sets = new String[this.propertySets.size()];
        int i = 0;
        while (i < sets.length) {
            BaseCompoundFile.PropertyStorage ps = (BaseCompoundFile.PropertyStorage)this.propertySets.get(i);
            sets[i] = ps.name;
            ++i;
        }
        return sets;
    }

    public BaseCompoundFile.PropertyStorage getPropertySet(String ps) {
        boolean found = false;
        BaseCompoundFile.PropertyStorage propertySet = null;
        Iterator i = this.propertySets.iterator();
        while (i.hasNext() && !found) {
            propertySet = (BaseCompoundFile.PropertyStorage)i.next();
            if (!propertySet.name.equalsIgnoreCase(ps)) continue;
            found = true;
        }
        return found ? propertySet : null;
    }
}

