/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import jxl.biff.drawing.Dg;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

public class DrawingData
implements EscherStream {
    private static Logger logger = Logger.getLogger(DrawingData.class);
    private byte[] drawingData = null;
    private int numDrawings = 0;
    private boolean initialized = false;
    private EscherRecord[] spgrChildren;
    static /* synthetic */ Class class$0;

    private void initialize() {
        EscherRecordData er = new EscherRecordData(this, 0);
        Assert.verify(er.isContainer());
        EscherContainer dgContainer = new EscherContainer(er);
        EscherRecord[] children = dgContainer.getChildren();
        children = dgContainer.getChildren();
        Dg dg = (Dg)children[0];
        EscherContainer spgrContainer = null;
        int i = 0;
        while (i < children.length && spgrContainer == null) {
            EscherRecord child = children[i];
            if (child.getType() == EscherRecordType.SPGR_CONTAINER) {
                spgrContainer = (EscherContainer)child;
            }
            ++i;
        }
        Assert.verify(spgrContainer != null);
        this.spgrChildren = spgrContainer.getChildren();
        this.initialized = true;
    }

    void addData(byte[] data) {
        this.addRawData(data);
        ++this.numDrawings;
    }

    void addRawData(byte[] data) {
        if (this.drawingData == null) {
            this.drawingData = data;
            return;
        }
        byte[] newArray = new byte[this.drawingData.length + data.length];
        System.arraycopy(this.drawingData, 0, newArray, 0, this.drawingData.length);
        System.arraycopy(data, 0, newArray, this.drawingData.length, data.length);
        this.drawingData = newArray;
        this.initialized = false;
    }

    final int getNumDrawings() {
        return this.numDrawings;
    }

    EscherContainer getSpContainer(int drawingNum) {
        if (!this.initialized) {
            this.initialize();
        }
        EscherContainer spContainer = (EscherContainer)this.spgrChildren[drawingNum + 1];
        return spContainer;
    }

    public byte[] getData() {
        return this.drawingData;
    }
}

