/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function.VBScript;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.regexp.RE;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class HTML2Text
extends PostfixMathCommand {
    public HTML2Text() {
        this.numberOfParameters = 1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param = inStack.pop();
        inStack.push(this.$html2text(param));
    }

    public Object $html2text(Object param) throws ParseException {
        if (param == null) {
            return "";
        }
        if (param instanceof String) {
            String s = HTML2Text.html2Text((String)param);
            s = HTML2Text.ToGBKHTML(s);
            return s;
        }
        return param.toString();
    }

    public static String html2Text(String s) {
        StringBuffer sb = new StringBuffer(1024);
        if (s == null) {
            return "";
        }
        int len = s.length();
        boolean inTag = false;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '<') {
                inTag = true;
            } else if (c == '>') {
                inTag = false;
            } else if (!inTag) {
                sb.append(c);
            }
            ++i;
        }
        s = sb.toString();
        s = HTML2Text.replaceAll(s, "&nbsp;", " ");
        s = HTML2Text.replaceAll(s, "&lt;", "<");
        s = HTML2Text.replaceAll(s, "&gt;", ">");
        s = HTML2Text.replaceAll(s, "\r", "");
        s = HTML2Text.replaceAll(s, "\n", "");
        return s;
    }

    public static String replaceAll(String source, String what, String to) {
        RE re = new RE(what);
        while (re.match(source)) {
            source = String.valueOf(source.substring(0, re.getParenStart(0))) + to + source.substring(re.getParenEnd(0));
        }
        return source;
    }

    public static String ToGBKHTML(String s) {
        StringBuffer sb = new StringBuffer(s);
        try {
            ArrayList<Integer> a1 = new ArrayList<Integer>();
            ArrayList<Integer> a2 = new ArrayList<Integer>();
            ArrayList<Integer> a3 = new ArrayList<Integer>();
            ArrayList<Integer> a4 = new ArrayList<Integer>();
            RE r = new RE("&#([0-9]{3,5})\\s*;");
            int startAt = 0;
            while (r.match(s, startAt)) {
                int n = r.getParenCount();
                int p1 = r.getParenStart(0);
                int p2 = r.getParenEnd(0);
                int p3 = r.getParenStart(1);
                int p4 = r.getParenEnd(1);
                startAt = p2;
                a1.add(new Integer(p1));
                a2.add(new Integer(p2));
                a3.add(new Integer(p3));
                a4.add(new Integer(p4));
            }
            StringBuffer temp = new StringBuffer(10);
            int i = a1.size() - 1;
            while (i >= 0) {
                int p1 = (Integer)a1.get(i);
                int p2 = (Integer)a2.get(i);
                int p3 = (Integer)a3.get(i);
                int p4 = (Integer)a4.get(i);
                temp.delete(0, temp.length());
                temp.append((char)new Integer(sb.substring(p3, p4)).intValue());
                sb.replace(p1, p2, temp.toString());
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }
}

