/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function.VBScript;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class CStr
extends PostfixMathCommand {
    public CStr() {
        this.numberOfParameters = -1;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        if (this.curNumberOfParameters == 1) {
            inStack.push(this.str(inStack.pop()));
            return;
        }
        if (this.curNumberOfParameters == 2) {
            Object p2 = inStack.pop();
            Object p1 = inStack.pop();
            inStack.push(this.str(p1, p2));
            return;
        }
        throw new ParseException("Invalid parameter count");
    }

    public Object str(Object param) throws ParseException {
        if (param == null) {
            return "";
        }
        return String.valueOf(param);
    }

    public Object str(Object p1, Object p2) throws ParseException {
        if (p1 instanceof Number && p2 instanceof String) {
            DecimalFormat df = new DecimalFormat((String)p2);
            return df.format(((Number)p1).doubleValue());
        }
        if (p1 instanceof Date && p2 instanceof String) {
            String format = (String)p2;
            format = format.replaceAll("YYYY", "yyyy").replaceAll("DD", "dd").replaceAll("hh", "HH");
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.format((Date)p1);
        }
        throw new ParseException("Invalid parameter type");
    }
}

