/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.StringReader;
import java.util.Vector;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserDumpVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.function.Mid;
import org.nfunk.jep.function.Month;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.VBScript.Abs;
import org.nfunk.jep.function.VBScript.Asc;
import org.nfunk.jep.function.VBScript.CBool;
import org.nfunk.jep.function.VBScript.CDate;
import org.nfunk.jep.function.VBScript.CDbl;
import org.nfunk.jep.function.VBScript.CInt;
import org.nfunk.jep.function.VBScript.CLng;
import org.nfunk.jep.function.VBScript.CStr;
import org.nfunk.jep.function.VBScript.Chr;
import org.nfunk.jep.function.VBScript.DaysBetween;
import org.nfunk.jep.function.VBScript.HTML2Text;
import org.nfunk.jep.function.VBScript.If;
import org.nfunk.jep.function.VBScript.Img;
import org.nfunk.jep.function.VBScript.IndexOf;
import org.nfunk.jep.function.VBScript.IsNull;
import org.nfunk.jep.function.VBScript.Mod;
import org.nfunk.jep.function.VBScript.Now;
import org.nfunk.jep.function.VBScript.Random;
import org.nfunk.jep.function.VBScript.RandomGuid;
import org.nfunk.jep.function.VBScript.Round;
import org.nfunk.jep.function.VBScript.RowCount;
import org.nfunk.jep.function.VBScript.Sqrt;
import org.nfunk.jep.function.VBScript.Sum;
import org.nfunk.jep.function.VBScript.ThisRow;
import org.nfunk.jep.function.Year;
import org.nfunk.jep.type.DoubleNumberFactory;
import org.nfunk.jep.type.NumberFactory;

public class JEP {
    public static String Datastore_internal_thisrow = "datastore_internal_symbol_thisrow_zj1211";
    public static String Datastore_internal_rowcount = "datastore_internal_symbol_rowcount_zj1211";
    public static String Datastore_internal_absolute = "datastore_internal_symbol_absolute_zj1211";
    private static final boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    private Parser parser;
    private Node topNode = null;
    private EvaluatorVisitor ev;
    private NumberFactory numberFactory;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor();
        this.parser = new Parser(new StringReader(""));
        this.parseExpression("");
    }

    public void initSymTab() {
        this.symTab = new SymbolTable();
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.addFunction("sqrt", new Sqrt());
        this.addFunction("abs", new Abs());
        this.addFunction("mod", new Mod());
        this.addFunction("sum", new Sum());
        this.addFunction("mid", new Mid());
        this.addFunction("if", new If());
        this.addFunction("rand", new Random());
        this.addFunction("asc", new Asc());
        this.addFunction("cdate", new CDate());
        this.addFunction("cdbl", new CDbl());
        this.addFunction("chr", new Chr());
        this.addFunction("clng", new CLng());
        this.addFunction("cint", new CInt());
        this.addFunction("floor", new CInt());
        this.addFunction("cbool", new CBool());
        this.addFunction("cstr", new CStr());
        this.addFunction("round", new Round());
        this.addFunction("now", new Now());
        this.addFunction("indexof", new IndexOf());
        this.addFunction("thisrow", new ThisRow(this));
        this.addFunction("rowcount", new RowCount(this));
        this.addFunction("RandomGuid", new RandomGuid());
        this.addFunction("randomguid", new RandomGuid());
        this.addFunction("html2text", new HTML2Text());
        this.addFunction("daysbetween", new DaysBetween());
        this.addFunction("isnull", new IsNull());
        this.addFunction("img", new Img());
        this.addFunction("year", new Year());
        this.addFunction("month", new Month());
    }

    public void addStandardConstants() {
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        this.funTab.put(functionName.toLowerCase(), function);
    }

    public Double addVariable(String name, double value) {
        Double object = new Double(value);
        this.symTab.put(name.toLowerCase(), object);
        return object;
    }

    public void addVariableAsObject(String name, Object object) {
        this.symTab.put(name.toLowerCase(), object);
    }

    public Object removeVariable(String name) {
        return this.symTab.remove(name.toLowerCase());
    }

    public Object removeFunction(String name) {
        return this.funTab.remove(name.toLowerCase());
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream(reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getErrorInfo());
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            this.topNode.jjtAccept(v, null);
        }
    }

    public double getValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return 0.0;
    }

    public Object getValueAsObject() {
        if (this.topNode != null && !this.hasError()) {
            Object result;
            try {
                result = this.ev.getValue(this.topNode, this.errorList, this.symTab);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            return result;
        }
        return null;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            int i = 0;
            while (i < this.errorList.size()) {
                str = String.valueOf(str) + this.errorList.elementAt(i) + "\n";
                ++i;
            }
            return str;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }
}

