/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;

public class Log {
    public static final int DEBUG = 1;
    public static final int MESSAGE = 3;
    public static final int NOTICE = 5;
    public static final int WARNING = 7;
    public static final int ERROR = 9;
    private static Object LOCK = new Object();
    private static Document logDocument;
    private static int level;
    private static PrintStream realOut;
    private static PrintStream realErr;

    static {
        realOut = System.out;
        realErr = System.err;
        logDocument = new PlainDocument();
    }

    public static void init(boolean stdio, int level) {
        if (stdio && System.out == realOut && System.err == realErr) {
            System.setOut(Log.createPrintStream(5, null));
            System.setErr(Log.createPrintStream(9, null));
        }
        Log.level = level;
        Log.clearLog();
    }

    public static Document getLogDocument() {
        return logDocument;
    }

    public static void saveLog(String path) throws IOException {
        Log.saveLog(new FileWriter(path));
    }

    public static void saveLog(Writer out) throws IOException {
        if (!(out instanceof BufferedWriter)) {
            Log.saveLog(new BufferedWriter(out));
            return;
        }
        String lineSep = System.getProperty("line.separator");
        Element map = logDocument.getDefaultRootElement();
        int i = 0;
        while (i < map.getElementCount()) {
            Element lineElement = map.getElement(i);
            try {
                String text = logDocument.getText(lineElement.getStartOffset(), lineElement.getEndOffset() - lineElement.getStartOffset() - 1);
                out.write(text);
                out.write(lineSep);
            }
            catch (BadLocationException bl) {
                Log.log(9, Log.class, bl);
            }
            ++i;
        }
        out.close();
    }

    public static void clearLog() {
        try {
            logDocument.remove(0, logDocument.getLength());
            Log.log(3, Log.class, "To copy from the activity log, select the appropriate text and press C+c");
            Log.log(3, Log.class, "When reporting bugs, please include the following information:");
            String[] props = new String[]{"java.version", "java.vendor", "java.compiler", "os.name", "os.version", "os.arch", "user.home"};
            int i = 0;
            while (i < props.length) {
                Log.log(3, Log.class, String.valueOf(props[i]) + "=" + System.getProperty(props[i]));
                ++i;
            }
        }
        catch (BadLocationException bl) {
            Log.log(9, Log.class, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int urgency, Object source, Object message) {
        int index;
        String _source;
        if (source == null) {
            _source = Thread.currentThread().getName();
            if (_source == null) {
                _source = Thread.currentThread().getClass().getName();
            }
        } else {
            _source = source instanceof Class ? ((Class)source).getName() : source.getClass().getName();
        }
        if ((index = _source.lastIndexOf(46)) != -1) {
            _source = _source.substring(index + 1);
        }
        if (message instanceof Throwable) {
            Log._logException(urgency, source, (Throwable)message);
        } else {
            String _message = String.valueOf(message);
            Object object = LOCK;
            synchronized (object) {
                StringTokenizer st = new StringTokenizer(_message, "\r\n");
                while (st.hasMoreTokens()) {
                    Log._log(urgency, _source, st.nextToken());
                }
            }
        }
    }

    private static PrintStream createPrintStream(final int urgency, final Object source) {
        return new PrintStream(new OutputStream(){

            public void write(int b) {
                byte[] barray = new byte[]{(byte)b};
                this.write(barray, 0, 1);
            }

            public void write(byte[] b, int off, int len) {
                String str = new String(b, off, len);
                Log.log(urgency, source, str);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _logException(int urgency, Object source, Throwable message) {
        PrintStream out = Log.createPrintStream(urgency, source);
        Object object = LOCK;
        synchronized (object) {
            message.printStackTrace(out);
        }
    }

    private static void _log(int urgency, String source, String message) {
        String urgencyString = "[" + Log.urgencyToString(urgency) + "] ";
        message = String.valueOf(message) + '\n';
        try {
            logDocument.insertString(logDocument.getLength(), String.valueOf(urgencyString) + source + ": " + message, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
        message = String.valueOf(urgencyString) + message;
        if (urgency >= level) {
            if (urgency == 9) {
                realErr.print(message);
            } else {
                realOut.print(message);
            }
        }
    }

    private static String urgencyToString(int urgency) {
        switch (urgency) {
            case 1: {
                return "debug";
            }
            case 3: {
                return "message";
            }
            case 5: {
                return "notice";
            }
            case 7: {
                return "warning";
            }
            case 9: {
                return "error";
            }
        }
        throw new IllegalArgumentException("Invalid urgency: " + urgency);
    }
}

