/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class PHPTokenMarker
extends TokenMarker {
    public static final byte SCRIPT = 100;
    private static KeywordMap keywords = new KeywordMap(false);
    private int lastOffset;
    private int lastKeyword;

    static {
        keywords.add("function", (byte)7);
        keywords.add("class", (byte)7);
        keywords.add("var", (byte)7);
        keywords.add("require", (byte)7);
        keywords.add("include", (byte)7);
        keywords.add("else", (byte)6);
        keywords.add("elseif", (byte)6);
        keywords.add("do", (byte)6);
        keywords.add("for", (byte)6);
        keywords.add("if", (byte)6);
        keywords.add("endif", (byte)6);
        keywords.add("in", (byte)6);
        keywords.add("new", (byte)6);
        keywords.add("return", (byte)6);
        keywords.add("while", (byte)6);
        keywords.add("endwhile", (byte)6);
        keywords.add("with", (byte)6);
        keywords.add("break", (byte)6);
        keywords.add("switch", (byte)6);
        keywords.add("case", (byte)6);
        keywords.add("continue", (byte)6);
        keywords.add("default", (byte)6);
        keywords.add("echo", (byte)6);
        keywords.add("false", (byte)6);
        keywords.add("this", (byte)6);
        keywords.add("true", (byte)6);
        keywords.add("array", (byte)6);
        keywords.add("extends", (byte)6);
    }

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int offset;
        char[] array = line.array;
        this.lastOffset = offset = line.offset;
        this.lastKeyword = offset;
        int length = line.count + offset;
        boolean backslash = false;
        int i = offset;
        block28: while (i < length) {
            int i1 = i + 1;
            char c = array[i];
            if (c == '\\') {
                backslash = !backslash;
            } else {
                block0 : switch (token) {
                    case 0: {
                        backslash = false;
                        switch (c) {
                            case '<': {
                                this.addToken(i - this.lastOffset, token);
                                this.lastOffset = this.lastKeyword = i++;
                                if (SyntaxUtilities.regionMatches(false, line, i1, "!--")) {
                                    i += 3;
                                    token = 1;
                                    break;
                                }
                                if (SyntaxUtilities.regionMatches(true, line, i1, "?php")) {
                                    this.addToken(5, (byte)5);
                                    this.lastOffset = this.lastKeyword = (i += 4) + 1;
                                    token = (byte)100;
                                    break;
                                }
                                if (SyntaxUtilities.regionMatches(true, line, i1, "?")) {
                                    this.addToken(2, (byte)5);
                                    this.lastOffset = this.lastKeyword = i + 1;
                                    token = (byte)100;
                                    break;
                                }
                                if (SyntaxUtilities.regionMatches(true, line, i1, "script>")) {
                                    this.addToken(8, (byte)5);
                                    this.lastOffset = this.lastKeyword = (i += 7) + 1;
                                    token = (byte)100;
                                    break;
                                }
                                token = (byte)6;
                                break;
                            }
                            case '&': {
                                this.addToken(i - this.lastOffset, token);
                                this.lastOffset = this.lastKeyword = i;
                                token = (byte)7;
                            }
                        }
                        break;
                    }
                    case 6: {
                        backslash = false;
                        if (c != '>') break;
                        this.addToken(i1 - this.lastOffset, token);
                        this.lastOffset = this.lastKeyword = i1;
                        token = 0;
                        break;
                    }
                    case 7: {
                        backslash = false;
                        if (c != ';') break;
                        this.addToken(i1 - this.lastOffset, token);
                        this.lastOffset = this.lastKeyword = i1;
                        token = 0;
                        break;
                    }
                    case 1: {
                        backslash = false;
                        if (!SyntaxUtilities.regionMatches(false, line, i, "-->")) break;
                        this.addToken(i + 3 - this.lastOffset, token);
                        this.lastOffset = this.lastKeyword = (i += 2) + 1;
                        token = 0;
                        break;
                    }
                    case 100: {
                        switch (c) {
                            case '<': {
                                backslash = false;
                                this.doKeyword(line, i, c);
                                if (SyntaxUtilities.regionMatches(true, line, i1, "/script>")) {
                                    this.addToken(i - this.lastOffset, (byte)8);
                                    this.addToken(9, (byte)5);
                                    this.lastOffset = this.lastKeyword = (i += 8) + 1;
                                    token = 0;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.addToken(1, (byte)9);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            case '?': {
                                backslash = false;
                                this.doKeyword(line, i, c);
                                if (array[i1] == '>') {
                                    this.addToken(i - this.lastOffset, (byte)8);
                                    this.addToken(2, (byte)5);
                                    this.lastOffset = this.lastKeyword = ++i + 1;
                                    token = 0;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.addToken(1, (byte)9);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            case '\"': {
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.lastOffset = this.lastKeyword = i;
                                token = (byte)3;
                                break;
                            }
                            case '\'': {
                                if (backslash) {
                                    backslash = false;
                                    break;
                                }
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.lastOffset = this.lastKeyword = i;
                                token = (byte)4;
                                break;
                            }
                            case '#': {
                                this.doKeyword(line, i, c);
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.addToken(length - i, (byte)2);
                                this.lastOffset = this.lastKeyword = length;
                                break block28;
                            }
                            case '/': {
                                backslash = false;
                                this.doKeyword(line, i, c);
                                if (length - i > 1) {
                                    this.addToken(i - this.lastOffset, (byte)8);
                                    this.lastOffset = this.lastKeyword = i;
                                    if (array[i1] == '/') {
                                        this.addToken(length - i, (byte)2);
                                        this.lastOffset = this.lastKeyword = length;
                                        break block28;
                                    }
                                    if (array[i1] == '*') {
                                        token = (byte)2;
                                        break;
                                    }
                                    this.addToken(i - this.lastOffset, (byte)8);
                                    this.addToken(1, (byte)9);
                                    this.lastOffset = this.lastKeyword = i1;
                                    break;
                                }
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.addToken(1, (byte)9);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                            default: {
                                backslash = false;
                                if (Character.isLetterOrDigit(c) || c == '_' || c == '$') break block0;
                                this.doKeyword(line, i, c);
                                if (c == ' ') break block0;
                                this.addToken(i - this.lastOffset, (byte)8);
                                this.addToken(1, (byte)9);
                                this.lastOffset = this.lastKeyword = i1;
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\"') break;
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        this.lastOffset = this.lastKeyword = i1;
                        token = (byte)100;
                        break;
                    }
                    case 4: {
                        if (backslash) {
                            backslash = false;
                            break;
                        }
                        if (c != '\'') break;
                        this.addToken(i1 - this.lastOffset, (byte)3);
                        this.lastOffset = this.lastKeyword = i1;
                        token = (byte)100;
                        break;
                    }
                    case 2: {
                        backslash = false;
                        if (c != '*' || length - i <= 1 || array[i1] != '/') break;
                        this.addToken(i + 2 - this.lastOffset, (byte)2);
                        this.lastOffset = this.lastKeyword = ++i + 1;
                        token = (byte)100;
                        break;
                    }
                    default: {
                        throw new InternalError("Invalid state: " + token);
                    }
                }
            }
            ++i;
        }
        switch (token) {
            case 3: {
                this.addToken(length - this.lastOffset, (byte)3);
                break;
            }
            case 4: {
                this.addToken(length - this.lastOffset, (byte)4);
                break;
            }
            case 7: {
                this.addToken(length - this.lastOffset, (byte)10);
                token = 0;
                break;
            }
            case 100: {
                this.doKeyword(line, length, '\u0000');
                this.addToken(length - this.lastOffset, (byte)8);
                break;
            }
            default: {
                this.addToken(length - this.lastOffset, token);
            }
        }
        return token;
    }

    private boolean doKeyword(Segment line, int i, char c) {
        int i1 = i + 1;
        int len = i - this.lastKeyword;
        byte id = keywords.lookup(line, this.lastKeyword, len);
        if (id != 0) {
            if (this.lastKeyword != this.lastOffset) {
                this.addToken(this.lastKeyword - this.lastOffset, (byte)8);
            }
            this.addToken(len, id);
            this.lastOffset = i;
        }
        this.lastKeyword = i1;
        return false;
    }
}

