/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import org.gjt.sp.jedit.search.SearchMatcher;

public class RESearchMatcher
implements SearchMatcher {
    private String replace;
    private RE re;

    public RESearchMatcher(String search, String replace, boolean ignoreCase) {
        try {
            this.re = new RE(search, (ignoreCase ? 2 : 0) | 8, RESyntax.RE_SYNTAX_PERL5);
        }
        catch (REException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.replace = replace;
    }

    public int[] nextMatch(String text) {
        REMatch match = this.re.getMatch(text);
        if (match == null) {
            return null;
        }
        int[] result = new int[]{match.getStartIndex(), match.getEndIndex()};
        return result;
    }

    public String substitute(String text) {
        String str = this.re.substituteAll(text, this.replace);
        if (str.equals(text)) {
            return null;
        }
        return str;
    }
}

