/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import org.gjt.sp.jedit.search.SearchMatcher;

public class BoyerMooreSearchMatcher
implements SearchMatcher {
    private char[] pattern;
    private String replace;
    private boolean ignoreCase;
    private int[] skip;
    private int[] suffix;

    public BoyerMooreSearchMatcher(String pattern, String replace, boolean ignoreCase) {
        this.pattern = (ignoreCase ? pattern.toUpperCase() : pattern).toCharArray();
        this.replace = replace;
        this.ignoreCase = ignoreCase;
        this.generateSkipArray();
        this.generateSuffixArray();
    }

    public int[] nextMatch(String text) {
        int pos = this.match(text.toCharArray(), 0);
        if (pos == -1) {
            return null;
        }
        int[] match = new int[]{pos, pos + this.pattern.length};
        return match;
    }

    public String substitute(String text) {
        int pos;
        StringBuffer buf = null;
        char[] chars = text.toCharArray();
        int lastMatch = 0;
        while ((pos = this.match(chars, lastMatch)) != -1) {
            if (buf == null) {
                buf = new StringBuffer(chars.length);
            }
            if (pos != lastMatch) {
                buf.append(chars, lastMatch, pos - lastMatch);
            }
            buf.append(this.replace);
            lastMatch = pos + this.pattern.length;
        }
        if (buf == null) {
            return null;
        }
        if (lastMatch < chars.length) {
            buf.append(chars, lastMatch, chars.length - lastMatch);
        }
        return buf.toString();
    }

    public int match(char[] text, int offset) {
        int gs;
        int j;
        int bc;
        int last_i = text.length - this.pattern.length;
        int first_j = this.pattern.length - 1;
        char ch = '\u0000';
        for (int i = offset >= 0 ? offset : 0; i <= last_i; i += (bc = j + 1 - this.skip[BoyerMooreSearchMatcher.getSkipIndex(ch)]) > (gs = this.suffix[j]) ? bc : gs) {
            j = first_j;
            while (j >= 0) {
                ch = text[i + j];
                if (this.ignoreCase) {
                    ch = Character.toUpperCase(ch);
                }
                if (ch != this.pattern[j]) break;
                --j;
            }
            if (j >= 0) {
                continue;
            }
            return i;
        }
        return -1;
    }

    private void generateSkipArray() {
        this.skip = new int[256];
        int pos = 0;
        while (pos < this.pattern.length) {
            char ch = this.pattern[pos];
            this.skip[BoyerMooreSearchMatcher.getSkipIndex((char)ch)] = ++pos;
        }
    }

    private static final int getSkipIndex(char ch) {
        return ch & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    private void generateSuffixArray() {
        m = this.pattern.length;
        j = m + 1;
        this.suffix = new int[j];
        tmp = new int[j];
        tmp[m] = j;
        i = m;
        ** GOTO lbl15
        {
            if (this.suffix[j] == 0) {
                this.suffix[j] = j - i;
            }
            j = tmp[j];
            do {
                if (j <= m && this.pattern[i - 1] != this.pattern[j - 1]) continue block0;
                tmp[i - 1] = --j;
                --i;
lbl15:
                // 2 sources

            } while (i > 0);
        }
        k = tmp[0];
        j = 0;
        while (j <= m) {
            if (this.suffix[j] == 0) {
                this.suffix[j] = k;
            }
            if (j == k) {
                k = tmp[k];
            }
            ++j;
        }
        System.arraycopy(this.suffix, 1, this.suffix, 0, m);
    }
}

