/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ShortcutsModel;

public abstract class ShortcutsOptionPane
extends AbstractOptionPane {
    private JTable keyTable;
    private JButton label;
    private JButton shortcut;
    private ShortcutsModel keyModel;

    public ShortcutsOptionPane(String name) {
        super(name);
        this.setLayout(new BorderLayout());
        this.add("Center", this.createKeyTableScroller());
        JPanel panel = new JPanel();
        this.label = new JButton(jEdit.getProperty("options.keys.sort.label"));
        this.label.addActionListener(new ActionHandler());
        panel.add(this.label);
        this.shortcut = new JButton(jEdit.getProperty("options.keys.sort.shortcut"));
        this.shortcut.addActionListener(new ActionHandler());
        panel.add(this.shortcut);
        this.add("South", panel);
    }

    public void save() {
        this.keyModel.save();
    }

    protected abstract Vector createBindings();

    private JScrollPane createKeyTableScroller() {
        this.keyModel = this.createShortcutsModel();
        this.keyTable = new JTable(this.keyModel);
        this.keyTable.getTableHeader().setReorderingAllowed(false);
        Dimension d = this.keyTable.getPreferredSize();
        d.height = Math.min(d.height, 200);
        JScrollPane scroller = new JScrollPane(this.keyTable);
        scroller.setPreferredSize(d);
        return scroller;
    }

    private ShortcutsModel createShortcutsModel() {
        return new ShortcutsModel(this.createBindings());
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            ShortcutsOptionPane.this.keyModel.sort(evt.getSource() == ShortcutsOptionPane.this.label ? 0 : 1);
        }
    }

    public static class KeyBinding {
        String name;
        String label;
        String shortcut;

        KeyBinding(String name, String label, String shortcut) {
            this.name = name;
            this.label = label;
            this.shortcut = shortcut;
        }
    }
}

