/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.ShortcutsOptionPane;

class ShortcutsModel
extends AbstractTableModel {
    private Vector bindings;

    ShortcutsModel(Vector bindings) {
        this.bindings = bindings;
        this.sort(0);
    }

    public void sort(int col) {
        MiscUtilities.quicksort(this.bindings, (MiscUtilities.Compare)new KeyCompare(col));
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.bindings.size();
    }

    public Object getValueAt(int row, int col) {
        ShortcutsOptionPane.KeyBinding binding = (ShortcutsOptionPane.KeyBinding)this.bindings.elementAt(row);
        switch (col) {
            case 0: {
                return binding.label;
            }
            case 1: {
                return binding.shortcut;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col != 1) {
            return;
        }
        ((ShortcutsOptionPane.KeyBinding)this.bindings.elementAt((int)row)).shortcut = (String)value;
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.keys.name");
            }
            case 1: {
                return jEdit.getProperty("options.keys.binding");
            }
        }
        return null;
    }

    public void save() {
        int i = 0;
        while (i < this.bindings.size()) {
            ShortcutsOptionPane.KeyBinding binding = (ShortcutsOptionPane.KeyBinding)this.bindings.elementAt(i);
            jEdit.setProperty(String.valueOf(binding.name) + ".shortcut", binding.shortcut);
            ++i;
        }
    }

    class KeyCompare
    implements MiscUtilities.Compare {
        int col;

        KeyCompare(int col) {
            this.col = col;
        }

        public int compare(Object obj1, Object obj2) {
            ShortcutsOptionPane.KeyBinding k1 = (ShortcutsOptionPane.KeyBinding)obj1;
            ShortcutsOptionPane.KeyBinding k2 = (ShortcutsOptionPane.KeyBinding)obj2;
            String label1 = k1.label;
            String label2 = k2.label;
            if (this.col == 0) {
                return label1.compareTo(label2);
            }
            String shortcut1 = k1.shortcut;
            String shortcut2 = k2.shortcut;
            if (shortcut1 == null && shortcut2 != null) {
                return 1;
            }
            if (shortcut2 == null && shortcut1 != null) {
                return -1;
            }
            if (shortcut1 == null && shortcut2 == null) {
                return label1.compareTo(label2);
            }
            return shortcut1.compareTo(shortcut2);
        }
    }
}

