/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.gui.FontComboBox;
import org.gjt.sp.jedit.jEdit;

public class GutterOptionPane
extends AbstractOptionPane {
    private JCheckBox gutterExpanded = new JCheckBox(jEdit.getProperty("options.gutter.expanded"));
    private JCheckBox lineNumbersEnabled;
    private JTextField gutterWidth;
    private JTextField gutterBorderWidth;
    private JTextField highlightInterval;
    private JComboBox numberAlignment;
    private JComboBox font;
    private JComboBox style;
    private JComboBox size;

    public GutterOptionPane() {
        super("gutter");
        this.gutterExpanded.getModel().setSelected(!"yes".equals(jEdit.getProperty("view.gutter.collapsed")));
        this.addComponent(this.gutterExpanded);
        this.lineNumbersEnabled = new JCheckBox(jEdit.getProperty("options.gutter.lineNumbers"));
        this.lineNumbersEnabled.getModel().setSelected(!"no".equals(jEdit.getProperty("view.gutter.lineNumbers")));
        this.addComponent(this.lineNumbersEnabled);
        this.gutterWidth = new JTextField(jEdit.getProperty("view.gutter.width"));
        this.addComponent(jEdit.getProperty("options.gutter.width"), this.gutterWidth);
        this.gutterBorderWidth = new JTextField(jEdit.getProperty("view.gutter.borderWidth"));
        this.addComponent(jEdit.getProperty("options.gutter.borderWidth"), this.gutterBorderWidth);
        this.highlightInterval = new JTextField(jEdit.getProperty("view.gutter.highlightInterval"));
        this.addComponent(jEdit.getProperty("options.gutter.interval"), this.highlightInterval);
        String[] alignments = new String[]{"Left", "Center", "Right"};
        this.numberAlignment = new JComboBox<String>(alignments);
        String alignment = jEdit.getProperty("view.gutter.numberAlignment");
        if ("right".equals(alignment)) {
            this.numberAlignment.setSelectedIndex(2);
        } else if ("center".equals(alignment)) {
            this.numberAlignment.setSelectedIndex(1);
        } else {
            this.numberAlignment.setSelectedIndex(0);
        }
        this.addComponent("Line number alignment: ", this.numberAlignment);
        this.font = new FontComboBox();
        this.font.setSelectedItem(jEdit.getProperty("view.gutter.font"));
        this.addComponent(jEdit.getProperty("options.gutter.font"), this.font);
        String[] styles = new String[]{jEdit.getProperty("options.editor.plain"), jEdit.getProperty("options.editor.bold"), jEdit.getProperty("options.editor.italic"), jEdit.getProperty("options.editor.boldItalic")};
        this.style = new JComboBox<String>(styles);
        try {
            this.style.setSelectedIndex(Integer.parseInt(jEdit.getProperty("view.gutter.fontstyle")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.addComponent(jEdit.getProperty("options.gutter.fontstyle"), this.style);
        String[] sizes = new String[]{"9", "10", "12", "14", "18", "24"};
        this.size = new JComboBox<String>(sizes);
        this.size.setEditable(true);
        this.size.setSelectedItem(jEdit.getProperty("view.gutter.fontsize"));
        this.addComponent(jEdit.getProperty("options.gutter.fontsize"), this.size);
    }

    public void save() {
        jEdit.setProperty("view.gutter.collapsed", this.gutterExpanded.getModel().isSelected() ? "no" : "yes");
        jEdit.setProperty("view.gutter.lineNumbers", this.lineNumbersEnabled.getModel().isSelected() ? "yes" : "no");
        jEdit.setProperty("view.gutter.width", this.gutterWidth.getText());
        jEdit.setProperty("view.gutter.borderWidth", this.gutterBorderWidth.getText());
        jEdit.setProperty("view.gutter.highlightInterval", this.highlightInterval.getText());
        String alignment = null;
        switch (this.numberAlignment.getSelectedIndex()) {
            case 2: {
                alignment = "right";
                break;
            }
            case 1: {
                alignment = "center";
                break;
            }
            default: {
                alignment = "left";
            }
        }
        jEdit.setProperty("view.gutter.numberAlignment", alignment);
        jEdit.setProperty("view.gutter.font", this.font.getSelectedItem().toString());
        jEdit.setProperty("view.gutter.fontsize", this.size.getSelectedItem().toString());
        jEdit.setProperty("view.gutter.fontstyle", Integer.toString(this.style.getSelectedIndex()));
    }
}

