/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.StyleOptionPane;

class ColorTableModel
extends AbstractTableModel {
    private Vector colorChoices = new Vector(7);

    ColorTableModel() {
        this.addColorChoice("options.styles.bgColor", "view.bgColor");
        this.addColorChoice("options.styles.fgColor", "view.fgColor");
        this.addColorChoice("options.styles.caretColor", "view.caretColor");
        this.addColorChoice("options.styles.selectionColor", "view.selectionColor");
        this.addColorChoice("options.styles.lineHighlightColor", "view.lineHighlightColor");
        this.addColorChoice("options.styles.bracketHighlightColor", "view.bracketHighlightColor");
        this.addColorChoice("options.styles.eolMarkerColor", "view.eolMarkerColor");
        this.addColorChoice("options.styles.gutterBgColor", "view.gutter.bgColor");
        this.addColorChoice("options.styles.gutterFgColor", "view.gutter.fgColor");
        this.addColorChoice("options.styles.gutterHighlightColor", "view.gutter.highlightColor");
        this.addColorChoice("options.styles.gutterBorderColor", "view.gutter.borderColor");
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.colorChoices.size();
    }

    public Object getValueAt(int row, int col) {
        ColorChoice ch = (ColorChoice)this.colorChoices.elementAt(row);
        switch (col) {
            case 0: {
                return ch.label;
            }
            case 1: {
                return ch.color;
            }
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        ColorChoice ch = (ColorChoice)this.colorChoices.elementAt(row);
        if (col == 1) {
            ch.color = (Color)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.styles.object");
            }
            case 1: {
                return jEdit.getProperty("options.styles.color");
            }
        }
        return null;
    }

    public void save() {
        int i = 0;
        while (i < this.colorChoices.size()) {
            ColorChoice ch = (ColorChoice)this.colorChoices.elementAt(i);
            jEdit.setProperty(ch.property, GUIUtilities.getColorHexString(ch.color));
            ++i;
        }
    }

    private void addColorChoice(String label, String property) {
        this.colorChoices.addElement(new ColorChoice(jEdit.getProperty(label), property, GUIUtilities.parseColor(jEdit.getProperty(property))));
    }

    static class ColorChoice {
        String label;
        String property;
        Color color;

        ColorChoice(String label, String property, Color color) {
            this.label = label;
            this.property = property;
            this.color = color;
        }
    }

    static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorRenderer() {
            this.setOpaque(true);
            this.setBorder(StyleOptionPane.noFocusBorder);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (value != null) {
                this.setBackground((Color)value);
            }
            this.setBorder(cellHasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : StyleOptionPane.noFocusBorder);
            return this;
        }
    }
}

