/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.Abbrev;

class AbbrevsModel
extends AbstractTableModel {
    Vector abbrevs = new Vector();

    AbbrevsModel() {
    }

    AbbrevsModel(Hashtable abbrevHash) {
        this();
        if (abbrevHash != null) {
            Enumeration abbrevEnum = abbrevHash.keys();
            Enumeration expandEnum = abbrevHash.elements();
            while (abbrevEnum.hasMoreElements()) {
                this.abbrevs.addElement(new Abbrev((String)abbrevEnum.nextElement(), (String)expandEnum.nextElement()));
            }
            this.sort(0);
        }
    }

    public void sort(int col) {
        MiscUtilities.quicksort(this.abbrevs, (MiscUtilities.Compare)new AbbrevCompare(col));
        this.fireTableDataChanged();
    }

    public Hashtable toHashtable() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        int i = 0;
        while (i < this.abbrevs.size()) {
            Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(i);
            if (abbrev.abbrev.length() > 0 && abbrev.expand.length() > 0) {
                hash.put(abbrev.abbrev, abbrev.expand);
            }
            ++i;
        }
        return hash;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.abbrevs.size() + 1;
    }

    public Object getValueAt(int row, int col) {
        if (row == this.abbrevs.size()) {
            return null;
        }
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(row);
        switch (col) {
            case 0: {
                return abbrev.abbrev;
            }
            case 1: {
                return abbrev.expand;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return true;
    }

    public void setValueAt(Object value, int row, int col) {
        Abbrev abbrev;
        if (value == null) {
            value = "";
        }
        if (row == this.abbrevs.size()) {
            abbrev = new Abbrev();
            this.abbrevs.addElement(abbrev);
        } else {
            abbrev = (Abbrev)this.abbrevs.elementAt(row);
        }
        if (col == 0) {
            abbrev.abbrev = (String)value;
        } else {
            abbrev.expand = (String)value;
        }
        this.fireTableRowsUpdated(row, row + 1);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.abbrevs.abbrev");
            }
            case 1: {
                return jEdit.getProperty("options.abbrevs.expand");
            }
        }
        return null;
    }

    class AbbrevCompare
    implements MiscUtilities.Compare {
        int col;

        AbbrevCompare(int col) {
            this.col = col;
        }

        public int compare(Object obj1, Object obj2) {
            Abbrev a1 = (Abbrev)obj1;
            Abbrev a2 = (Abbrev)obj2;
            if (this.col == 0) {
                String abbrev1 = a1.abbrev;
                String abbrev2 = a2.abbrev;
                return abbrev1.compareTo(abbrev2);
            }
            String expand1 = a1.expand;
            String expand2 = a2.expand;
            return expand1.compareTo(expand2);
        }
    }
}

