/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.Element;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.Autosave;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.Sessions;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.actions.ignore_case;
import org.gjt.sp.jedit.actions.multifile_search;
import org.gjt.sp.jedit.actions.regexp;
import org.gjt.sp.jedit.actions.toggle_gutter;
import org.gjt.sp.jedit.actions.toggle_line_numbers;
import org.gjt.sp.jedit.actions.toggle_rect;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.EditorStarted;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.textarea.DefaultInputHandler;
import org.gjt.sp.jedit.textarea.InputHandler;
import org.gjt.sp.util.Escape;
import org.gjt.sp.util.Log;

public class jEdit {
    public static String currentModeName = "";
    public static boolean exitOnExit = true;
    private static String jEditHome;
    private static String settingsDirectory;
    private static long propsModTime;
    private static String session;
    private static Properties defaultProps;
    private static Properties props;
    private static Autosave autosave;
    private static EditServer server;
    private static Hashtable actionHash;
    private static Vector plugins;
    private static Vector brokenPlugins;
    private static Vector modes;
    private static Vector recent;
    private static int maxRecent;
    private static InputHandler inputHandler;
    public static boolean sortBuffers;
    public static boolean sortByName;
    private static int bufferCount;
    private static Buffer buffersFirst;
    private static Buffer buffersLast;
    private static int viewCount;
    private static View viewsFirst;
    private static View viewsLast;

    public static String getVersion() {
        return MiscUtilities.buildToVersion(jEdit.getBuild());
    }

    public static String getBuild() {
        return "02.03.99.00";
    }

    public static void main(String[] args) {
        String levelStr;
        int level = 7;
        if (args.length >= 1 && (levelStr = args[0]).length() == 1 && Character.isDigit(levelStr.charAt(0))) {
            level = Integer.parseInt(levelStr);
            args[0] = null;
        }
        boolean endOpts = false;
        boolean readOnly = false;
        boolean reuseView = false;
        settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), ".jedit");
        String portFile = "server";
        boolean defaultSession = true;
        session = "default";
        boolean showSplash = true;
        portFile = null;
        String userDir = System.getProperty("user.dir");
        Log.init(true, level);
        jEdit.initMisc();
        jEdit.initSystemProperties();
        jEdit.initPlugins();
        jEdit.initUserProperties();
        sortBuffers = "on".equals(jEdit.getProperty("sortBuffers"));
        sortByName = "on".equals(jEdit.getProperty("sortByName"));
        jEdit.propertiesChanged();
        jEdit.initRecent();
        jEdit.initPLAF();
        SearchAndReplace.load();
        Abbrevs.load();
        jEdit.initActions();
        jEdit.initModes();
        jEdit.initKeyBindings();
        Macros.loadMacros();
        JARClassLoader.initPlugins();
        GUIUtilities.loadMenuBarModel("view.mbar");
        GUIUtilities.loadMenuModel("view.context");
        GUIUtilities.loadMenuModel("gutter.context");
        if ("on".equals(jEdit.getProperty("view.showToolbar"))) {
            GUIUtilities.loadToolBarModel("view.toolbar");
        }
        if (portFile != null) {
            server = new EditServer(portFile);
        }
        String HomeURL = "";
        String FileName = "";
        String mode = "script";
        if (args.length >= 2) {
            HomeURL = args[0];
            FileName = Escape.unescape(args[1]);
        }
        if (args.length == 3) {
            mode = args[2];
        }
        if (mode.equals("script")) {
            mode = "javascript";
        }
        currentModeName = mode;
        if (HomeURL.endsWith("//")) {
            HomeURL = HomeURL.substring(0, HomeURL.length() - 1);
        }
        Buffer buffer = jEdit.openRemoteFile(null, null, HomeURL, FileName, false, false);
        buffer.setMode(jEdit.getMode(currentModeName));
        final Buffer _buffer = buffer;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditBus.send(new EditorStarted(null));
                jEdit.newView(null, _buffer);
                Log.log(3, jEdit.class, "Startup complete");
            }
        });
    }

    public static void loadProps(InputStream in) throws IOException {
        props.load(new BufferedInputStream(in));
        in.close();
    }

    public static final String getProperty(String name) {
        return props.getProperty(name);
    }

    public static final String getProperty(String name, String def) {
        return props.getProperty(name, def);
    }

    public static final String getProperty(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return props.getProperty(name, name);
        }
        try {
            String s = props.getProperty(name, name);
            return MessageFormat.format(s, args);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static final void setProperty(String name, String value) {
        if (value == null || value.length() == 0) {
            String prop = (String)defaultProps.get(name);
            if (prop == null || prop.length() == 0) {
                props.remove(name);
            } else {
                props.put(name, "");
            }
        } else if (!value.equals(jEdit.getProperty(name))) {
            props.put(name, value);
        }
    }

    public static final void setTemporaryProperty(String name, String value) {
        props.remove(name);
        defaultProps.put(name, value);
    }

    public static final void setDefaultProperty(String name, String value) {
        jEdit.setTemporaryProperty(name, value);
    }

    public static final void unsetProperty(String name) {
        if (defaultProps.get(name) != null) {
            props.put(name, "");
        } else {
            props.remove(name);
        }
    }

    public static void propertiesChanged() {
        if (autosave != null) {
            autosave.interrupt();
        }
        autosave = new Autosave();
        try {
            maxRecent = Integer.parseInt(jEdit.getProperty("recent"));
        }
        catch (NumberFormatException nf) {
            Log.log(9, jEdit.class, nf);
            maxRecent = 8;
        }
        GUIUtilities.chooser = null;
        EditBus.send(new PropertiesChanged(null));
    }

    public static void loadPlugins(String directory) {
        Log.log(3, jEdit.class, "Scanning directory: " + directory);
        File file = new File(directory);
        if (!file.exists() && !file.isDirectory()) {
            return;
        }
        Object[] plugins = file.list();
        if (plugins == null) {
            return;
        }
        MiscUtilities.quicksort(plugins, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        int i = 0;
        while (i < plugins.length) {
            Object plugin = plugins[i];
            if (((String)plugin).toLowerCase().endsWith(".jar")) {
                try {
                    String path = MiscUtilities.constructPath(directory, (String)plugin);
                    Log.log(1, jEdit.class, "Scanning JAR file: " + path);
                    new JARClassLoader(path);
                }
                catch (IOException io) {
                    Log.log(9, jEdit.class, "Cannot load plugin " + (String)plugin);
                    Log.log(9, jEdit.class, io);
                }
            }
            ++i;
        }
    }

    public static void addPlugin(EditPlugin plugin) {
        plugin.start();
        plugins.addElement(plugin);
    }

    public static EditPlugin getPlugin(String name) {
        int i = 0;
        while (i < plugins.size()) {
            EditPlugin p = (EditPlugin)plugins.elementAt(i);
            if (p.getClass().getName().equals(name)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static EditPlugin[] getPlugins() {
        Object[] pluginArray = new EditPlugin[plugins.size()];
        plugins.copyInto(pluginArray);
        return pluginArray;
    }

    public static EditPlugin.Broken[] getBrokenPlugins() {
        Object[] pluginArray = new EditPlugin.Broken[brokenPlugins.size()];
        brokenPlugins.copyInto(pluginArray);
        return pluginArray;
    }

    public static void addAction(EditAction action) {
        String name = action.getName();
        actionHash.put(name, new EditAction.Wrapper(action));
        String binding = jEdit.getProperty(String.valueOf(name) + ".shortcut");
        if (binding != null) {
            inputHandler.addKeyBinding(binding, action);
        }
    }

    public static EditAction getAction(String action) {
        return (EditAction)actionHash.get(action);
    }

    public static EditAction[] getActions() {
        EditAction[] actions = new EditAction[actionHash.size()];
        Enumeration enume = actionHash.elements();
        int i = 0;
        while (enume.hasMoreElements()) {
            actions[i++] = (EditAction)enume.nextElement();
        }
        return actions;
    }

    public static void addMode(Mode mode) {
        modes.addElement(mode);
    }

    public static void addMode(String mode) {
        modes.addElement(new Mode(mode));
    }

    public static Mode getMode(String name) {
        int i = 0;
        while (i < modes.size()) {
            Mode mode = (Mode)modes.elementAt(i);
            if (mode.getName().equals(name)) {
                return mode;
            }
            ++i;
        }
        return null;
    }

    public static String getModeName(Mode mode) {
        return props.getProperty("mode." + mode.getName() + ".name");
    }

    public static Mode[] getModes() {
        Object[] array = new Mode[modes.size()];
        modes.copyInto(array);
        return array;
    }

    public static Buffer openFile(View view, String parent, String path, boolean readOnly, boolean newFile) {
        if (view != null && parent == null) {
            parent = view.getBuffer().getFile().getParent();
        }
        int index = path.indexOf(35);
        String marker = null;
        if (index != -1) {
            marker = path.substring(index + 1);
            path = path.substring(0, index);
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException mu) {
            path = MiscUtilities.constructPath(parent, path);
        }
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getPath().equals(path)) {
                if (view != null) {
                    if (marker != null) {
                        jEdit.gotoMarker(buffer, view, marker);
                    }
                    view.setBuffer(buffer);
                }
                return buffer;
            }
            buffer = buffer.next;
        }
        buffer = new Buffer(url, path, "", readOnly, newFile, false);
        jEdit.addBufferToList(buffer);
        EditBus.send(new BufferUpdate(buffer, BufferUpdate.CREATED));
        if (marker != null) {
            jEdit.gotoMarker(buffer, null, marker);
        }
        if (view != null) {
            view.setBuffer(buffer);
        }
        return buffer;
    }

    public static Buffer openRemoteFile(View view, String parent, String filepath, String filename, boolean readOnly, boolean newFile) {
        String path = String.valueOf(filepath) + filename;
        if (view != null && parent == null) {
            parent = view.getBuffer().getFile().getParent();
        }
        int index = path.indexOf(35);
        String marker = null;
        if (index != -1) {
            marker = path.substring(index + 1);
            path = path.substring(0, index);
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException mu) {
            path = MiscUtilities.constructPath(parent, path);
        }
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getPath().equals(path)) {
                if (view != null) {
                    if (marker != null) {
                        jEdit.gotoMarker(buffer, view, marker);
                    }
                    view.setBuffer(buffer);
                }
                return buffer;
            }
            buffer = buffer.next;
        }
        buffer = new Buffer(url, filepath, filename, readOnly, newFile, false);
        jEdit.addBufferToList(buffer);
        EditBus.send(new BufferUpdate(buffer, BufferUpdate.CREATED));
        if (marker != null) {
            jEdit.gotoMarker(buffer, null, marker);
        }
        if (view != null) {
            view.setBuffer(buffer);
        }
        return buffer;
    }

    public static Buffer openTemporary(View view, String parent, String path, boolean readOnly, boolean newFile) {
        if (view != null && parent == null) {
            parent = view.getBuffer().getFile().getParent();
        }
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException mu) {
            path = MiscUtilities.constructPath(parent, path);
        }
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getPath().equals(path)) {
                return buffer;
            }
            buffer = buffer.next;
        }
        return new Buffer(url, path, "", readOnly, newFile, true);
    }

    public static void commitTemporary(Buffer buffer) {
        if (!buffer.isTemporary()) {
            return;
        }
        buffer.setMode();
        buffer.propertiesChanged();
        jEdit.addBufferToList(buffer);
        buffer.commitTemporary();
        EditBus.send(new BufferUpdate(buffer, BufferUpdate.CREATED));
    }

    public static Buffer newFile(View view) {
        int untitledCount = 0;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getName().startsWith("Untitled-")) {
                try {
                    untitledCount = Math.max(untitledCount, Integer.parseInt(buffer.getName().substring(9)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            buffer = buffer.next;
        }
        return jEdit.openFile(view, null, "\u672a\u547d\u540d-" + (untitledCount + 1), false, true);
    }

    public static boolean closeBuffer(View view, Buffer buffer) {
        Object[] args;
        int result;
        if (buffer.isDirty() && ((result = JOptionPane.showConfirmDialog(view, jEdit.getProperty("notsaved.message", args = new Object[]{"\u6b63\u5728\u7f16\u8f91\u7684\u5185\u5bb9"}), jEdit.getProperty("notsaved.title"), 1, 2)) == 0 ? !buffer.save(view, null) : result != 1)) {
            return false;
        }
        jEdit._closeBuffer(view, buffer);
        return true;
    }

    public static void _closeBuffer(View view, Buffer buffer) {
        jEdit.removeBufferFromList(buffer);
        buffer.close();
        if (!buffer.isNewFile()) {
            jEdit.addRecent(buffer.getPath());
        }
        EditBus.send(new BufferUpdate(buffer, BufferUpdate.CLOSED));
        if (buffersFirst == null && buffersLast == null) {
            jEdit.newFile(view);
        }
    }

    public static boolean closeAllBuffers(View view, boolean isExiting) {
        boolean ok;
        boolean dirty = false;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                dirty = true;
                break;
            }
            buffer = buffer.next;
        }
        if (dirty && !(ok = new CloseDialog(view).isOK())) {
            return false;
        }
        buffer = buffersFirst;
        buffersLast = null;
        buffersFirst = null;
        bufferCount = 0;
        while (buffer != null) {
            if (!buffer.isNewFile()) {
                jEdit.addRecent(buffer.getPath());
            }
            buffer.close();
            if (!isExiting) {
                EditBus.send(new BufferUpdate(buffer, BufferUpdate.CLOSED));
            }
            buffer = buffer.next;
        }
        if (!isExiting) {
            jEdit.newFile(view);
        }
        return true;
    }

    public static Buffer getBuffer(String path) {
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getPath().equals(path)) {
                return buffer;
            }
            buffer = buffer.next;
        }
        return null;
    }

    public static Buffer[] getBuffers() {
        Buffer[] buffers = new Buffer[bufferCount];
        Buffer buffer = buffersFirst;
        int i = 0;
        while (i < bufferCount) {
            buffers[i] = buffer;
            buffer = buffer.next;
            ++i;
        }
        return buffers;
    }

    public static int getBufferCount() {
        return bufferCount;
    }

    public static Buffer getFirstBuffer() {
        return buffersFirst;
    }

    public static Buffer getLastBuffer() {
        return buffersLast;
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static void reloadKeyBindings() {
        inputHandler.removeAllKeyBindings();
        EditAction[] actions = jEdit.getActions();
        int i = 0;
        while (i < actions.length) {
            EditAction action = actions[i];
            String shortcut = jEdit.getProperty(String.valueOf(action.getName()) + ".shortcut");
            if (shortcut != null) {
                inputHandler.addKeyBinding(shortcut, action);
            }
            ++i;
        }
        jEdit.initKeyBindings();
        Mode[] modes = jEdit.getModes();
        int i2 = 0;
        while (i2 < modes.length) {
            modes[i2].initKeyBindings();
            ++i2;
        }
    }

    public static View newView(View view, Buffer buffer) {
        if (view != null) {
            view.showWaitCursor();
            view.saveCaretInfo();
        }
        View newView = new View(view, buffer);
        jEdit.addViewToList(newView);
        EditBus.send(new ViewUpdate(newView, ViewUpdate.CREATED));
        newView.pack();
        if (view != null) {
            newView.setSize(view.getSize());
            Point location = view.getLocation();
            location.x += 20;
            location.y += 20;
            newView.setLocation(location);
            view.hideWaitCursor();
        } else {
            GUIUtilities.loadGeometry(newView, "view");
        }
        newView.setVisible(true);
        newView.focusOnTextArea();
        StringBuffer sb = new StringBuffer();
        try {
            Element map = buffer.getDefaultRootElement();
            int i = 0;
            while (i < map.getElementCount()) {
                Element line = map.getElement(i);
                sb.append(buffer.getText(line.getStartOffset(), line.getEndOffset() - line.getStartOffset() - 1));
                sb.append("\n");
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        buffer.syntaxCheck(sb.toString(), newView);
        return newView;
    }

    public static void closeView(View view) {
        if (viewsFirst == viewsLast) {
            jEdit.exit(view);
        } else {
            EditBus.send(new ViewUpdate(view, ViewUpdate.CLOSED));
            view.close();
            jEdit.removeViewFromList(view);
        }
    }

    public static View[] getViews() {
        View[] views = new View[viewCount];
        View view = viewsFirst;
        int i = 0;
        while (i < viewCount) {
            views[i] = view;
            view = view.next;
            ++i;
        }
        return views;
    }

    public static int getViewCount() {
        return viewCount;
    }

    public static View getFirstView() {
        return viewsFirst;
    }

    public static View getLastView() {
        return viewsLast;
    }

    public static String[] getRecent() {
        Object[] array = new String[recent.size()];
        recent.copyInto(array);
        return array;
    }

    public static String getJEditHome() {
        return jEditHome;
    }

    public static String getSettingsDirectory() {
        return settingsDirectory;
    }

    public static void exit(View view) {
        if (settingsDirectory != null && session != null) {
            Sessions.saveSession(view, session);
        }
        if (!jEdit.closeAllBuffers(view, true)) {
            return;
        }
        autosave.stop();
        if (server != null) {
            server.stopServer();
        }
        view.close();
        int i = 0;
        while (i < plugins.size()) {
            ((EditPlugin)plugins.elementAt(i)).stop();
            ++i;
        }
        EditBus.send(new EditorExiting(null));
        if (settingsDirectory != null) {
            i = 0;
            while (i < recent.size()) {
                String file = (String)recent.elementAt(i);
                jEdit.setProperty("recent." + i, file);
                ++i;
            }
            jEdit.unsetProperty("recent." + maxRecent);
            HistoryModel.saveHistory(MiscUtilities.constructPath(settingsDirectory, "history"));
            SearchAndReplace.save();
            Abbrevs.save();
            File file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
            if (file.lastModified() > propsModTime) {
                Log.log(7, jEdit.class, file + " changed" + " on disk; will not save user properties");
            } else {
                try {
                    FileOutputStream out = new FileOutputStream(file);
                    props.save(out, "jEdit properties");
                    ((OutputStream)out).close();
                }
                catch (IOException io) {
                    Log.log(9, jEdit.class, io);
                }
            }
        }
        if (exitOnExit) {
            System.exit(0);
        }
    }

    static void updatePosition(Buffer buffer) {
        if (sortBuffers) {
            jEdit.removeBufferFromList(buffer);
            jEdit.addBufferToList(buffer);
        }
    }

    static void addBrokenPlugin(String jar, String name) {
        brokenPlugins.addElement(new EditPlugin.Broken(jar, name));
    }

    private jEdit() {
    }

    private static void usage() {
        System.out.println("Usage: jedit [<options>] [<files>]");
        System.out.println("Common options:");
        System.out.println("\t<filename>#<marker>: Positions caret at marker <marker>");
        System.out.println("\t<filename>#+<line>: Positions caret at line number <line>");
        System.out.println("\t--: End of options");
        System.out.println("\t-version: Print jEdit version and exit");
        System.out.println("\t-usage: Print this message and exit");
        System.out.println("\t-readonly: Open files read-only");
        System.out.println("\t-nosession: Don't load default session");
        System.out.println("\t-session=<name>: Load session from $HOME/.jedit/sessions/<name>");
        System.out.println("\t-noserver: Don't start editor server");
        System.out.println("\t-server=<name>: Reads/writes server info to $HOME/.jedit/<name>");
        System.out.println();
        System.out.println("Server-only options:");
        System.out.println("\t-nosettings: Don't load user-specific settings");
        System.out.println("\t-settings=<path>: Load user-specific settings from <path>");
        System.out.println("\t-nosplash: Don't show splash screen");
        System.out.println();
        System.out.println("Client-only options:");
        System.out.println("\t-reuseview: Don't open new view in");
        System.out.println();
        System.out.println("To set minimum activity log level, specify a number as the first");
        System.out.println("command line parameter (1-9, 1 = debug, 9 = error)");
        System.out.println();
        System.out.println("Report bugs to Slava Pestov <sp@gjt.org>.");
    }

    private static void version() {
        System.out.println("jEdit " + jEdit.getVersion());
    }

    public static void initMisc() {
        Log.log(5, jEdit.class, "jEdit version " + jEdit.getVersion());
        Log.log(3, jEdit.class, "Settings directory is " + settingsDirectory);
        inputHandler = new DefaultInputHandler();
        System.getProperties().put("java.protocol.handler.pkgs", "org.gjt.sp.jedit.proto|" + System.getProperty("java.protocol.handler.pkgs", ""));
        jEditHome = System.getProperty("jedit.home");
        if (jEditHome == null) {
            int start;
            String classpath = System.getProperty("java.class.path");
            int index = classpath.toLowerCase().indexOf("jedit.jar");
            jEditHome = index > (start = classpath.lastIndexOf(File.pathSeparator, index) + 1) ? classpath.substring(start, index - 1) : System.getProperty("user.dir");
        }
        if (settingsDirectory != null) {
            File _sessionsDirectory;
            File _macrosDirectory;
            File _settingsDirectory = new File(settingsDirectory);
            if (!_settingsDirectory.exists()) {
                _settingsDirectory.mkdirs();
            }
            if (!(_macrosDirectory = new File(settingsDirectory, "macros")).exists()) {
                _macrosDirectory.mkdir();
            }
            if (!(_sessionsDirectory = new File(settingsDirectory, "sessions")).exists()) {
                _sessionsDirectory.mkdir();
            }
        }
    }

    public static void initSystemProperties() {
        defaultProps = props = new Properties();
        try {
            jEdit.loadProps(jEdit.class.getResourceAsStream("/org/gjt/sp/jedit/jedit_gui.props"));
            jEdit.loadProps(jEdit.class.getResourceAsStream("/org/gjt/sp/jedit/jedit.props"));
            jEdit.loadProps(jEdit.class.getResourceAsStream("/org/gjt/sp/jedit/jedit_keys.props"));
        }
        catch (Exception e) {
            Log.log(9, jEdit.class, "Error while loading system properties!");
            Log.log(9, jEdit.class, "One of the following property files could not be loaded:\n- jedit.props\n- jedit_gui.props\n- jedit_keys.props\nTry reinstalling jEdit.");
            Log.log(9, jEdit.class, e);
            System.exit(1);
        }
    }

    public static void initModes() {
        modes = new Vector(29);
        jEdit.addMode("bat");
        jEdit.addMode("bsh");
        jEdit.addMode("c");
        jEdit.addMode("cc");
        jEdit.addMode("eiffel");
        jEdit.addMode("html");
        jEdit.addMode("idl");
        jEdit.addMode("java");
        jEdit.addMode("javascript");
        jEdit.addMode("makefile");
        jEdit.addMode("patch");
        jEdit.addMode("perl");
        jEdit.addMode("php3");
        jEdit.addMode("postscript");
        jEdit.addMode("props");
        jEdit.addMode("python");
        jEdit.addMode("shell");
        jEdit.addMode("tex");
        jEdit.addMode("text");
        jEdit.addMode("tsql");
        jEdit.addMode("xml");
    }

    private static void addAction(String name) {
        EditAction.Wrapper action = new EditAction.Wrapper(name);
        actionHash.put(name, action);
        String binding = jEdit.getProperty(String.valueOf(name) + ".shortcut");
        if (binding != null) {
            inputHandler.addKeyBinding(binding, action);
        }
    }

    public static void initActions() {
        actionHash = new Hashtable();
        jEdit.addAction("about");
        jEdit.addAction("scriptTip");
        jEdit.addAction("script_flowOpen");
        jEdit.addAction("script_newOpen");
        jEdit.addAction("script_editOpen");
        jEdit.addAction("script_viewOpen");
        jEdit.addAction("script_flowClose");
        jEdit.addAction("script_cellClicked");
        jEdit.addAction("script_cellRightClicked");
        jEdit.addAction("script_cellDblClicked");
        jEdit.addAction("script_CellValueChanged");
        jEdit.addAction("script_CellValueChangedByEdit");
        jEdit.addAction("script_isCellEditable");
        jEdit.addAction("script_DataStoreItemChangeAccept");
        jEdit.addAction("script_DataStoreItemChanged");
        jEdit.addAction("script_afterinsert");
        jEdit.addAction("script_afterdelete");
        jEdit.addAction("script_sqlPreview");
        jEdit.addAction("script_DataStoreRetrieveOnceMoreEnd");
        jEdit.addAction("script_DataStoreBeforeRetrieve");
        jEdit.addAction("script_DataStoreAfterFilter");
        jEdit.addAction("script_DataStoreRetrieveEnd");
        jEdit.addAction("script_deleteRowPermit");
        jEdit.addAction("script_afterDeleteBill");
        jEdit.addAction("script_afterBillDeleteSuccess");
        jEdit.addAction("script_newBillNo");
        jEdit.addAction("script_buildToolTip");
        jEdit.addAction("script_afterDeleteWork");
        jEdit.addAction("script_beforeSubmitWork");
        jEdit.addAction("script_untreadPermit");
        jEdit.addAction("script_afterSubmitWork");
        jEdit.addAction("script_beforeUnOverWork");
        jEdit.addAction("script_afterUnOverWork");
        jEdit.addAction("script_onWorkOver");
        jEdit.addAction("script_workSheetActiveStateChanged");
        jEdit.addAction("script_currentBindRowChanged");
        jEdit.addAction("script_beginEdit");
        jEdit.addAction("script_endEdit");
        jEdit.addAction("script_keyPressed");
        jEdit.addAction("script_keyReleased");
        jEdit.addAction("script_VirtualButtonClicked");
        jEdit.addAction("script_VirtualButtonClicked2");
        jEdit.addAction("script_validate");
        jEdit.addAction("script_saveOnClick");
        jEdit.addAction("script_saveIsNeeded");
        jEdit.addAction("script_beforeSave");
        jEdit.addAction("script_afterSaveSuccessful");
        jEdit.addAction("script_newPermit");
        jEdit.addAction("script_viewPermit");
        jEdit.addAction("script_editPermit");
        jEdit.addAction("script_deletePermit");
        jEdit.addAction("script_flowDeletePermit");
        jEdit.addAction("script_obsoletePermit");
        jEdit.addAction("script_printPermit");
        jEdit.addAction("script_printPermit");
        jEdit.addAction("script_contextMenuClicked");
        jEdit.addAction("script_contextMenuClicked2");
        jEdit.addAction("script_beforeBillPrint");
        jEdit.addAction("script_afterBillPrint");
        jEdit.addAction("script_duplicateKeyErrorOnUpdate");
        jEdit.addAction("script_afterEditFocusLostAndBeforeWriteBackToCell");
        jEdit.addAction("script_afterBlindDoWork");
        jEdit.addAction("script_mobileCanBillDeleteOneRow");
        jEdit.addAction("script_mobileAfterBillDeleteOneRow");
        jEdit.addAction("script_mobileBeforeBillSaveOneRow");
        jEdit.addAction("script_mobileAfterBillSaveOneRow");
        jEdit.addAction("script_flowWithdraw");
        jEdit.addAction("script_preparePrint");
        jEdit.addAction("script_attachmentChanged");
        jEdit.addAction("script_attachmentDeletePermit");
        jEdit.addAction("script_attachmentRenamePermit");
        jEdit.addAction("script_attachmentUploadPermit");
        jEdit.addAction("script_popupedWorkSheetOnCancel");
        jEdit.addAction("script_popupedWorkSheetOnOK");
        jEdit.addAction("script_onceRetrieveCountWhenPrint");
        jEdit.addAction("append-string-register");
        jEdit.addAction("block-comment");
        jEdit.addAction("box-comment");
        jEdit.addAction("buffer-options");
        jEdit.addAction("clear-marker");
        jEdit.addAction("clear-register");
        jEdit.addAction("close-all");
        jEdit.addAction("close-file");
        jEdit.addAction("close-view");
        jEdit.addAction("complete-word");
        jEdit.addAction("copy");
        jEdit.addAction("copy-string-register");
        jEdit.addAction("cut");
        jEdit.addAction("cut-string-register");
        jEdit.addAction("delete-end-line");
        jEdit.addAction("delete-line");
        jEdit.addAction("delete-paragraph");
        jEdit.addAction("delete-start-line");
        jEdit.addAction("edit-macro");
        jEdit.addAction("exchange-caret-register");
        jEdit.addAction("exit");
        jEdit.addAction("expand-abbrev");
        jEdit.addAction("find");
        jEdit.addAction("find-next");
        jEdit.addAction("find-selection");
        jEdit.addAction("global-options");
        jEdit.addAction("goto-end-indent");
        jEdit.addAction("goto-line");
        jEdit.addAction("goto-marker");
        jEdit.addAction("goto-register");
        jEdit.addAction("help");
        jEdit.addAction("hypersearch");
        jEdit.addAction("hypersearch-selection");
        jEdit.addAction("indent-lines");
        jEdit.addAction("indent-on-enter");
        jEdit.addAction("indent-on-tab");
        jEdit.addAction("insert-char");
        jEdit.addAction("insert-literal");
        jEdit.addAction("join-lines");
        jEdit.addAction("load-session");
        jEdit.addAction("locate-bracket");
        jEdit.addAction("log-viewer");
        jEdit.addAction("new-file");
        jEdit.addAction("new-view");
        jEdit.addAction("next-bracket-exp");
        jEdit.addAction("next-buffer");
        jEdit.addAction("next-paragraph");
        jEdit.addAction("open-file");
        jEdit.addAction("open-path");
        jEdit.addAction("open-url");
        jEdit.addAction("paste");
        jEdit.addAction("paste-previous");
        jEdit.addAction("paste-string-register");
        jEdit.addAction("play-last-macro");
        jEdit.addAction("play-temp-macro");
        jEdit.addAction("play-macro");
        jEdit.addAction("prev-bracket-exp");
        jEdit.addAction("prev-buffer");
        jEdit.addAction("prev-paragraph");
        jEdit.addAction("print");
        jEdit.addAction("record-macro");
        jEdit.addAction("record-temp-macro");
        jEdit.addAction("redo");
        jEdit.addAction("reload");
        jEdit.addAction("reload-all");
        jEdit.addAction("replace-all");
        jEdit.addAction("replace-in-selection");
        jEdit.addAction("rescan-macros");
        jEdit.addAction("save");
        jEdit.addAction("save-all");
        jEdit.addAction("save-as");
        jEdit.addAction("save-gutter-size");
        jEdit.addAction("save-session");
        jEdit.addAction("scroll-line");
        jEdit.addAction("search-and-replace");
        jEdit.addAction("select-all");
        jEdit.addAction("select-block");
        jEdit.addAction("select-buffer");
        jEdit.addAction("select-caret-register");
        jEdit.addAction("select-line");
        jEdit.addAction("select-line-range");
        jEdit.addAction("select-next-paragraph");
        jEdit.addAction("select-none");
        jEdit.addAction("select-paragraph");
        jEdit.addAction("select-prev-paragraph");
        jEdit.addAction("select-word");
        jEdit.addAction("set-caret-register");
        jEdit.addAction("set-filename-register");
        jEdit.addAction("set-replace-string");
        jEdit.addAction("set-search-parameters");
        jEdit.addAction("set-search-string");
        jEdit.addAction("send");
        jEdit.addAction("set-marker");
        jEdit.addAction("shift-left");
        jEdit.addAction("shift-right");
        jEdit.addAction("split-horizontal");
        jEdit.addAction("split-vertical");
        jEdit.addAction("stop-recording");
        jEdit.addAction("tab");
        jEdit.addAction("to-lower");
        jEdit.addAction("to-upper");
        jEdit.addAction("undo");
        jEdit.addAction("unsplit");
        jEdit.addAction("untab");
        jEdit.addAction("view-registers");
        jEdit.addAction("wing-comment");
        jEdit.addAction("word-count");
        inputHandler.setInputAction(jEdit.getAction("insert-char"));
        jEdit.addAction(new ignore_case());
        jEdit.addAction(new multifile_search());
        jEdit.addAction(new regexp());
        jEdit.addAction(new toggle_gutter());
        jEdit.addAction(new toggle_line_numbers());
        jEdit.addAction(new toggle_rect());
    }

    public static void initPlugins() {
        plugins = new Vector();
        brokenPlugins = new Vector();
    }

    public static void initUserProperties() {
        props = new Properties(defaultProps);
        if (settingsDirectory != null) {
            File file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
            propsModTime = file.lastModified();
            try {
                jEdit.loadProps(new FileInputStream(file));
            }
            catch (FileNotFoundException fnf) {
                Log.log(1, jEdit.class, fnf);
            }
            catch (IOException e) {
                Log.log(9, jEdit.class, e);
            }
        }
    }

    public static void initPLAF() {
        String lf = jEdit.getProperty("lookAndFeel");
        try {
            if (lf != null && lf.length() != 0) {
                UIManager.setLookAndFeel(lf);
            }
        }
        catch (Exception e) {
            Log.log(9, jEdit.class, e);
        }
    }

    public static void initRecent() {
        recent = new Vector(maxRecent);
    }

    public static void initKeyBindings() {
        Enumeration textActions = InputHandler.getActions();
        while (textActions.hasMoreElements()) {
            String name = (String)textActions.nextElement();
            String binding = jEdit.getProperty(String.valueOf(name) + ".shortcut");
            if (binding == null) continue;
            inputHandler.addKeyBinding(binding, InputHandler.getAction(name));
        }
    }

    private static void gotoMarker(Buffer buffer, View view, String marker) {
        int start;
        int end2;
        if (marker.length() == 0) {
            return;
        }
        buffer.loadIfNecessary(view);
        if (marker.charAt(0) == '+') {
            try {
                int line = Integer.parseInt(marker.substring(1));
                Element lineElement = buffer.getDefaultRootElement().getElement(line + 1);
                start = end2 = lineElement.getStartOffset();
            }
            catch (Exception e) {
                return;
            }
        } else {
            Marker m = buffer.getMarker(marker);
            if (m == null) {
                return;
            }
            start = m.getStart();
            end2 = m.getEnd();
        }
        if (view == null || view.getBuffer() != buffer) {
            buffer.putProperty("Buffer__selStart", new Integer(start));
            buffer.putProperty("Buffer__selEnd", new Integer(end2));
        } else if (view != null) {
            view.getTextArea().select(start, end2);
        }
    }

    private static void addBufferToList(Buffer buffer) {
        ++bufferCount;
        if (buffersFirst == null) {
            buffersFirst = buffersLast = buffer;
            return;
        }
        if (sortBuffers) {
            String name1 = (sortByName ? buffer.getName() : buffer.getPath()).toLowerCase();
            Buffer _buffer = buffersFirst;
            while (_buffer != null) {
                String name2 = (sortByName ? _buffer.getName() : _buffer.getPath()).toLowerCase();
                if (name1.compareTo(name2) <= 0) {
                    buffer.next = _buffer;
                    buffer.prev = _buffer.prev;
                    _buffer.prev = buffer;
                    if (_buffer != buffersFirst) {
                        buffer.prev.next = buffer;
                    } else {
                        buffersFirst = buffer;
                    }
                    return;
                }
                _buffer = _buffer.next;
            }
        }
        buffer.prev = buffersLast;
        jEdit.buffersLast.next = buffer;
        buffersLast = buffer;
    }

    private static void removeBufferFromList(Buffer buffer) {
        --bufferCount;
        if (buffer == buffersFirst && buffer == buffersLast) {
            buffersLast = null;
            buffersFirst = null;
            return;
        }
        if (buffer == buffersFirst) {
            buffersFirst = buffer.next;
            buffer.next.prev = null;
        } else {
            buffer.prev.next = buffer.next;
        }
        if (buffer == buffersLast) {
            buffersLast = jEdit.buffersLast.prev;
            buffer.prev.next = null;
        } else {
            buffer.next.prev = buffer.prev;
        }
    }

    private static void addViewToList(View view) {
        ++viewCount;
        if (viewsFirst == null) {
            viewsFirst = viewsLast = view;
        } else {
            view.prev = viewsLast;
            jEdit.viewsLast.next = view;
            viewsLast = view;
        }
    }

    private static void removeViewFromList(View view) {
        --viewCount;
        if (view == viewsFirst) {
            viewsFirst = view.next;
            view.next.prev = null;
        } else {
            view.prev.next = view.next;
        }
        if (view == viewsLast) {
            viewsLast = jEdit.viewsLast.prev;
            view.prev.next = null;
        } else {
            view.next.prev = view.prev;
        }
    }

    private static void addRecent(String path) {
        if (recent.contains(path)) {
            recent.removeElement(path);
        }
        recent.insertElementAt(path, 0);
        if (recent.size() > maxRecent) {
            recent.removeElementAt(maxRecent);
        }
    }
}

