/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class ViewRegisters
extends EnhancedDialog {
    private JButton close;

    public ViewRegisters(View view) {
        super(view, jEdit.getProperty("view-registers.title"), true);
        Container content = this.getContentPane();
        Registers.Register[] registers = Registers.getRegisters();
        Vector<String> strings = new Vector<String>();
        int i = 0;
        while (i < registers.length) {
            Registers.Register reg = registers[i];
            if (reg != null) {
                String name = i == 10 ? "\n" : (i == 9 ? "\t" : String.valueOf((char)i));
                String value = reg.toString();
                if (value != null) {
                    strings.addElement(String.valueOf(name) + ": " + value);
                }
            }
            ++i;
        }
        JList registerList = new JList(strings);
        registerList.setVisibleRowCount(16);
        registerList.setFont(view.getTextArea().getPainter().getFont());
        this.close = new JButton(jEdit.getProperty("common.close"));
        content.setLayout(new BorderLayout());
        content.add((Component)new JLabel(jEdit.getProperty("view-registers.caption")), "North");
        JScrollPane scroller = new JScrollPane(registerList);
        Dimension dim = scroller.getPreferredSize();
        scroller.setPreferredSize(new Dimension(640, dim.height));
        content.add((Component)scroller, "Center");
        JPanel panel = new JPanel();
        panel.add(this.close);
        content.add((Component)panel, "South");
        this.getRootPane().setDefaultButton(this.close);
        ActionHandler actionListener = new ActionHandler();
        this.close.addActionListener(actionListener);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
        registerList.requestFocus();
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ViewRegisters.this.close) {
                ViewRegisters.this.cancel();
            }
        }
    }
}

