/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.MenuItemModel;
import org.gjt.sp.jedit.jEdit;

public class ToolBarModel
extends MenuItemModel {
    public static final Object SEPARATOR = "-";
    protected Vector children = new Vector();

    public ToolBarModel(String name) {
        super(name);
        String buttons = jEdit.getProperty(name);
        if (buttons != null) {
            StringTokenizer st = new StringTokenizer(buttons);
            while (st.hasMoreTokens()) {
                String button = st.nextToken();
                if (button.equals("-")) {
                    this.children.addElement(SEPARATOR);
                    continue;
                }
                this.children.addElement(GUIUtilities.loadMenuItemModel(button));
            }
        }
    }

    public JToolBar create() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        int i = 0;
        while (i < this.children.size()) {
            Object obj = this.children.elementAt(i);
            if (obj == SEPARATOR) {
                toolBar.addSeparator();
            } else {
                MenuItemModel menuItem = (MenuItemModel)obj;
                toolBar.add(menuItem.createButton());
            }
            ++i;
        }
        return toolBar;
    }

    public JPopupMenu createPopup(View view) {
        JPopupMenu menu = new JPopupMenu();
        menu.setInvoker(view);
        int i = 0;
        while (i < this.children.size()) {
            Object obj = this.children.elementAt(i);
            if (obj == SEPARATOR) {
                menu.addSeparator();
            } else {
                MenuItemModel menuItem = (MenuItemModel)obj;
                menu.add(menuItem.create(view));
            }
            ++i;
        }
        return menu;
    }
}

