/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class SendDialog
extends EnhancedDialog
implements ActionListener,
Runnable {
    public static final String CRLF = "\r\n";
    private View view;
    private Thread thread;
    private JTextField smtp;
    private JTextField from;
    private JTextField to;
    private JTextField subject;
    private JCheckBox selectionOnly;
    private JPanel buttons;
    private JButton send;
    private JButton cancel;

    public SendDialog(View view) {
        super(view, jEdit.getProperty("send.title"), true);
        this.view = view;
        JPanel panel = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        JLabel label = new JLabel(jEdit.getProperty("send.smtp"), 4);
        layout.setConstraints(label, constraints);
        panel.add(label);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        this.smtp = new JTextField(jEdit.getProperty("send.smtp.value"), 30);
        layout.setConstraints(this.smtp, constraints);
        panel.add(this.smtp);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        label = new JLabel(jEdit.getProperty("send.from"), 4);
        layout.setConstraints(label, constraints);
        panel.add(label);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        this.from = new JTextField(jEdit.getProperty("send.from.value"), 30);
        layout.setConstraints(this.from, constraints);
        panel.add(this.from);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        label = new JLabel(jEdit.getProperty("send.to"), 4);
        layout.setConstraints(label, constraints);
        panel.add(label);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        this.to = new JTextField(jEdit.getProperty("send.to.value"), 30);
        layout.setConstraints(this.to, constraints);
        panel.add(this.to);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        label = new JLabel(jEdit.getProperty("send.subject"), 4);
        layout.setConstraints(label, constraints);
        panel.add(label);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        this.subject = new JTextField(view.getBuffer().getPath(), 30);
        layout.setConstraints(this.subject, constraints);
        panel.add(this.subject);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.fill = 3;
        constraints.anchor = 17;
        this.selectionOnly = new JCheckBox(jEdit.getProperty("send.selectionOnly"));
        this.selectionOnly.getModel().setSelected("on".equals(jEdit.getProperty("send.selectionOnly.value")));
        layout.setConstraints(this.selectionOnly, constraints);
        panel.add(this.selectionOnly);
        this.getContentPane().add("North", panel);
        this.getContentPane().add("Center", new JSeparator());
        this.buttons = new JPanel();
        this.send = new JButton(jEdit.getProperty("send.send"));
        this.buttons.add(this.send);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.buttons.add(this.cancel);
        this.getContentPane().add("South", this.buttons);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.getRootPane().setDefaultButton(this.send);
        this.send.addActionListener(this);
        this.cancel.addActionListener(this);
        this.show();
    }

    public void run() {
        JEditTextArea textArea = this.view.getTextArea();
        String smtp = this.smtp.getText();
        String from = this.from.getText();
        String to = this.to.getText();
        String subject = this.subject.getText();
        boolean selectionOnly = this.selectionOnly.getModel().isSelected();
        if (smtp.length() == 0 || from.length() == 0 || to.length() == 0) {
            GUIUtilities.error(this.view, "sendempty", new Object[0]);
            return;
        }
        this.smtp.setEnabled(false);
        this.from.setEnabled(false);
        this.to.setEnabled(false);
        this.subject.setEnabled(false);
        this.send.setEnabled(false);
        this.cancel.setEnabled(false);
        Object[] args = new Object[]{smtp};
        Log.log(1, this, jEdit.getProperty("send.connect", args));
        try {
            int endLine;
            int startLine;
            int index = smtp.indexOf(58);
            int port = 25;
            if (index != -1) {
                port = Integer.parseInt(smtp.substring(index + 1));
                smtp = smtp.substring(0, index);
            }
            Socket socket = new Socket(smtp, port);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
            String response = in.readLine();
            Log.log(1, this, response);
            if (!response.startsWith("220")) {
                this.error("serverdown");
            }
            String command = "HELO " + socket.getLocalAddress().getHostName() + CRLF;
            Log.log(1, this, command);
            out.write(command);
            ((Writer)out).flush();
            response = in.readLine();
            Log.log(1, this, response);
            if (!response.startsWith("250")) {
                this.error("badhost");
            }
            command = "MAIL FROM: <" + from + ">" + CRLF;
            Log.log(1, this, command);
            out.write(command);
            ((Writer)out).flush();
            response = in.readLine();
            Log.log(1, this, response);
            if (!response.startsWith("250")) {
                this.error("badsender");
            }
            command = "RCPT TO: <" + to + ">" + CRLF;
            Log.log(1, this, command);
            out.write(command);
            ((Writer)out).flush();
            response = in.readLine();
            Log.log(1, this, response);
            if (!response.startsWith("250")) {
                this.error("badrecepient");
            }
            command = "DATA\r\n";
            Log.log(1, this, command);
            out.write(command);
            ((Writer)out).flush();
            response = in.readLine();
            Log.log(1, this, response);
            if (!response.startsWith("354")) {
                this.error("badmsg");
            }
            out.write("Subject: " + subject);
            out.write(CRLF);
            out.write("X-Mailer: jEdit " + jEdit.getVersion());
            out.write(CRLF);
            out.write(CRLF);
            Buffer buffer = this.view.getBuffer();
            if (selectionOnly) {
                startLine = textArea.getSelectionStartLine();
                endLine = textArea.getSelectionEndLine();
            } else {
                startLine = 0;
                endLine = textArea.getLineCount() - 1;
            }
            int i = startLine;
            while (i <= endLine) {
                String line;
                if (selectionOnly) {
                    int start = textArea.getSelectionStart(i);
                    int end2 = textArea.getSelectionEnd(i);
                    line = textArea.getText(start, end2 - start);
                } else {
                    line = textArea.getLineText(i);
                }
                if (line.equals(".")) {
                    line = "!";
                }
                out.write(line);
                out.write(CRLF);
                ++i;
            }
            out.write(".\r\n");
            ((Writer)out).flush();
            response = in.readLine();
            Log.log(1, this, response);
            if (!response.startsWith("250")) {
                this.error("badmsg");
            }
            command = "QUIT\r\n";
            Log.log(1, this, command);
            out.write(command);
            ((Writer)out).flush();
            response = in.readLine();
            Log.log(1, this, response);
            in.close();
            ((Writer)out).close();
            socket.close();
        }
        catch (IOException io) {
            Log.log(9, this, io);
            args[0] = io.toString();
            GUIUtilities.error(this.view, "ioerror", args);
        }
        catch (NumberFormatException nf) {
            Log.log(9, this, nf);
            GUIUtilities.error(this.view, "badport", new Object[0]);
        }
        this.save();
        this.dispose();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.send) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        }
    }

    public void ok() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void cancel() {
        this.dispose();
    }

    private void error(String msg) {
        GUIUtilities.error(this.view, msg, new Object[0]);
        this.dispose();
    }

    private void save() {
        jEdit.setProperty("send.smtp.value", this.smtp.getText());
        jEdit.setProperty("send.from.value", this.from.getText());
        jEdit.setProperty("send.to.value", this.to.getText());
        jEdit.setProperty("send.subject.value", this.subject.getText());
        jEdit.setProperty("send.selectionOnly.value", this.selectionOnly.getModel().isSelected() ? "on" : "off");
        if (this.thread != null) {
            this.thread.stop();
        }
    }
}

