/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Element;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class SelectLineRange
extends EnhancedDialog
implements ActionListener {
    private Buffer buffer;
    private JTextField start;
    private JTextField end;
    private JButton ok;
    private JButton cancel;

    public SelectLineRange(View view) {
        super(view, jEdit.getProperty("selectlinerange.title"), true);
        this.buffer = view.getBuffer();
        this.getContentPane().add("North", new JLabel(jEdit.getProperty("selectlinerange.caption")));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        panel.add(new JLabel(jEdit.getProperty("selectlinerange.start"), 4));
        this.start = new JTextField();
        panel.add(this.start);
        panel.add(new JLabel(jEdit.getProperty("selectlinerange.end"), 4));
        this.end = new JTextField();
        panel.add(this.end);
        this.getContentPane().add("Center", panel);
        panel = new JPanel();
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        panel.add(this.ok);
        this.ok.addActionListener(this);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        panel.add(this.cancel);
        this.cancel.addActionListener(this);
        this.getContentPane().add("South", panel);
        this.getRootPane().setDefaultButton(this.ok);
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
        this.start.requestFocus();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.ok) {
            this.ok();
        } else if (source == this.cancel) {
            this.cancel();
        }
    }

    public void ok() {
        int endLine;
        int startLine;
        try {
            startLine = Integer.parseInt(this.start.getText()) - 1;
            endLine = Integer.parseInt(this.end.getText()) - 1;
        }
        catch (NumberFormatException nf) {
            this.getToolkit().beep();
            return;
        }
        Element startElement = this.buffer.getDefaultRootElement().getElement(startLine);
        Element endElement = this.buffer.getDefaultRootElement().getElement(endLine);
        if (startElement == null || endElement == null) {
            this.getToolkit().beep();
            return;
        }
        int startOffset = startElement.getStartOffset();
        int endOffset = endElement.getEndOffset() - 1;
        ((View)this.getParent()).getTextArea().select(startOffset, endOffset);
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }
}

