/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.AllBufferSet;
import org.gjt.sp.jedit.search.BufferListSet;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchFileSet;

public class MultiFileSearchDialog
extends EnhancedDialog {
    private View view;
    private SearchFileSet fileset;
    private JRadioButton current;
    private JRadioButton all;
    private JRadioButton selected;
    private JRadioButton directory;
    private JList bufferList;
    private JTextField directoryPath;
    private JButton directoryChoose;
    private JComboBox directoryGlob;
    private JCheckBox directoryRecurse;
    private JButton ok;
    private JButton cancel;
    private boolean isOK;

    public MultiFileSearchDialog(View view, SearchFileSet fileset) {
        super(view, jEdit.getProperty("multifile.title"), true);
        this.view = view;
        this.fileset = fileset;
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.anchor = 17;
        cons.fill = 1;
        cons.weightx = 1.0;
        JLabel caption = new JLabel(jEdit.getProperty("multifile.caption"));
        ++cons.gridy;
        layout.setConstraints(caption, cons);
        this.getContentPane().add(caption);
        ActionHandler actionHandler = new ActionHandler();
        ButtonGroup grp = new ButtonGroup();
        this.current = new JRadioButton(jEdit.getProperty("multifile.current"));
        if (fileset instanceof CurrentBufferSet) {
            this.current.getModel().setSelected(true);
        }
        this.current.addActionListener(actionHandler);
        grp.add(this.current);
        ++cons.gridy;
        layout.setConstraints(this.current, cons);
        this.getContentPane().add(this.current);
        this.all = new JRadioButton(jEdit.getProperty("multifile.all"));
        if (fileset instanceof AllBufferSet) {
            this.all.getModel().setSelected(true);
        }
        this.all.addActionListener(actionHandler);
        grp.add(this.all);
        ++cons.gridy;
        layout.setConstraints(this.all, cons);
        this.getContentPane().add(this.all);
        this.selected = new JRadioButton(jEdit.getProperty("multifile.selected"));
        if (fileset instanceof BufferListSet && !(fileset instanceof DirectoryListSet)) {
            this.selected.getModel().setSelected(true);
        }
        this.selected.addActionListener(actionHandler);
        grp.add(this.selected);
        ++cons.gridy;
        layout.setConstraints(this.selected, cons);
        this.getContentPane().add(this.selected);
        JScrollPane list = this.createBufferList();
        ++cons.gridy;
        cons.weighty = 1.0;
        layout.setConstraints(list, cons);
        cons.weighty = 0.0;
        this.getContentPane().add(list);
        this.directory = new JRadioButton(jEdit.getProperty("multifile.directory"));
        if (fileset instanceof DirectoryListSet) {
            this.directory.getModel().setSelected(true);
        }
        this.directory.addActionListener(actionHandler);
        grp.add(this.directory);
        ++cons.gridy;
        layout.setConstraints(this.directory, cons);
        this.getContentPane().add(this.directory);
        JPanel options = this.createDirectoryOptions();
        ++cons.gridy;
        layout.setConstraints(options, cons);
        this.getContentPane().add(options);
        JPanel panel = new JPanel();
        this.ok = new JButton(jEdit.getProperty("common.ok"));
        this.ok.addActionListener(actionHandler);
        this.getRootPane().setDefaultButton(this.ok);
        panel.add(this.ok);
        this.cancel = new JButton(jEdit.getProperty("common.cancel"));
        this.cancel.addActionListener(actionHandler);
        panel.add(this.cancel);
        ++cons.gridy;
        layout.setConstraints(panel, cons);
        this.getContentPane().add(panel);
        this.updateEnabled();
        Dimension screen = this.getToolkit().getScreenSize();
        this.pack();
        this.setLocation((screen.width - this.getSize().width) / 2, (screen.height - this.getSize().height) / 2);
        this.show();
    }

    public SearchFileSet getSearchFileSet() {
        if (!this.isOK) {
            return null;
        }
        if (this.current.getModel().isSelected()) {
            return new CurrentBufferSet();
        }
        if (this.all.getModel().isSelected()) {
            return new AllBufferSet();
        }
        if (this.selected.getModel().isSelected()) {
            Object[] values = this.bufferList.getSelectedValues();
            if (values == null || values.length == 0) {
                return new CurrentBufferSet();
            }
            return new BufferListSet(values);
        }
        if (this.directory.getModel().isSelected()) {
            String _directory = this.directoryPath.getText();
            String _glob = (String)this.directoryGlob.getSelectedItem();
            boolean _recurse = this.directoryRecurse.getModel().isSelected();
            jEdit.setProperty("multifile.directory.path.value", _directory);
            jEdit.setProperty("multifile.directory.glob.value", _glob);
            jEdit.setProperty("multifile.directory.recurse.value", _recurse ? "on" : "off");
            return new DirectoryListSet(_directory, _glob, _recurse);
        }
        return null;
    }

    public void ok() {
        this.isOK = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    private void updateEnabled() {
        this.bufferList.setEnabled(this.selected.getModel().isSelected());
        if (this.directory.getModel().isSelected()) {
            this.directoryPath.setEnabled(true);
            this.directoryChoose.setEnabled(true);
            this.directoryGlob.setEnabled(true);
            this.directoryRecurse.setEnabled(true);
        } else {
            this.directoryPath.setEnabled(false);
            this.directoryChoose.setEnabled(false);
            this.directoryGlob.setEnabled(false);
            this.directoryRecurse.setEnabled(false);
        }
    }

    private JScrollPane createBufferList() {
        Buffer[] buffers = jEdit.getBuffers();
        this.bufferList = new JList<Buffer>(buffers);
        if (this.fileset instanceof BufferListSet && !(this.fileset instanceof DirectoryListSet)) {
            Buffer buffer = this.fileset.getFirstBuffer(this.view);
            do {
                int i = 0;
                while (i < buffers.length) {
                    if (buffers[i] == buffer) {
                        this.bufferList.addSelectionInterval(i, i);
                    }
                    ++i;
                }
            } while ((buffer = this.fileset.getNextBuffer(this.view, buffer)) != null);
        }
        return new JScrollPane(this.bufferList);
    }

    private JPanel createDirectoryOptions() {
        String glob;
        JPanel box = new JPanel(new BorderLayout());
        JPanel labels = new JPanel(new GridLayout(2, 1));
        labels.add(new JLabel(jEdit.getProperty("multifile.directory.path"), 4));
        labels.add(new JLabel(jEdit.getProperty("multifile.directory.glob"), 4));
        box.add("West", labels);
        JPanel fields = new JPanel(new GridLayout(2, 1));
        JPanel box1 = new JPanel(new BorderLayout());
        Box box2 = new Box(1);
        box2.add(Box.createGlue());
        this.directoryPath = new JTextField(jEdit.getProperty("multifile.directory.path.value"));
        Dimension dim = this.directoryPath.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        this.directoryPath.setMaximumSize(dim);
        box2.add(this.directoryPath);
        box2.add(Box.createGlue());
        box1.add("Center", box2);
        this.directoryChoose = new JButton(jEdit.getProperty("multifile.directory.choose"));
        this.directoryChoose.addActionListener(new ActionHandler());
        box1.add("East", this.directoryChoose);
        fields.add(box1);
        JPanel box3 = new JPanel(new BorderLayout());
        Box box4 = new Box(1);
        box4.add(Box.createGlue());
        Mode[] modes = jEdit.getModes();
        Vector<String> globs = new Vector<String>(modes.length);
        int i = 0;
        while (i < modes.length) {
            glob = (String)modes[i].getProperty("filenameGlob");
            if (glob != null) {
                globs.addElement(glob);
            }
            ++i;
        }
        i = 0;
        while ((glob = jEdit.getProperty("filefilter." + i)) != null) {
            globs.addElement(glob);
            ++i;
        }
        this.directoryGlob = new JComboBox(globs);
        this.directoryGlob.setEditable(true);
        this.directoryGlob.setSelectedItem(jEdit.getProperty("multifile.directory.glob.value"));
        dim = this.directoryGlob.getPreferredSize();
        dim.width = Integer.MAX_VALUE;
        this.directoryGlob.setMaximumSize(dim);
        box4.add(this.directoryGlob);
        box4.add(Box.createGlue());
        box3.add("Center", box4);
        this.directoryRecurse = new JCheckBox(jEdit.getProperty("multifile.directory.recurse"));
        this.directoryRecurse.getModel().setSelected("on".equals(jEdit.getProperty("multifile.directory.recurse.value")));
        this.directoryRecurse.addActionListener(new ActionHandler());
        box3.add("East", this.directoryRecurse);
        fields.add(box3);
        box.add("Center", fields);
        return box;
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JRadioButton) {
                MultiFileSearchDialog.this.updateEnabled();
            }
            if (source == MultiFileSearchDialog.this.directoryChoose) {
                File directory = new File(MultiFileSearchDialog.this.directoryPath.getText());
                JFileChooser chooser = new JFileChooser(directory.getParent());
                chooser.setFileSelectionMode(1);
                chooser.setSelectedFile(directory);
                if (chooser.showOpenDialog(MultiFileSearchDialog.this) == 0) {
                    MultiFileSearchDialog.this.directoryPath.setText(chooser.getSelectedFile().getPath());
                }
            } else if (source == MultiFileSearchDialog.this.ok) {
                MultiFileSearchDialog.this.ok();
            } else if (source == MultiFileSearchDialog.this.cancel) {
                MultiFileSearchDialog.this.cancel();
            }
        }
    }
}

