/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class LogViewer
extends JFrame {
    private JButton clear;
    private JButton save;

    public LogViewer(View view) {
        super(jEdit.getProperty("log-viewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        JPanel panel = new JPanel();
        this.clear = new JButton(jEdit.getProperty("log-viewer.clear"));
        this.clear.addActionListener(new ActionHandler());
        panel.add(this.clear);
        this.save = new JButton(jEdit.getProperty("log-viewer.save"));
        this.save.addActionListener(new ActionHandler());
        panel.add(this.save);
        this.getContentPane().add("North", panel);
        JTextArea textArea = new JTextArea(24, 80);
        textArea.setDocument(Log.getLogDocument());
        Font font = view.getTextArea().getPainter().getFont();
        textArea.setFont(font);
        this.getContentPane().add("Center", new JScrollPane(textArea));
        this.pack();
        GUIUtilities.loadGeometry(this, "log-viewer");
        this.show();
    }

    public void dispose() {
        GUIUtilities.saveGeometry(this, "log-viewer");
        super.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == LogViewer.this.clear) {
                Log.clearLog();
            } else {
                String path = GUIUtilities.showFileDialog(null, MiscUtilities.constructPath(null, "jedit.log"), 1);
                if (path != null) {
                    try {
                        Log.saveLog(path);
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                        Object[] args = new String[]{io.getMessage()};
                        GUIUtilities.error(LogViewer.this, "ioerror", args);
                    }
                }
            }
        }
    }
}

