/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import org.gjt.sp.jedit.gui.HistoryModel;

public class HistoryTextField
extends JTextField {
    private HistoryModel historyModel;
    private boolean instantPopups;
    private String current;
    private int index;

    public HistoryTextField(String name) {
        this(name, false);
    }

    public HistoryTextField(String name, boolean instantPopups) {
        this.historyModel = HistoryModel.getModel(name);
        this.addKeyListener(new KeyHandler());
        this.addMouseListener(new MouseHandler());
        this.instantPopups = instantPopups;
        this.index = -1;
    }

    public void setModel(String name) {
        this.historyModel = HistoryModel.getModel(name);
        this.index = -1;
    }

    public void addCurrentToHistory() {
        this.historyModel.addItem(this.getText());
        this.index = 0;
    }

    public void setText(String text) {
        super.setText(text);
        this.index = -1;
    }

    public HistoryModel getModel() {
        return this.historyModel;
    }

    public void fireActionPerformed() {
        super.fireActionPerformed();
    }

    private void doBackwardSearch() {
        String text;
        if (this.getSelectionEnd() != this.getDocument().getLength()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
        if ((text = this.getText().substring(0, this.getSelectionStart())) == null) {
            this.historyPrevious();
            return;
        }
        int i = this.index + 1;
        while (i < this.historyModel.getSize()) {
            String item = this.historyModel.getItem(i);
            if (item.startsWith(text)) {
                this.replaceSelection(item.substring(text.length()));
                this.select(text.length(), this.getDocument().getLength());
                this.index = i;
                return;
            }
            ++i;
        }
        this.getToolkit().beep();
    }

    private void doForwardSearch() {
        String text;
        if (this.getSelectionEnd() != this.getDocument().getLength()) {
            this.setCaretPosition(this.getDocument().getLength());
        }
        if ((text = this.getText().substring(0, this.getSelectionStart())) == null) {
            this.historyNext();
            return;
        }
        int i = this.index - 1;
        while (i >= 0) {
            String item = this.historyModel.getItem(i);
            if (item.startsWith(text)) {
                this.replaceSelection(item.substring(text.length()));
                this.select(text.length(), this.getDocument().getLength());
                this.index = i;
                return;
            }
            --i;
        }
        this.getToolkit().beep();
    }

    private void historyPrevious() {
        if (this.index == this.historyModel.getSize() - 1) {
            this.getToolkit().beep();
        } else if (this.index == -1) {
            this.current = this.getText();
            this.setText(this.historyModel.getItem(0));
            this.index = 0;
        } else {
            int newIndex = this.index + 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    private void historyNext() {
        if (this.index == -1) {
            this.getToolkit().beep();
        } else if (this.index == 0) {
            this.setText(this.current);
        } else {
            int newIndex = this.index - 1;
            this.setText(this.historyModel.getItem(newIndex));
            this.index = newIndex;
        }
    }

    private void showFullMenu(int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem caption = new JMenuItem(this.historyModel.getName());
        caption.getModel().setEnabled(false);
        popup.add(caption);
        popup.addSeparator();
        ButtonGroup grp = new ButtonGroup();
        ActionHandler actionListener = new ActionHandler();
        if (this.index == -1) {
            this.current = this.getText();
        }
        if (this.current != null && this.current.length() != 0) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.current);
            menuItem.setActionCommand("-1");
            menuItem.addActionListener(actionListener);
            grp.add(menuItem);
            popup.add(menuItem);
            menuItem.getModel().setSelected(true);
        }
        int i = 0;
        while (i < this.historyModel.getSize()) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.historyModel.getItem(i));
            menuItem.setActionCommand(String.valueOf(i));
            menuItem.addActionListener(actionListener);
            grp.add(menuItem);
            popup.add(menuItem);
            if (i == this.index) {
                menuItem.getModel().setSelected(true);
            }
            ++i;
        }
        popup.show(this, x, y);
    }

    private void showPartialMenu(int x, int y) {
        String text = this.getText().substring(0, this.getSelectionStart());
        if (text == null || text.length() == 0) {
            this.showFullMenu(x, y);
            return;
        }
        ActionHandler actionListener = new ActionHandler();
        JPopupMenu popup = new JPopupMenu();
        JMenuItem caption = new JMenuItem(String.valueOf(this.historyModel.getName()) + "/" + text);
        caption.getModel().setEnabled(false);
        popup.add(caption);
        popup.addSeparator();
        int i = 0;
        while (i < this.historyModel.getSize()) {
            String item = this.historyModel.getItem(i);
            if (item.startsWith(text)) {
                JMenuItem menuItem = new JMenuItem(item);
                menuItem.setActionCommand(String.valueOf(i));
                menuItem.addActionListener(actionListener);
                popup.add(menuItem);
            }
            ++i;
        }
        popup.show(this, x, y);
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            int ind = Integer.parseInt(evt.getActionCommand());
            if (ind == -1) {
                if (HistoryTextField.this.index != -1) {
                    HistoryTextField.this.setText(HistoryTextField.this.current);
                }
            } else {
                HistoryTextField.this.setText(HistoryTextField.this.historyModel.getItem(ind));
                HistoryTextField.this.index = ind;
            }
            if (HistoryTextField.this.instantPopups) {
                HistoryTextField.this.addCurrentToHistory();
                HistoryTextField.this.fireActionPerformed();
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                HistoryTextField.this.addCurrentToHistory();
            } else if (evt.getKeyCode() == 38) {
                if ((evt.getModifiers() & 2) != 0) {
                    HistoryTextField.this.doBackwardSearch();
                } else {
                    HistoryTextField.this.historyPrevious();
                }
                evt.consume();
            } else if (evt.getKeyCode() == 40) {
                if ((evt.getModifiers() & 2) != 0) {
                    HistoryTextField.this.doForwardSearch();
                } else {
                    HistoryTextField.this.historyNext();
                }
                evt.consume();
            } else if (evt.getKeyCode() == 9 && (evt.getModifiers() & 2) != 0) {
                HistoryTextField.this.doBackwardSearch();
                evt.consume();
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            if ((evt.getModifiers() & 2) != 0) {
                HistoryTextField.this.showPartialMenu(0, HistoryTextField.this.getHeight());
            } else if ((evt.getModifiers() & 4) != 0) {
                HistoryTextField.this.showFullMenu(0, HistoryTextField.this.getHeight());
            }
        }
    }
}

