/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public abstract class EnhancedDialog
extends JDialog {
    protected KeyHandler keyHandler;

    public EnhancedDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.getContentPane().addContainerListener(new ContainerHandler());
        this.keyHandler = new KeyHandler();
        this.addKeyListener(this.keyHandler);
        this.addWindowListener(new WindowHandler());
        this.setDefaultCloseOperation(0);
    }

    public abstract void ok();

    public abstract void cancel();

    class ContainerHandler
    extends ContainerAdapter {
        ContainerHandler() {
        }

        public void componentAdded(ContainerEvent evt) {
            this.componentAdded(evt.getChild());
        }

        public void componentRemoved(ContainerEvent evt) {
            this.componentRemoved(evt.getChild());
        }

        private void componentAdded(Component comp) {
            comp.addKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                cont.addContainerListener(this);
                Component[] comps = cont.getComponents();
                int i = 0;
                while (i < comps.length) {
                    this.componentAdded(comps[i]);
                    ++i;
                }
            }
        }

        private void componentRemoved(Component comp) {
            comp.removeKeyListener(EnhancedDialog.this.keyHandler);
            if (comp instanceof Container) {
                Container cont = (Container)comp;
                cont.removeContainerListener(this);
                Component[] comps = cont.getComponents();
                int i = 0;
                while (i < comps.length) {
                    this.componentRemoved(comps[i]);
                    ++i;
                }
            }
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 10) {
                EnhancedDialog.this.ok();
                evt.consume();
            } else if (evt.getKeyCode() == 27) {
                EnhancedDialog.this.cancel();
                evt.consume();
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            EnhancedDialog.this.cancel();
        }
    }
}

