/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.jEdit;

public class EnhancedCheckBoxMenuItem
extends JCheckBoxMenuItem {
    private String keyBinding;
    private String keyBindingProp;
    private EditAction action;
    private static Font acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
    private static Color acceleratorForeground;
    private static Color acceleratorSelectionForeground;

    static {
        acceleratorFont = new Font("Monospaced", acceleratorFont.getStyle(), acceleratorFont.getSize());
        acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground");
    }

    public EnhancedCheckBoxMenuItem(String label, EditAction action, String actionCommand) {
        super(label);
        this.action = action;
        if (action != null) {
            this.setEnabled(true);
            this.addActionListener(action);
            this.keyBindingProp = String.valueOf(action.getName()) + ".shortcut";
        } else {
            this.setEnabled(false);
        }
        this.setActionCommand(actionCommand);
        this.setModel(new Model());
    }

    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        String keyBinding = this.getKeyBinding();
        if (keyBinding != null) {
            d.width += this.getToolkit().getFontMetrics(acceleratorFont).stringWidth(keyBinding) + 30;
        }
        return d;
    }

    public void paint(Graphics g) {
        super.paint(g);
        String keyBinding = this.getKeyBinding();
        if (keyBinding != null) {
            g.setFont(acceleratorFont);
            g.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
            FontMetrics fm = g.getFontMetrics();
            Insets insets = this.getInsets();
            g.drawString(keyBinding, this.getWidth() - (fm.stringWidth(keyBinding) + insets.right + insets.left), this.getFont().getSize() + (insets.top - 1));
        }
    }

    public String getActionCommand() {
        return this.getModel().getActionCommand();
    }

    private String getKeyBinding() {
        if (this.action == null) {
            return null;
        }
        if (this.keyBinding == null && this.getActionCommand() == null) {
            return jEdit.getProperty(this.keyBindingProp);
        }
        return this.keyBinding;
    }

    class Model
    extends DefaultButtonModel {
        Model() {
        }

        public boolean isSelected() {
            return EnhancedCheckBoxMenuItem.this.action.isSelected(EnhancedCheckBoxMenuItem.this);
        }

        public void setSelected(boolean b) {
        }
    }
}

