/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedMenuItem;
import org.gjt.sp.jedit.jEdit;

public class CurrentDirectoryMenu
extends JMenu {
    private View view;

    public CurrentDirectoryMenu(View view) {
        String label = jEdit.getProperty("current-directory.label");
        int index = label.indexOf(36);
        char mnemonic = '\u0000';
        if (index != -1) {
            mnemonic = Character.toUpperCase(label.charAt(index + 1));
            label = String.valueOf(label.substring(0, index)) + label.substring(index + 1);
        }
        this.setText(label);
        this.setMnemonic(mnemonic);
        this.view = view;
    }

    public void setPopupMenuVisible(boolean b) {
        if (b) {
            if (this.getMenuComponentCount() != 0) {
                this.removeAll();
            }
            File dir = new File(this.view.getBuffer().getFile().getParent());
            JMenuItem mi = new JMenuItem(dir.getPath());
            mi.setEnabled(false);
            this.add(mi);
            this.addSeparator();
            JMenu current = this;
            int count = 0;
            EditAction action = jEdit.getAction("open-path");
            Object[] list = dir.list();
            if (list != null) {
                MiscUtilities.quicksort(list, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
                int i = 0;
                while (i < list.length) {
                    Object name = list[i];
                    File file = new File(dir, (String)name);
                    if (!file.isDirectory()) {
                        mi = new EnhancedMenuItem((String)name, null, action, file.getPath());
                        if (count++ > 20) {
                            current.addSeparator();
                            JMenu newCurrent = new JMenu(jEdit.getProperty("current-directory.more.label"));
                            current.add(newCurrent);
                            current = newCurrent;
                            count = 0;
                        }
                        current.add(mi);
                    }
                    ++i;
                }
            }
        }
        super.setPopupMenuVisible(b);
    }
}

